/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical;

import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.FactoryConfiguration;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.FolderLogicalObject;
import com.sas.metadata.logical.FolderType;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeActionEvent;
import com.sas.metadata.logical.LogicalTypeActionListener;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.RB;
import com.sas.metadata.logical.RootFolderType;
import com.sas.metadata.logical.SimpleLogicalObject;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.SmartObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.unknown.TypeSpecificUnknownType;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.ChildServerInterface;
import com.sas.services.information.MetadataConnectionEvent;
import com.sas.services.information.MetadataConnectionListener;
import com.sas.services.information.MetadataServerInterface;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.services.session.SessionContextInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.text.Message;
import com.sas.workspace.WAPropertyTab;
import java.awt.Frame;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Factory
implements MdFactoryListener,
MetadataConnectionListener {
    public static String EVENT_FOLDER_ADDED = "EVENT_FOLDER_ADDED";
    public static String EVENT_FOLDER_UPDATED = "EVENT_FOLDER_UPDATED";
    public static String EVENT_MEMBER_ADDED = "EVENT_MEMBER_ADDED";
    public static String EVENT_MEMBER_UPDATED = "EVENT_MEMBER_UPDATED";
    private static Factory _theInstance;
    private List<LogicalTypeActionListener> _actionListeners;
    private boolean _iSecurityIsCurrent;
    private ISecurity _iSecurity;
    private boolean _IOMIIsCurrent;
    private IOMI _IOMI;
    private List<TypeInterface> _typeInterfaces = new ArrayList<TypeInterface>();
    private String[] _neededAttributes;
    private String _templateFormOfNeededAttributes;
    private Frame _frame;
    private FolderInterface _rootFolder;
    private HashMap<String, FolderLogicalObject> _topLevelFoldersMap = new HashMap();
    private HashMap<String, Boolean> _reposidPermissionMap = new HashMap();
    private HashMap<String, Boolean> _projectRepositoryStatusMap = new HashMap();
    private TypeInterface _tiForUnknown;
    private ObjectFactoryInterface _objectFactoryForUnknown;
    private MdFactory _mdFactory;
    private MdObjectStore _scratchStore;
    private MdOMIUtil _mdOMIUtil;
    private MetadataServerInterface _metadataServerInterface;
    private boolean _useTypeSpecificUnknownType;
    private boolean _initialized;
    private Map<String, TypeMappedObject> _typeMap = new HashMap<String, TypeMappedObject>();
    private boolean _allTD;
    private boolean _attemptedToLoadAllTD;
    private List<String> _publicTypeNames;
    private Logger _logger;
    private Map<String, TypeDescriptorInterface> _typeDescriptorMap;
    private static final String[] _requiredAttributes;

    private Factory() {
    }

    public static Factory getInstance() {
        if (_theInstance == null) {
            _theInstance = new Factory();
        }
        return _theInstance;
    }

    public Frame getFrame() {
        return this._frame;
    }

    public void initialize(FactoryConfiguration configuration) throws RemoteException {
        this._tiForUnknown = configuration.getTypeInterfaceForUnknown();
        if (this._tiForUnknown != null) {
            this._objectFactoryForUnknown = this._tiForUnknown.getObjectFactory();
        }
        this._frame = configuration.getFrame();
        this._logger = LogManager.getLogger((String)"com.sas.metadata.logical");
        String[] neededAttributes = configuration.getNeededAttributes();
        this._neededAttributes = neededAttributes != null ? (String[])neededAttributes.clone() : new String[0];
        List<String> supportedTypes = configuration.getSupportedPublicTypes();
        this._allTD = configuration._allTD;
        this._publicTypeNames = supportedTypes;
        this._useTypeSpecificUnknownType = configuration.useTypeSpecificUnknownType();
        this._initialized = true;
    }

    public void unInitialize() {
        this._initialized = false;
    }

    public void setConnection(SessionContextInterface sessionContextInterface, MdFactory mdFactory) throws LogicalTypeException, RemoteException {
        TypeDescriptorInterface td;
        if (sessionContextInterface == null) {
            throw new IllegalStateException("The sessionContextInterface parameter should not be null.");
        }
        if (mdFactory == null) {
            throw new IllegalStateException("The mdFactory parameter should not be null.");
        }
        this._iSecurityIsCurrent = false;
        this._IOMIIsCurrent = false;
        this._topLevelFoldersMap.clear();
        this._projectRepositoryStatusMap.clear();
        this._reposidPermissionMap.clear();
        this._mdFactory = mdFactory;
        this._mdOMIUtil = this._mdFactory.getOMIUtil();
        if (this._scratchStore != null) {
            this._scratchStore.dispose();
        }
        this._scratchStore = this._mdFactory.createObjectStore(null, "Logical Types Factory: Scratch Store");
        this._rootFolder = null;
        this._metadataServerInterface = null;
        try {
            UtilPlatformServices.setSessionContext(sessionContextInterface);
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        this._typeMap.clear();
        this._attemptedToLoadAllTD = false;
        UserContextInterface uci = sessionContextInterface.getUserContext();
        try {
            this._metadataServerInterface = (MetadataServerInterface)uci.getAuthServer();
            if (this._metadataServerInterface == null) {
                throw new LogicalTypeException("Logic error: UserContext's getAuthServer() returns a null MetadataServerInterface.");
            }
            this._metadataServerInterface.addMetadataConnectionListener((MetadataConnectionListener)this);
            this._typeDescriptorMap = this._metadataServerInterface.getTypeDictionaryMap();
            if (this._typeDescriptorMap == null || this._typeDescriptorMap.size() == 0) {
                throw new LogicalTypeException(RB.getStringResource("FAC.noTypDefs.ex.txt"));
            }
        }
        catch (ServiceException e) {
            this._typeDescriptorMap = null;
            throw new LogicalTypeException((Exception)((Object)e));
        }
        if (this._allTD) {
            for (Map.Entry entry : this._typeDescriptorMap.entrySet()) {
                String type = (String)entry.getKey();
                TypeMappedObject tmo2 = new TypeMappedObject(type, false);
                tmo2._typeDescriptor = (TypeDescriptorInterface)entry.getValue();
                this._typeMap.put(type, tmo2);
            }
        } else {
            for (String string : this._publicTypeNames) {
                TypeDescriptorInterface td2 = this._typeDescriptorMap.get(string);
                if (td2 == null) {
                    this.error("Public Type " + string + " not found in Type Dictionary.");
                    continue;
                }
                TypeMappedObject tmo = new TypeMappedObject(string, false);
                tmo._typeDescriptor = td2;
                this._typeMap.put(string, tmo);
            }
        }
        if (this._typeMap.get("Folder") == null) {
            td = this._typeDescriptorMap.get("Folder");
            if (td == null) {
                throw new LogicalTypeException("Repository error: No Type Definition for Folder");
            }
            TypeMappedObject typeMappedObject = new TypeMappedObject("Folder", true);
            typeMappedObject._typeDescriptor = td;
            this._typeMap.put("Folder", typeMappedObject);
        }
        if (this._typeMap.get("RootFolder") == null) {
            td = this._typeDescriptorMap.get("RootFolder");
            if (td == null) {
                throw new LogicalTypeException("Repository error: No Type Definition for RootFolder");
            }
            TypeMappedObject typeMappedObject = new TypeMappedObject("RootFolder", true);
            typeMappedObject._typeDescriptor = td;
            this._typeMap.put("RootFolder", typeMappedObject);
        }
        MdObjectStore store = this.getScratchStore();
        try {
            SoftwareComponent softwareComponent = UtilMetadata.locateSoftwareComponent(UtilMetadata.getFoundationRepositoryID(), store);
            this._rootFolder = (FolderInterface)this.getTypeInterface("RootFolder").getObjectFactory().createItemFromMetadataObject((Root)softwareComponent);
            if (this._rootFolder == null) {
                throw new LogicalTypeException(RB.getStringResource("FAC.noRF.ex.txt"));
            }
            for (Tree tree : softwareComponent.getSoftwareTrees()) {
                try {
                    this.getObject((Root)tree, false, true);
                }
                catch (LogicalTypeException e) {
                    this.error(e, "Error obtaining folder logical object for " + tree.getName() + ".");
                }
            }
        }
        catch (MdException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        finally {
            store.clearObjectsFromStore();
        }
        this._mdFactory.addMdFactoryListener((MdFactoryListener)this, new String[]{"Tree"});
    }

    public void addActionListener(LogicalTypeActionListener listener) {
        if (this._actionListeners == null) {
            this._actionListeners = new ArrayList<LogicalTypeActionListener>(4);
        }
        this._actionListeners.add(listener);
    }

    public void removeActionListener(LogicalTypeActionListener listener) {
        if (this._actionListeners != null) {
            this._actionListeners.remove(listener);
        }
    }

    public void fireActionPerformed(LogicalTypeActionEvent event) throws LogicalTypeException {
        if (this._actionListeners != null) {
            for (LogicalTypeActionListener listener : this._actionListeners) {
                listener.actionPerformed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void MdObjectsCreated(MdFactoryEvent e) throws RemoteException {
        for (String fqid : e.getObjectMap().keySet()) {
            String value = (String)e.getObjectMap().get(fqid);
            if (!value.equals("Tree")) continue;
            MdObjectStore store = this.getMdFactory().createObjectStore();
            try {
                Tree tree = (Tree)UtilMetadata.locateExistingObject(store, "Tree", fqid);
                if (!tree.getPublicType().equals("Folder") || tree.getParentTree() != null) continue;
                this.getObject((Root)tree, false, true);
            }
            catch (MdException ex) {
                this.error(ex, null);
            }
            catch (LogicalTypeException ex) {
                this.error(ex, null);
            }
            finally {
                store.dispose();
            }
        }
    }

    public void MdObjectsDeleted(MdFactoryEvent e) throws RemoteException {
        for (String fqid : e.getObjectMap().keySet()) {
            this._topLevelFoldersMap.remove(fqid);
        }
    }

    public void MdObjectsModified(MdFactoryEvent e) throws RemoteException {
        this.MdObjectsCreated(e);
    }

    public TypeInterface[] getTypesSupported() throws RemoteException, LogicalTypeException {
        if (!this._attemptedToLoadAllTD) {
            this.loadTypesSupported();
        }
        return this._typeInterfaces.toArray(new TypeInterface[0]);
    }

    private void loadTypesSupported() throws RemoteException, LogicalTypeException {
        if (this._attemptedToLoadAllTD) {
            return;
        }
        this._attemptedToLoadAllTD = true;
        this._typeInterfaces.clear();
        for (TypeMappedObject tmo : this._typeMap.values()) {
            TypeInterface ti;
            if (tmo._internalUse || (ti = tmo.getTypeInterface()) == null || this._typeInterfaces.contains(ti)) continue;
            this._typeInterfaces.add(ti);
        }
    }

    public TypeDescriptorInterface getTypeDescriptorFromTypeDictionary(String publicType) {
        if (this._typeDescriptorMap == null) {
            return null;
        }
        return this._typeDescriptorMap.get(publicType);
    }

    public TypeInterface getTypeInterface(String publicType) throws RemoteException, LogicalTypeException {
        TypeMappedObject tmo = this._typeMap.get(publicType);
        if (tmo == null) {
            return null;
        }
        return tmo.getTypeInterface();
    }

    public boolean isTypeContainedByFolder(String publicType) throws LogicalTypeException, RemoteException {
        TypeDescriptorInterface tdi = this.getTypeDescriptorFromTypeDictionary(publicType);
        if (tdi != null) {
            try {
                String containerType = tdi.getContainerType();
                return "Folder".equalsIgnoreCase(containerType);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
        }
        return false;
    }

    public FolderInterface getRootFolder() {
        return this._rootFolder;
    }

    public LogicalObjectInterface getObject(MetadataInterface smartObject) throws LogicalTypeException, RemoteException {
        Object o = smartObject.getRepositoryEntity();
        if (o instanceof Root) {
            return this.getObject((Root)o);
        }
        throw new IllegalArgumentException(o + " is not Root subclassed.");
    }

    public LogicalObjectInterface getObject(Root root) throws LogicalTypeException, RemoteException {
        return this.getObject(root, true, false);
    }

    LogicalObjectInterface getObject(Root root, boolean refreshIfCached, boolean parentTreeKnownToBeNull) throws LogicalTypeException, RemoteException {
        TypeInterface ti = this.locateTypeInterfaceForRoot(root);
        if (ti != null) {
            if (!root.getCMetadataType().equalsIgnoreCase(ti.getMetadataType())) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FAC.badObj.ex.fmt.txt", (Object)ti.getDisplayType(), (Object)root.getName(), (Object)root.getFQID(), (Object)((PrimaryType)root).getPublicType(), (Object)root.getCMetadataType());
                throw new LogicalTypeException(msg);
            }
            Class<?> typeClass = ti.getClass();
            if (typeClass == RootFolderType.class) {
                if (this._rootFolder == null) {
                    throw new LogicalTypeException(RB.getStringResource("FAC.noRF.ex.txt"));
                }
                if (refreshIfCached) {
                    this._rootFolder.refresh(root);
                }
                return this._rootFolder;
            }
            if (typeClass != FolderType.class) {
                return ti.getObjectFactory().createItemFromMetadataObject(root);
            }
            if (root instanceof Tree) {
                try {
                    Tree tree = (Tree)root;
                    if (refreshIfCached && tree.getParentTrees(false).size() == 0 && tree.getSoftwareComponents(false).size() == 0) {
                        int options = 268;
                        MdObjectStore store = (MdObjectStore)tree.getObjectStore();
                        tree = (Tree)store.getFactory().getOMIUtil().getMetadataAllDepths((CMetadata)tree, null, null, "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>", options);
                    }
                    Tree parent = parentTreeKnownToBeNull ? null : tree.getParentTree();
                    FolderLogicalObject topLevelFolder = this._topLevelFoldersMap.get(tree.getFQID());
                    if (parent == null) {
                        if (topLevelFolder != null) {
                            if (refreshIfCached) {
                                topLevelFolder.refresh((Root)tree);
                            }
                            return topLevelFolder;
                        }
                        topLevelFolder = new FolderLogicalObject(tree, ti, this);
                        this._topLevelFoldersMap.put(tree.getFQID(), topLevelFolder);
                        return topLevelFolder;
                    }
                    if (topLevelFolder != null) {
                        this._topLevelFoldersMap.remove(tree.getFQID());
                    }
                    return new FolderLogicalObject(tree, ti, this);
                }
                catch (MdException e) {
                    throw new LogicalTypeException((Exception)((Object)e));
                }
            }
        }
        if (this._tiForUnknown != null) {
            return this._objectFactoryForUnknown.createItemFromMetadataObject(root);
        }
        return null;
    }

    public LogicalObjectInterface getObjectByPath(String path) throws LogicalTypeException, RemoteException {
        if (this._metadataServerInterface == null) {
            throw new LogicalTypeException("MetadataServer not defined.");
        }
        try {
            PathUrl objectPathUrl = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)this._metadataServerInterface, (String)path);
            return this.getObjectByPath(objectPathUrl);
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
    }

    public LogicalObjectInterface getObjectByPath(PathUrl objectPathUrl) throws LogicalTypeException, RemoteException {
        LogicalObjectInterface object = null;
        if (this._metadataServerInterface == null) {
            throw new LogicalTypeException("MetadataServer not defined.");
        }
        try {
            MetadataInterface smartObject = this._metadataServerInterface.getObjectByPath(objectPathUrl);
            if (smartObject != null) {
                object = this.getObject((Root)smartObject.getRepositoryEntity());
            }
        }
        catch (ServiceException e) {
            throw new LogicalTypeException((Exception)((Object)e));
        }
        return object;
    }

    public SimpleLogicalObjectInterface getSimpleObject(Root root) throws RemoteException, LogicalTypeException {
        TypeInterface ti = this.locateTypeInterfaceForRoot(root);
        if (ti != null) {
            if (!root.getCMetadataType().equalsIgnoreCase(ti.getMetadataType())) {
                String msg = Message.format((ResourceBundle)RB.getResources(), (String)"FAC.badObj.ex.fmt.txt", (Object)ti.getDisplayType(), (Object)root.getName(), (Object)root.getFQID(), (Object)((PrimaryType)root).getPublicType(), (Object)root.getCMetadataType());
                throw new LogicalTypeException(msg);
            }
            return new SimpleLogicalObject(root.getName(), root.getId(), ti);
        }
        return null;
    }

    public boolean isInitialized() {
        return this._initialized;
    }

    public TypeInterface locateTypeInterfaceForRoot(Root root) throws RemoteException, LogicalTypeException {
        if (!(root instanceof PrimaryType)) {
            throw new LogicalTypeException(root + " is not a Primary Type.");
        }
        PrimaryType primaryType = (PrimaryType)root;
        String publicType = primaryType.getPublicType();
        if (publicType == null) {
            return null;
        }
        return this.getTypeInterface(publicType);
    }

    public boolean isSmartObjectBasedDialog(LogicalObjectInterface logicalObject) {
        TypeInterface ti = logicalObject.getTypeInterface();
        if (ti == null) {
            return false;
        }
        ObjectFactoryInterface ofi = ti.getObjectFactory();
        return ofi instanceof SmartObjectFactoryInterface;
    }

    public List<? extends WAPropertyTab> getPropertyTabs(LogicalObjectInterface logicalObject, ChildServerInterface childServerInterface, MetadataInterface metadataInterface, Root complex, Config config) throws MdException, RemoteException {
        TypeInterface ti = logicalObject.getTypeInterface();
        if (ti == null) {
            return new ArrayList(0);
        }
        ObjectFactoryInterface ofi = ti.getObjectFactory();
        if (ofi instanceof SmartObjectFactoryInterface) {
            SmartObjectFactoryInterface sofi = (SmartObjectFactoryInterface)((Object)ofi);
            return sofi.getPropertyTabs(logicalObject, childServerInterface, metadataInterface, complex, config);
        }
        return ofi.getPropertyTabs(logicalObject, complex, config);
    }

    public List<? extends WAPropertyTab> getPropertyTabs(LogicalObjectInterface logicalObject, Root complex, Config config) throws MdException, RemoteException {
        FolderInterface fi;
        if (!logicalObject.getID().equalsIgnoreCase(complex.getFQID())) {
            throw new IllegalArgumentException("Logic error: inconsistent argument.  " + logicalObject.getID() + " is not equal to " + complex.getFQID());
        }
        TypeInterface ti = logicalObject.getTypeInterface();
        if (ti.getMetadataType().length() > 0 && !logicalObject.getTypeInterface().getMetadataType().equalsIgnoreCase(complex.getCMetadataType())) {
            throw new IllegalArgumentException("Logic error: inconsistent argument.  " + logicalObject.getTypeInterface().getMetadataType() + " is not equal to " + complex.getCMetadataType());
        }
        if (logicalObject instanceof FolderInterface && !(fi = (FolderInterface)logicalObject).isRoot()) {
            FolderLogicalObject folder = (FolderLogicalObject)logicalObject;
            return folder.getPropertyTabs(logicalObject, complex, config);
        }
        if (ti == null) {
            return new ArrayList(0);
        }
        return ti.getObjectFactory().getPropertyTabs(logicalObject, complex, config);
    }

    public List<? extends WAPropertyTab> getPropertyTabs(LogicalObjectInterface logicalObject, MdObjectStore objectStore, ObjectContainer objectContainer, Config config) throws MdException, RemoteException {
        Root complex;
        String jomaType = logicalObject.getTypeInterface().getMetadataType();
        if (jomaType.length() > 0) {
            complex = (Root)this.getOMIUtil().getMetadataAllDepths((MdStore)objectStore, jomaType, logicalObject.getID(), null, null, null, 264);
        } else {
            String options = "<XMLSelect search=\"@ID='" + logicalObject.getID() + "'\"/>";
            String reposID = UtilMetadata.makeRepositoryFQIDFromRoot(logicalObject.getID());
            List list = this.getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, reposID, "Root", 408, options);
            if (list.size() != 1) {
                throw new MdException(UtilMisc.getMessage(RB.getStringResource("FAC.noUniqObj.fmt.txt"), logicalObject.getID(), Integer.toString(list.size())));
            }
            complex = (Root)list.get(0);
        }
        objectContainer.setObject(complex);
        return this.getPropertyTabs(logicalObject, complex, config);
    }

    public ISecurity getISecurity() {
        if (!this._iSecurityIsCurrent) {
            this._iSecurity = null;
            try {
                MdOMRConnection mdOMRConnection = this._mdFactory.getConnection();
                if (mdOMRConnection != null) {
                    this._iSecurity = mdOMRConnection.MakeISecurityConnection();
                }
            }
            catch (Exception e) {
                this.error(e, null);
            }
            this._iSecurityIsCurrent = true;
        }
        return this._iSecurity;
    }

    public IOMI getIOMI() throws LogicalTypeException, RemoteException {
        if (!this._IOMIIsCurrent) {
            MdOMRConnection mdOMRConnection = this._mdFactory.getConnection();
            if (mdOMRConnection != null) {
                this._IOMI = mdOMRConnection.getCMRHandle();
            }
            if (this._IOMI == null) {
                throw new LogicalTypeException(RB.getStringResource("FAC.noIOMI.txt"));
            }
            this._IOMIIsCurrent = true;
        }
        return this._IOMI;
    }

    public String[] getNeededAttributes() {
        return this._neededAttributes;
    }

    public String getTemplateFormOfNeededAttributes() {
        if (this._templateFormOfNeededAttributes == null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this._neededAttributes.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(this._neededAttributes[i]);
                sb.append("=\"\"");
            }
            this._templateFormOfNeededAttributes = sb.toString();
        }
        return this._templateFormOfNeededAttributes;
    }

    public String getTemplateFormOfRequiredAndNeededAttributes(TypeInterface ti) {
        String neededAttributes;
        StringBuffer sb = new StringBuffer();
        String[] requiredAttributes = _requiredAttributes;
        if (requiredAttributes != null) {
            for (int i = 0; i < requiredAttributes.length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                sb.append(requiredAttributes[i]);
                sb.append("=\"\"");
            }
        }
        if ((neededAttributes = this.getTemplateFormOfNeededAttributes()).length() > 0) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(neededAttributes);
        }
        return sb.toString();
    }

    public void destroy() {
        UtilPlatformServices.destroy();
        this._mdOMIUtil = null;
        this._metadataServerInterface = null;
        this._projectRepositoryStatusMap.clear();
        this._projectRepositoryStatusMap = null;
        this._topLevelFoldersMap.clear();
        this._topLevelFoldersMap = null;
        this._reposidPermissionMap.clear();
        this._reposidPermissionMap = null;
        if (this._typeDescriptorMap != null) {
            this._typeDescriptorMap.clear();
        }
        this._typeDescriptorMap = null;
        this._typeMap.clear();
        this._typeMap = null;
        this._rootFolder = null;
        this._mdFactory = null;
        _theInstance = null;
        this._initialized = false;
    }

    public boolean isProjectRepository(String reposID) throws LogicalTypeException, RemoteException, MdException {
        Boolean value = this._projectRepositoryStatusMap.get(reposID);
        if (value != null) {
            return value;
        }
        String reposType = this.getMdFactory().getRepositoryUtil().getRepositoryType(reposID);
        boolean retVal = reposType.equalsIgnoreCase("PROJECT");
        this._projectRepositoryStatusMap.put(reposID, retVal);
        return retVal;
    }

    public MdFactory getMdFactory() {
        return this._mdFactory;
    }

    public MdOMIUtil getOMIUtil() {
        return this._mdOMIUtil;
    }

    public MetadataServerInterface getMetadataServerInterface() {
        return this._metadataServerInterface;
    }

    public MdObjectStore getScratchStore() throws RemoteException {
        return this._scratchStore;
    }

    boolean isContentMappingStatusDeterminableFromRootAndTopLevelFolders(ObjectContainer oc) throws RemoteException, LogicalTypeException {
        if (this.getRootFolder().isContentBacked()) {
            oc.setObject(true);
            return true;
        }
        boolean topLevelWithCMExists = false;
        boolean topLevelWithoutCMExists = false;
        for (FolderInterface folderInterface : this._topLevelFoldersMap.values()) {
            if (folderInterface.isContentBacked()) {
                topLevelWithCMExists = true;
                continue;
            }
            topLevelWithoutCMExists = true;
        }
        if (topLevelWithCMExists && topLevelWithoutCMExists) {
            return false;
        }
        if (topLevelWithCMExists) {
            oc.setObject(true);
            return true;
        }
        if (topLevelWithoutCMExists) {
            oc.setObject(false);
            return true;
        }
        return false;
    }

    boolean isContentMappingDefinedOnTopLevelFolders() throws RemoteException, LogicalTypeException {
        for (FolderInterface folderInterface : this._topLevelFoldersMap.values()) {
            if (!folderInterface.isContentBacked()) continue;
            return true;
        }
        return false;
    }

    boolean getWriteAllowedOnRepository(LogicalObjectInterface loi) throws LogicalTypeException, RemoteException {
        String reposID = UtilMetadata.makeRepositoryFQIDFromRoot(loi.getID());
        Boolean b = this._reposidPermissionMap.get(reposID);
        if (b == null) {
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                MetadataInterface mi = detachedTransaction.getSmartObject(loi);
                OMIRepositoryInterface ri = (OMIRepositoryInterface)mi.getRepository();
                b = new Boolean(ri.isUserAuthorizedInRepository("WriteMetadata"));
                this._reposidPermissionMap.put(reposID, b);
            }
            catch (ServiceException e) {
                throw new LogicalTypeException((Exception)((Object)e));
            }
            finally {
                if (detachedTransaction != null) {
                    detachedTransaction.rollback();
                }
            }
        }
        return b;
    }

    public void error(Throwable t, String message) {
        if (t == null) {
            this.error(message);
        } else {
            this._logger.error(message == null ? "" : message, t);
        }
    }

    public void error(String message) {
        if (message != null) {
            this._logger.error(message);
        }
    }

    public void info(String message) {
        if (message != null) {
            this._logger.info(message);
        }
    }

    public void warn(Throwable t, String message) {
        if (t == null) {
            this.warn(message);
        } else {
            this._logger.warn(message == null ? "" : message, t);
        }
    }

    public void warn(String message) {
        if (message != null) {
            this._logger.warn(message);
        }
    }

    public void debug(String message) {
        if (message != null) {
            this._logger.debug(message);
        }
    }

    public void connectionNotification(MetadataConnectionEvent event) throws RemoteException {
        this._iSecurityIsCurrent = false;
        this._IOMIIsCurrent = false;
    }

    static {
        _requiredAttributes = new String[]{"UsageVersion", "PublicType"};
    }

    class TypeMappedObject {
        private String _type;
        private TypeDescriptorInterface _typeDescriptor;
        private TypeInterface _typeInterface;
        boolean _triedToLoadTypeInterface;
        boolean _internalUse;

        TypeMappedObject(String type, boolean internalUse) {
            this._type = type;
            this._internalUse = internalUse;
        }

        synchronized TypeInterface getTypeInterface() throws RemoteException, LogicalTypeException {
            String ltClassName;
            if (this._triedToLoadTypeInterface) {
                return this._typeInterface;
            }
            this._triedToLoadTypeInterface = true;
            if (this._type.equals("Folder")) {
                this._typeInterface = FolderType.getInstance(Factory.this, this._typeDescriptor);
                return this._typeInterface;
            }
            if (this._type.equals("RootFolder")) {
                this._typeInterface = RootFolderType.getInstance(Factory.this, this._typeDescriptor);
                return this._typeInterface;
            }
            try {
                ltClassName = this._typeDescriptor.getLogicalTypeClassName();
            }
            catch (ServiceException e1) {
                throw new LogicalTypeException((Exception)((Object)e1));
            }
            if (ltClassName == null) {
                if (Factory.this._useTypeSpecificUnknownType) {
                    this._typeInterface = new TypeSpecificUnknownType(Factory.this, this._typeDescriptor);
                    return this._typeInterface;
                }
                return null;
            }
            try {
                TypeInterface ti;
                Class c = com.sas.services.information.Factory.getInstance().loadClass(ltClassName);
                Method m = c.getMethod("getInstance", Factory.class, TypeDescriptorInterface.class);
                this._typeInterface = ti = (TypeInterface)m.invoke(null, Factory.this, this._typeDescriptor);
                return this._typeInterface;
            }
            catch (ClassNotFoundException e) {
                Factory.this.info("Logical Type class " + ltClassName + " not found.  " + e.toString());
                if (Factory.this._useTypeSpecificUnknownType) {
                    this._typeInterface = new TypeSpecificUnknownType(Factory.this, this._typeDescriptor);
                    return this._typeInterface;
                }
            }
            catch (Throwable t) {
                Factory.this.error("Error loading Logical Type class " + ltClassName + ".  " + t.toString());
            }
            return null;
        }
    }
}

