/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.converter.etl.ETLContext;
import MITI.converter.etl.FeatureMapper;
import MITI.converter.etl.MIREtlModelProcessor;
import MITI.converter.etl.expression.ExpressionCopier;
import MITI.converter.etl.expression.ExpressionPrinter;
import MITI.converter.etl.expression.HavingExpressionAnalyzer;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRAggregationTransformation;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRConnectionDataAttribute;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionDataSet;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDelimitedFileDescriptor;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRExpressionTransformation;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFilteringTransformation;
import MITI.sdk.MIRFixedWidthFileDescriptor;
import MITI.sdk.MIRFlatFileDescriptor;
import MITI.sdk.MIRJoinTransformation;
import MITI.sdk.MIRLookupTransformation;
import MITI.sdk.MIRModelObject;
import MITI.sdk.MIRObject;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRQueryColumn;
import MITI.sdk.MIRQueryFilter;
import MITI.sdk.MIRQueryJoin;
import MITI.sdk.MIRQueryLookup;
import MITI.sdk.MIRQuerySort;
import MITI.sdk.MIRQuerySortItem;
import MITI.sdk.MIRQueryTable;
import MITI.sdk.MIRQueryUnion;
import MITI.sdk.MIRReaderTransformation;
import MITI.sdk.MIRSortingTransformation;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRTransformation;
import MITI.sdk.MIRTransformationDataAttribute;
import MITI.sdk.MIRTransformationDataSet;
import MITI.sdk.MIRTransformationSortItem;
import MITI.sdk.MIRUnionTransformation;
import MITI.sdk.MIRUnionType;
import MITI.sdk.MIRWriterTransformation;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class TableBlock {
    private static String INPUT_DATASET_NAME = "input_dataset";
    private static String OUTPUT_DATASET_NAME = "output_dataset";
    private Map<MIRQueryTable, MIRTransformationDataSet> inputMap = new HashMap<MIRQueryTable, MIRTransformationDataSet>();
    private MIRTransformationDataSet output;
    private MIRQueryTable from;
    private LinkedList<MIRTransformation> transformations = new LinkedList();
    private FeatureMapper mapper = null;
    private HavingExpressionAnalyzer havingExpression = null;

    private TableBlock(MIRQueryTable mIRQueryTable) {
        BLIB.DBG_DEBUG.log(String.format("Creating table block from '%s' query table", mIRQueryTable.getName()));
        this.from = mIRQueryTable;
        this.havingExpression = new HavingExpressionAnalyzer(ETLContext.model);
        this.mapper = new FeatureMapper();
    }

    public static TableBlock fromTable(MIRQueryTable mIRQueryTable) {
        BLIB.DBG_DEBUG.log(String.format("Processing Query table '%s'", mIRQueryTable.getName()));
        TableBlock tableBlock = new TableBlock(mIRQueryTable);
        tableBlock.transform();
        tableBlock.stitchTransformations();
        return tableBlock;
    }

    public MIRFeature getOriginalFeature(MIRFeature mIRFeature) {
        return this.mapper.getOriginalFeatureFromCopy(mIRFeature);
    }

    public MIRFeature getCopyofOriginalFeature(MIRClassifier mIRClassifier, MIRFeature mIRFeature) {
        return this.mapper.getCopyOfOriginalFeature(mIRClassifier, mIRFeature);
    }

    private void transform() {
        BLIB.DBG_DEBUG.log(String.format("Creating transformations from query table '%s'", this.from.getName()));
        if (this.from.getSourceOfQueryLookup() != null) {
            return;
        }
        MIRReaderTransformation mIRReaderTransformation = this.processReader();
        if (mIRReaderTransformation != null) {
            this.output = mIRReaderTransformation.getOutputTransformationDataSet();
            ETLContext.model.addTransformationUniqueName(mIRReaderTransformation);
        } else {
            MIRSqlQuery mIRSqlQuery;
            MIRElement mIRElement;
            MIRElement mIRElement2;
            Object object7;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            MIRElement mIRElement3;
            Object object6;
            MIRModelObject mIRModelObject;
            MIRClassifierMap mIRClassifierMap = this.from.getDestinationOfClassifierMap();
            HashSet<MIRClassifier> hashSet = new HashSet<MIRClassifier>();
            if (mIRClassifierMap != null) {
                for (MIRClassifier mIRElement42 : mIRClassifierMap.getSourceClassifiers()) {
                    if (((MIRQueryTable)mIRElement42).getSourceOfQueryLookup() != null) continue;
                    hashSet.add(mIRElement42);
                }
            }
            Object object8 = null;
            MIRWriterTransformation mIRWriterTransformation = this.processWriter();
            if (mIRWriterTransformation != null) {
                mIRModelObject = mIRWriterTransformation.getInputTransformationDataSet();
                object6 = hashSet.iterator();
                while (object6.hasNext()) {
                    mIRElement3 = (MIRClassifier)object6.next();
                    this.inputMap.put((MIRQueryTable)mIRElement3, (MIRTransformationDataSet)mIRModelObject);
                }
                this.transformations.add(mIRWriterTransformation);
                this.output = null;
                object8 = mIRModelObject;
                ETLContext.model.addTransformationUniqueName(mIRWriterTransformation);
            }
            if ((mIRModelObject = ((MIRSqlQuery)this.from.getParent()).getTopQueryUnion()) != null && (object6 = this.processUnion((MIRQueryUnion)mIRModelObject)) != null) {
                if (this.output == null) {
                    this.output = ((MIRUnionTransformation)object6).getOutputTransformationDataSet();
                }
                if (object8 != null) {
                    mIRElement3 = new MIRClassifierMap();
                    ((MIRClassifierMap)mIRElement3).addSourceClassifier(((MIRUnionTransformation)object6).getOutputTransformationDataSet());
                    ((MIRClassifierMap)mIRElement3).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)mIRElement3);
                }
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object6);
                return;
            }
            object6 = this.processSort();
            if (object6 != null) {
                this.transformations.add((MIRTransformation)object6);
                if (this.output == null) {
                    this.output = ((MIRSortingTransformation)object6).getOutputTransformationDataSet();
                }
                mIRElement3 = ((MIRSortingTransformation)object6).getInputTransformationDataSet();
                object5 = hashSet.iterator();
                while (object5.hasNext()) {
                    object4 = (MIRClassifier)object5.next();
                    this.inputMap.put((MIRQueryTable)object4, (MIRTransformationDataSet)mIRElement3);
                }
                if (object8 != null) {
                    object5 = new MIRClassifierMap();
                    ((MIRClassifierMap)object5).addSourceClassifier(((MIRSortingTransformation)object6).getOutputTransformationDataSet());
                    ((MIRClassifierMap)object5).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)object5);
                }
                object8 = mIRElement3;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object6);
            }
            if ((mIRElement3 = this.processHavingFilter()) != null) {
                this.transformations.add((MIRTransformation)mIRElement3);
                if (this.output == null) {
                    this.output = ((MIRFilteringTransformation)mIRElement3).getOutputTransformationDataSet(OUTPUT_DATASET_NAME);
                }
                object5 = ((MIRFilteringTransformation)mIRElement3).getInputTransformationDataSet();
                object4 = hashSet.iterator();
                while (object4.hasNext()) {
                    object3 = (MIRClassifier)object4.next();
                    this.inputMap.put((MIRQueryTable)object3, (MIRTransformationDataSet)object5);
                }
                if (object8 != null) {
                    object4 = new MIRClassifierMap();
                    ((MIRClassifierMap)object4).addSourceClassifier(((MIRFilteringTransformation)mIRElement3).getOutputTransformationDataSet(OUTPUT_DATASET_NAME));
                    ((MIRClassifierMap)object4).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)object4);
                }
                object8 = object5;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)mIRElement3);
            }
            if ((object5 = this.processAggregationExpression()) != null) {
                this.transformations.add((MIRTransformation)object5);
                if (this.output == null) {
                    this.output = ((MIRExpressionTransformation)object5).getOutputTransformationDataSet();
                }
                object4 = ((MIRExpressionTransformation)object5).getInputTransformationDataSet();
                object3 = hashSet.iterator();
                while (object3.hasNext()) {
                    object2 = (MIRClassifier)object3.next();
                    this.inputMap.put((MIRQueryTable)object2, (MIRTransformationDataSet)object4);
                }
                if (object8 != null) {
                    object3 = new MIRClassifierMap();
                    ((MIRClassifierMap)object3).addSourceClassifier(((MIRExpressionTransformation)object5).getOutputTransformationDataSet());
                    ((MIRClassifierMap)object3).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)object3);
                }
                object8 = object4;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object5);
            }
            if ((object4 = this.processAggregation()) != null) {
                this.transformations.add((MIRTransformation)object4);
                if (this.output == null) {
                    this.output = ((MIRAggregationTransformation)object4).getOutputTransformationDataSet();
                }
                object3 = ((MIRAggregationTransformation)object4).getInputTransformationDataSet();
                for (MIRClassifier mIRClassifier : hashSet) {
                    this.inputMap.put((MIRQueryTable)mIRClassifier, (MIRTransformationDataSet)object3);
                }
                if (object8 != null) {
                    object2 = new MIRClassifierMap();
                    ((MIRClassifierMap)object2).addSourceClassifier(((MIRAggregationTransformation)object4).getOutputTransformationDataSet());
                    ((MIRClassifierMap)object2).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)object2);
                }
                object8 = object3;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object4);
            }
            if ((object3 = this.processExpression()) != null) {
                this.transformations.add((MIRTransformation)object3);
                if (this.output == null) {
                    this.output = ((MIRExpressionTransformation)object3).getOutputTransformationDataSet();
                }
                object2 = ((MIRExpressionTransformation)object3).getInputTransformationDataSet();
                for (Object object7 : hashSet) {
                    this.inputMap.put((MIRQueryTable)object7, (MIRTransformationDataSet)object2);
                }
                if (object8 != null) {
                    MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
                    mIRClassifierMap2.addSourceClassifier(((MIRExpressionTransformation)object3).getOutputTransformationDataSet());
                    mIRClassifierMap2.addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap(mIRClassifierMap2);
                }
                object8 = object2;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object3);
            }
            for (MIRFeature mIRFeature : this.from.getFeatures()) {
                if (mIRFeature.getElementType() != 335 || (mIRElement2 = this.processLookup((MIRQueryLookup)(object7 = (MIRQueryLookup)mIRFeature))) == null) continue;
                this.transformations.add((MIRTransformation)mIRElement2);
                if (this.output == null) {
                    this.output = ((MIRLookupTransformation)mIRElement2).getOutputTransformationDataSet(OUTPUT_DATASET_NAME);
                }
                mIRElement = ((MIRLookupTransformation)mIRElement2).getControlTransformationDataSet();
                for (MIRClassifier mIRClassifier : hashSet) {
                    this.inputMap.put((MIRQueryTable)mIRClassifier, (MIRTransformationDataSet)mIRElement);
                }
                if (object8 != null) {
                    MIRClassifierMap mIRClassifierMap3 = new MIRClassifierMap();
                    mIRClassifierMap3.addSourceClassifier(((MIRLookupTransformation)mIRElement2).getOutputTransformationDataSet(OUTPUT_DATASET_NAME));
                    mIRClassifierMap3.addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap(mIRClassifierMap3);
                }
                object8 = mIRElement;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)mIRElement2);
            }
            object2 = this.processFilter();
            if (object2 != null) {
                this.transformations.add((MIRTransformation)object2);
                if (this.output == null) {
                    this.output = ((MIRFilteringTransformation)object2).getOutputTransformationDataSet(OUTPUT_DATASET_NAME);
                }
                MIRTransformationDataSet mIRTransformationDataSet = ((MIRFilteringTransformation)object2).getInputTransformationDataSet();
                object7 = hashSet.iterator();
                while (object7.hasNext()) {
                    mIRElement2 = (MIRClassifier)object7.next();
                    this.inputMap.put((MIRQueryTable)mIRElement2, mIRTransformationDataSet);
                }
                if (object8 != null) {
                    object7 = new MIRClassifierMap();
                    ((MIRClassifierMap)object7).addSourceClassifier(((MIRFilteringTransformation)object2).getOutputTransformationDataSet(OUTPUT_DATASET_NAME));
                    ((MIRClassifierMap)object7).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)object7);
                }
                object8 = mIRTransformationDataSet;
                ETLContext.model.addTransformationUniqueName((MIRTransformation)object2);
            }
            if ((object7 = (mIRSqlQuery = (MIRSqlQuery)this.from.getParent()).getTopQueryJoin()) != null && (mIRElement2 = this.processJoin((MIRQueryJoin)object7)) != null) {
                if (this.output == null) {
                    this.output = ((MIRJoinTransformation)mIRElement2).getOutputTransformationDataSet();
                }
                if (object8 != null) {
                    mIRElement = new MIRClassifierMap();
                    ((MIRClassifierMap)mIRElement).addSourceClassifier(((MIRJoinTransformation)mIRElement2).getOutputTransformationDataSet());
                    ((MIRClassifierMap)mIRElement).addDestinationClassifier((MIRClassifier)object8);
                    ETLContext.model.addClassifierMap((MIRClassifierMap)mIRElement);
                }
            }
        }
    }

    private void stitchTransformations() {
        MIRElement mIRElement;
        BLIB.DBG_DEBUG.log("Stitching transformations..");
        if (this.transformations.size() == 0) {
            return;
        }
        MIRTransformation mIRTransformation = this.transformations.peekFirst();
        if (mIRTransformation.getElementType() != 260) {
            for (MIRModelObject mIRModelObject : this.from.getFeatures()) {
                if (mIRModelObject.getElementType() != 242 || mIRModelObject.getSourceOfFeatureMapCount() == 0 || (mIRElement = this.mapper.getCopyOfOriginalFeature(this.output, (MIRFeature)mIRModelObject)) != null) continue;
                mIRElement = this.mapper.getOrAdd((MIRFeature)mIRModelObject, this.output);
            }
            this.stitchToLeft(this.output);
        }
        while (this.transformations.size() > 0) {
            MIRModelObject mIRModelObject;
            MIRTransformation mIRTransformation2 = this.transformations.poll();
            mIRModelObject = null;
            if (mIRTransformation2.getElementType() == 260) {
                mIRElement = (MIRWriterTransformation)mIRTransformation2;
                mIRModelObject = ((MIRWriterTransformation)mIRElement).getInputTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 253) {
                mIRElement = (MIRSortingTransformation)mIRTransformation2;
                mIRModelObject = ((MIRSortingTransformation)mIRElement).getInputTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 236) {
                mIRElement = (MIRExpressionTransformation)mIRTransformation2;
                mIRModelObject = ((MIRExpressionTransformation)mIRElement).getInputTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 237) {
                mIRElement = (MIRFilteringTransformation)mIRTransformation2;
                mIRModelObject = ((MIRFilteringTransformation)mIRElement).getInputTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 240) {
                mIRElement = (MIRJoinTransformation)mIRTransformation2;
                mIRModelObject = ((MIRJoinTransformation)mIRElement).getLeftTransformationDataSet();
                this.stitchToLeft((MIRTransformationDataSet)mIRModelObject);
                mIRModelObject = ((MIRJoinTransformation)mIRElement).getRightTransformationDataSet();
                this.stitchToLeft((MIRTransformationDataSet)mIRModelObject);
                mIRModelObject = null;
            }
            if (mIRTransformation2.getElementType() == 219) {
                mIRElement = (MIRAggregationTransformation)mIRTransformation2;
                mIRModelObject = ((MIRAggregationTransformation)mIRElement).getInputTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 241) {
                mIRElement = (MIRLookupTransformation)mIRTransformation2;
                mIRModelObject = ((MIRLookupTransformation)mIRElement).getControlTransformationDataSet();
            }
            if (mIRTransformation2.getElementType() == 259) {
                mIRElement = (MIRUnionTransformation)mIRTransformation2;
                for (MIRTransformationDataSet mIRTransformationDataSet : ((MIRUnionTransformation)mIRElement).getInputTransformationDataSets()) {
                    this.stitchToLeft(mIRTransformationDataSet);
                }
                mIRModelObject = null;
            }
            if (mIRModelObject == null) continue;
            this.stitchToLeft((MIRTransformationDataSet)mIRModelObject);
        }
        MIREtlModelProcessor.checkAggregations(ETLContext.model);
    }

    private void stitchToLeft(MIRTransformationDataSet mIRTransformationDataSet) {
        for (MIRFeature mIRFeature : mIRTransformationDataSet.getFeatures()) {
            MIRClassifier mIRClassifier;
            if (mIRFeature.getDestinationOfFeatureMap() != null) continue;
            MIRFeature mIRFeature2 = null;
            MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet.getDestinationOfClassifierMap();
            if (mIRClassifierMap == null) continue;
            Object object = mIRClassifierMap.getSourceClassifiers().iterator();
            while (object.hasNext() && (mIRFeature2 = this.getSourceFeatureFor(mIRFeature, (MIRTransformationDataSet)(mIRClassifier = (MIRClassifier)object.next()))) == null) {
            }
            if (mIRFeature2 != null) {
                object = mIRFeature.getDestinationOfFeatureMap();
                if (object == null) {
                    object = new MIRFeatureMap();
                    ((MIRFeatureMap)object).addDestinationFeature(mIRFeature);
                    mIRClassifierMap.addFeatureMap((MIRFeatureMap)object);
                }
                if (((MIRFeatureMap)object).getSourceFeature(mIRFeature2.getName()) != null) continue;
                ((MIRFeatureMap)object).addSourceFeature(mIRFeature2);
                continue;
            }
            MBCONV.CAN_NOT_STITCH_FEATURE.log(mIRTransformationDataSet.getParent().getName(), mIRTransformationDataSet.getName(), mIRFeature.getName());
        }
    }

    private MIRFeature getSourceFeatureFor(MIRFeature mIRFeature, MIRTransformationDataSet mIRTransformationDataSet) {
        MIRModelObject mIRModelObject;
        block6: {
            MIRFeature mIRFeature2;
            MIRFeature mIRFeature3;
            block7: {
                MIRModelObject mIRModelObject2;
                mIRFeature3 = this.mapper.getOriginalFeatureFromCopy(mIRFeature);
                MIRFeatureMap mIRFeatureMap = mIRFeature3.getDestinationOfFeatureMap();
                mIRFeature2 = null;
                if (mIRFeatureMap != null && mIRFeatureMap.getSourceFeatureCount() > 0 && mIRFeatureMap.getOperation().isEmpty()) {
                    mIRFeature2 = mIRFeatureMap.getSourceFeatures().first();
                }
                if ((mIRModelObject = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet, mIRFeature3)) == null && mIRFeature2 != null) {
                    mIRModelObject = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet, mIRFeature2);
                }
                if (mIRModelObject != null) break block6;
                MIRClassifierMap mIRClassifierMap = mIRTransformationDataSet.getDestinationOfClassifierMap();
                if (mIRClassifierMap == null) break block7;
                if (!mIRClassifierMap.getName().isEmpty()) {
                    return null;
                }
                Object object = mIRClassifierMap.getSourceClassifiers().iterator();
                while (object.hasNext() && (mIRModelObject = this.getSourceFeatureFor(mIRFeature, (MIRTransformationDataSet)(mIRModelObject2 = (MIRClassifier)object.next()))) == null) {
                }
                if (mIRModelObject == null) break block6;
                object = this.mapper.getOriginalFeatureFromCopy((MIRFeature)mIRModelObject);
                mIRModelObject2 = this.mapper.getOrAdd((MIRFeature)object, mIRTransformationDataSet);
                MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
                mIRFeatureMap2.addDestinationFeature((MIRFeature)mIRModelObject2);
                mIRFeatureMap2.addSourceFeature((MIRFeature)mIRModelObject);
                mIRClassifierMap.addFeatureMap(mIRFeatureMap2);
                mIRModelObject = mIRModelObject2;
                break block6;
            }
            for (Map.Entry<MIRQueryTable, MIRTransformationDataSet> entry : this.inputMap.entrySet()) {
                if (entry.getValue() != mIRTransformationDataSet) continue;
                MIRQueryTable mIRQueryTable = entry.getKey();
                if (mIRFeature3.getParent() == mIRQueryTable) {
                    mIRModelObject = this.mapper.getOrAdd(mIRFeature3, mIRTransformationDataSet);
                    break;
                }
                if (mIRFeature2 == null || mIRFeature2.getParent() != mIRQueryTable) continue;
                mIRModelObject = this.mapper.getOrAdd(mIRFeature2, mIRTransformationDataSet);
                break;
            }
        }
        return mIRModelObject;
    }

    public MIRTransformationDataSet getOutput() {
        return this.output;
    }

    public MIRTransformationDataSet getInput(MIRQueryTable mIRQueryTable) {
        if (this.inputMap.containsKey(mIRQueryTable)) {
            return this.inputMap.get(mIRQueryTable);
        }
        MBCONV.NO_TABLEBLOCK_INPUT_FOR_QUERYTABLE.log(this.getName(), mIRQueryTable.getName());
        return null;
    }

    public String getName() {
        return this.from.getName();
    }

    private MIRConnectionDataAttribute createConnectionDataAttributeFromColumn(MIRFeature mIRFeature) {
        MIRConnectionDataAttribute mIRConnectionDataAttribute = new MIRConnectionDataAttribute();
        mIRConnectionDataAttribute.setName(mIRFeature.getName());
        mIRConnectionDataAttribute.setDescription(mIRFeature.getDescription());
        mIRConnectionDataAttribute.setComment(mIRFeature.getComment());
        mIRConnectionDataAttribute.setPhysicalName(mIRFeature.getPhysicalName());
        return mIRConnectionDataAttribute;
    }

    private void logCreateTransformation(String string) {
        BLIB.DBG_DEBUG.log(String.format("Creating %s from query table %s", string, this.from.getName()));
    }

    /*
     * WARNING - void declaration
     */
    private MIRReaderTransformation processReader() {
        MIRModelObject mIRModelObject2;
        Object object;
        Object object3;
        MIRElement mIRElement;
        MIRElement mIRElement222;
        MIRClassifierMap mIRClassifierMap = this.from.getDestinationOfClassifierMap();
        if (mIRClassifierMap != null) {
            for (MIRElement mIRElement222 : mIRClassifierMap.getSourceClassifiers()) {
                if (mIRElement222 == this.from) continue;
                return null;
            }
        }
        this.logCreateTransformation(MIRElementType.getName((short)251));
        MIRReaderTransformation mIRReaderTransformation = new MIRReaderTransformation();
        mIRReaderTransformation.setName(this.from.getName() + "_Reader");
        mIRElement222 = this.from.getFlatFileDescriptor();
        if (mIRElement222 != null) {
            mIRElement = null;
            if (mIRElement222 instanceof MIRDelimitedFileDescriptor) {
                mIRElement = new MIRDelimitedFileDescriptor();
            } else if (mIRElement222 instanceof MIRFixedWidthFileDescriptor) {
                mIRElement = new MIRFixedWidthFileDescriptor();
            }
            if (mIRElement != null) {
                void var6_8;
                ((MIRFlatFileDescriptor)mIRElement).setFrom(mIRElement222);
                mIRReaderTransformation.addFlatFileDescriptor((MIRFlatFileDescriptor)mIRElement222);
                object3 = this.from.getConnectionDataPackage();
                String object22 = this.from.getName();
                if (object3 != null) {
                    String string = MIRBridgeLib.getFilePath((MIRElement)object3) + File.separator + object22;
                }
                mIRReaderTransformation.setConnectionName((String)var6_8);
            }
        }
        mIRElement = this.createDataSet(this.from.getName());
        ((MIRModelObject)mIRElement).setPhysicalName(this.from.getPhysicalName());
        mIRReaderTransformation.addOutputTransformationDataSet((MIRTransformationDataSet)mIRElement);
        for (MIRFeature mIRFeature : this.from.getFeatures()) {
            if (mIRFeature.getElementType() != 242 || mIRFeature.getSourceOfFeatureMapCount() <= 0) continue;
            object = this.mapper.getOrAdd(mIRFeature, (MIRClassifier)mIRElement);
            ((MIRElement)object).setDescription(mIRFeature.getDescription());
            ((MIRModelObject)object).setComment(mIRFeature.getComment());
        }
        object3 = new MIRConnectionDataSet();
        ((MIRObject)object3).setName(this.from.getName());
        ((MIRModelObject)object3).setPhysicalName(this.from.getPhysicalName());
        MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
        mIRClassifierMap2.addSourceClassifier((MIRClassifier)object3);
        mIRClassifierMap2.addDestinationClassifier((MIRClassifier)mIRElement);
        for (MIRModelObject mIRModelObject2 : ((MIRClassifier)mIRElement).getFeatures()) {
            MIRFeature mIRFeature = this.mapper.getOriginalFeatureFromCopy((MIRFeature)mIRModelObject2);
            MIRConnectionDataAttribute mIRConnectionDataAttribute = this.createConnectionDataAttributeFromColumn(mIRFeature);
            ((MIRClassifier)object3).addFeature(mIRConnectionDataAttribute);
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            mIRFeatureMap.addSourceFeature(mIRConnectionDataAttribute);
            mIRFeatureMap.addDestinationFeature((MIRFeature)mIRModelObject2);
            mIRClassifierMap2.addFeatureMap(mIRFeatureMap);
        }
        mIRReaderTransformation.addClassifierMap(mIRClassifierMap2);
        mIRReaderTransformation.addConnectionDataSet((MIRConnectionDataSet)object3);
        object = this.from.getConnectionDataPackage();
        if (object == null && this.from.getImportedByPackages().size() > 0 && (mIRModelObject2 = this.from.getImportedByPackages().first()) instanceof MIRConnectionDataPackage) {
            object = (MIRConnectionDataPackage)mIRModelObject2;
        }
        if (object != null) {
            if (ETLContext.connectionPackageMap.containsKey(object)) {
                ((MIRClassifier)object3).addConnectionDataPackage(ETLContext.connectionPackageMap.get(object));
            }
        } else {
            ((MIRClassifier)object3).addConnectionDataPackage(this.getDefaultConnectionPackage());
        }
        return mIRReaderTransformation;
    }

    private MIRQueryColumn castToColumn(MIRFeature mIRFeature) {
        if (mIRFeature.getElementType() == 242) {
            return (MIRQueryColumn)mIRFeature;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private MIRJoinTransformation processJoin(MIRQueryJoin mIRQueryJoin) {
        MIRModelObject mIRModelObject;
        Object object;
        MIRQueryTable mIRQueryTable = mIRQueryJoin.getLeftQueryTable();
        MIRQueryTable mIRQueryTable2 = mIRQueryJoin.getRightQueryTable();
        MIRClassifier mIRClassifier = mIRQueryJoin.getClassifier();
        if (mIRQueryTable == null && mIRQueryTable2 == null) {
            MBCONV.LEFT_RIGHT_JOINS_ARE_NULL.log(this.from.getName(), mIRQueryJoin.getName());
            return null;
        }
        MIRFeatureMap mIRFeatureMap = mIRQueryJoin.getDestinationOfFeatureMap();
        if (mIRFeatureMap == null) {
            MBCONV.JOIN_NO_DESTINATION_OF_FEATURE_MAP.log(mIRQueryJoin.getName(), this.from.getName());
            return null;
        }
        this.logCreateTransformation(MIRElementType.getName((short)240));
        MIRJoinTransformation mIRJoinTransformation = new MIRJoinTransformation();
        mIRJoinTransformation.setName(this.from.getName() + "_Join");
        mIRJoinTransformation.setType(mIRQueryJoin.getJoinType());
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME + "_right");
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(INPUT_DATASET_NAME + "_left");
        MIRTransformationDataSet mIRTransformationDataSet3 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRJoinTransformation.addLeftTransformationDataSet(mIRTransformationDataSet2);
        mIRJoinTransformation.addRightTransformationDataSet(mIRTransformationDataSet);
        mIRJoinTransformation.addOutputTransformationDataSet(mIRTransformationDataSet3);
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRJoinTransformation.addClassifierMap(mIRClassifierMap);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet2);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet3);
        for (MIRFeature mIRElement22 : mIRClassifier.getFeatures()) {
            void var14_15;
            MIRModelObject mIRModelObject22;
            Object object2;
            MIRTransformationDataSet mIRTransformationDataSet4;
            block19: {
                void var14_18;
                block18: {
                    Object object3;
                    block17: {
                        MIRFeature mIRFeature;
                        block16: {
                            object = mIRElement22.getDestinationOfFeatureMap();
                            if (object == null || !((MIRFeatureMap)object).getOperation().isEmpty() || ((MIRFeatureMap)object).getSourceFeatureCount() <= 0) continue;
                            mIRFeature = ((MIRFeatureMap)object).getSourceFeatures().first();
                            mIRTransformationDataSet4 = null;
                            mIRModelObject = mIRQueryJoin.getLeftQueryTable();
                            if (mIRModelObject == null) break block16;
                            if (!mIRModelObject.containsFeature(mIRFeature)) break block17;
                            mIRTransformationDataSet4 = mIRTransformationDataSet2;
                            break block17;
                        }
                        object3 = this.getJoinedTables(mIRQueryJoin.getLeftQueryJoin()).iterator();
                        while (object3.hasNext()) {
                            object2 = (MIRClassifier)object3.next();
                            if (!((MIRClassifier)object2).containsFeature(mIRFeature)) continue;
                            mIRTransformationDataSet4 = mIRTransformationDataSet2;
                            MIRFeature mIRFeature2 = mIRElement22;
                            break;
                        }
                    }
                    if ((object3 = mIRQueryJoin.getRightQueryTable()) == null) break block18;
                    if (!((MIRClassifier)object3).containsFeature((MIRFeature)var14_18)) break block19;
                    mIRTransformationDataSet4 = mIRTransformationDataSet;
                    break block19;
                }
                for (MIRModelObject mIRModelObject22 : this.getJoinedTables(mIRQueryJoin.getRightQueryJoin())) {
                    if (!mIRModelObject22.containsFeature((MIRFeature)var14_18)) continue;
                    mIRTransformationDataSet4 = mIRTransformationDataSet;
                    MIRFeature mIRFeature = mIRElement22;
                    break;
                }
            }
            if (mIRTransformationDataSet4 == null) continue;
            object2 = this.mapper.getOrAdd((MIRFeature)var14_15, mIRTransformationDataSet4);
            mIRModelObject22 = this.mapper.getOrAdd(mIRElement22, mIRTransformationDataSet3);
            MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
            mIRClassifierMap.addFeatureMap(mIRFeatureMap2);
            mIRFeatureMap2.addSourceFeature((MIRFeature)object2);
            mIRFeatureMap2.addDestinationFeature((MIRFeature)mIRModelObject22);
        }
        MIRCondition mIRCondition = new MIRCondition();
        mIRCondition.setName("JOIN CONDITION");
        mIRTransformationDataSet3.addFeature(mIRCondition);
        MIRFeatureMap mIRFeatureMap3 = new MIRFeatureMap();
        mIRFeatureMap3.addDestinationFeature(mIRCondition);
        mIRClassifierMap.addFeatureMap(mIRFeatureMap3);
        for (MIRFeature mIRFeature : mIRFeatureMap.getSourceFeatures()) {
            boolean bl = false;
            if (mIRQueryTable != null) {
                if (mIRFeature.getParent() == mIRQueryTable) {
                    bl = true;
                }
            } else if (mIRFeature.getParent() != mIRQueryTable2) {
                bl = true;
            }
            mIRModelObject = null;
            mIRModelObject = bl ? this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet2) : this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
            mIRFeatureMap3.addSourceFeature((MIRFeature)mIRModelObject);
        }
        this.copyExpression(mIRFeatureMap, mIRFeatureMap3);
        this.transformations.add(mIRJoinTransformation);
        ETLContext.model.addTransformationUniqueName(mIRJoinTransformation);
        if (mIRQueryTable == null) {
            object = mIRQueryJoin.getLeftQueryJoin();
            MIRJoinTransformation mIRJoinTransformation2 = this.processJoin((MIRQueryJoin)object);
            if (mIRJoinTransformation2 != null) {
                MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
                mIRClassifierMap2.addSourceClassifier(mIRJoinTransformation2.getOutputTransformationDataSet());
                mIRClassifierMap2.addDestinationClassifier(mIRTransformationDataSet2);
                ETLContext.model.addClassifierMap(mIRClassifierMap2);
            }
        } else {
            this.inputMap.put(mIRQueryTable, mIRTransformationDataSet2);
        }
        if (mIRQueryTable2 == null) {
            object = mIRQueryJoin.getRightQueryJoin();
            MIRJoinTransformation mIRJoinTransformation3 = this.processJoin((MIRQueryJoin)object);
            if (mIRJoinTransformation3 != null) {
                MIRClassifierMap mIRClassifierMap3 = new MIRClassifierMap();
                mIRClassifierMap3.addSourceClassifier(mIRJoinTransformation3.getOutputTransformationDataSet());
                mIRClassifierMap3.addDestinationClassifier(mIRTransformationDataSet);
                ETLContext.model.addClassifierMap(mIRClassifierMap3);
            }
        } else {
            this.inputMap.put(mIRQueryTable2, mIRTransformationDataSet);
        }
        return mIRJoinTransformation;
    }

    private Set<MIRClassifier> getJoinedTables(MIRQueryJoin mIRQueryJoin) {
        HashSet<MIRClassifier> hashSet = new HashSet<MIRClassifier>();
        if (mIRQueryJoin == null) {
            return hashSet;
        }
        MIRQueryTable mIRQueryTable = mIRQueryJoin.getLeftQueryTable();
        if (mIRQueryTable != null) {
            hashSet.add(mIRQueryTable);
        } else {
            hashSet.addAll(this.getJoinedTables(mIRQueryJoin.getLeftQueryJoin()));
        }
        MIRQueryTable mIRQueryTable2 = mIRQueryJoin.getRightQueryTable();
        if (mIRQueryTable2 != null) {
            hashSet.add(mIRQueryTable2);
        } else {
            hashSet.addAll(this.getJoinedTables(mIRQueryJoin.getRightQueryJoin()));
        }
        return hashSet;
    }

    private Set<MIRQueryFilter> getFilteredColumns(MIRQueryTable mIRQueryTable, byte by) {
        HashSet<MIRQueryFilter> hashSet = new HashSet<MIRQueryFilter>();
        for (MIRFeature mIRFeature : mIRQueryTable.getFeatures()) {
            MIRQueryFilter mIRQueryFilter;
            MIRFeatureMap mIRFeatureMap;
            if (mIRFeature.getElementType() != 333 || (mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap()) == null || mIRFeatureMap.getOperation().isEmpty() || (mIRQueryFilter = (MIRQueryFilter)mIRFeature).getFilterType() != by) continue;
            hashSet.add(mIRQueryFilter);
        }
        return hashSet;
    }

    private MIRFilteringTransformation processFilter() {
        Set<MIRQueryFilter> set = this.getFilteredColumns(this.from, (byte)0);
        if (set.size() == 0) {
            return null;
        }
        this.logCreateTransformation(MIRElementType.getName((short)237));
        MIRFilteringTransformation mIRFilteringTransformation = new MIRFilteringTransformation();
        mIRFilteringTransformation.setName(this.from.getName() + "_Filter");
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRFilteringTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        mIRFilteringTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRFilteringTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        MIRCondition mIRCondition = new MIRCondition();
        mIRCondition.setName("FILTER CONDITION");
        mIRTransformationDataSet2.addFeature(mIRCondition);
        MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
        mIRClassifierMap.addFeatureMap(mIRFeatureMap);
        mIRFeatureMap.addDestinationFeature(mIRCondition);
        HashSet<MIRExpression> hashSet = new HashSet<MIRExpression>();
        for (MIRFeature mIRFeature : set) {
            MIRFeatureMap mIRFeatureMap2 = mIRFeature.getDestinationOfFeatureMap();
            for (MIRFeature mIRFeature2 : mIRFeatureMap2.getSourceFeatures()) {
                MIRFeature mIRFeature3 = this.mapper.getOrAdd(mIRFeature2, mIRTransformationDataSet);
                mIRFeatureMap.addSourceFeature(mIRFeature3);
            }
            if (mIRFeatureMap2.getExpression() == null) continue;
            hashSet.add(mIRFeatureMap2.getExpression());
        }
        MIRExpression mIRExpression = this.uniteExpressions(hashSet);
        TableBlock.copyExpression(mIRExpression, mIRFeatureMap, this.mapper);
        return mIRFilteringTransformation;
    }

    private MIRExpression uniteExpressions(Set<MIRExpression> set) {
        if (set.size() == 0) {
            return null;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        Stack<MIRExpressionNode> stack = new Stack<MIRExpressionNode>();
        for (MIRExpression mIRElement2 : set) {
            for (MIRStatementNode mIRStatementNode : mIRElement2.getStatementNodes()) {
                for (MIRExpressionNode mIRExpressionNode : mIRStatementNode.getExpressionNodes()) {
                    stack.add(mIRExpressionNode);
                }
            }
        }
        MIRExpression mIRExpression = new MIRExpression();
        MIRStatementNode mIRStatementNode = new MIRStatementNode();
        mIRExpression.addStatementNode(mIRStatementNode);
        mIRStatementNode.addExpressionNode(this.buildExpressionTree(stack));
        return mIRExpression;
    }

    private MIROperatorNode buildExpressionTree(Stack<MIRExpressionNode> stack) {
        MIROperatorNode mIROperatorNode = new MIROperatorNode();
        mIROperatorNode.setName("AND");
        mIROperatorNode.addRightExpressionNode(stack.pop());
        if (stack.size() > 1) {
            mIROperatorNode.addLeftExpressionNode(this.buildExpressionTree(stack));
        } else {
            mIROperatorNode.addLeftExpressionNode(stack.pop());
        }
        return mIROperatorNode;
    }

    /*
     * WARNING - void declaration
     */
    private MIRExpressionTransformation processExpression() {
        Object object;
        MIRElement mIRElement;
        MIRFeature mIRFeature;
        MIRFeature mIRFeature22;
        Set<MIRQueryColumn> set = this.getGroupByColumns(this.from);
        if (set.size() > 0) {
            MIRElement mIRTransformationDataSet2;
            HashSet<MIRQueryColumn> hashSet = new HashSet<MIRQueryColumn>();
            for (MIRQueryColumn mIRElement42 : set) {
                mIRTransformationDataSet2 = mIRElement42.getDestinationOfFeatureMap();
                if (mIRTransformationDataSet2 == null || mIRTransformationDataSet2.getExpression() == null) continue;
                hashSet.add(mIRElement42);
            }
            if (hashSet.size() == 0) {
                return null;
            }
            this.logCreateTransformation(MIRElementType.getName((short)236));
            MIRExpressionTransformation mIRExpressionTransformation = new MIRExpressionTransformation();
            mIRExpressionTransformation.setName(this.from.getName() + "_Expression");
            MIRClassifierMap mIRTransformationDataSet = new MIRClassifierMap();
            mIRExpressionTransformation.addClassifierMap(mIRTransformationDataSet);
            mIRTransformationDataSet2 = this.createDataSet(INPUT_DATASET_NAME);
            MIRTransformationDataSet hashSet3 = this.createDataSet(OUTPUT_DATASET_NAME);
            mIRExpressionTransformation.addInputTransformationDataSet((MIRTransformationDataSet)mIRTransformationDataSet2);
            mIRExpressionTransformation.addOutputTransformationDataSet(hashSet3);
            mIRTransformationDataSet.addSourceClassifier((MIRClassifier)mIRTransformationDataSet2);
            mIRTransformationDataSet.addDestinationClassifier(hashSet3);
            for (MIRQueryColumn mIRClassifierMap2 : hashSet) {
                MIRFeatureMap object2 = mIRClassifierMap2.getDestinationOfFeatureMap();
                MIRFeature mIRElement22 = this.mapper.getOrAdd(mIRClassifierMap2, hashSet3);
                MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
                mIRTransformationDataSet.addFeatureMap(mIRFeatureMap);
                mIRFeatureMap.addDestinationFeature(mIRElement22);
                for (MIRFeature mIRFeature3 : object2.getSourceFeatures()) {
                    MIRFeature mIRFeature4 = this.mapper.getOrAdd(mIRFeature3, (MIRClassifier)mIRTransformationDataSet2);
                    mIRFeatureMap.addSourceFeature(mIRFeature4);
                }
                this.copyExpression(object2, mIRFeatureMap);
            }
            return mIRExpressionTransformation;
        }
        this.logCreateTransformation(MIRElementType.getName((short)236));
        MIRExpressionTransformation mIRExpressionTransformation = new MIRExpressionTransformation();
        mIRExpressionTransformation.setName(this.from.getName() + "_Expression");
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRExpressionTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRExpressionTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRExpressionTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
        HashSet<MIRFeatureMap> hashSet2 = new HashSet<MIRFeatureMap>();
        MIRClassifierMap mIRClassifierMap2 = this.from.getDestinationOfClassifierMap();
        for (MIRFeatureMap mIRFeatureMap : mIRClassifierMap2.getFeatureMaps()) {
            boolean bl = false;
            for (MIRFeature mIRFeature22 : mIRFeatureMap.getSourceFeatures()) {
                if (mIRFeature22.getParent() != this.from) continue;
                bl = true;
                break;
            }
            if (mIRFeatureMap.getOperation().isEmpty() || mIRFeatureMap.getDestinationFeature().getElementType() != 242) continue;
            if (bl) {
                hashSet.add(mIRFeatureMap);
                continue;
            }
            hashSet2.add(mIRFeatureMap);
        }
        Object object2 = null;
        Object var10_21 = null;
        if (hashSet.size() == 0 && hashSet2.size() == 0) {
            return null;
        }
        if (hashSet.size() > 0) {
            object2 = this.createDataSet("Var");
            mIRExpressionTransformation.addVariableTransformationDataSet((MIRTransformationDataSet)object2);
            mIRClassifierMap.addSourceClassifier((MIRClassifier)object2);
            MIRClassifierMap mIRClassifierMap3 = new MIRClassifierMap();
            mIRClassifierMap3.setName("Var");
            mIRClassifierMap3.addSourceClassifier(mIRTransformationDataSet);
            mIRClassifierMap3.addDestinationClassifier((MIRClassifier)object2);
            mIRExpressionTransformation.addClassifierMap(mIRClassifierMap3);
            for (MIRFeatureMap mIRFeatureMap : hashSet) {
                mIRFeature22 = mIRFeatureMap.getDestinationFeature();
                mIRFeature = this.mapper.getOrAdd(mIRFeature22, mIRTransformationDataSet2);
                mIRElement = new MIRFeatureMap();
                ((MIRFeatureMap)mIRElement).addDestinationFeature(mIRFeature);
                mIRClassifierMap.addFeatureMap((MIRFeatureMap)mIRElement);
                object = mIRFeatureMap.getSourceFeatures().iterator();
                while (object.hasNext()) {
                    MIRFeature mIRFeature5 = (MIRFeature)object.next();
                    MIRFeature mIRFeature6 = null;
                    mIRFeature6 = mIRFeature5.getParent() == this.from ? this.mapper.getOrAdd(mIRFeature5, (MIRClassifier)object2) : this.mapper.getOrAdd(mIRFeature5, mIRTransformationDataSet);
                    ((MIRFeatureMap)mIRElement).addSourceFeature(mIRFeature6);
                }
                this.copyExpression(mIRFeatureMap, (MIRFeatureMap)mIRElement);
            }
        }
        for (MIRFeatureMap mIRFeatureMap : hashSet2) {
            mIRFeature22 = this.castToColumn(mIRFeatureMap.getDestinationFeature());
            if (mIRFeature22 == null) continue;
            mIRFeature = null;
            mIRElement = mIRClassifierMap;
            if (object2 != null) {
                void var10_23;
                mIRFeature = this.mapper.getCopyOfOriginalFeature((MIRClassifier)object2, mIRFeature22);
                mIRElement = var10_23;
            }
            if (mIRFeature == null) {
                mIRFeature = this.mapper.getOrAdd(mIRFeature22, mIRTransformationDataSet2);
                mIRElement = mIRClassifierMap;
            }
            if ((object = mIRFeature.getDestinationOfFeatureMap()) == null) {
                object = new MIRFeatureMap();
                ((MIRFeatureMap)object).addDestinationFeature(mIRFeature);
                ((MIRClassifierMap)mIRElement).addFeatureMap((MIRFeatureMap)object);
            }
            for (MIRFeature mIRFeature6 : mIRFeatureMap.getSourceFeatures()) {
                MIRFeature mIRFeature7 = this.mapper.getOrAdd(mIRFeature6, mIRTransformationDataSet);
                ((MIRFeatureMap)object).addSourceFeature(mIRFeature7);
            }
            this.copyExpression(mIRFeatureMap, (MIRFeatureMap)object);
        }
        return mIRExpressionTransformation;
    }

    private Set<MIRQueryColumn> getGroupByColumns(MIRQueryTable mIRQueryTable) {
        HashSet<MIRQueryColumn> hashSet = new HashSet<MIRQueryColumn>();
        for (MIRFeature mIRFeature : mIRQueryTable.getFeatures()) {
            MIRQueryColumn mIRQueryColumn = this.castToColumn(mIRFeature);
            if (mIRQueryColumn == null || mIRQueryColumn.getQueryGroupBy() == null) continue;
            hashSet.add(mIRQueryColumn);
        }
        return hashSet;
    }

    private MIRFilteringTransformation processHavingFilter() {
        Set<MIRQueryFilter> set = this.getFilteredColumns(this.from, (byte)1);
        if (set.size() == 0) {
            return null;
        }
        this.logCreateTransformation("Having filter");
        MIRQueryFilter mIRQueryFilter = set.iterator().next();
        MIRFeatureMap mIRFeatureMap = mIRQueryFilter.getDestinationOfFeatureMap();
        if (mIRFeatureMap == null) {
            MBCONV.HAVING_NO_DESTINATION_OF_FEATURE_MAP.log(this.from.getName());
            return null;
        }
        this.havingExpression.parseHaving(mIRFeatureMap.getExpression());
        MIRFeatureMap mIRFeatureMap2 = this.havingExpression.getHavingFeatureMap();
        if (mIRFeatureMap2 == null) {
            return null;
        }
        MIRFilteringTransformation mIRFilteringTransformation = new MIRFilteringTransformation();
        mIRFilteringTransformation.setName(this.from.getName() + "_Having");
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRFilteringTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        mIRFilteringTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRFilteringTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        MIRCondition mIRCondition = new MIRCondition();
        mIRCondition.setName("FILTER CONDITION");
        mIRTransformationDataSet2.addFeature(mIRCondition);
        MIRFeatureMap mIRFeatureMap3 = new MIRFeatureMap();
        mIRClassifierMap.addFeatureMap(mIRFeatureMap3);
        mIRFeatureMap3.addDestinationFeature(mIRCondition);
        for (MIRFeature mIRFeature : mIRFeatureMap2.getSourceFeatures()) {
            MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
            mIRFeatureMap3.addSourceFeature(mIRFeature2);
        }
        this.copyExpression(mIRFeatureMap2, mIRFeatureMap3);
        return mIRFilteringTransformation;
    }

    private MIRExpressionTransformation processAggregationExpression() {
        if (this.getGroupByColumns(this.from).size() == 0) {
            return null;
        }
        HashSet<MIRFeatureMap> hashSet = new HashSet<MIRFeatureMap>();
        MIRClassifierMap mIRClassifierMap = this.from.getDestinationOfClassifierMap();
        for (MIRFeatureMap mIRElement2 : mIRClassifierMap.getFeatureMaps()) {
            boolean mIRTransformationDataSet = false;
            for (MIRFeature mIRFeature : mIRElement2.getSourceFeatures()) {
                if (mIRFeature.getParent() != this.from) continue;
                mIRTransformationDataSet = true;
                break;
            }
            if (!mIRTransformationDataSet) continue;
            hashSet.add(mIRElement2);
        }
        if (hashSet.size() == 0) {
            return null;
        }
        this.logCreateTransformation("Aggregation Expressions");
        MIRExpressionTransformation mIRExpressionTransformation = new MIRExpressionTransformation();
        mIRExpressionTransformation.setName(this.from.getName() + "_AggregationExpression");
        MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
        mIRExpressionTransformation.addClassifierMap(mIRClassifierMap2);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRExpressionTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRExpressionTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        mIRClassifierMap2.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap2.addDestinationClassifier(mIRTransformationDataSet2);
        for (MIRFeatureMap mIRFeatureMap : hashSet) {
            MIRFeature mIRFeature = mIRFeatureMap.getDestinationFeature();
            MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet2);
            MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
            mIRClassifierMap2.addFeatureMap(mIRFeatureMap2);
            mIRFeatureMap2.addDestinationFeature(mIRFeature2);
            for (MIRFeature mIRFeature3 : mIRFeatureMap.getSourceFeatures()) {
                MIRFeature mIRFeature4 = this.mapper.getOrAdd(mIRFeature3, mIRTransformationDataSet);
                mIRFeatureMap2.addSourceFeature(mIRFeature4);
            }
            this.copyExpression(mIRFeatureMap, mIRFeatureMap2);
        }
        return mIRExpressionTransformation;
    }

    private MIRAggregationTransformation processAggregation() {
        Object object;
        Object object2;
        Object object3;
        Set<MIRQueryColumn> set = this.getGroupByColumns(this.from);
        if (set.size() == 0) {
            return null;
        }
        this.logCreateTransformation(MIRElementType.getName((short)219));
        MIRAggregationTransformation mIRAggregationTransformation = new MIRAggregationTransformation();
        mIRAggregationTransformation.setName(this.from.getName() + "_Aggregation");
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRAggregationTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        mIRAggregationTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRAggregationTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
        mIRClassifierMap.addFeatureMap(mIRFeatureMap);
        MIRCondition mIRCondition = new MIRCondition();
        mIRCondition.setName("GROUP BY CONDITION");
        mIRTransformationDataSet2.addFeature(mIRCondition);
        mIRFeatureMap.addDestinationFeature(mIRCondition);
        for (MIRQueryColumn mIRElement22 : set) {
            object3 = mIRElement22.getDestinationOfFeatureMap();
            if (object3 == null) continue;
            if (((MIRFeatureMap)object3).getExpression() != null) {
                MIRFeature mIRFeature = this.mapper.getOrAdd(mIRElement22, mIRTransformationDataSet);
                mIRFeatureMap.addSourceFeature(mIRFeature);
                continue;
            }
            for (MIRFeature mIRFeature : ((MIRFeatureMap)object3).getSourceFeatures()) {
                object2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
                mIRFeatureMap.addSourceFeature((MIRFeature)object2);
            }
        }
        HashSet hashSet = new HashSet();
        MIRClassifierMap mIRClassifierMap2 = this.from.getDestinationOfClassifierMap();
        for (MIRFeatureMap mIRFeatureMap2 : mIRClassifierMap2.getFeatureMaps()) {
            boolean bl = false;
            for (MIRFeature mIRFeature : mIRFeatureMap2.getSourceFeatures()) {
                if (mIRFeature.getParent() != this.from) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            hashSet.add(mIRFeatureMap2);
        }
        object3 = hashSet.iterator();
        while (object3.hasNext()) {
            MIRFeatureMap mIRFeatureMap3 = (MIRFeatureMap)object3.next();
            MIRQueryColumn mIRQueryColumn = this.castToColumn(mIRFeatureMap3.getDestinationFeature());
            if (mIRQueryColumn == null) continue;
            object2 = this.mapper.getOrAdd(mIRQueryColumn, mIRTransformationDataSet2);
            MIRFeatureMap mIRFeatureMap4 = new MIRFeatureMap();
            mIRFeatureMap4.addDestinationFeature((MIRFeature)object2);
            mIRClassifierMap.addFeatureMap(mIRFeatureMap4);
            if (set.contains(mIRQueryColumn) && mIRFeatureMap3.getExpression() != null) {
                object = this.mapper.getOrAdd(mIRQueryColumn, mIRTransformationDataSet);
                mIRFeatureMap4.addSourceFeature((MIRFeature)object);
                continue;
            }
            for (MIRFeature mIRFeature : mIRFeatureMap3.getSourceFeatures()) {
                MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
                mIRFeatureMap4.addSourceFeature(mIRFeature2);
            }
            this.copyExpression(mIRFeatureMap3, mIRFeatureMap4);
        }
        if (this.havingExpression != null) {
            object3 = this.havingExpression.getAggFeatureMaps();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                MIRFeatureMap mIRFeatureMap5 = (MIRFeatureMap)iterator.next();
                object2 = mIRFeatureMap5.getDestinationFeature();
                MIRFeature mIRFeature = this.mapper.getOrAdd((MIRFeature)object2, mIRTransformationDataSet2);
                object = new MIRFeatureMap();
                mIRClassifierMap.addFeatureMap((MIRFeatureMap)object);
                ((MIRFeatureMap)object).addDestinationFeature(mIRFeature);
                for (MIRFeature mIRFeature2 : mIRFeatureMap5.getSourceFeatures()) {
                    MIRFeature mIRFeature3 = this.mapper.getOrAdd(mIRFeature2, mIRTransformationDataSet);
                    ((MIRFeatureMap)object).addSourceFeature(mIRFeature3);
                }
                this.copyExpression(mIRFeatureMap5, (MIRFeatureMap)object);
            }
        }
        return mIRAggregationTransformation;
    }

    /*
     * WARNING - void declaration
     */
    private MIRLookupTransformation processLookup(MIRQueryLookup mIRQueryLookup) {
        void var14_25;
        MIRElement mIRElement;
        Object object;
        Object object2;
        MIRFeatureMap mIRFeatureMap;
        this.logCreateTransformation(MIRElementType.getName((short)241));
        MIRLookupTransformation mIRLookupTransformation = new MIRLookupTransformation();
        mIRLookupTransformation.setName(this.from.getName() + "_Lookup");
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRLookupTransformation.addOutputTransformationDataSet(mIRTransformationDataSet);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet("data");
        mIRLookupTransformation.addDataTransformationDataSet(mIRTransformationDataSet2);
        MIRTransformationDataSet mIRTransformationDataSet3 = this.createDataSet("control");
        mIRLookupTransformation.addControlTransformationDataSet(mIRTransformationDataSet3);
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet2);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet3);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet);
        mIRLookupTransformation.addClassifierMap(mIRClassifierMap);
        MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
        mIRClassifierMap2.setName("__");
        mIRClassifierMap2.addSourceClassifier(mIRTransformationDataSet3);
        mIRClassifierMap2.addDestinationClassifier(mIRTransformationDataSet2);
        mIRLookupTransformation.addClassifierMap(mIRClassifierMap2);
        MIRQueryTable mIRQueryTable = mIRQueryLookup.getSourceQueryTable();
        for (MIRFeature object42 : mIRQueryTable.getFeatures()) {
            this.mapper.getOrAdd(object42, mIRTransformationDataSet2);
        }
        MIRClassifier mIRClassifier = mIRQueryLookup.getClassifier();
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            void var14_17;
            mIRFeatureMap = mIRFeature.getDestinationOfFeatureMap();
            if (mIRFeatureMap == null || !mIRFeatureMap.getOperation().isEmpty() || mIRFeatureMap.getSourceFeatureCount() <= 0) continue;
            object2 = mIRFeatureMap.getSourceFeatures().first();
            Object var14_18 = null;
            if (mIRQueryTable.containsFeature((MIRFeature)object2)) {
                MIRTransformationDataSet mIRTransformationDataSet4 = mIRTransformationDataSet2;
            } else {
                MIRTransformationDataSet mIRTransformationDataSet5 = mIRTransformationDataSet3;
            }
            if (var14_17 == null) continue;
            object = this.mapper.getOrAdd((MIRFeature)object2, (MIRClassifier)var14_17);
            MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
            mIRElement = new MIRFeatureMap();
            mIRClassifierMap.addFeatureMap((MIRFeatureMap)mIRElement);
            mIRElement.addSourceFeature((MIRFeature)object);
            mIRElement.addDestinationFeature(mIRFeature2);
        }
        MIRCondition mIRCondition = new MIRCondition();
        mIRCondition.setName("LOOKUP CONDITION");
        mIRTransformationDataSet2.addFeature(mIRCondition);
        MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
        mIRFeatureMap2.addDestinationFeature(mIRCondition);
        mIRClassifierMap2.addFeatureMap(mIRFeatureMap2);
        mIRFeatureMap = mIRQueryLookup.getDestinationOfFeatureMap();
        for (MIRFeature mIRFeature : mIRFeatureMap.getSourceFeatures()) {
            object = null;
            object = mIRFeature.getParent() == mIRQueryTable ? this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet3) : this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet2);
            mIRFeatureMap2.addSourceFeature((MIRFeature)object);
        }
        object2 = new MIRConnectionDataSet();
        mIRLookupTransformation.addConnectionDataSet((MIRConnectionDataSet)object2);
        String string = mIRTransformationDataSet2.getName();
        if (!mIRQueryTable.getPhysicalName().isEmpty()) {
            String string2 = mIRQueryTable.getPhysicalName();
            mIRTransformationDataSet2.setName(string2);
        }
        ((MIRObject)object2).setName((String)var14_25);
        mIRClassifierMap2.addSourceClassifier((MIRClassifier)object2);
        this.copyExpression(mIRFeatureMap, mIRFeatureMap2);
        for (MIRFeature mIRFeature2 : mIRTransformationDataSet2.getFeatures()) {
            if (mIRFeature2.getElementType() != 255) continue;
            mIRElement = this.mapper.getOriginalFeatureFromCopy(mIRFeature2);
            MIRConnectionDataAttribute mIRConnectionDataAttribute = this.createConnectionDataAttributeFromColumn((MIRFeature)mIRElement);
            ((MIRClassifier)object2).addFeature(mIRConnectionDataAttribute);
            MIRFeatureMap mIRFeatureMap3 = new MIRFeatureMap();
            mIRFeatureMap3.addSourceFeature(mIRConnectionDataAttribute);
            mIRFeatureMap3.addDestinationFeature(mIRFeature2);
            mIRClassifierMap2.addFeatureMap(mIRFeatureMap3);
        }
        object = mIRQueryTable.getConnectionDataPackage();
        if (object != null) {
            if (ETLContext.connectionPackageMap.containsKey(object)) {
                ((MIRClassifier)object2).addConnectionDataPackage(ETLContext.connectionPackageMap.get(object));
            }
        } else {
            ((MIRClassifier)object2).addConnectionDataPackage(this.getDefaultConnectionPackage());
        }
        return mIRLookupTransformation;
    }

    private MIRSortingTransformation processSort() {
        MIRQuerySort mIRQuerySort = this.from.getQuerySort();
        if (mIRQuerySort == null) {
            return null;
        }
        this.logCreateTransformation(MIRElementType.getName((short)253));
        MIRSortingTransformation mIRSortingTransformation = new MIRSortingTransformation();
        mIRSortingTransformation.setName(this.from.getName() + "_Sort");
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRSortingTransformation.addClassifierMap(mIRClassifierMap);
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet2);
        mIRSortingTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRSortingTransformation.addOutputTransformationDataSet(mIRTransformationDataSet2);
        for (MIRQuerySortItem mIRQuerySortItem : mIRQuerySort.getQuerySortItems()) {
            MIRQueryColumn mIRQueryColumn = mIRQuerySortItem.getQueryColumn();
            MIRFeature mIRFeature = this.mapper.getOrAdd(mIRQueryColumn, mIRTransformationDataSet2);
            MIRTransformationDataAttribute mIRTransformationDataAttribute = (MIRTransformationDataAttribute)mIRFeature;
            MIRTransformationSortItem mIRTransformationSortItem = new MIRTransformationSortItem();
            mIRTransformationDataAttribute.addTransformationSortItem(mIRTransformationSortItem);
            mIRTransformationSortItem.setAscending(mIRQuerySortItem.getAscending());
            mIRTransformationSortItem.setPosition(mIRQuerySortItem.getPosition());
            MIRFeature mIRFeature2 = this.mapper.getOrAdd(mIRQueryColumn, mIRTransformationDataSet);
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            mIRFeatureMap.addDestinationFeature(mIRFeature);
            mIRFeatureMap.addSourceFeature(mIRFeature2);
            mIRClassifierMap.addFeatureMap(mIRFeatureMap);
        }
        return mIRSortingTransformation;
    }

    private MIRWriterTransformation processWriter() {
        MIRModelObject mIRModelObject2;
        Object object;
        Object object2;
        if (this.from.getSourceOfClassifierMapCount() > 0) {
            for (MIRClassifierMap mIRElement22 : this.from.getSourceOfClassifierMaps()) {
                if (mIRElement22.getDestinationClassifier() == this.from) continue;
                return null;
            }
        }
        this.logCreateTransformation(MIRElementType.getName((short)260));
        MIRWriterTransformation mIRWriterTransformation = new MIRWriterTransformation();
        mIRWriterTransformation.setName(this.from.getName() + "_Writer");
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME);
        mIRWriterTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        MIRFlatFileDescriptor mIRFlatFileDescriptor = this.from.getFlatFileDescriptor();
        if (mIRFlatFileDescriptor != null) {
            object2 = null;
            if (mIRFlatFileDescriptor instanceof MIRDelimitedFileDescriptor) {
                object2 = new MIRDelimitedFileDescriptor();
            } else if (mIRFlatFileDescriptor instanceof MIRFixedWidthFileDescriptor) {
                object2 = new MIRFixedWidthFileDescriptor();
            }
            if (object2 != null) {
                ((MIRFlatFileDescriptor)object2).setFrom(mIRFlatFileDescriptor);
                mIRWriterTransformation.addFlatFileDescriptor(mIRFlatFileDescriptor);
                MIRConnectionDataPackage mIRConnectionDataPackage = this.from.getConnectionDataPackage();
                object = this.from.getName();
                if (mIRConnectionDataPackage != null) {
                    object = MIRBridgeLib.getFilePath(mIRConnectionDataPackage) + File.separator + object;
                }
                mIRWriterTransformation.setConnectionName((String)object);
            }
        }
        for (MIRFeature mIRFeature : this.from.getFeatures()) {
            object = mIRFeature.getDestinationOfFeatureMap();
            if (mIRFeature.getElementType() != 242 || object == null) continue;
            mIRModelObject2 = this.mapper.getOrAdd(mIRFeature, mIRTransformationDataSet);
            mIRModelObject2.setDescription(((MIRElement)object).getDescription());
        }
        object2 = new MIRConnectionDataSet();
        ((MIRObject)object2).setName(this.from.getName());
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRWriterTransformation.addClassifierMap(mIRClassifierMap);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addDestinationClassifier((MIRClassifier)object2);
        for (MIRModelObject mIRModelObject2 : mIRTransformationDataSet.getFeatures()) {
            MIRFeature mIRFeature = this.mapper.getOriginalFeatureFromCopy((MIRFeature)mIRModelObject2);
            MIRConnectionDataAttribute mIRConnectionDataAttribute = this.createConnectionDataAttributeFromColumn(mIRFeature);
            ((MIRClassifier)object2).addFeature(mIRConnectionDataAttribute);
            MIRFeatureMap mIRFeatureMap = new MIRFeatureMap();
            mIRClassifierMap.addFeatureMap(mIRFeatureMap);
            mIRFeatureMap.addSourceFeature((MIRFeature)mIRModelObject2);
            mIRFeatureMap.addDestinationFeature(mIRConnectionDataAttribute);
        }
        mIRWriterTransformation.addConnectionDataSet((MIRConnectionDataSet)object2);
        object = this.from.getConnectionDataPackage();
        if (object == null && this.from.getImportedByPackages().size() > 0 && (mIRModelObject2 = this.from.getImportedByPackages().first()) instanceof MIRConnectionDataPackage) {
            object = (MIRConnectionDataPackage)mIRModelObject2;
        }
        if (object != null) {
            if (ETLContext.connectionPackageMap.containsKey(object)) {
                ((MIRClassifier)object2).addConnectionDataPackage(ETLContext.connectionPackageMap.get(object));
            }
        } else {
            ((MIRClassifier)object2).addConnectionDataPackage(this.getDefaultConnectionPackage());
        }
        return mIRWriterTransformation;
    }

    private MIRUnionTransformation processUnion(MIRQueryUnion mIRQueryUnion) {
        MIRFeature mIRFeature;
        MIRFeatureMap mIRFeatureMap;
        MIRFeature mIRFeature2;
        Object object;
        MIRFeature mIRFeature3;
        MIRSqlQuery mIRSqlQuery = mIRQueryUnion.getLeftSqlQuery();
        MIRSqlQuery mIRSqlQuery2 = mIRQueryUnion.getRightSqlQuery();
        this.logCreateTransformation(MIRElementType.getName((short)259));
        MIRUnionTransformation mIRUnionTransformation = new MIRUnionTransformation();
        mIRUnionTransformation.setName(this.from.getName() + "_Union");
        MIRTransformationDataSet mIRTransformationDataSet = this.createDataSet(INPUT_DATASET_NAME + "_left");
        MIRTransformationDataSet mIRTransformationDataSet2 = this.createDataSet(INPUT_DATASET_NAME + "_right");
        MIRTransformationDataSet mIRTransformationDataSet3 = this.createDataSet(OUTPUT_DATASET_NAME);
        mIRUnionTransformation.addInputTransformationDataSet(mIRTransformationDataSet);
        mIRUnionTransformation.addInputTransformationDataSet(mIRTransformationDataSet2);
        mIRUnionTransformation.addOutputTransformationDataSet(mIRTransformationDataSet3);
        mIRUnionTransformation.setDescription(MIRUnionType.toString(mIRQueryUnion.getUnionType()));
        MIRClassifierMap mIRClassifierMap = new MIRClassifierMap();
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet);
        mIRClassifierMap.addSourceClassifier(mIRTransformationDataSet2);
        mIRClassifierMap.addDestinationClassifier(mIRTransformationDataSet3);
        mIRUnionTransformation.addClassifierMap(mIRClassifierMap);
        for (MIRFeature object22 : this.from.getFeatures()) {
            MIRQueryColumn mIRQueryColumn = this.castToColumn(object22);
            if (mIRQueryColumn == null) continue;
            Iterator iterator = this.mapper.getOrAdd(mIRQueryColumn, mIRTransformationDataSet3);
            MIRFeatureMap mIRFeatureMap2 = new MIRFeatureMap();
            mIRFeatureMap2.addDestinationFeature((MIRFeature)((Object)iterator));
            mIRClassifierMap.addFeatureMap(mIRFeatureMap2);
            if (mIRSqlQuery == null) {
                mIRFeature3 = this.mapper.getOrAdd(object22, mIRTransformationDataSet);
                mIRFeatureMap2.addSourceFeature(mIRFeature3);
            }
            if (mIRSqlQuery2 != null) continue;
            mIRFeature3 = this.mapper.getOrAdd(object22, mIRTransformationDataSet2);
            mIRFeatureMap2.addSourceFeature(mIRFeature3);
        }
        if (mIRSqlQuery != null) {
            object = mIRSqlQuery.getOutputTransformationDataSets().first();
            for (MIRFeature mIRFeature4 : ((MIRClassifier)object).getFeatures()) {
                for (MIRFeatureMap mIRFeatureMap3 : mIRFeature4.getSourceOfFeatureMaps()) {
                    mIRFeature3 = this.castToColumn(mIRFeatureMap3.getDestinationFeature());
                    if (mIRFeature3 == null || mIRFeature3.getParent() != this.from || (mIRFeature2 = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet3, mIRFeature3)) == null) continue;
                    mIRFeatureMap = mIRFeature2.getDestinationOfFeatureMap();
                    mIRFeature = this.mapper.getOrAdd(mIRFeature4, mIRTransformationDataSet);
                    mIRFeatureMap.addSourceFeature(mIRFeature);
                }
            }
            this.inputMap.put((MIRQueryTable)object, mIRTransformationDataSet);
        } else {
            object = mIRQueryUnion.getLeftQueryUnion();
            MIRUnionTransformation mIRUnionTransformation2 = this.processUnion((MIRQueryUnion)object);
            MIRClassifierMap mIRClassifierMap2 = new MIRClassifierMap();
            mIRClassifierMap2.addSourceClassifier(mIRUnionTransformation2.getOutputTransformationDataSet());
            mIRClassifierMap2.addDestinationClassifier(mIRTransformationDataSet);
            ETLContext.model.addClassifierMap(mIRClassifierMap2);
            ETLContext.model.addTransformationUniqueName(mIRUnionTransformation2);
            for (MIRFeature mIRFeature5 : mIRUnionTransformation2.getOutputTransformationDataSet().getFeatures()) {
                mIRFeature3 = (MIRQueryColumn)this.mapper.getOriginalFeatureFromCopy(mIRFeature5);
                mIRFeature2 = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet, mIRFeature3);
                mIRFeatureMap = new MIRFeatureMap();
                mIRFeatureMap.addSourceFeature(mIRFeature5);
                mIRFeatureMap.addDestinationFeature(mIRFeature2);
                mIRClassifierMap2.addFeatureMap(mIRFeatureMap);
            }
        }
        if (mIRSqlQuery2 != null) {
            object = mIRSqlQuery2.getOutputTransformationDataSets().first();
            for (MIRFeature mIRFeature6 : ((MIRClassifier)object).getFeatures()) {
                for (MIRFeatureMap mIRFeatureMap4 : mIRFeature6.getSourceOfFeatureMaps()) {
                    mIRFeature3 = this.castToColumn(mIRFeatureMap4.getDestinationFeature());
                    if (mIRFeature3 == null || mIRFeature3.getParent() != this.from || (mIRFeature2 = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet3, mIRFeature3)) == null) continue;
                    mIRFeatureMap = mIRFeature2.getDestinationOfFeatureMap();
                    mIRFeature = this.mapper.getOrAdd(mIRFeature6, mIRTransformationDataSet2);
                    mIRFeatureMap.addSourceFeature(mIRFeature);
                }
            }
            this.inputMap.put((MIRQueryTable)object, mIRTransformationDataSet2);
        } else {
            object = mIRQueryUnion.getRightQueryUnion();
            MIRUnionTransformation mIRUnionTransformation3 = this.processUnion((MIRQueryUnion)object);
            MIRClassifierMap mIRClassifierMap3 = new MIRClassifierMap();
            mIRClassifierMap3.addSourceClassifier(mIRUnionTransformation3.getOutputTransformationDataSet());
            mIRClassifierMap3.addDestinationClassifier(mIRTransformationDataSet2);
            ETLContext.model.addClassifierMap(mIRClassifierMap3);
            ETLContext.model.addTransformationUniqueName(mIRUnionTransformation3);
            for (MIRFeature mIRFeature7 : mIRUnionTransformation3.getOutputTransformationDataSet().getFeatures()) {
                mIRFeature3 = (MIRQueryColumn)this.mapper.getOriginalFeatureFromCopy(mIRFeature7);
                mIRFeature2 = this.mapper.getCopyOfOriginalFeature(mIRTransformationDataSet2, mIRFeature3);
                mIRFeatureMap = new MIRFeatureMap();
                mIRFeatureMap.addSourceFeature(mIRFeature7);
                mIRFeatureMap.addDestinationFeature(mIRFeature2);
                mIRClassifierMap3.addFeatureMap(mIRFeatureMap);
            }
        }
        return mIRUnionTransformation;
    }

    private MIRTransformationDataSet createDataSet(String string) {
        MIRTransformationDataSet mIRTransformationDataSet = new MIRTransformationDataSet();
        mIRTransformationDataSet.setName(string);
        return mIRTransformationDataSet;
    }

    private MIRConnectionPackage getDefaultConnectionPackage() {
        MIRConnectionPackage mIRConnectionPackage;
        MIRStoreConnection mIRStoreConnection = ETLContext.model.getStoreConnection("__default__");
        if (mIRStoreConnection == null) {
            mIRStoreConnection = new MIRStoreConnection();
            mIRStoreConnection.setName("__default__");
            ETLContext.model.addStoreConnection(mIRStoreConnection);
            mIRConnectionPackage = new MIRConnectionPackage();
            mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
        } else {
            mIRConnectionPackage = mIRStoreConnection.getConnectionPackage("");
            if (mIRConnectionPackage == null) {
                mIRConnectionPackage = new MIRConnectionPackage();
                mIRStoreConnection.addConnectionPackage(mIRConnectionPackage);
            }
        }
        return mIRConnectionPackage;
    }

    public static void copyExpression(MIRExpression mIRExpression, MIRFeatureMap mIRFeatureMap, FeatureMapper featureMapper) {
        if (mIRExpression == null) {
            return;
        }
        HashSet<MIRClassifier> hashSet = new HashSet<MIRClassifier>();
        for (MIRClassifier object2 : mIRFeatureMap.getClassifierMap().getSourceClassifiers()) {
            hashSet.add(object2);
        }
        hashSet.add(mIRFeatureMap.getClassifierMap().getDestinationClassifier());
        MIRExpression mIRExpression2 = mIRExpression;
        ExpressionCopier expressionCopier = new ExpressionCopier();
        try {
            MIRExpression exception = expressionCopier.cloneExpression(mIRExpression2, hashSet, featureMapper);
            if (exception != null) {
                mIRFeatureMap.addExpression(exception);
                ExpressionPrinter expressionPrinter = new ExpressionPrinter();
                mIRFeatureMap.setOperation(expressionPrinter.convertExpression(mIRFeatureMap));
            }
        }
        catch (Exception exception) {
            MBCONV.ERR_EXPRESSION_COPY_FATAL_ERROR.log(exception.toString());
        }
    }

    private void copyExpression(MIRFeatureMap mIRFeatureMap, MIRFeatureMap mIRFeatureMap2) {
        MIRExpression mIRExpression = mIRFeatureMap.getExpression();
        if (mIRFeatureMap.getExpression() == null) {
            mIRFeatureMap2.setOperation(mIRFeatureMap.getOperation());
            return;
        }
        TableBlock.copyExpression(mIRExpression, mIRFeatureMap2, this.mapper);
    }
}

