/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.converter.etl.ETLContext;
import MITI.converter.etl.QueryBlock;
import MITI.lineage.links.ModelLineageAugmenter;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRBaseType;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRConnectionDataPackage;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDiModel;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRSqlQuery;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRType;
import java.util.HashMap;
import java.util.Map;

public class QueryToDataFlow {
    Map<MIRConnectionDataPackage, MIRConnectionDataPackage> connectionPackageMap = new HashMap<MIRConnectionDataPackage, MIRConnectionDataPackage>();
    HashMap<MIRDerivedType, MIRDerivedType> derivedTypeMap = new HashMap();
    HashMap<MIRBaseType, MIRBaseType> baseTypeMap = new HashMap();

    public MIRDiModel convert(MIRDiModel mIRDiModel) {
        BLIB.DBG_DEBUG.log("Feature '" + mIRDiModel.getName() + "' does not have a type");
        MIRDiModel mIRDiModel2 = new MIRDiModel();
        mIRDiModel2.setName(mIRDiModel.getName());
        MIRMetadataOrigin mIRMetadataOrigin = mIRDiModel.getMetadataOrigin();
        if (mIRMetadataOrigin != null) {
            mIRDiModel2.addMetadataOrigin(new MIRMetadataOrigin(mIRMetadataOrigin));
        }
        this.copyTypes(mIRDiModel, mIRDiModel2);
        this.copyStoreConnections(mIRDiModel, mIRDiModel2);
        new ModelLineageAugmenter(mIRDiModel);
        MIRSqlQuery mIRSqlQuery = mIRDiModel.getSqlQuery();
        if (mIRSqlQuery != null) {
            ETLContext.model = mIRDiModel2;
            ETLContext.connectionPackageMap = this.connectionPackageMap;
            ETLContext.derivedTypeMap = this.derivedTypeMap;
            QueryBlock.fromQuery(mIRSqlQuery);
        } else {
            MBCONV.ERR_NO_SQLQUERY.log(new Object[0]);
        }
        return mIRDiModel2;
    }

    private void copyTypes(MIRModel mIRModel, MIRModel mIRModel2) {
        MIRConcreteType mIRConcreteType;
        MIRDerivedType mIRDerivedType;
        MIRType mIRType2;
        BLIB.DBG_DEBUG.log("Copying types...");
        for (MIRType mIRType2 : mIRModel.getTypes()) {
            switch (mIRType2.getElementType()) {
                case 5: {
                    mIRDerivedType = new MIRDerivedType((MIRDerivedType)mIRType2);
                    mIRModel2.addType(mIRDerivedType);
                    this.derivedTypeMap.put((MIRDerivedType)mIRType2, mIRDerivedType);
                    break;
                }
                case 4: {
                    mIRConcreteType = new MIRBaseType((MIRBaseType)mIRType2);
                    mIRModel2.addType(mIRConcreteType);
                    this.baseTypeMap.put((MIRBaseType)mIRType2, (MIRBaseType)mIRConcreteType);
                    break;
                }
            }
        }
        for (MIRType mIRType2 : mIRModel.getTypes()) {
            if (mIRType2.getElementType() != 5 || (mIRConcreteType = (mIRDerivedType = (MIRDerivedType)mIRType2).getDerivedFromConcreteType()).getElementType() != 4) continue;
            MIRBaseType mIRBaseType = (MIRBaseType)mIRConcreteType;
            MIRDerivedType mIRDerivedType2 = this.derivedTypeMap.get(mIRDerivedType);
            MIRBaseType mIRBaseType2 = this.baseTypeMap.get(mIRBaseType);
            if (mIRDerivedType2 == null || mIRBaseType2 == null) continue;
            mIRDerivedType2.addDerivedFromConcreteType(mIRBaseType2);
        }
        MIRBaseType mIRBaseType = new MIRBaseType();
        mIRBaseType.setDataType("undefined");
        mIRBaseType.setName("base_undefined");
        mIRModel2.addType(mIRBaseType);
        mIRType2 = new MIRDerivedType();
        ((MIRConcreteType)mIRType2).setDataType("undefined");
        mIRType2.setName("undefined");
        mIRModel2.addType(mIRType2);
        ((MIRDerivedType)mIRType2).addDerivedFromConcreteType(mIRBaseType);
        this.derivedTypeMap.put(null, (MIRDerivedType)mIRType2);
    }

    private void copyStoreConnections(MIRDiModel mIRDiModel, MIRDiModel mIRDiModel2) {
        BLIB.DBG_DEBUG.log("Copying Store Connections...");
        for (MIRStoreConnection mIRStoreConnection : mIRDiModel.getStoreConnections()) {
            MIRConnectionDataPackage mIRConnectionDataPackage;
            MIRStoreConnection mIRStoreConnection2 = new MIRStoreConnection(mIRStoreConnection);
            if (mIRDiModel.containsSourceStoreConnection(mIRStoreConnection)) {
                mIRDiModel2.addSourceStoreConnection(mIRStoreConnection2);
            }
            if (mIRDiModel.containsDestinationStoreConnection(mIRStoreConnection)) {
                mIRDiModel2.addDestinationStoreConnection(mIRStoreConnection2);
            }
            mIRDiModel2.addStoreConnection(mIRStoreConnection2);
            for (MIRConnectionPackage mIRConnectionPackage : mIRStoreConnection.getConnectionPackages()) {
                mIRConnectionDataPackage = new MIRConnectionPackage(mIRConnectionPackage);
                mIRStoreConnection2.addConnectionPackage((MIRConnectionPackage)mIRConnectionDataPackage);
                this.connectionPackageMap.put(mIRConnectionPackage, mIRConnectionDataPackage);
            }
            for (MIRConnectionNamespace mIRConnectionNamespace : mIRStoreConnection.getConnectionNamespaces()) {
                mIRConnectionDataPackage = new MIRConnectionNamespace(mIRConnectionNamespace);
                mIRStoreConnection2.addConnectionNamespace((MIRConnectionNamespace)mIRConnectionDataPackage);
                this.connectionPackageMap.put(mIRConnectionNamespace, mIRConnectionDataPackage);
                for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionNamespace.getNamespaceElements()) {
                    if (!(mIRNamespaceElement instanceof MIRConnectionNamespace)) continue;
                    this.copyConnectionNamespace(mIRConnectionDataPackage, (MIRConnectionNamespace)mIRNamespaceElement);
                }
            }
        }
    }

    private void copyConnectionNamespace(MIRConnectionDataPackage mIRConnectionDataPackage, MIRConnectionNamespace mIRConnectionNamespace) {
        MIRConnectionNamespace mIRConnectionNamespace2 = new MIRConnectionNamespace(mIRConnectionNamespace);
        mIRConnectionDataPackage.addNamespaceElement(mIRConnectionNamespace2);
        this.connectionPackageMap.put(mIRConnectionNamespace, mIRConnectionNamespace2);
        for (MIRNamespaceElement mIRNamespaceElement : mIRConnectionNamespace.getNamespaceElements()) {
            if (!(mIRNamespaceElement instanceof MIRConnectionNamespace)) continue;
            this.copyConnectionNamespace(mIRConnectionNamespace2, (MIRConnectionNamespace)mIRNamespaceElement);
        }
    }
}

