/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter.etl;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRRolapLib;
import MITI.converter.MIRModelConverter;
import MITI.messages.MIRModelConverter.MBCONV;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.util.ObjectCollector;
import java.io.File;
import java.util.ArrayList;

public class MIREtlModelConverter
extends MIRModelConverter {
    private static final String NAME = "ETL";

    public MIREtlModelConverter() {
        this.acceptsElement((short)286);
        this.acceptsDirectoryStructure((byte)0);
        this.acceptsDirectoryStructure((byte)2);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected boolean convert(File file) throws MIRException {
        MIRMixManager mIRMixManager = new MIRMixManager(file.getParentFile());
        MIRDirectoryStructureModel mIRDirectoryStructureModel = mIRMixManager.loadDirectoryStructure();
        if (!this.supports(mIRDirectoryStructureModel)) {
            return false;
        }
        ObjectCollector objectCollector = new ObjectCollector(new short[]{159});
        objectCollector.collect(mIRDirectoryStructureModel);
        boolean bl = false;
        for (MIRContent mIRContent : objectCollector.getObjects()) {
            if (mIRContent.isInstanceOf((short)295)) {
                MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRMixManager.loadModel(mIRContent);
                if (mIRStoreModel.getStoreType() == 1) {
                    this.convertModelStoreType(mIRStoreModel, (byte)0);
                    MIRRolapLib mIRRolapLib = new MIRRolapLib();
                    mIRRolapLib.reverseEngineerROLAPModel(mIRStoreModel);
                }
                if (mIRStoreModel.getStoreType() == 2 || mIRStoreModel.getStoreType() == 0) {
                    bl = true;
                    if (this.convertToPhysicalStore(mIRStoreModel)) {
                        mIRMixManager.saveModel(mIRContent);
                    }
                }
                mIRStoreModel.delete();
                continue;
            }
            if (!mIRContent.isInstanceOf((short)278)) continue;
            bl = true;
        }
        if (!bl) {
            MBCONV.ERR_NO_MODELS_FOR_ETL.log(new Object[0]);
        }
        mIRMixManager.saveDirectoryStructure(mIRDirectoryStructureModel);
        return bl;
    }

    private boolean convertToPhysicalStore(MIRStoreModel mIRStoreModel) {
        boolean bl = false;
        for (MIRDataPackage mIRDataPackage : mIRStoreModel.getDataPackages()) {
            ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>();
            for (MIRNamespaceElement mIRNamespaceElement : mIRDataPackage.getImportedNamespaceElements()) {
                if (!mIRNamespaceElement.isInstanceOf((short)13) && !mIRNamespaceElement.isInstanceOf((short)209) && !mIRNamespaceElement.isInstanceOf((short)25)) continue;
                arrayList.add(mIRNamespaceElement);
            }
            for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
                mIRDataPackage.removeImportedNamespaceElement(mIRNamespaceElement);
                mIRNamespaceElement.removeNamespace();
                mIRDataPackage.addNamespaceElement(mIRNamespaceElement);
                bl = true;
            }
        }
        return bl;
    }
}

