/*
 * Decompiled with CFR 0.152.
 */
package MITI.converter;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.bridges.bridgelib.MIRUdpLib;
import MITI.messages.MIRModelBridge.BLIB;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDesignPackage;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFolder;
import MITI.sdk.MIRFolderContent;
import MITI.sdk.MIRMetadataOrigin;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRPropertyElementTypeScope;
import MITI.sdk.MIRPropertyType;
import MITI.sdk.MIRPropertyValue;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRType;
import MITI.sdk.mix.MIRMixManager;
import java.util.ArrayList;
import java.util.Iterator;

public class MIRFileSystemSummarizer {
    private MIRMixManager mixManager;
    private MIRStoreModel model;

    public MIRStoreModel run(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRMixManager mIRMixManager) throws MIRException {
        if (mIRDirectoryStructureModel.getType() != 3) {
            return null;
        }
        this.mixManager = mIRMixManager;
        this.model = new MIRStoreModel();
        this.model.setFrom(mIRDirectoryStructureModel);
        this.model.setStoreType((byte)2);
        MIRMetadataOrigin mIRMetadataOrigin = new MIRMetadataOrigin();
        mIRMetadataOrigin.setFrom(mIRDirectoryStructureModel.getMetadataOrigin());
        this.model.addMetadataOrigin(mIRMetadataOrigin);
        for (MIRFolderContent mIRFolderContent : mIRDirectoryStructureModel.getFolderContents()) {
            this.mergeFolderContent(mIRFolderContent, null);
        }
        MIRBridgeLib.deleteEmptyDesignPackages(this.model);
        MIRTypeLib.factorizeTypes(this.model, false, true);
        return this.model;
    }

    private void mergeFolderContent(MIRFolderContent mIRFolderContent, MIRDesignPackage mIRDesignPackage) throws MIRException {
        if (mIRFolderContent.getElementType() == 157) {
            this.mergeFolder((MIRFolder)mIRFolderContent, mIRDesignPackage);
        } else if (mIRFolderContent.getElementType() == 295) {
            this.mergeStoreContent((MIRStoreContent)mIRFolderContent, mIRDesignPackage);
        }
    }

    private MIRDesignPackage getDesignPackage(MIRDesignPackage mIRDesignPackage, String string, boolean bl) {
        MIRDesignPackage mIRDesignPackage2 = null;
        if (mIRDesignPackage != null) {
            for (MIRNamespaceElement mIRNamespaceElement : mIRDesignPackage.getNamespaceElements()) {
                if (mIRNamespaceElement.getElementType() != 9 || !mIRNamespaceElement.getName().equals(string)) continue;
                mIRDesignPackage2 = (MIRDesignPackage)mIRNamespaceElement;
                break;
            }
        } else {
            mIRDesignPackage2 = this.model.getDesignPackage(string);
        }
        if (mIRDesignPackage2 == null) {
            mIRDesignPackage2 = new MIRDesignPackage();
            mIRDesignPackage2.setName(string);
            mIRDesignPackage2.setUserDefined(bl);
            if (mIRDesignPackage != null) {
                mIRDesignPackage.addNamespaceElement(mIRDesignPackage2);
            } else {
                this.model.addDesignPackage(mIRDesignPackage2);
            }
        }
        return mIRDesignPackage2;
    }

    private void mergeFolder(MIRFolder mIRFolder, MIRDesignPackage mIRDesignPackage) throws MIRException {
        MIRDesignPackage mIRDesignPackage2 = this.getDesignPackage(mIRDesignPackage, mIRFolder.getName(), false);
        for (MIRFolderContent mIRFolderContent : mIRFolder.getFolderContents()) {
            this.mergeFolderContent(mIRFolderContent, mIRDesignPackage2);
        }
    }

    private void mergeStoreContent(MIRStoreContent mIRStoreContent, MIRDesignPackage mIRDesignPackage) throws MIRException {
        MIRModel mIRModel = this.mixManager.loadModel(mIRStoreContent);
        if (mIRModel != null) {
            if (mIRModel instanceof MIRStoreModel) {
                MIRStoreModel mIRStoreModel = (MIRStoreModel)mIRModel;
                BLIB.DBG_DEBUG.log("Summarizing model " + mIRStoreModel.getName());
                if (mIRStoreModel.getStoreType() == this.model.getStoreType()) {
                    this.mergeStoreModel(mIRStoreModel, mIRDesignPackage);
                }
            }
            mIRModel.delete();
        }
    }

    private void mergeStoreModel(MIRStoreModel mIRStoreModel, MIRDesignPackage mIRDesignPackage) {
        for (MIRDataPackage object2 : mIRStoreModel.getDataPackages()) {
            this.mergeDataPackage(object2);
        }
        Iterator<Object> iterator = mIRStoreModel.getDesignPackages().iterator();
        while (iterator.hasNext()) {
            MIRDesignPackage mIRDesignPackage2 = (MIRDesignPackage)iterator.next();
            this.mergeDesignPackage(mIRDesignPackage2, mIRDesignPackage);
        }
        while ((iterator = mIRStoreModel.getTypeIterator()).hasNext()) {
            MIRType mIRType = (MIRType)iterator.next();
            mIRStoreModel.removeType(mIRType);
            this.model.addType(mIRType);
        }
        for (MIRPropertyElementTypeScope mIRPropertyElementTypeScope : mIRStoreModel.getPropertyElementTypeScopes()) {
            for (MIRPropertyType mIRPropertyType : mIRPropertyElementTypeScope.getPropertyTypes()) {
                this.mergePropertyType(mIRPropertyType);
            }
        }
    }

    private void mergePropertyType(MIRPropertyType mIRPropertyType) {
        Iterator<MIRPropertyValue> iterator;
        MIRPropertyType mIRPropertyType2 = MIRUdpLib.fetchPropertyType(this.model, mIRPropertyType.getPropertyElementTypeScope().getScope(), mIRPropertyType.getName(), mIRPropertyType.getDesignLevel(), mIRPropertyType.getUsage(), mIRPropertyType.getGroup(), mIRPropertyType.getDataType(), true, mIRPropertyType.getInitialValue());
        while ((iterator = mIRPropertyType.getInstanciatedPropertyValueIterator()).hasNext()) {
            MIRPropertyValue mIRPropertyValue = iterator.next();
            mIRPropertyType.removeInstanciatedPropertyValue(mIRPropertyValue);
            mIRPropertyType2.addInstanciatedPropertyValue(mIRPropertyValue);
        }
    }

    private void mergeDesignPackage(MIRDesignPackage mIRDesignPackage, MIRDesignPackage mIRDesignPackage2) {
        MIRDesignPackage mIRDesignPackage3 = this.getDesignPackage(mIRDesignPackage2, mIRDesignPackage.getName(), mIRDesignPackage.getUserDefined());
        ArrayList<MIRNamespaceElement> arrayList = new ArrayList<MIRNamespaceElement>(mIRDesignPackage.getNamespaceElements());
        for (MIRNamespaceElement mIRNamespaceElement : arrayList) {
            if (mIRNamespaceElement.getElementType() == 9) {
                this.mergeDesignPackage((MIRDesignPackage)mIRNamespaceElement, mIRDesignPackage3);
                continue;
            }
            mIRDesignPackage.removeNamespaceElement(mIRNamespaceElement);
            mIRDesignPackage3.addNamespaceElementUniqueName(mIRNamespaceElement);
        }
    }

    private void mergeDataPackage(MIRDataPackage mIRDataPackage) {
        MIRNamespaceElement mIRNamespaceElement;
        Iterator<MIRNamespaceElement> iterator;
        String string = mIRDataPackage.getNamespaceName(mIRDataPackage);
        MIRDataPackage mIRDataPackage2 = this.model.getDataPackage(string);
        if (mIRDataPackage2 == null) {
            if (mIRDataPackage.getElementType() != 207) {
                return;
            }
            mIRDataPackage2 = new MIRFileDirectory();
            mIRDataPackage2.setName(string);
            this.model.addDataPackage(mIRDataPackage2);
        }
        while ((iterator = mIRDataPackage.getNamespaceElementIterator()).hasNext()) {
            mIRNamespaceElement = iterator.next();
            this.computeNativeId(mIRNamespaceElement, mIRDataPackage);
            mIRDataPackage.removeNamespaceElement(mIRNamespaceElement);
            mIRDataPackage2.addNamespaceElementUniqueName(mIRNamespaceElement);
        }
        while ((iterator = mIRDataPackage.getImportedNamespaceElementIterator()).hasNext()) {
            mIRNamespaceElement = iterator.next();
            this.computeNativeId(mIRNamespaceElement, mIRDataPackage);
            mIRDataPackage.removeImportedNamespaceElement(mIRNamespaceElement);
            mIRDataPackage2.addImportedNamespaceElementUniqueName(mIRNamespaceElement);
        }
    }

    private void computeNativeId(MIRNamespaceElement mIRNamespaceElement, MIRDataPackage mIRDataPackage) {
        if (mIRNamespaceElement.getNativeId().isEmpty()) {
            mIRNamespaceElement.setNativeId(mIRDataPackage.getStoreModel().getName());
        }
    }
}

