/*
 * Decompiled with CFR 0.152.
 */
package org.jdom2.contrib.dom;

import java.net.URISyntaxException;
import org.jdom2.Attribute;
import org.jdom2.AttributeType;
import org.jdom2.Namespace;
import org.jdom2.contrib.dom.JDocument;
import org.jdom2.contrib.dom.JNamespaceAware;
import org.jdom2.contrib.dom.JParent;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.TypeInfo;

final class JAttribute
extends JNamespaceAware
implements Attr {
    final Attribute attribute;

    public JAttribute(JDocument topdoc, JParent parent, Attribute attribute, Namespace[] nstack) {
        super(topdoc, parent, (short)2, nstack);
        this.attribute = attribute;
    }

    public final Object getWrapped() {
        return this.attribute;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public NodeList getChildNodes() {
        return EMPTYLIST;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public String getNamespaceURI() {
        return this.attribute.getNamespaceURI();
    }

    public String getPrefix() {
        return this.attribute.getNamespacePrefix();
    }

    public String getLocalName() {
        return this.attribute.getName();
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getBaseURI() {
        try {
            return this.attribute.getParent().getXMLBaseURI().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to process URI", e);
        }
    }

    public String getTextContent() throws DOMException {
        return "";
    }

    public String getName() {
        return this.attribute.getQualifiedName();
    }

    public boolean getSpecified() {
        return true;
    }

    public String getValue() {
        return this.attribute.getValue();
    }

    public Element getOwnerElement() {
        return (Element)this.getParentNode();
    }

    public TypeInfo getSchemaTypeInfo() {
        return TYPEINFO;
    }

    public boolean isId() {
        return this.attribute.getAttributeType() == AttributeType.ID;
    }

    public void setValue(String value) throws DOMException {
        throw new DOMException(7, "Cannot modify JDOM Wrapper DOM objects.");
    }
}

