/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.filter.visuals;

import com.sas.plugins.PluginResourceBundle;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.Resources;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ValueListBox
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(ValueListBox.class);
    private Frame m_frame;
    private JList m_list;
    private JTextField m_text = new JTextField();
    private JButton m_icon = new JButton();
    private int m_width = 125;
    private ActionListener m_actionListener = null;
    private JDialog m_dia;

    public ValueListBox(Frame frame, Object[] objects) {
        this.m_frame = frame;
        this.m_list = new JList<Object>(objects);
        this._init();
    }

    public ValueListBox(Frame frame, Vector<?> list) {
        this.m_frame = frame;
        this.m_list = new JList(list);
        this._init();
    }

    public Object getSelectedValue() {
        return this.m_text.getText();
    }

    public void setSelectedValue(Object object) {
        this.m_text.setText(object.toString());
        this.m_text.setToolTipText(object.toString());
        String[] o = this.m_text.getText().split(";");
        ListModel model = this.m_list.getModel();
        int listsize = model.getSize();
        int[] indices = new int[listsize];
        int count = 0;
        for (int i = 0; i < o.length; ++i) {
            String value = o[i].toString();
            for (int x = 0; x < listsize; ++x) {
                String temp = model.getElementAt(x).toString();
                if (temp.compareTo(value) != 0) continue;
                indices[count++] = x;
            }
        }
        for (int x = count; x < listsize; ++x) {
            indices[x] = -1;
        }
        this.m_list.setSelectedIndices(indices);
        if (this.m_actionListener != null) {
            ActionEvent ae = new ActionEvent(this.m_text, 1001, null);
            this.m_actionListener.actionPerformed(ae);
        }
    }

    public void addListSelectionListener(ActionListener l) {
        this.m_actionListener = l;
    }

    private void _init() {
        this.setTextField();
        ImageIcon image = Resources.getImageIcon((String)"DownArrow.gif");
        this.m_icon.setIcon(image);
        this.m_icon.setToolTipText(m_bundle.getString("ValueListBox.DownArrow.ToolTip.txt"));
        this.m_icon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueListBox.this.showList();
            }
        });
        GridBagConstraints gbc_text = new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_icon = new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_text, gbc_text);
        this.add((Component)this.m_icon, gbc_icon);
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.m_width = preferredSize.width;
        if (this.m_width < 124) {
            this.m_width = 124;
        }
        int h = preferredSize.height;
        super.setPreferredSize(new Dimension(this.m_width, h));
        Dimension t = new Dimension(this.m_width / 4 * 3, h);
        this.m_text.setPreferredSize(t);
        Dimension i = new Dimension(this.m_width / 4, h);
        this.m_icon.setPreferredSize(i);
    }

    private void setTextField() {
        Object[] o = this.m_list.getSelectedValues();
        StringBuffer value = new StringBuffer();
        if (o.length > 0) {
            value.append(o[0].toString());
        }
        for (int i = 1; i < o.length; ++i) {
            value.append(";");
            value.append(o[i].toString());
        }
        this.m_text.setText(value.toString());
        this.m_text.setToolTipText(value.toString());
        if (this.m_actionListener != null) {
            ActionEvent ae = new ActionEvent(this.m_text, 1001, null);
            this.m_actionListener.actionPerformed(ae);
        }
    }

    private void showList() {
        this.m_dia = new JDialog(this.m_frame, "", true);
        this.m_list.setSelectionMode(2);
        this.m_list.setCellRenderer(new BasicComboBoxRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (isSelected) {
                    this.setBackground(list.getSelectionBackground());
                    this.setForeground(list.getSelectionForeground());
                    if (-1 < index) {
                        list.setToolTipText(value.toString());
                    }
                } else {
                    this.setBackground(list.getBackground());
                    this.setForeground(list.getForeground());
                }
                this.setFont(list.getFont());
                String text = "";
                if (value != null) {
                    text = value.toString();
                }
                this.setText(text);
                return this;
            }
        });
        JPanel panel = new JPanel();
        GridBagConstraints gbc_panel = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_buttons = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        panel.setLayout(new GridBagLayout());
        panel.add((Component)new JScrollPane(this.m_list), gbc_panel);
        JPanel buttons = new JPanel();
        String okText = m_bundle.getString("ValueListBox.Button.Ok.txt");
        JButton btnOk = new JButton(Util.getLabelWithoutMnemonic((String)okText));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueListBox.this.setTextField();
                ValueListBox.this.m_dia.dispose();
            }
        });
        String cancelText = m_bundle.getString("ValueListBox.Button.Cancel.txt");
        JButton btnCancel = new JButton(Util.getLabelWithoutMnemonic((String)cancelText));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ValueListBox.this.setSelectedValue(ValueListBox.this.m_text.getText());
                ValueListBox.this.m_dia.dispose();
            }
        });
        GridBagConstraints gbc_ok = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_cancel = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        Dimension o = btnOk.getPreferredSize();
        Dimension c = btnCancel.getPreferredSize();
        int w = Math.max(o.width, c.width);
        int h = Math.max(o.height, c.height);
        Dimension d = new Dimension(w, h);
        btnOk.setPreferredSize(d);
        btnCancel.setPreferredSize(d);
        buttons.setLayout(new GridBagLayout());
        buttons.add((Component)btnOk, gbc_ok);
        buttons.add((Component)btnCancel, gbc_cancel);
        int width = Math.max(this.m_width, w + w);
        this.m_dia.setUndecorated(true);
        this.m_dia.setSize(width, 175);
        this.m_dia.setLayout(new GridBagLayout());
        this.m_dia.add((Component)panel, gbc_panel);
        this.m_dia.add((Component)buttons, gbc_buttons);
        Double dX = new Double(this.getLocationOnScreen().getX());
        Integer iH = new Integer(this.getHeight());
        Double dY = new Double(this.getLocationOnScreen().getY() + iH.doubleValue());
        this.m_dia.setLocation(dX.intValue(), dY.intValue());
        this.m_dia.pack();
        this.m_dia.setVisible(true);
    }
}

