/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.filter.visuals;

import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.CustomTableSorter;
import com.sas.console.visuals.ConsoleAction;
import com.sas.console.visuals.SubmenuAction;
import com.sas.console.visuals.ToolTipStrippingJPopupMenu;
import com.sas.plugins.PluginResourceBundle;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSorterInterface;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.undo.UndoManager;

public class FilterTablePane
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FilterTablePane.class);
    private int m_rowCount;
    private String m_settingsPrefix;
    private WsTable m_table;
    private NeoTableModelInterface m_tableModel;

    public FilterTablePane(NeoTableModelInterface tableModel, String settingsPrefix) {
        this.m_rowCount = tableModel.getRowCount();
        this.m_settingsPrefix = settingsPrefix;
        this.m_tableModel = tableModel;
        this.m_table = new WsTable(this.m_tableModel.getModel()){
            private static final long serialVersionUID = 1L;

            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                int rowIndex = this.rowAtPoint(p);
                int colIndex = this.columnAtPoint(p);
                Object tip = null;
                if (rowIndex >= 0 && colIndex >= 0) {
                    try {
                        tip = this.getValueAt(rowIndex, colIndex);
                    }
                    catch (RuntimeException ex) {
                        tip = ex.getLocalizedMessage();
                    }
                }
                return tip != null ? tip.toString() : "";
            }
        };
        this.m_table.setAutoResizeMode(4);
        this.m_table.setUndoManager(new UndoManager());
        this.m_table.restoreSettings(this.m_settingsPrefix);
        this.m_table.setEditable(false);
        int numCols = this.m_table.getColumnCount();
        for (int index = numCols - 1; index >= 0; --index) {
            if (!this.m_tableModel.isHidden(index)) continue;
            this.m_table.hideColumn(index);
        }
        this.m_table.setDeleteKeyAction((Action)new cCustomTableDeleteAction());
        this.m_table.addKeyListener((KeyListener)new cCustomTableKeyListener(this));
        this.m_table.setTablePopupMenuRequestListener((WsPopupMenuRequestListener)new cCellPopupMenuRequestListener(this));
        this.m_table.setColumnHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cColumnPopupMenuRequestListener());
        this.m_table.setRowHeaderPopupMenuRequestListener((WsPopupMenuRequestListener)new cRowPopupMenuRequestListener());
        this.setViewportView((Component)this.m_table);
    }

    public Vector<Integer> getSelectedColumns() {
        int[][] cells = this.m_table.getSelectedCells();
        int numOuter = cells.length;
        Vector<Integer> columns = new Vector<Integer>();
        for (int i = 0; i < numOuter; ++i) {
            int[] cell = cells[i];
            Integer col = cell[1];
            if (columns.contains(col)) continue;
            columns.add(col);
        }
        return columns;
    }

    public void saveSettings() {
        this.m_table.saveSettings(this.m_settingsPrefix);
    }

    public void restoreSettings() {
        this.m_table.restoreSettings(this.m_settingsPrefix);
    }

    public void setAutoResizeMode(int mode) {
        this.m_table.setAutoResizeMode(mode);
    }

    public int getAutoResizeMode() {
        return this.m_table.getAutoResizeMode();
    }

    public List<?> getContextMenuActions() {
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        this.m_table.convertRowIndexesToModel(selectedRows);
        return this.m_tableModel.getContextMenuActions(selectedRows);
    }

    public List<?> getToolBarActions() {
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        this.m_table.convertRowIndexesToModel(selectedRows);
        return this.m_tableModel.getContextMenuActions(selectedRows);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouse) {
        this.m_table.addMouseListener(mouse);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouse) {
        this.m_table.removeMouseListener(mouse);
    }

    @Override
    public synchronized void addFocusListener(FocusListener focus) {
        if (this.m_table != null) {
            this.m_table.addFocusListener(focus);
        }
    }

    @Override
    public synchronized void removeFocusListener(FocusListener focus) {
        this.m_table.removeFocusListener(focus);
    }

    public void deleteRow(int row) {
        this.m_table.undoableDeleteRow(row);
        --this.m_rowCount;
    }

    public void insertRow(int afterRow, ArrayList<Object> rowData) {
        this.m_table.undoableInsertRow(afterRow, rowData);
        ++this.m_rowCount;
    }

    public void refreshRow(int row) {
        this.m_tableModel.refreshRowData(row);
    }

    public void refresh(int newRowCount) {
        if (newRowCount <= this.m_rowCount) {
            for (int i = 0; i < newRowCount; ++i) {
                this.m_tableModel.refreshRowData(i);
            }
            for (int j = this.m_rowCount - 1; j >= newRowCount; --j) {
                this.deleteRow(j);
            }
        } else {
            for (int i = 0; i < this.m_rowCount; ++i) {
                this.m_tableModel.refreshRowData(i);
            }
            for (int j = this.m_rowCount; j < newRowCount; ++j) {
                ArrayList<Object> rowData = new ArrayList<Object>();
                for (int c = 0; c < this.m_tableModel.getColumnCount(); ++c) {
                    rowData.add(this.m_tableModel.getValueAt(j, c));
                }
                this.insertRow(j - 1, rowData);
            }
        }
        this.m_rowCount = newRowCount;
        this.m_table.clearSelection();
    }

    public int convertRowIndexToModel(int viewIndex) {
        return this.m_table.convertRowIndexToModel(viewIndex);
    }

    public int convertRowIndexToView(int modelIndex) {
        return this.m_table.convertRowIndexToView(modelIndex);
    }

    public int convertColIndexToModel(int viewIndex) {
        return this.m_table.convertColumnIndexToModel(viewIndex);
    }

    public int convertColIndexToView(int modelIndex) {
        return this.m_table.convertColumnIndexToView(modelIndex);
    }

    public String getColNameFromView(int modelIndex) {
        return this.m_table.getColumnName(modelIndex);
    }

    public void setRowHeaderVisible(boolean visible) {
        this.m_table.setRowHeaderVisible(visible);
    }

    public WsAbstractTableColumn getCurrentColumn() {
        int index = this.m_table.getCurrentColumn();
        if (index == -1) {
            return null;
        }
        return this.m_tableModel.getColumn(index);
    }

    public void setCurrentColumn(int index) {
        this.m_table.setCurrentColumn(index);
    }

    public void sort(int columnIndex) {
        this.m_table.sort(columnIndex);
    }

    public void sort(int[] columnIndexes, int[] directions) {
        this.m_table.sort(columnIndexes, directions);
    }

    public void sort(int columnIndex, int direction) {
        this.m_table.sort(columnIndex, direction);
    }

    public void setSorter(CustomTableSorter sorter) {
        this.m_table.setSorter((WsSorterInterface)sorter);
    }

    private boolean addPopupMenuItems(JPopupMenu mnuPopup, boolean addSeparator) {
        int[] selectedRows = this.m_table.getSelectedRowsFromSelectedCells();
        this.m_table.convertRowIndexesToModel(selectedRows);
        List<?> actions = this.m_tableModel.getContextMenuActions(selectedRows);
        if (actions != null) {
            if (addSeparator) {
                mnuPopup.add(new JSeparator());
            }
            for (int j = 0; j < actions.size(); ++j) {
                Action action = (Action)actions.get(j);
                if (action == null) {
                    mnuPopup.add(new JSeparator());
                    continue;
                }
                if (action instanceof SubmenuAction) {
                    SubmenuAction submenuAction = (SubmenuAction)action;
                    JMenu submenu = SubmenuAction.generateSubmenu((SubmenuAction)submenuAction);
                    mnuPopup.add(submenu);
                    continue;
                }
                mnuPopup.add((Action)new ConsoleAction(action));
            }
        }
        return true;
    }

    private void executeAction(String name, ActionEvent event) {
        List<?> actions = this.getContextMenuActions();
        for (int i = 0; i < actions.size(); ++i) {
            AbstractAction action = (AbstractAction)actions.get(i);
            if (action == null || !action.getValue("Name").equals(name)) continue;
            ConsoleAction ca = new ConsoleAction((Action)action);
            ca.actionPerformed(event);
            break;
        }
    }

    private class cCustomTableKeyListener
    extends KeyAdapter {
        private FilterTablePane mc_pane;

        public cCustomTableKeyListener(FilterTablePane pane) {
            this.mc_pane = pane;
        }

        @Override
        public void keyPressed(KeyEvent e) {
            ToolTipStrippingJPopupMenu mnuPopup = null;
            switch (e.getKeyCode()) {
                case 121: {
                    if (!e.isShiftDown()) break;
                }
                case 525: {
                    e.consume();
                    int[] selectedRows = FilterTablePane.this.m_table.getSelectedRowsFromSelectedCells();
                    if (selectedRows.length > 0) {
                        mnuPopup = new ToolTipStrippingJPopupMenu();
                        FilterTablePane.this.addPopupMenuItems((JPopupMenu)mnuPopup, false);
                        mnuPopup.show((Component)e.getSource(), this.mc_pane.m_table.getX(), this.mc_pane.m_table.getY());
                        break;
                    }
                    this.mc_pane.m_table.showPopup(this.mc_pane.m_table.getSelectedRow(), 0);
                }
            }
        }
    }

    private class cCustomTableDeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private cCustomTableDeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            FilterTablePane.this.executeAction(m_bundle.getString("Common.DeleteAction.Name.txt"), event);
        }
    }

    private class cRowPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cRowPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = FilterTablePane.this.m_table.createRowHeaderPopupMenu();
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cColumnPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        private cColumnPopupMenuRequestListener() {
        }

        public void popupMenuRequested(MouseEvent e) {
            JPopupMenu mnuPopup = FilterTablePane.this.m_table.createColumnHeaderPopupMenu();
            FilterTablePane.this.addPopupMenuItems(mnuPopup, true);
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    private class cCellPopupMenuRequestListener
    implements WsPopupMenuRequestListener {
        protected FilterTablePane m_pane;

        public cCellPopupMenuRequestListener(FilterTablePane pane) {
            this.m_pane = pane;
        }

        public void popupMenuRequested(MouseEvent e) {
            ToolTipStrippingJPopupMenu mnuPopup = new ToolTipStrippingJPopupMenu();
            FilterTablePane.this.addPopupMenuItems((JPopupMenu)mnuPopup, false);
            mnuPopup.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }
}

