/*
 * Decompiled with CFR 0.152.
 */
package com.sas.console.filter.visuals;

import com.sas.console.filter.visuals.FilterManagementDialog;
import com.sas.console.filter.visuals.NeoTableModelInterface;
import com.sas.console.plugins.NodeInterface;
import com.sas.filter.model.FilterSelector;
import com.sas.plugins.PluginResourceBundle;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAPanel;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FilterSelectorPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(FilterSelectorPanel.class);
    private List<FilterSelector> m_filters = null;
    private JComboBox m_cmbFilterList;
    private NeoTableModelInterface m_tableModel;
    private JButton m_btnNow;
    private WorkspaceFile m_work;
    private NodeInterface m_node;

    public FilterSelectorPanel(List<FilterSelector> listOfFilters, FilterSelector defaultfilter, NeoTableModelInterface tableModel, WorkspaceFile work, NodeInterface node) {
        this.m_work = work;
        this.m_node = node;
        this.m_tableModel = tableModel;
        if (listOfFilters != null) {
            this.m_filters = listOfFilters;
            this.__initialize(defaultfilter);
        }
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_filters = null;
        this.m_cmbFilterList = null;
        this.m_tableModel = null;
        this.m_btnNow = null;
        this.m_node = null;
    }

    public void addActionListenerToNow(ActionListener al) {
        this.m_btnNow.addActionListener(al);
    }

    public FilterSelector getSelectedFilter() {
        return (FilterSelector)this.m_cmbFilterList.getSelectedItem();
    }

    public boolean setSelectedFilter(FilterSelector filter) {
        if (filter != null) {
            this.populateFilters(filter);
            return true;
        }
        return false;
    }

    public void __initialize(FilterSelector defaultfilter) {
        this.m_cmbFilterList = new JComboBox();
        this.m_cmbFilterList.setToolTipText(m_bundle.getString("FilterSelectorPanel.Filter.ToolTip.txt"));
        String filterText = m_bundle.getString("FilterSelectorPanel.Filter.txt");
        JLabel lblFilter = new JLabel(Util.getLabelWithoutMnemonic((String)filterText));
        lblFilter.setDisplayedMnemonic(Util.getDisplayedMnemonic((String)filterText));
        lblFilter.setLabelFor(this.m_cmbFilterList);
        this.populateFilters(defaultfilter);
        String nowText = m_bundle.getString("FilterSelectorPanel.NowButton.txt");
        this.m_btnNow = new JButton(Util.getLabelWithoutMnemonic((String)nowText));
        this.m_btnNow.setMnemonic(Util.getDisplayedMnemonic((String)nowText));
        this.m_btnNow.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)nowText));
        this.m_btnNow.setToolTipText(m_bundle.getString("FilterSelectorPanel.NowButton.ToolTip.txt"));
        String optionText = m_bundle.getString("FilterSelectorPanel.OptionButton.txt");
        JButton btnOption = new JButton(Util.getLabelWithoutMnemonic((String)optionText));
        btnOption.setMnemonic(Util.getDisplayedMnemonic((String)optionText));
        btnOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex((String)optionText));
        btnOption.setToolTipText(m_bundle.getString("FilterSelectorPanel.OptionButton.ToolTip.txt"));
        btnOption.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterManagementDialog view = new FilterManagementDialog((Frame)Workspace.getWorkspace(), FilterSelectorPanel.this.m_filters, (FilterSelector)FilterSelectorPanel.this.m_cmbFilterList.getSelectedItem(), FilterSelectorPanel.this.m_tableModel, FilterSelectorPanel.this.m_work, FilterSelectorPanel.this.m_node);
                view.makeVisible();
                if (view.getReturnValue() == 1) {
                    FilterSelector filter = view.getSelectedFilter();
                    FilterSelectorPanel.this.m_filters = view.getFilters();
                    FilterSelectorPanel.this.populateFilters(filter);
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc_lblfilter = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_filters = new GridBagConstraints(1, 0, 4, 1, 1.0, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0);
        GridBagConstraints gbc_now = new GridBagConstraints(5, 0, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0);
        GridBagConstraints gbc_options = new GridBagConstraints(7, 0, 2, 1, 1.0, 1.0, 13, 0, new Insets(5, 5, 0, 5), 0, 0);
        this.add(lblFilter, gbc_lblfilter);
        this.add(this.m_cmbFilterList, gbc_filters);
        this.add(this.m_btnNow, gbc_now);
        this.add(btnOption, gbc_options);
    }

    private void populateFilters(FilterSelector defaultfilter) {
        int i;
        int arrMax = this.m_filters.size() - 1;
        for (i = 0; i < arrMax; ++i) {
            for (int j = 0; j < arrMax - i; ++j) {
                String name1 = this.m_filters.get(i).toString();
                String name2 = this.m_filters.get(j + 1).toString();
                if (name2.compareToIgnoreCase(name1) >= 0) continue;
                FilterSelector fsm = this.m_filters.get(j);
                this.m_filters.set(j, this.m_filters.get(j + 1));
                this.m_filters.set(j, fsm);
            }
        }
        this.m_cmbFilterList.setModel(new DefaultComboBoxModel<Object>(this.m_filters.toArray()));
        if (defaultfilter != null) {
            for (i = 0; i < this.m_filters.size(); ++i) {
                if (!this.m_filters.get(i).toString().equals(defaultfilter.toString())) continue;
                this.m_cmbFilterList.setSelectedIndex(i);
                break;
            }
        } else if (this.m_cmbFilterList.getItemCount() != 0) {
            this.m_cmbFilterList.setSelectedIndex(0);
        }
    }
}

