/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.lang.NullArgumentException;

public class StringExpression
extends AbstractExpression {
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SINGLE_QUOTE = '\'';
    private static final long serialVersionUID = 1L;
    private static final StringExpression NULL = new StringExpression("");
    private final String string;

    public static StringExpression NULL() {
        return NULL;
    }

    public StringExpression(String string) {
        NullArgumentException.throwIfNull((Object)string, (String)"string");
        this.string = string;
    }

    @Override
    public Expression accept(ExpressionVisitor visitor) {
        return visitor.visitString(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof StringExpression)) {
            return false;
        }
        StringExpression other = (StringExpression)obj;
        return this.string.equals(other.string);
    }

    public String getText() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return this.string.hashCode();
    }

    @Override
    public StringBuilder toString(StringBuilder s) {
        boolean hasQuote;
        String text = this.getText();
        if (s == null) {
            s = new StringBuilder();
        }
        boolean bl = hasQuote = text.indexOf(39) >= 0;
        if (!hasQuote) {
            s.append('\'').append(text).append('\'');
        } else {
            boolean bl2 = hasQuote = text.indexOf(34) >= 0;
            if (!hasQuote) {
                s.append('\"').append(text).append('\"');
            } else {
                s.append('\'');
                for (char c : text.toCharArray()) {
                    if (c == '\'') {
                        s.append(c);
                    }
                    s.append(c);
                }
                s.append('\'');
            }
        }
        return s;
    }
}

