/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.SimpleName;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import net.jcip.annotations.Immutable;

@Immutable
public class SortKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Expression key;
    private final boolean ascending;
    private final int strength;

    public SortKey(@NonNull String name) {
        this.key = new SimpleName(name);
        this.ascending = true;
        this.strength = 2;
    }

    public SortKey(@NonNull Expression e, boolean ascending, @NonNull int strength) {
        this.key = e;
        this.ascending = ascending;
        this.strength = strength;
        this.validateStrength(strength);
    }

    private void validateStrength(int strength) {
        switch (strength) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 15: {
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("invalid sort key strength %d", strength));
            }
        }
    }

    public SortKey(@NonNull Expression e) {
        this(e, true, 2);
    }

    @NonNull
    public SortKey ascending() {
        if (this.ascending) {
            return this;
        }
        return new SortKey(this.key, true, this.strength);
    }

    @NonNull
    public SortKey descending() {
        if (!this.ascending) {
            return this;
        }
        return new SortKey(this.key, false, this.strength);
    }

    @NonNull
    public SortKey primaryStrength() {
        return new SortKey(this.key, this.ascending, 0);
    }

    @NonNull
    public SortKey secondaryStrength() {
        return new SortKey(this.key, this.ascending, 1);
    }

    @NonNull
    public SortKey tertiaryStrength() {
        return new SortKey(this.key, this.ascending, 2);
    }

    @NonNull
    public SortKey quaternaryStrength() {
        return new SortKey(this.key, this.ascending, 3);
    }

    @NonNull
    public SortKey identicalStrength() {
        return new SortKey(this.key, this.ascending, 15);
    }

    public boolean isKeyAName() {
        return this.key instanceof SimpleName;
    }

    public Expression getKey() {
        return this.key;
    }

    public String getKeyName() {
        if (!this.isKeyAName()) {
            throw new AssertionError((Object)"sort key expression is not a SimpleName");
        }
        SimpleName name = (SimpleName)this.key;
        return name.getText();
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    @NonNull
    public int getStrength() {
        return this.strength;
    }

    public int hashCode() {
        int h = 27;
        h = h * 17 + this.key.hashCode();
        h = h * 17 + (this.ascending ? 1 : 0);
        h = h * 17 + this.strength;
        return h;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        SortKey that = (SortKey)obj;
        return this.key.equals(that.key) && this.ascending == that.ascending && this.strength == that.strength;
    }

    public String toString() {
        StringBuilder b = this.key.toString(new StringBuilder()).append(",").append(this.ascending ? "ascending" : "descending").append(":").append(this.strength());
        return b.toString();
    }

    private String strength() {
        switch (this.strength) {
            case 0: {
                return "PRIMARY";
            }
            case 1: {
                return "SECONDARY";
            }
            case 2: {
                return "TERTIARY";
            }
            case 3: {
                return "QUATERNARY";
            }
            case 15: {
                return "IDENTICAL";
            }
        }
        throw new IllegalStateException(String.format("Unknown strength %d", this.strength));
    }
}

