/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;

public class Function
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final SimpleName name;
    @NonNull
    private final List<Expression> arguments;

    public Function(@NonNull SimpleName fnName, @NonNull List<Expression> args) throws NullArgumentException {
        NullArgumentException.throwIfNull((Object)fnName, (String)"fnName");
        this.name = fnName;
        this.arguments = args;
    }

    public Function(@NonNull SimpleName fnName, Expression ... args) {
        this(fnName, Arrays.asList(args));
    }

    public Function(@NonNull String fnName, Expression ... args) {
        this(new SimpleName(fnName), Arrays.asList(args));
    }

    @Override
    public Expression accept(ExpressionVisitor visitor) {
        return visitor.visitFunction(this);
    }

    @NonNull
    public List<Expression> getArguments() {
        return this.arguments;
    }

    @NonNull
    public String getFunctionName() {
        return this.name.getText();
    }

    @NonNull
    public SimpleName getName() {
        return this.name;
    }

    @Override
    public StringBuilder toString(StringBuilder s) {
        if (s == null) {
            s = new StringBuilder();
        }
        s.append(this.getFunctionName());
        s.append('(');
        String delim = "";
        for (Expression arg : this.getArguments()) {
            s.append(delim);
            arg.toString(s);
            delim = ",";
        }
        s.append(')');
        return s;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Function)) {
            return false;
        }
        Function that = (Function)other;
        if (!that.getName().equals(this.getName())) {
            return false;
        }
        return this.getArguments().equals(that.getArguments());
    }

    @Override
    public int hashCode() {
        int h = this.getName().getText().hashCode();
        for (Expression arg : this.getArguments()) {
            h = h * 17 + arg.hashCode();
        }
        return h;
    }
}

