/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import com.sas.commons.expr.Name;
import com.sas.commons.expr.SimpleName;
import com.sas.commons.lang.NullArgumentException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DottedName
extends Name {
    private static final long serialVersionUID = 1L;
    public static final Comparator<DottedName> CASE_INSENSITIVE_COMPARATOR = new Comparator<DottedName>(){

        @Override
        public int compare(DottedName dn1, DottedName dn2) {
            int len2;
            ArrayList names1 = dn1.names;
            ArrayList names2 = dn2.names;
            int len1 = names1.size();
            if (len1 != (len2 = names2.size())) {
                return len1 < len2 ? -1 : 1;
            }
            for (int i = 0; i < len1; ++i) {
                String n2;
                String n1 = ((SimpleName)names1.get(i)).getText();
                int x = n1.compareToIgnoreCase(n2 = ((SimpleName)names2.get(i)).getText());
                if (x == 0) continue;
                return x;
            }
            return 0;
        }
    };
    private final ArrayList<SimpleName> names = new ArrayList();

    public DottedName(@NonNull SimpleName name) {
        super(name.getText());
        this.names.add(name);
    }

    @Override
    public Expression accept(@NonNull ExpressionVisitor visitor) {
        return visitor.visitDottedName(this);
    }

    public DottedName add(@NonNull SimpleName name) {
        NullArgumentException.throwIfNull((Object)name, (String)"name");
        this.names.add(name);
        return this;
    }

    @Override
    @NonNull
    public DottedName asDottedName() {
        return this;
    }

    public DottedName butFirst() {
        if (this.names.size() == 1) {
            throw new UnsupportedOperationException("butFirst not allowed on DottedName with size() == 1");
        }
        DottedName newName = new DottedName(this.names.get(1));
        for (int n = 2; n < this.names.size(); ++n) {
            newName.add(this.names.get(n));
        }
        return newName;
    }

    public DottedName butLast() {
        if (this.size() == 1) {
            throw new UnsupportedOperationException("butLast not allowed on DottedName with size() == 1");
        }
        DottedName newName = new DottedName(this.names.get(0));
        for (int n = 1; n < this.names.size() - 1; ++n) {
            newName.add(this.names.get(n));
        }
        return newName;
    }

    public boolean endsWith(@NonNull DottedName name) {
        int delta = this.size() - name.size();
        if (delta < 0) {
            return false;
        }
        List<SimpleName> sublist = this.names.subList(delta, this.names.size());
        return sublist.equals(name.names);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof DottedName)) {
            return false;
        }
        DottedName other = (DottedName)obj;
        if (this.names.size() != other.names.size()) {
            return false;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.names.get(i).equals(other.names.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NonNull
    public SimpleName first() {
        return this.names.get(0);
    }

    @Override
    @NonNull
    public SimpleName last() {
        return this.names.get(this.names.size() - 1);
    }

    @NonNull
    public SimpleName get(int i) {
        return this.names.get(i);
    }

    @NonNull
    public List<SimpleName> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    @NonNull
    public String getText() {
        StringBuilder b = this.toString(new StringBuilder(this.names.size() * 10));
        return b.toString();
    }

    @Override
    public int hashCode() {
        int h = 27;
        for (int i = this.size() - 1; i >= 0; --i) {
            h = h * 17 + this.names.get(i).hashCode();
        }
        return h;
    }

    @Override
    public int size() {
        return this.names.size();
    }

    @Override
    @NonNull
    public StringBuilder toString(StringBuilder s) {
        if (s == null) {
            s = new StringBuilder();
        }
        String delim = "";
        for (Name name : this.names) {
            s.append(delim).append(name.getText());
            delim = ".";
        }
        return s;
    }
}

