/*
 * Decompiled with CFR 0.152.
 */
package com.sas.commons.expr;

import com.sas.commons.expr.AbstractExpression;
import com.sas.commons.expr.Expression;
import com.sas.commons.expr.ExpressionVisitor;
import edu.umd.cs.findbugs.annotations.NonNull;

public class BooleanExpression
extends AbstractExpression {
    private static final long serialVersionUID = 1L;
    private static final BooleanExpression TRUE = new BooleanExpression(true);
    private static final BooleanExpression FALSE = new BooleanExpression(false);
    private final boolean value;

    @NonNull
    public static BooleanExpression FALSE() {
        return FALSE;
    }

    @NonNull
    public static BooleanExpression TRUE() {
        return TRUE;
    }

    @Deprecated
    public BooleanExpression(boolean b) {
        this.value = b;
    }

    @Override
    public Expression accept(@NonNull ExpressionVisitor visitor) {
        return visitor.visitBoolean(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanExpression other = (BooleanExpression)obj;
        return this.value == other.value;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public StringBuilder toString(StringBuilder s) {
        if (s == null) {
            s = new StringBuilder();
        }
        return s.append(Boolean.valueOf(this.value).toString());
    }

    public static Expression valueOf(boolean b) {
        return b ? TRUE : FALSE;
    }
}

