/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.FilePluginData;
import com.sas.app.NameVersion;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryOptions;
import com.sas.app.SDSFileTraversalPath;
import com.sas.app.SDSImageServerConnection;
import com.sas.app.SDSImageServerPath;
import com.sas.app.SDSSyncTraversalPath;
import com.sas.app.SDSTraversalPath;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

final class SDSImageServerCacheRepository
extends Repository {
    private final File m_plugins;
    private final String m_imageServerPlugins;
    private final boolean m_debug;
    private Map m_cached = new HashMap();
    private long m_lastCachedSourceMod = Long.MIN_VALUE;

    SDSImageServerCacheRepository(Repository parent, boolean behaviorDevLookThrough, RepositoryOptions repositoryOptions, String imageServerPathPluginsParent, File localPluginsParent) {
        super(parent, behaviorDevLookThrough, repositoryOptions);
        if (localPluginsParent == null) {
            throw Util.illegalNull("localPluginsParent");
        }
        SDSImageServerConnection.validatePath(imageServerPathPluginsParent);
        String path = imageServerPathPluginsParent.endsWith("/") ? imageServerPathPluginsParent : imageServerPathPluginsParent + '/';
        this.m_imageServerPlugins = path + "plugins" + '/';
        this.m_plugins = new File(Util.canonical(localPluginsParent), "plugins");
        this.m_debug = repositoryOptions.m_debug;
        if (this.m_debug) {
            System.out.println("Setting up image server cache between " + this.m_imageServerPlugins + " and " + this.m_plugins);
            System.out.flush();
        }
    }

    @Override
    protected File getLocation() {
        return this.m_plugins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized Plugin localFind(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        String name = request.getName();
        VersionSpec range = request.getRange();
        try (SDSImageServerPath sourcePluginsDir = new SDSImageServerPath(this.m_imageServerPlugins);){
            if (range.isRange()) {
                Iterator it = this.calcPossibleVersions(name, sourcePluginsDir, range).iterator();
                while (it.hasNext()) {
                    Plugin p = this.cache((NameVersion)it.next(), sourcePluginsDir);
                    if (p == null) continue;
                    Plugin plugin = p;
                    return plugin;
                }
                Plugin plugin = null;
                return plugin;
            }
            Plugin plugin = this.cache(new NameVersion(name, range), sourcePluginsDir);
            return plugin;
        }
    }

    private SortedSet calcPossibleVersions(String symbolicName, SDSTraversalPath sourcePluginsDir, VersionSpec range) {
        String name;
        if (symbolicName == null) {
            throw Util.illegalNull("symbolicName");
        }
        if (sourcePluginsDir == null) {
            throw Util.illegalNull("sourcePluginsDir");
        }
        if ((symbolicName = symbolicName.trim()).length() <= 0) {
            throw Util.illegalArgument("symbolicName", symbolicName);
        }
        if (range == null) {
            range = VersionSpec.ANY;
        }
        TreeSet<NameVersion> rc = new TreeSet<NameVersion>();
        String prefix = symbolicName + '_';
        long t0 = System.currentTimeMillis();
        String[] list = sourcePluginsDir.list();
        long t1 = System.currentTimeMillis();
        if (this.m_debug) {
            System.out.println("dir listing (size " + (list != null ? Integer.toString(list.length) : "null") + ") of " + sourcePluginsDir.getRelPath() + " to calculate possible versions of " + symbolicName + " range " + range.toRangeString(true) + " took " + (double)(t1 - t0) / 1000.0 + "s");
        }
        if (list != null) {
            int n = prefix.length();
            for (int i = 0; i < list.length; ++i) {
                VersionSpec v;
                name = list[i];
                if (name == null || !name.startsWith(prefix) || (v = VersionSpec.parseVersion(name.substring(n))) == null || !range.includes(v)) continue;
                rc.add(new NameVersion(symbolicName, v));
            }
        }
        for (NameVersion nv : this.m_cached.keySet()) {
            if (nv == null) continue;
            name = nv.getName();
            VersionSpec version = nv.getVersion();
            if (name == null || version == null || !symbolicName.equals(name) || !range.includes(version)) continue;
            rc.add(nv);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Plugin cache(NameVersion nv, SDSTraversalPath sourcePluginsDir) {
        String syncError;
        long t0;
        long lastSourceMod;
        String pluginLocName;
        block18: {
            if (nv == null) {
                throw Util.illegalNull("nv");
            }
            if (sourcePluginsDir == null) {
                throw Util.illegalNull("sourcePluginsDir");
            }
            if (this.m_cached.containsKey(nv)) {
                Plugin rc = (Plugin)this.m_cached.get(nv);
                if (this.m_debug) {
                    System.out.println(rc != null ? nv.getName() + " " + nv.getVersion().toVersionString() + " previously cached" : nv.getName() + " " + nv.getVersion().toVersionString() + " previously failed to cache");
                }
                return rc;
            }
            pluginLocName = nv.getName() + '_' + nv.getVersion().toVersionString();
            SDSFileTraversalPath dest = new SDSFileTraversalPath(this.m_plugins);
            dest.push(pluginLocName);
            lastSourceMod = Long.MIN_VALUE;
            SDSTraversalPath source = sourcePluginsDir;
            source.push(pluginLocName);
            t0 = System.currentTimeMillis();
            try {
                SDSSyncTraversalPath sync;
                if (source.isDirectory()) {
                    sync = new SDSSyncTraversalPath(source, dest, this.m_debug);
                    syncError = sync.run();
                    if (syncError == null) {
                        lastSourceMod = sync.getLatestSourceMod();
                    }
                    break block18;
                }
                dest.delete();
                source.pop();
                dest.pop();
                pluginLocName = pluginLocName + ".jar";
                source.push(pluginLocName);
                dest.push(pluginLocName);
                if (source.isFile()) {
                    sync = new SDSSyncTraversalPath(source, dest, this.m_debug);
                    syncError = sync.run();
                    if (syncError == null) {
                        lastSourceMod = sync.getLatestSourceMod();
                    }
                    break block18;
                }
                dest.delete();
                this.m_cached.put(nv, null);
                Plugin sync2 = null;
                return sync2;
            }
            finally {
                source.pop();
            }
        }
        long t1 = System.currentTimeMillis();
        if (this.m_debug) {
            System.out.print("caching " + nv.getName() + " " + nv.getVersion().toVersionString() + " took " + (double)(t1 - t0) / 1000.0 + "s");
            if (syncError != null) {
                System.out.print(", error = " + syncError);
            }
            System.out.println();
        }
        Plugin rc = null;
        if (syncError == null) {
            FilePluginData pdata = FilePluginData.refresh(this.m_plugins, pluginLocName, null, new FilePluginData.AttrScanner());
            if (nv.getName().equals(pdata.m_idName) && nv.getVersion().equals(pdata.m_version)) {
                rc = pdata.toPlugin(this.m_plugins);
            }
        } else if (this.m_debug) {
            System.out.println("Unable to sync " + nv.getName() + " " + nv.getVersion().toVersionString() + " with image server: " + syncError);
            System.out.flush();
        }
        this.m_cached.put(nv, rc);
        if (rc != null) {
            this.m_lastCachedSourceMod = Math.max(this.m_lastCachedSourceMod, lastSourceMod);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Plugin[] localFindAll(PluginRequest request) throws IllegalArgumentException {
        if (request == null) {
            throw Util.illegalNull("request");
        }
        String name = request.getName();
        VersionSpec range = request.getRange();
        try (SDSImageServerPath sourcePluginsDir = new SDSImageServerPath(this.m_imageServerPlugins);){
            Plugin[] pluginArray;
            if (range.isRange()) {
                Iterator it = this.calcPossibleVersions(name, sourcePluginsDir, range).iterator();
                ArrayList<Plugin> rc = new ArrayList<Plugin>();
                while (it.hasNext()) {
                    Plugin p = this.cache((NameVersion)it.next(), sourcePluginsDir);
                    if (p == null) continue;
                    rc.add(p);
                }
                Plugin[] pluginArray2 = rc.isEmpty() ? Plugin.ZERO_PLUGINS : rc.toArray(new Plugin[rc.size()]);
                return pluginArray2;
            }
            Plugin p = this.cache(new NameVersion(name, range), sourcePluginsDir);
            if (p != null) {
                Plugin[] pluginArray3 = new Plugin[1];
                pluginArray = pluginArray3;
                pluginArray3[0] = p;
            } else {
                pluginArray = Plugin.ZERO_PLUGINS;
            }
            Plugin[] pluginArray4 = pluginArray;
            return pluginArray4;
        }
    }

    @Override
    protected long localGetTimestamp() {
        return this.m_lastCachedSourceMod;
    }

    @Override
    protected void localPutAllPlugins(Map map) throws IllegalArgumentException {
        map.putAll(this.m_cached);
    }

    @Override
    public Repository reindex(long ifNotNewerThan) {
        return this;
    }

    @Override
    public Plugin[] find(PickList pickList) throws IllegalArgumentException, RepositoryException {
        if (this.m_debug) {
            long t0 = System.currentTimeMillis();
            Plugin[] rc = super.find(pickList);
            long t1 = System.currentTimeMillis();
            System.out.println(this + " processing pick list " + pickList + " took " + (double)(t1 - t0) / 1000.0 + 's');
            return rc;
        }
        return super.find(pickList);
    }

    @Override
    public Plugin find(PluginRequest request) throws IllegalArgumentException {
        if (this.m_debug && request != null) {
            long t0 = System.currentTimeMillis();
            Plugin rc = super.find(request);
            long t1 = System.currentTimeMillis();
            System.out.println(this + " processing request for " + request.getName() + " " + request.getRange().toRangeString(true) + " took " + (double)(t1 - t0) / 1000.0 + 's');
            return rc;
        }
        return super.find(request);
    }
}

