/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.PluginRequest;
import com.sas.app.VersionSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class RepositoryException
extends Exception {
    private static final long serialVersionUID = 5941749112393265709L;
    private final List m_unsatisfiedRequests;

    private static List normalize(List unsatisfiedRequests) throws ClassCastException {
        ArrayList<PluginRequest> rc = new ArrayList<PluginRequest>();
        if (unsatisfiedRequests != null) {
            for (PluginRequest r : unsatisfiedRequests) {
                if (r == null) continue;
                rc.add(r);
            }
        }
        return rc.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(rc);
    }

    RepositoryException(String message) throws IllegalArgumentException {
        super(message);
        this.m_unsatisfiedRequests = Collections.EMPTY_LIST;
    }

    RepositoryException(String message, Throwable cause) throws IllegalArgumentException {
        super(message, cause);
        this.m_unsatisfiedRequests = Collections.EMPTY_LIST;
    }

    RepositoryException(String message, List unsatisfiedRequests) throws IllegalArgumentException {
        super(message);
        this.m_unsatisfiedRequests = RepositoryException.normalize(unsatisfiedRequests);
    }

    public List getUnsatisfiedRequests() {
        return this.m_unsatisfiedRequests;
    }

    @Override
    public String toString() {
        if (this.m_unsatisfiedRequests.isEmpty()) {
            return super.toString();
        }
        StringBuffer rc = new StringBuffer(super.toString());
        rc.append(':');
        Iterator it = this.m_unsatisfiedRequests.iterator();
        boolean first = true;
        while (it.hasNext()) {
            PluginRequest r = (PluginRequest)it.next();
            if (first) {
                first = false;
            } else {
                rc.append(',');
            }
            rc.append(' ').append(r.getName());
            VersionSpec range = r.getRange();
            if (VersionSpec.ANY.equals(range)) continue;
            rc.append(' ').append(range.toRangeString(false));
        }
        return rc.toString();
    }
}

