/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.AppClassLoader;
import com.sas.app.Hacks;
import com.sas.app.LaunchLocatorEntryPoint;
import com.sas.app.PickList;
import com.sas.app.Plugin;
import com.sas.app.PluginRequest;
import com.sas.app.PluginsDirRepository;
import com.sas.app.Repository;
import com.sas.app.RepositoryException;
import com.sas.app.RepositoryUtil;
import com.sas.app.SplashController;
import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import javax.swing.JWindow;

public final class NonAPI {
    private static final Object[] ZERO_OBJECTS = new Object[0];
    private static final Class[] ZERO_CLASSES = new Class[0];
    private static final String SPLASH_CONTROLLER_CLASS_NAME = SplashController.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map configuratorHelper(File repositoryLocation, URL pickListLocation, String idStringNameVersionSeparator) throws IllegalArgumentException, RepositoryException {
        PickList pickList;
        if (repositoryLocation == null) {
            throw Util.illegalNull("repositoryLocation");
        }
        if (pickListLocation == null) {
            throw Util.illegalNull("pickListLocation");
        }
        if (idStringNameVersionSeparator == null) {
            throw Util.illegalNull("idStringNameVersionSeparator");
        }
        InputStream s = null;
        try {
            s = pickListLocation.openStream();
            pickList = new PickList(s);
        }
        catch (IOException e) {
            Map map = null;
            return map;
        }
        finally {
            Util.close(s);
        }
        if (!repositoryLocation.isDirectory()) {
            return null;
        }
        Repository repository = Repository.newChain(new File[]{repositoryLocation});
        Plugin[] plugins = repository.find(pickList);
        LinkedHashMap<String, URL> rc = new LinkedHashMap<String, URL>();
        for (int i = 0; i < plugins.length; ++i) {
            Plugin p = plugins[i];
            File f = p.getFile();
            if (f == null) {
                assert (false);
                continue;
            }
            URL u = Util.toURL(f);
            if (u == null) continue;
            String key = p.getName() + idStringNameVersionSeparator + p.getVersion().toVersionString();
            rc.put(key, u);
        }
        return rc;
    }

    public static synchronized void launchLocatorEntryPoint(Object caller, String[] args) throws ClassNotFoundException, ExceptionInInitializerError, Exception {
        if (caller == null) {
            throw Util.illegalNull("caller");
        }
        if (args != null) {
            String[] copy = new String[args.length];
            if (args.length > 0) {
                System.arraycopy(args, 0, copy, 0, args.length);
            }
            args = copy;
        } else {
            args = new String[]{};
        }
        Class<?> callerClass = caller instanceof Class ? (Class<?>)caller : caller.getClass();
        LaunchLocatorEntryPoint ll = new LaunchLocatorEntryPoint(callerClass);
        AppClassLoader newSys = new AppClassLoader(callerClass.getClassLoader(), ll);
        Hacks.setSystemClassLoader(newSys);
        NonAPI.updateContextClassLoaders(newSys);
        Hacks.updateEventQueueContextClassLoader(newSys);
        Class userMainClass = newSys.loadClass(ll.getUserMain());
        Throwable[] rcProblem = new Throwable[1];
        Util.invoke(userMainClass, "main", new Class[]{String[].class}, new Object[]{args}, Void.TYPE, rcProblem);
        Throwable t = rcProblem[0];
        if (t == null) {
            return;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new RuntimeException(t);
    }

    private static void updateContextClassLoaders(ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw Util.illegalNull("cl");
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        if (tg == null) {
            return;
        }
        try {
            ThreadGroup p;
            while ((p = tg.getParent()) != null) {
                tg = p;
            }
        }
        catch (SecurityException p) {
            // empty catch block
        }
        ArrayList<ThreadGroup> stack = new ArrayList<ThreadGroup>();
        stack.add(tg);
        Thread[] threads = new Thread[23];
        ThreadGroup[] subGroups = new ThreadGroup[23];
        while (!stack.isEmpty()) {
            int i;
            int n;
            tg = (ThreadGroup)stack.remove(stack.size() - 1);
            while ((n = tg.enumerate(threads, false)) >= threads.length) {
                threads = new Thread[threads.length * 2];
            }
            for (i = 0; i < n; ++i) {
                Thread t = threads[i];
                if (t == null) continue;
                try {
                    ClassLoader ctx = t.getContextClassLoader();
                    if (ctx == null || ctx == cl) continue;
                    t.setContextClassLoader(cl);
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            while ((n = tg.enumerate(subGroups, false)) >= subGroups.length) {
                subGroups = new ThreadGroup[subGroups.length * 2];
            }
            for (i = n - 1; i >= 0; --i) {
                tg = subGroups[i];
                if (tg == null) continue;
                stack.add(tg);
            }
        }
    }

    public static void adsWritePickList(PickList pickList, Attributes attr, String userMainClass, boolean useLaunchLocator) throws IllegalArgumentException {
        pickList.write(attr, userMainClass, useLaunchLocator);
    }

    public static void adsExtractRequests(PickList pickList, Map rcMap) throws IllegalArgumentException {
        if (pickList == null) {
            throw Util.illegalNull("pickList");
        }
        if (rcMap == null) {
            throw Util.illegalNull("rcMap");
        }
        rcMap.clear();
        PluginRequest[] requests = pickList.getRequestsAndExcludes(null, null);
        for (int i = 0; i < requests.length; ++i) {
            PluginRequest r = requests[i];
            rcMap.put(r.getName(), r.getRange());
        }
    }

    public boolean isTainted(Plugin p) throws IllegalArgumentException {
        if (p == null) {
            throw Util.illegalNull("p");
        }
        return p.isTainted();
    }

    public static PluginRequest[] adsExtractRequests(PickList pickList, Set rcExcludes, Set rcOptional) throws IllegalArgumentException {
        if (pickList == null) {
            throw Util.illegalNull("pickList");
        }
        if (rcExcludes != null) {
            rcExcludes.clear();
        }
        PluginRequest[] rc = pickList.getRequestsAndExcludes(null, rcExcludes);
        if (rcOptional != null) {
            rcOptional.clear();
            for (int i = 0; i < rc.length; ++i) {
                PluginRequest r = rc[i];
                if (!r.isOptional()) continue;
                rcOptional.add(r.getName());
            }
        }
        return rc;
    }

    public static PluginRequest adsNewExcludeRequest(String name) throws IllegalArgumentException {
        return new PluginRequest(name, VersionSpec.ANY, 1);
    }

    public static PluginRequest adsNewOptionalRequest(String name, VersionSpec range) throws IllegalArgumentException {
        return new PluginRequest(name, range, 2);
    }

    public static PickList adsNewRecursivePickList(Collection requests) throws IllegalArgumentException, ClassCastException, RepositoryException {
        return new PickList(requests, true);
    }

    public static URL[] smcResolveDependencies(File[] files, Repository repository, ClassLoader filterCL) throws IllegalArgumentException, RepositoryException, MalformedURLException {
        if (repository == null) {
            throw Util.illegalNull("repository");
        }
        if (files == null || files.length <= 0) {
            return Util.ZERO_URLS;
        }
        ArrayList<URL> list = new ArrayList<URL>();
        for (int i = 0; i < files.length; ++i) {
            File f = Util.canonical(files[i]);
            if (f == null) continue;
            URL u = f.toURI().toURL();
            list.add(u);
        }
        int n = list.size();
        if (n <= 0) {
            return Util.ZERO_URLS;
        }
        URL[] urls = list.toArray(new URL[n]);
        return NonAPI.smcResolveDependencies(urls, repository, filterCL);
    }

    public static URL[] smcResolveDependencies(URL[] urls, Repository repository, ClassLoader filterCL) throws IllegalArgumentException, RepositoryException {
        if (repository == null) {
            throw Util.illegalNull("repository");
        }
        if (urls == null || urls.length <= 0) {
            return Util.ZERO_URLS;
        }
        ArrayList<URL> origURLs = new ArrayList<URL>();
        for (int i = 0; i < urls.length; ++i) {
            URL u = urls[i];
            if (u == null) continue;
            origURLs.add(u);
        }
        if (origURLs.isEmpty()) {
            return Util.ZERO_URLS;
        }
        LinkedHashSet<URL> rc = new LinkedHashSet<URL>();
        PickList deps = RepositoryUtil.parseDepsForURLs(origURLs, false);
        if (!deps.isEmpty()) {
            Map loadedPluginNameVersions;
            HashMap usedPluginNameVersions = null;
            if (filterCL != null && (loadedPluginNameVersions = (Map)Util.invoke(filterCL, "getLoadedPluginNameVersions()", Util.VOID, null, Map.class, null)) != null && !loadedPluginNameVersions.isEmpty()) {
                usedPluginNameVersions = new HashMap(loadedPluginNameVersions);
            }
            RepositoryUtil.getClasspath(repository, deps, rc, usedPluginNameVersions);
        }
        rc.addAll(origURLs);
        return rc.toArray(new URL[rc.size()]);
    }

    public static Map smcGetLoadedPluginVersions(ClassLoader classLoader) {
        if (classLoader == null) {
            return null;
        }
        Object o = Util.invoke(classLoader, "getLoadedPluginNameVersions", ZERO_CLASSES, ZERO_OBJECTS, Map.class, null);
        if (!(o instanceof Map)) {
            return null;
        }
        Map m = (Map)o;
        if (m.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        if (!(o instanceof Serializable)) {
            return null;
        }
        Serializable converted = NonAPI.crossClassLoaderBoundary((Serializable)o);
        return converted instanceof Map ? (Map)((Object)converted) : null;
    }

    static Serializable crossClassLoaderBoundary(Serializable o) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(os);
            out.writeObject(o);
            out.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            ObjectInputStream in = new ObjectInputStream(is);
            Object rc = in.readObject();
            return rc instanceof Serializable ? (Serializable)rc : null;
        }
        catch (IOException iOException) {
        }
        catch (ClassCastException classCastException) {
        }
        catch (SecurityException securityException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static void main(String[] args) {
        Repository repository;
        if (args == null) {
            throw Util.illegalNull("args");
        }
        if (args.length < 1 || args.length > 2) {
            throw Util.illegalArgument("args.length", new Integer(args.length));
        }
        boolean test = false;
        String temp = args[0];
        if (!"-install".equals(temp) && !"-test".equals(temp)) {
            throw new UnsupportedOperationException(Util.format("NonAPI.main.unsupportedOperation.fmt.log", temp));
        }
        if ("-test".equals(temp)) {
            test = true;
        }
        try {
            repository = Repository.getDefaultRepository();
        }
        catch (RepositoryException e) {
            System.err.println(e.getMessage());
            System.exit(2);
            return;
        }
        if (test) {
            System.out.println("repository loc " + repository.getLocation());
            for (Repository p = repository.getParent(); p != null; p = p.getParent()) {
                System.out.println("ancestor repository loc " + p.getLocation());
            }
            System.exit(0);
            return;
        }
        repository.reindex(Long.MAX_VALUE);
    }

    public static Repository newRepositoryChain(File base, String relativeLocationsPath) throws IllegalArgumentException, RepositoryException {
        return NonAPI.newRepositoryChain(base, relativeLocationsPath, false);
    }

    public static Repository newRepositoryChain(File base, String relativeLocationsPath, boolean devLookThrough) throws IllegalArgumentException, RepositoryException {
        if (base == null) {
            throw Util.illegalNull("base");
        }
        if (relativeLocationsPath == null) {
            throw Util.illegalNull("relativeLocationsPath");
        }
        StringTokenizer tok = new StringTokenizer(relativeLocationsPath.trim(), ":;");
        int n = tok.countTokens();
        if (n <= 0) {
            throw Util.illegalArgument("relativeLocationsPath", relativeLocationsPath);
        }
        File b = Util.canonical(base);
        File[] eclipseDirs = new File[n];
        for (int i = 0; i < n; ++i) {
            File plugins2;
            File eclipse;
            String relPath = tok.nextToken().trim();
            if (relPath.length() <= 0) {
                throw Util.illegalArgument("relativeLocationsPath", relativeLocationsPath);
            }
            File loc = new File(b, relPath);
            File plugins = new File(loc, "plugins");
            boolean pdir = plugins.isDirectory();
            if (!pdir && (eclipse = new File(loc, "eclipse")).isDirectory() && (plugins2 = new File(eclipse, "plugins")).isDirectory()) {
                loc = eclipse;
                plugins = plugins2;
                pdir = true;
            }
            if (!pdir) {
                throw new RepositoryException(Util.format("NonAPI.nonDir.ex.fmt.txt", plugins));
            }
            eclipseDirs[i] = loc;
        }
        return PluginsDirRepository.newChain(eclipseDirs, devLookThrough);
    }

    public static JWindow getSplashWindow() {
        ClassLoader cl = NonAPI.getOriginalSystemClassLoader();
        if (cl == null) {
            return null;
        }
        Object rc = NonAPI.invokeStatic(cl, SPLASH_CONTROLLER_CLASS_NAME, "getSplashWindow", ZERO_CLASSES, ZERO_OBJECTS, JWindow.class, null);
        return rc instanceof JWindow ? (JWindow)rc : null;
    }

    public static void closeSplash() {
        ClassLoader cl = NonAPI.getOriginalSystemClassLoader();
        if (cl == null) {
            return;
        }
        NonAPI.invokeStatic(cl, SPLASH_CONTROLLER_CLASS_NAME, "closeSplash", ZERO_CLASSES, ZERO_OBJECTS, null, null);
    }

    static Object invokeStatic(ClassLoader cl, String className, String methodName, Class[] sig, Object[] args, Class desiredReturnType, Throwable[] rcProblem) throws IllegalArgumentException {
        Class c = NonAPI.loadClass(cl, className, rcProblem);
        if (c == null) {
            return null;
        }
        return Util.invoke(c, methodName, sig, args, desiredReturnType, rcProblem);
    }

    private static Class loadClass(ClassLoader cl, String className, Throwable[] rcProblem) throws IllegalArgumentException {
        if (cl == null) {
            throw Util.illegalNull("cl");
        }
        if (className == null) {
            throw Util.illegalNull("className");
        }
        Throwable t = null;
        try {
            return cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            t = e;
        }
        catch (ExceptionInInitializerError e) {
            t = e;
        }
        if (t != null && rcProblem != null && rcProblem.length > 0) {
            rcProblem[0] = t;
        }
        return null;
    }

    private static ClassLoader getOriginalSystemClassLoader() {
        ClassLoader cl = null;
        try {
            cl = ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Error error) {
            // empty catch block
        }
        if (cl == null) {
            try {
                cl = NonAPI.class.getClassLoader();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (cl == null) {
                try {
                    cl = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (cl == null) {
                    return null;
                }
            }
        }
        try {
            while (true) {
                ClassLoader src;
                if ((src = cl.getClass().getClassLoader()) == null) {
                    return cl;
                }
                cl = src;
            }
        }
        catch (SecurityException e) {
            return cl;
        }
    }
}

