/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.Util;
import com.sas.app.VersionSpec;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

class FrameworkProps {
    private static final String UNKNOWN = "unknown";
    private static final String OS_ARCH = "os.arch";
    private static final String OS_NAME = "os.name";
    private static final String ARCH_X86 = "x86";
    private static final String ARCH_IGNITE = "ignite";
    private static final String ARCH_POWERPC = "powerpc";
    private static final String OS_OS2 = "os2";
    private static final String OS_QNX = "qnx";
    private static final String OS_WIN32 = "win32";
    private static final String WS_WIN32 = "win32";
    private static final String WS_GTK = "gtk";
    private static final String WS_PHOTON = "photon";
    private static final String WS_MOTIF = "motif";
    private static final String PROP_FRAMEWORK_VERSION = "org.osgi.framework.version";
    private static final String PROP_FRAMEWORK_VENDOR = "org.osgi.framework.vendor";
    static final String PROP_LANGUAGE = "org.osgi.framework.language";
    private static final String PROP_FRAMEWORK_EXECUTION_ENVIRONMENT = "org.osgi.framework.executionenvironment";
    static final String PROP_PROCESSOR = "org.osgi.framework.processor";
    static final String PROP_OS_NAME = "org.osgi.framework.os.name";
    static final String PROP_FRAMEWORK_OS_VERSION = "org.osgi.framework.os.version";
    private static final String PROP_WINDOWING_SYSTEM = "org.osgi.framework.windowing.system";
    private static final String PROP_FRAMEWORK_SUPPORTS_REQUIRE_BUNDLE = "org.osgi.supports.framework.requirebundle";
    private static final String PROP_JAVA_SPEC_VERSION = "java.specification.version";
    private static final String PROP_SUN_DESKTOP = "sun.desktop";
    private static final String PROP_JAVA_OS_VERSION = "os.version";
    private static final String VALUE_FRAMEWORK_VENDOR = "SAS Launcher";
    private static Map s_props;

    FrameworkProps() {
    }

    static synchronized Map getFrameworkProps() {
        Map rc = s_props;
        if (rc == null) {
            s_props = rc = FrameworkProps.calcFrameworkProps();
        }
        return rc;
    }

    static boolean matchesOsName(String[] targets, Map frameworkProps) {
        int i;
        if (targets == null || targets.length <= 0) {
            return false;
        }
        String[] osNames = FrameworkProps.getStringArray(PROP_OS_NAME, frameworkProps);
        if (osNames == null || osNames.length <= 0) {
            return false;
        }
        HashSet<String> normOsNames = new HashSet<String>();
        for (i = 0; i < osNames.length; ++i) {
            String name = osNames[i];
            if (name == null || (name = name.trim()).length() <= 0) continue;
            normOsNames.add(name.toLowerCase());
            FrameworkProps.addNormalizeOsNames(name, normOsNames);
        }
        for (i = 0; i < targets.length; ++i) {
            String t = targets[i];
            if (t == null || !normOsNames.contains(t.trim().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    static boolean matchesProcessor(String[] targets, Map frameworkProps) {
        int i;
        if (targets == null || targets.length <= 0) {
            return false;
        }
        String[] procs = FrameworkProps.getStringArray(PROP_PROCESSOR, frameworkProps);
        if (procs == null || procs.length <= 0) {
            return false;
        }
        HashSet<String> normProcs = new HashSet<String>();
        for (i = 0; i < procs.length; ++i) {
            String name = procs[i];
            if (name == null || (name = name.trim()).length() <= 0) continue;
            normProcs.add(name.toLowerCase());
            String normed = FrameworkProps.normalizeProcessor(name);
            if (normed == null || (normed = normed.trim()).length() <= 0) continue;
            normProcs.add(normed.toLowerCase());
        }
        for (i = 0; i < targets.length; ++i) {
            String t = targets[i];
            if (t == null || !normProcs.contains(t.trim().toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private static Map calcFrameworkProps() {
        Object o;
        VersionSpec v;
        String s;
        Properties sysProps = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperties();
                }
                catch (SecurityException e) {
                    return null;
                }
            }
        });
        Map rc = FrameworkProps.lowercase(sysProps);
        if (!rc.containsKey(PROP_FRAMEWORK_VERSION)) {
            rc.put(PROP_FRAMEWORK_VERSION, "1.3");
        }
        if (!rc.containsKey(PROP_FRAMEWORK_VENDOR)) {
            rc.put(PROP_FRAMEWORK_VENDOR, VALUE_FRAMEWORK_VENDOR);
        }
        if (!rc.containsKey(PROP_LANGUAGE) && (s = Locale.getDefault().getLanguage()) != null && s.trim().length() > 0) {
            rc.put(PROP_LANGUAGE, s);
        }
        if (!rc.containsKey(PROP_FRAMEWORK_EXECUTION_ENVIRONMENT) && (s = (String)rc.get(PROP_JAVA_SPEC_VERSION)) != null && (v = VersionSpec.parseVersion(s)) != null && v.getMajor() == 1 && v.getMinor() >= 2) {
            StringBuffer b = new StringBuffer();
            int n = v.getMinor();
            for (int i = 2; i <= n; ++i) {
                if (b.length() > 0) {
                    b.append(',');
                }
                b.append("J2SE-1.").append(i);
            }
            rc.put(PROP_FRAMEWORK_EXECUTION_ENVIRONMENT, b.toString());
        }
        if (!rc.containsKey(PROP_PROCESSOR)) {
            rc.put(PROP_PROCESSOR, FrameworkProps.calcProcessor(rc));
        }
        if (!rc.containsKey(PROP_FRAMEWORK_OS_VERSION) && (o = rc.get(PROP_JAVA_OS_VERSION)) != null) {
            rc.put(PROP_FRAMEWORK_OS_VERSION, o);
        }
        if (!rc.containsKey(PROP_OS_NAME)) {
            rc.put(PROP_OS_NAME, FrameworkProps.calcOsName(rc));
        }
        if (!rc.containsKey(PROP_WINDOWING_SYSTEM) && (o = FrameworkProps.guessWindowingSystem(rc)) != null) {
            rc.put(PROP_WINDOWING_SYSTEM, o);
        }
        if (!rc.containsKey(PROP_FRAMEWORK_SUPPORTS_REQUIRE_BUNDLE)) {
            rc.put(PROP_FRAMEWORK_SUPPORTS_REQUIRE_BUNDLE, Boolean.TRUE);
        }
        return Collections.unmodifiableMap(rc);
    }

    private static String calcProcessor(Map frameworkProps) {
        Object o = frameworkProps.get(OS_ARCH);
        if (!(o instanceof String)) {
            return UNKNOWN;
        }
        String s = FrameworkProps.normalizeProcessor((String)o);
        return s == null ? UNKNOWN : s.toLowerCase();
    }

    private static String normalizeProcessor(String s) {
        if (s == null) {
            return null;
        }
        int len = (s = s.trim().toLowerCase()).length();
        if (len <= 0) {
            return null;
        }
        if (s.matches("(68k|arm|alpha|ignite|mips|parisc|powerpc|sh4|sparc|s390|v850e|x86)")) {
            return s;
        }
        if (s.indexOf("pentium") >= 0) {
            return ARCH_X86;
        }
        if (Pattern.compile("i\\d86").matcher(s).find()) {
            return ARCH_X86;
        }
        if (s.indexOf("psc1k") >= 0) {
            return ARCH_IGNITE;
        }
        if ("power".equalsIgnoreCase(s) || "ppc".equalsIgnoreCase(s)) {
            return ARCH_POWERPC;
        }
        return null;
    }

    private static Object calcOsName(Map frameworkProps) {
        Object o = frameworkProps.get(OS_NAME);
        if (!(o instanceof String)) {
            return UNKNOWN;
        }
        LinkedHashSet set = new LinkedHashSet();
        if (!FrameworkProps.addNormalizeOsNames((String)o, set)) {
            return UNKNOWN;
        }
        int n = set.size();
        if (n <= 0) {
            return UNKNOWN;
        }
        if (n == 1) {
            return set.iterator().next();
        }
        return set.toArray(new String[n]);
    }

    private static boolean addNormalizeOsNames(String s, Collection rc) {
        assert (rc != null);
        if (s == null) {
            return false;
        }
        int len = (s = s.trim().toLowerCase()).length();
        if (len <= 0) {
            return false;
        }
        String out = null;
        if (s.matches("(aix|digitalunix|freebsd|hpux|irix|linux|macos|netware|openbsd|netbsd|os2|qnx|solaris|sunos|vxworks)")) {
            out = s;
        } else if (s.indexOf("os/2") >= 0) {
            out = OS_OS2;
        } else if (s.indexOf("procnto") >= 0) {
            out = OS_QNX;
        } else if (s.indexOf("win") >= 0) {
            out = "win32";
            StringTokenizer tok = new StringTokenizer("xp 2000 ce nt 98 95");
            while (tok.hasMoreTokens()) {
                String subType = tok.nextToken().toLowerCase();
                Pattern p = Pattern.compile("win(dows)? ?" + subType);
                if (!p.matcher(s).find()) continue;
                rc.add("windows" + subType);
                break;
            }
        }
        if (out == null) {
            return false;
        }
        rc.add(out.toLowerCase());
        return true;
    }

    private static Object guessWindowingSystem(Map frameworkProps) {
        assert (frameworkProps != null);
        String[] sunDesktop = FrameworkProps.getStringArray(PROP_SUN_DESKTOP, frameworkProps);
        String[] osNames = FrameworkProps.getStringArray(PROP_OS_NAME, frameworkProps);
        if (FrameworkProps.findMatchProp("win", sunDesktop) || FrameworkProps.findMatchProp("win", osNames)) {
            return new String[]{"win32", "windows"};
        }
        if (FrameworkProps.findMatchProp("gnome", sunDesktop)) {
            return WS_GTK;
        }
        if (FrameworkProps.findMatchProp(OS_QNX, osNames)) {
            return WS_PHOTON;
        }
        if (FrameworkProps.findMatchProp("(aix|hpux|linux|solaris)", osNames)) {
            return WS_MOTIF;
        }
        return null;
    }

    private static boolean findMatchProp(String valueRegex, String[] values) {
        if (values == null) {
            return false;
        }
        Pattern p = Pattern.compile(valueRegex);
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            if (v == null || !p.matcher(v.toLowerCase()).find()) continue;
            return true;
        }
        return false;
    }

    static String[] getStringArray(String propKey, Map frameworkProps) throws IllegalArgumentException {
        if (frameworkProps == null) {
            throw Util.illegalNull("frameworkProps");
        }
        if (propKey == null) {
            return null;
        }
        Object o = frameworkProps.get(propKey);
        if (o instanceof String) {
            return new String[]{(String)o};
        }
        if (o instanceof String[]) {
            String[] rc = (String[])o;
            return rc.length > 0 ? rc : null;
        }
        return null;
    }

    private static Map lowercase(Properties p) {
        HashMap<String, String> rc = new HashMap<String, String>();
        if (p == null) {
            return rc;
        }
        HashSet<String> lowercased = new HashSet<String>();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            if (s == null) continue;
            String lower = s.toLowerCase();
            if (!s.equals(lower)) {
                if (rc.containsKey(lower) && !lowercased.contains(lower)) continue;
                lowercased.add(lower);
            } else {
                lowercased.remove(lower);
            }
            rc.put(lower, p.getProperty(s));
        }
        return rc;
    }
}

