/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.validator.commands;

import com.sas.management.MetadataFactory;
import com.sas.management.MetadataInterface;
import com.sas.management.ValidatorException;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.log.ServerLogUtil;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.meta.SASOMI.IOMI;
import com.sas.metadata.Util;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.ServiceException;
import com.sas.services.deployment.CorePlatformServices;
import com.sas.services.deployment.Environment;
import com.sas.services.deployment.MetadataSourceInterface;
import com.sas.services.deployment.PlatformServices;
import com.sas.services.deployment.PlatformServicesConfiguration;
import com.sas.services.deployment.ServiceLoader;
import com.sas.services.deployment.URLMetadataSource;
import com.sas.services.discovery.DiscoveryServiceInterface;
import com.sas.services.security.login.OMILoginModule;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserInitializationException;
import com.sas.services.user.UserServiceInterface;
import com.sas.util.ChainedExceptionInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import javax.security.auth.login.AppConfigurationEntry;

public class ValidateServer {
    private MetaServerConnection m_metaConnection;
    private String m_strServerType;
    private String m_strServerName;
    private String m_strServerID;
    private static UserContextInterface m_userContext;
    private int m_returnCode = 0;
    private Handler m_handler;
    private MdFactory m_objectFactory;
    private MdObjectStore m_store;
    protected static WAdminResource bundle;

    public ValidateServer() {
        try {
            this.m_objectFactory = new MdFactoryImpl();
            MetadataFactory.setMdFactory(this.m_objectFactory);
            this.m_store = this.m_objectFactory.createObjectStore();
            MetadataFactory.setStore(this.m_store);
        }
        catch (MdException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        System.setOut(System.out);
    }

    private void setLogging(Properties properties) {
        try {
            File file;
            StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter());
            handler.setLevel(Level.ALL);
            this.setHandler(handler);
            this.m_objectFactory.setDebug(false);
            this.m_objectFactory.setLoggingEnabled(false);
            Util.setLogStream((OutputStream)System.out);
            String strAppData = Workspace.getAppDataPath();
            String strSeparator = File.separator;
            String strEnvironmentLocation = strAppData + strSeparator + "SAS" + strSeparator + "Logs";
            if (strSeparator.equals("/")) {
                strEnvironmentLocation = strAppData + strSeparator + ".SASAppData" + strSeparator + "Logs";
            }
            if (!(file = new File(strEnvironmentLocation)).exists()) {
                file.mkdirs();
            }
            String strLogFileName = strEnvironmentLocation + strSeparator + "ValidateServerErrorLog.log";
            this.setFileHandler(strLogFileName);
            boolean bLogSet = properties.containsKey("log");
            if (bLogSet) {
                strLogFileName = properties.getProperty("log");
                if (strLogFileName != null && strLogFileName.length() > 0) {
                    String strFolder;
                    if (strLogFileName.lastIndexOf(System.getProperty("file.separator")) != -1 && !(file = new File(strFolder = strLogFileName.substring(0, strLogFileName.lastIndexOf(System.getProperty("file.separator"))))).exists()) {
                        file.mkdirs();
                    }
                } else {
                    strLogFileName = System.getProperty("user.home") + System.getProperty("file.separator") + "ValidateServerErrorLog.log";
                }
                this.setFileHandler(strLogFileName);
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void setFileHandler(String filename) {
        try {
            FileHandler handler = new FileHandler(filename);
            handler.setLevel(Level.ALL);
            this.setHandler(handler);
            FileOutputStream fileStream = new FileOutputStream(filename);
            PrintStream printStream = new PrintStream(fileStream);
            System.setOut(printStream);
            System.setErr(printStream);
            Util.setLogStream((OutputStream)printStream);
        }
        catch (FileNotFoundException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (IOException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }

    public void setReturnCode(int code) {
        this.m_returnCode = code;
    }

    private boolean validateArgs(Properties argProperties, Properties serverProperties, Properties metaserverProperties) {
        boolean bValidated = true;
        if (argProperties.containsKey("help") || argProperties.containsKey("?")) {
            return bValidated;
        }
        if (!this.validateServerParms(serverProperties)) {
            bValidated = false;
            return bValidated;
        }
        if (!this.validateMetaServerParms(metaserverProperties)) {
            bValidated = false;
            return bValidated;
        }
        String strMetaServerParms = argProperties.getProperty("metaserverparms");
        if (strMetaServerParms == null) {
            strMetaServerParms = argProperties.getProperty("msp");
        }
        if (strMetaServerParms != null) {
            if (argProperties.getProperty("servername") == null && argProperties.getProperty("sn") == null && argProperties.getProperty("serverid") == null && argProperties.getProperty("sid") == null) {
                String strOption = "-servername | -sn | -serverid | -sid";
                ServerUtil.printLog(bundle.formatString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
                bValidated = false;
                return bValidated;
            }
        } else {
            String strOption = "-metaserverparms | -msp";
            ServerUtil.printLog(bundle.formatString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
            bValidated = false;
            return bValidated;
        }
        String strServerName = argProperties.getProperty("servername");
        if (strServerName == null) {
            strServerName = argProperties.getProperty("sn");
        }
        if (strServerName != null && argProperties.getProperty("metaserverparms") == null && argProperties.getProperty("msp") == null) {
            String strOption = "-metaserverparms | -msp";
            ServerUtil.printLog(bundle.formatString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
            bValidated = false;
            return bValidated;
        }
        String strServerID = argProperties.getProperty("serverid");
        if (strServerID == null) {
            strServerID = argProperties.getProperty("sid");
        }
        if (strServerID != null) {
            if (strServerID.length() != 17 || strServerID.indexOf(".") != 8) {
                ServerUtil.printLog(bundle.getString("ValidateServer.WrongServerID.txt"));
                bValidated = false;
                return bValidated;
            }
            if (argProperties.getProperty("metaserverparms") == null && argProperties.getProperty("msp") == null) {
                String strOption = "-metaserverparms | -msp";
                ServerUtil.printLog(bundle.formatString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
                bValidated = false;
                return bValidated;
            }
        }
        return bValidated;
    }

    private boolean validateServerParms(Properties properties) {
        boolean bValidated = true;
        String strPort = properties.getProperty("port");
        if (strPort != null) {
            try {
                Integer portObj = Integer.valueOf(strPort);
                if (portObj == null || portObj < 0 || portObj >= 65536) {
                    ServerUtil.printLog(bundle.getString("ValidateServer.WrongPortRange.txt"));
                    bValidated = false;
                    return bValidated;
                }
            }
            catch (NumberFormatException exc) {
                ServerUtil.printLog(bundle.formatString("ValidateServer.WrongPortFormat.fmt.txt", (Object)strPort));
                bValidated = false;
                return bValidated;
            }
        }
        return bValidated;
    }

    private boolean validateMetaServerParms(Properties properties) {
        String strReposID;
        boolean bValidated = true;
        String strPort = properties.getProperty("port");
        if (strPort != null) {
            try {
                Integer portObj = Integer.valueOf(strPort);
                if (portObj == null || portObj < 0 || portObj >= 65536) {
                    ServerUtil.printLog(bundle.getString("ValidateServer.WrongPortRange.txt"));
                    bValidated = false;
                    return bValidated;
                }
            }
            catch (NumberFormatException exc) {
                ServerUtil.printLog(bundle.formatString("ValidateServer.WrongPortFormat.fmt.txt", (Object)strPort));
                bValidated = false;
                return bValidated;
            }
        }
        if ((strReposID = properties.getProperty("reposid")) != null && (strReposID.length() != 17 || strReposID.indexOf(".") != 8)) {
            ServerUtil.printLog(bundle.getString("ValidateServer.WrongReposID.txt"));
            bValidated = false;
            return bValidated;
        }
        String strWorkspaceFile = properties.getProperty("metadataprofile");
        if (strWorkspaceFile != null && !strWorkspaceFile.endsWith(".swa")) {
            ServerUtil.printLog(bundle.getString("ValidateServer.WrongWorkspaceFile.txt"));
            bValidated = false;
            return bValidated;
        }
        return bValidated;
    }

    private boolean setArgs(Properties argProperties, Properties serverProperties, Properties metaserverProperties, Properties credentialProperties) {
        boolean bPropertiesSet = true;
        if (argProperties.isEmpty() && serverProperties.isEmpty() && metaserverProperties.isEmpty() && credentialProperties.isEmpty() || argProperties.containsKey("help") || argProperties.containsKey("?")) {
            this.printHelpInfo();
            bPropertiesSet = false;
            return bPropertiesSet;
        }
        this.m_strServerName = argProperties.getProperty("servername");
        if (this.m_strServerName == null) {
            this.m_strServerName = argProperties.getProperty("sn");
        }
        if (this.m_strServerName != null) {
            serverProperties.put("servername", this.m_strServerName);
        }
        this.m_strServerID = argProperties.getProperty("serverid");
        if (this.m_strServerID == null) {
            this.m_strServerID = argProperties.getProperty("sid");
        }
        if (this.m_strServerID != null) {
            serverProperties.put("serverid", this.m_strServerID);
        }
        return bPropertiesSet;
    }

    private void printHelpInfo() {
        ServerUtil.printLog("ValidateServer validates a specified server type with given server attributes.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("Usage:", false);
        ServerUtil.printLog("      java -classpath sas.servermgr.jar com.sas.management.servers.validator.commands.ValidateServer <options>", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("Where <options> are:", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-metaserverparms \"<parms>\" (or -msp \"<parms>\")", false);
        ServerUtil.printLog("      Consists of name/value pairs of methods to connect to a metadata server i.e. metadata connection attributes or metadata profile", false);
        ServerUtil.printLog("      Valid values are:", false);
        ServerUtil.printLog("          <parms>: \"host=XXX port=XXX domain=XXX userid=XXX password=XXX reposid=XXX | reposname=XXX\"", false);
        ServerUtil.printLog("          \tRequired parms: host, port, domain, userid, password, reposid or reposname", false);
        ServerUtil.printLog("          \tEither reposid or reposname is acceptable. reposid is the metadata repository ID", false);
        ServerUtil.printLog("          <parms>: \"metadataprofile=XXX.swa\"", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-servername Name (or -sn Name)", false);
        ServerUtil.printLog("      This is the name of the server metadata definition of the server to be validated.", false);
        ServerUtil.printLog("      Use either this option or -serverid (-sid)", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-serverid ID (or -sid ID)", false);
        ServerUtil.printLog("      This is the ID of the server metadata definition of the server to be validated.", false);
        ServerUtil.printLog("      Use either this option or -servername (-sn)", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-serverparms \"<parms>\" (or -sp \"<parms>\")", false);
        ServerUtil.printLog("      Consists of name/value pairs of server/connection attributes for the server to be validated.", false);
        ServerUtil.printLog("      e.g. <parms>: \"contentlocation=XXX\"", false);
        ServerUtil.printLog("      \tFor workspace, pooled workspace, stored process and ABM servers, hostid= is required, since multiple hosts can be defined for each server", false);
        ServerUtil.printLog("      \tThis is the metadata object ID of the defined host/machine for the server", false);
        ServerUtil.printLog("      \ti.e. <parms>: \"hostid=XXX\"", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-credentials \"<parms>\" (or -cred \"<parms>\")", false);
        ServerUtil.printLog("      Consists of a domain, userid and password for the server to be validated.", false);
        ServerUtil.printLog("      Valid values are:", false);
        ServerUtil.printLog("          <parms>: \"domain=XXX userid=XXX password=XXX\"", false);
        ServerUtil.printLog("          \tRequired parms: domain, userid, password", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-log \"<logFile>\"", false);
        ServerUtil.printLog("      Writes out logging information out to a specified file.", false);
        ServerUtil.printLog("      If <logFile> is not specified, logging information is written out to the file <user profile directory>\\ValidateServerErrorLog.log", false);
        ServerUtil.printLog("      If -log is not specified, logging information is written out to the file \"ValidateServerErrorLog.log\" in <user profile directory>\\AppData\\Roaming\\SAS\\LOGS on Windows and <user profile directory>/.SASAppData/Logs on all other operating systems.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-help (or -?)", false);
        ServerUtil.printLog("      Prints this help information", false);
        ServerUtil.printLog("", false);
    }

    private MetaServerConnection newMetaConnection(Properties properties) {
        String strHost = properties.getProperty("host");
        String strPort = properties.getProperty("port");
        String strUserID = properties.getProperty("userid");
        String strReposID = properties.getProperty("reposid");
        String strReposName = properties.getProperty("reposname");
        String strWorkspaceFile = properties.getProperty("metadataprofile");
        if (strWorkspaceFile != null) {
            WorkspaceFile workspaceFile = new WorkspaceFile(strWorkspaceFile);
            this.m_metaConnection = new MetaServerConnection(this.m_objectFactory, workspaceFile);
        } else {
            this.m_metaConnection = new MetaServerConnection(this.m_objectFactory, strHost, strPort, strUserID, properties.getProperty("password"), strReposName);
            if (strReposID != null) {
                this.m_metaConnection.setReposId(strReposID);
            }
        }
        return this.m_metaConnection;
    }

    private ServerValidatorInterface newServer(Properties serverProperties, Properties credentialProperties) throws MdException, RemoteException {
        String strUserID = credentialProperties.getProperty("userid");
        PasswordAuthentication credentials = null;
        if (strUserID != null && credentialProperties.getProperty("password") == null) {
            credentials = ServerUtil.getCredentials(strUserID, "");
        }
        if (credentials == null && strUserID != null && credentialProperties.getProperty("password") != null) {
            credentials = ServerUtil.getCredentials(strUserID, credentialProperties.getProperty("password"));
        }
        ServerValidatorInterface server = null;
        if (this.m_metaConnection != null) {
            server = this.newServer(serverProperties);
        }
        if (server == null) {
            if (this.m_strServerType != null) {
                serverProperties.setProperty("classidentifier", this.m_strServerType);
                ServerInterface svr = ServerFactory.newServer(this.m_metaConnection, null, this.m_strServerType, serverProperties, m_userContext);
                server = ServerFactory.newServerValidator(svr);
            } else {
                ServerUtil.printLog(bundle.getString("ValidateServer.WrongServerType.txt"));
            }
        }
        return server;
    }

    private ServerValidatorInterface newServer(Properties serverProperties) throws MdException, RemoteException {
        ServerValidatorInterface server = null;
        if (this.m_strServerType != null) {
            serverProperties.setProperty("classidentifier", this.m_strServerType);
        }
        if (this.m_strServerID == null && this.m_strServerName != null) {
            this.m_strServerID = this.getServerID(this.m_metaConnection, this.m_strServerName);
            if (this.m_strServerID != null) {
                serverProperties.setProperty("serverid", this.m_strServerID);
            }
        }
        if (this.isLogicalServer(this.m_metaConnection, serverProperties)) {
            LogicalServerInterface ls = ServerFactory.newLogicalServer(this.m_metaConnection, this.m_strServerID, this.m_strServerType, serverProperties, m_userContext);
            server = ServerFactory.newLogicalServerValidator(ls);
        } else {
            String strHostID = serverProperties.getProperty("hostid");
            ServerInterface svr = ServerFactory.newServer(this.m_metaConnection, this.m_strServerID, strHostID, this.m_strServerType, serverProperties, m_userContext);
            server = (ServerValidatorInterface)((Object)svr);
        }
        return server;
    }

    private boolean isLogicalServer(MetaServerConnection metaConn, Properties properties) throws MdException, RemoteException {
        boolean bLogicalServer = false;
        MdObjectStore store = this.m_objectFactory.createObjectStore();
        String strName = properties.getProperty("servername");
        String strID = properties.getProperty("serverid");
        String strReposID = metaConn.getReposId();
        if (strID != null) {
            strReposID = ServerUtil.getReposID(strID);
        }
        if (strReposID == null) {
            return bLogicalServer;
        }
        String strType = "ServerComponent";
        int flags = 408;
        String strXMLSelect = "";
        if (strName != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + strName + "']\" />";
        }
        if (strID != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Id='" + strID + "']\" />";
        }
        String strOptions = strXMLSelect;
        List serversList = this.m_objectFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        for (int serverIndex = 0; serverIndex < serversList.size(); ++serverIndex) {
            ServerComponent serverComponent = (ServerComponent)serversList.get(serverIndex);
            this.m_strServerType = serverComponent.getClassIdentifier();
            if (!(serverComponent instanceof LogicalServer)) continue;
            bLogicalServer = true;
            break;
        }
        store.dispose();
        return bLogicalServer;
    }

    private String getServerID(MetaServerConnection metaConn, String name) throws MdException, RemoteException {
        String strXMLSelect;
        String strServerID = null;
        MdObjectStore store = this.m_objectFactory.createObjectStore();
        String strReposID = metaConn.getReposId();
        if (strReposID == null) {
            return strServerID;
        }
        String strType = "ServerComponent";
        int flags = 408;
        String strOptions = strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + name + "']\" />";
        int serverIndex = 0;
        List serversList = this.m_objectFactory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        if (serverIndex < serversList.size()) {
            ServerComponent serverComponent = (ServerComponent)serversList.get(serverIndex);
            strServerID = serverComponent.getFQID();
        }
        store.dispose();
        return strServerID;
    }

    private Handler getHandler() {
        return this.m_handler;
    }

    private void setHandler(Handler handler) {
        this.m_handler = handler;
    }

    private void setupEnvironment(Properties metaproperties, Properties credentialProperties, MetadataSourceInterface[] localServiceDeployment, UserServiceInterface userService, DiscoveryServiceInterface discoveryService) {
        AppConfigurationEntry credAppConfigurationEntry;
        AppConfigurationEntry metaAppConfigurationEntry;
        String strHost = metaproperties.getProperty("host");
        String strPort = metaproperties.getProperty("port");
        String strDomain = metaproperties.getProperty("domain");
        String strWorkspaceFile = metaproperties.getProperty("metadataprofile");
        if (strWorkspaceFile != null) {
            WorkspaceFile workspaceFile = new WorkspaceFile(strWorkspaceFile);
            strHost = workspaceFile.getPropertyString("host");
            strPort = workspaceFile.getPropertyString("port");
            strDomain = workspaceFile.getPropertyString("authenticationdomain");
        }
        AppConfigurationEntry[] entries = new AppConfigurationEntry[2];
        HashMap<String, String> metaOptionsMap = new HashMap<String, String>(4);
        metaOptionsMap.put("host", strHost);
        metaOptionsMap.put("port", strPort);
        metaOptionsMap.put("domain", strDomain);
        metaOptionsMap.put("debug", "false");
        entries[0] = metaAppConfigurationEntry = new AppConfigurationEntry(OMILoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, metaOptionsMap);
        HashMap<String, String> credOptionsMap = new HashMap<String, String>(4);
        credOptionsMap.put("host", strHost);
        credOptionsMap.put("port", strPort);
        credOptionsMap.put("domain", credentialProperties.getProperty("domain"));
        credOptionsMap.put("debug", "false");
        entries[1] = credAppConfigurationEntry = new AppConfigurationEntry(OMILoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, credOptionsMap);
        try {
            Environment environment = userService.getServiceConfiguration().getEnvironment();
            environment.setAppConfigurationEntry(entries);
            ServiceLoader.deployServices((MetadataSourceInterface)localServiceDeployment[0], (Environment)environment, (DiscoveryServiceInterface)discoveryService);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    private String getApplicationNameForLogging() {
        String utilityName = "ValidateServer";
        String version = ValidateServer.class.getPackage().getSpecificationVersion();
        if (version == null) {
            version = IOMI.class.getPackage().getSpecificationVersion();
        }
        if (version == null) {
            return "ValidateServer (unknown)";
        }
        return "ValidateServer " + version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argsArray) {
        boolean bPropertiesSet;
        ValidateServer vs = new ValidateServer();
        Properties argProperties = (Properties)com.sas.management.util.Util.tokenize((String[])argsArray);
        vs.setLogging(argProperties);
        Properties serverProperties = null;
        Properties metaserverProperties = null;
        Properties credentialProperties = null;
        try {
            serverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"serverparms", (Properties)argProperties);
            if (serverProperties.isEmpty()) {
                serverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"sp", (Properties)argProperties);
            }
            if ((metaserverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"metaserverparms", (Properties)argProperties)).isEmpty()) {
                metaserverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"msp", (Properties)argProperties);
            }
            if ((credentialProperties = (Properties)com.sas.management.util.Util.tokenize((String)"credentials", (Properties)argProperties)).isEmpty()) {
                credentialProperties = (Properties)com.sas.management.util.Util.tokenize((String)"cred", (Properties)argProperties);
            }
        }
        catch (IOException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        boolean bPropertiesValidated = vs.validateArgs(argProperties, serverProperties, metaserverProperties);
        if (!bPropertiesValidated) {
            vs.setReturnCode(1);
            System.exit(vs.getReturnCode());
        }
        if (!(bPropertiesSet = vs.setArgs(argProperties, serverProperties, metaserverProperties, credentialProperties))) {
            vs.setReturnCode(0);
            System.exit(vs.getReturnCode());
        }
        MetaServerConnection metaConn = null;
        if (!metaserverProperties.isEmpty()) {
            metaConn = vs.newMetaConnection(metaserverProperties);
        }
        ServerValidatorInterface server = null;
        try {
            URL serviceDeploymentURL = ValidateServer.class.getResource("foundation_services.xml");
            MetadataSourceInterface[] localServiceDeployment = new MetadataSourceInterface[]{new URLMetadataSource(serviceDeploymentURL)};
            PlatformServicesConfiguration servicesConfiguration = new PlatformServicesConfiguration(localServiceDeployment, null);
            PlatformServices.setServicesConfiguration((PlatformServicesConfiguration)servicesConfiguration);
            CorePlatformServices.startServices();
            UserServiceInterface userService = CorePlatformServices.getUserService();
            userService.setGroupLoginEnabled(true);
            DiscoveryServiceInterface discoveryService = CorePlatformServices.getDiscoveryService();
            vs.setupEnvironment(metaserverProperties, credentialProperties, localServiceDeployment, userService, discoveryService);
            String strUserID = credentialProperties.getProperty("userid");
            String strDomain = credentialProperties.getProperty("domain");
            try {
                m_userContext = userService.newUser(strUserID, credentialProperties.getProperty("password"), strDomain, null, vs.getApplicationNameForLogging());
            }
            catch (UserInitializationException exc) {
                m_userContext = exc.getUser();
            }
            if (metaConn != null) {
                metaConn.connect();
            }
            if ((server = vs.newServer(serverProperties, credentialProperties)) != null) {
                ServerLogUtil.addHandler(((MetadataInterface)((Object)server)).getLogger(), vs.getHandler());
                server.validate();
            } else {
                vs.setReturnCode(1);
            }
        }
        catch (ValidatorException exc) {
            if (!ServerUtil.isCallbackCancelledException((ChainedExceptionInterface)exc) && exc instanceof ServerValidatorException) {
                ServerValidatorException svExc = (ServerValidatorException)exc;
                vs.setReturnCode(svExc.getReturnLevel());
            }
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (ServerException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (ServiceException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (Exception exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        finally {
            if (server != null) {
                ((MetadataInterface)((Object)server)).getLogger().removeHandler(vs.getHandler());
            }
            if (metaConn != null) {
                metaConn.disconnect();
                metaConn.dispose();
            }
        }
        ServerFactory.dispose();
        try {
            if (vs.m_store != null) {
                vs.m_store.dispose();
                vs.m_store = null;
            }
            if (vs.m_objectFactory != null) {
                vs.m_objectFactory.dispose();
                vs.m_objectFactory = null;
            }
        }
        catch (RemoteException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        try {
            CorePlatformServices.terminateServices();
        }
        catch (ServiceException exc) {
            exc.printStackTrace();
        }
        ServerUtil.printLog(new String(), false);
        ServerUtil.printLog(bundle.formatString("ValidateServer.ReturnCode.fmt.txt", (Object)String.valueOf(vs.getReturnCode())));
        System.exit(vs.getReturnCode());
    }

    static {
        bundle = new WAdminResource(ValidateServer.class);
    }
}

