/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.validator;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASMDX.IMDXServer;
import com.sas.iom.SASMDX.IMDXServerHelper;
import com.sas.iom.SASStoredProcess.IStoredProcessContext2;
import com.sas.iom.SASStoredProcess.IStoredProcessServerPackage.BadSessionID;
import com.sas.iom.SASStoredProcess.IStoredProcessServer_1_1;
import com.sas.iom.SASStoredProcess.IStoredProcessServer_1_1Helper;
import com.sas.management.MetadataFactory;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.meta.SASOMI.IOMI;
import com.sas.meta.SASOMI.IOMIHelper;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.SchemaInterface;
import com.sas.storage.olap.sasmdx.Metadata;
import com.sas.util.ChainedExceptionInterface;
import com.sas.workspace.WAdminResource;
import java.io.IOException;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerValidatorUtil {
    protected static WAdminResource bundle = new WAdminResource(ServerValidatorUtil.class);

    public static void validateServerPing(String strServerType, Logger logger, String host, int port, int validationLevel) throws ServerValidatorException {
        String strLevel = String.valueOf(validationLevel);
        String strValidationMethod = bundle.getString("ServerValidatorUtil.Ping.notrans");
        logger.info(bundle.formatString("ServerValidatorUtil.StartSimpleValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
        try {
            ServerValidatorUtil.ping(host, port);
            logger.info(bundle.getString("ServerValidatorUtil.PingSuccess.txt"));
        }
        catch (UnknownHostException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Simple", validationLevel, logger);
        }
        catch (IOException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Simple", validationLevel, logger);
        }
    }

    public static ConnectionInterface validateIOMServerMakeConnection(ConnectionFactoryConfiguration cxfConfig, String strServerType, UserContextInterface user, Logger logger, int validationLevel) throws ServerValidatorException {
        if (user == null) {
            throw ServerValidatorUtil.logServerValidatorException(bundle.getString("ServerValidatorUtil.NoCredentials.txt"), "Extended", validationLevel, logger);
        }
        String strLevel = String.valueOf(validationLevel);
        String strValidationMethod = bundle.getString("ServerValidatorUtil.MakingConnection.txt");
        logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
        ConnectionInterface cx = null;
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            cx = cxf.getConnection(user);
            logger.info(bundle.getString("ServerValidatorUtil.ConnectionSuccess.txt"));
        }
        catch (ConnectionFactoryException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (SystemException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        return cx;
    }

    public static ConnectionInterface validateABMServerMakeConnection(ConnectionFactoryConfiguration cxfConfig, String strServerType, String domain, UserContextInterface user, Logger logger, int validationLevel) throws ServerValidatorException {
        if (user == null) {
            throw ServerValidatorUtil.logServerValidatorException(bundle.getString("ServerValidatorUtil.NoCredentials.txt"), "Extended", validationLevel, logger);
        }
        String strLevel = String.valueOf(validationLevel);
        String strValidationMethod = bundle.getString("ServerValidatorUtil.MakingConnection.txt");
        logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
        ConnectionInterface cx = null;
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            UserIdentityInterface userIdentity = user.getAuthServer().generatePassword(null);
            if (userIdentity == null) {
                throw ServerValidatorUtil.logServerValidatorException(bundle.getString("ServerValidatorUtil.NoCredentials.txt"), "Extended", validationLevel, logger);
            }
            String strUser = (String)userIdentity.getPrincipal();
            cx = cxf.getConnection(strUser, (String)userIdentity.getCredential(), domain);
            logger.info(bundle.getString("ServerValidatorUtil.ConnectionSuccess.txt"));
        }
        catch (ConnectionFactoryException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (ServiceException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (RemoteException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (SystemException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        return cx;
    }

    public static void validateMetadataServerGetRepositories(ConnectionInterface cx, Logger logger, int validationLevel) throws ServerValidatorException {
        try {
            String strServerType = "Metadata";
            String strLevel = String.valueOf(validationLevel);
            String strValidationMethod = bundle.getString("ServerValidatorUtil.Metadata.GettingRepositories.txt");
            logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
            Object obj = cx.getObject();
            IOMI iOMI = IOMIHelper.narrow((Object)obj);
            StringHolder outXML = new StringHolder();
            iOMI.GetRepositories(outXML, 1, "");
            String strXML = outXML.value;
            Document doc = MetadataFactory.getMdFactory().getOMIUtil().parseXML(strXML);
            ArrayList<String> lstRepositories = new ArrayList<String>();
            ServerValidatorUtil.getRepositories(doc, lstRepositories);
            String[] aryRepositories = lstRepositories.toArray(new String[0]);
            String strReposNames = "";
            for (int reposIndex = 0; reposIndex < aryRepositories.length; ++reposIndex) {
                strReposNames = strReposNames + aryRepositories[reposIndex];
                if (reposIndex >= aryRepositories.length - 1) continue;
                strReposNames = strReposNames + ", ";
            }
            logger.info(bundle.getString("ServerValidatorUtil.Metadata.GettingRepositoriesSuccess.txt"));
            logger.fine(bundle.formatString("ServerValidatorUtil.Metadata.RepositoryNames.fmt.txt", (java.lang.Object)strReposNames));
        }
        catch (GenericError err) {
            throw ServerValidatorUtil.logServerValidatorException(err, "Extended", validationLevel, logger);
        }
        catch (MdException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (RemoteException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
    }

    public static void validateWorkspaceServerCodeSubmit(ConnectionInterface cx, String serverType, String code, Logger logger, int validationLevel) throws ServerValidatorException {
        try {
            String strLevel = String.valueOf(validationLevel);
            String strValidationMethod = bundle.getString("ServerValidatorUtil.SubmittingCode.txt");
            logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)serverType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
            Object obj = cx.getObject();
            IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)obj);
            logger.fine(bundle.formatString("ServerValidatorUtil.CodeToSubmit.fmt.txt", (java.lang.Object)code));
            ILanguageService sasLanguage = iWorkspace.LanguageService();
            sasLanguage.Submit(code);
            logger.info(bundle.getString("ServerValidatorUtil.SubmittingCodeSuccess.txt"));
            CarriageControlSeqHolder logCarriageControlHldr = new CarriageControlSeqHolder();
            LineTypeSeqHolder logLineTypeHldr = new LineTypeSeqHolder();
            StringSeqHolder logHldr = new StringSeqHolder();
            sasLanguage.FlushLogLines(Integer.MAX_VALUE, logCarriageControlHldr, logLineTypeHldr, logHldr);
            String[] logLines = logHldr.value;
            String strLog = "";
            for (int lineIndex = 0; lineIndex < logLines.length; ++lineIndex) {
                strLog = strLog + logLines[lineIndex];
                if (lineIndex >= logLines.length - 1) continue;
                strLog = strLog + "\n";
            }
            logger.finer(bundle.formatString("ServerValidatorUtil.CodeLog.fmt.txt", (java.lang.Object)strLog));
            CarriageControlSeqHolder listCarriageControlHldr = new CarriageControlSeqHolder();
            LineTypeSeqHolder listLineTypeHldr = new LineTypeSeqHolder();
            StringSeqHolder listHldr = new StringSeqHolder();
            sasLanguage.FlushListLines(Integer.MAX_VALUE, listCarriageControlHldr, listLineTypeHldr, listHldr);
            String[] listLines = listHldr.value;
            String strLine = "";
            for (int lineIndex = 0; lineIndex < listLines.length; ++lineIndex) {
                strLine = strLine + listLines[lineIndex];
                if (lineIndex >= listLines.length - 1) continue;
                strLine = strLine + "\n";
            }
            logger.finest(bundle.formatString("ServerValidatorUtil.CodeLog.fmt.txt", (java.lang.Object)strLine));
        }
        catch (GenericError err) {
            throw ServerValidatorUtil.logServerValidatorException(err, "Extended", validationLevel, logger);
        }
        catch (SystemException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
    }

    public static void validateStoredProcessServerCodeSubmit(ConnectionInterface cx, String code, Logger logger, int validationLevel) throws ServerValidatorException {
        IStoredProcessContext2 iSTPContext = null;
        try {
            String strServerType = "Stored Process";
            String strLevel = String.valueOf(validationLevel);
            String strValidationMethod = bundle.getString("ServerValidatorUtil.SubmittingCode.txt");
            logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
            Object obj = cx.getObject();
            IStoredProcessServer_1_1 iStoredProcess = IStoredProcessServer_1_1Helper.narrow((Object)obj);
            iSTPContext = iStoredProcess.CreateSTPContextFromWorkspace("");
            Object wsObj = iSTPContext.Workspace();
            IWorkspace iWorkspace = IWorkspaceHelper.narrow((Object)wsObj);
            logger.fine(bundle.formatString("ServerValidatorUtil.CodeToSubmit.fmt.txt", (java.lang.Object)code));
            ILanguageService sasLanguage = iWorkspace.LanguageService();
            sasLanguage.Submit(code);
            logger.info(bundle.getString("ServerValidatorUtil.SubmittingCodeSuccess.txt"));
            CarriageControlSeqHolder logCarriageControlHldr = new CarriageControlSeqHolder();
            LineTypeSeqHolder logLineTypeHldr = new LineTypeSeqHolder();
            StringSeqHolder logHldr = new StringSeqHolder();
            sasLanguage.FlushLogLines(Integer.MAX_VALUE, logCarriageControlHldr, logLineTypeHldr, logHldr);
            String[] logLines = logHldr.value;
            String strLog = "";
            for (int lineIndex = 0; lineIndex < logLines.length; ++lineIndex) {
                strLog = strLog + logLines[lineIndex];
                if (lineIndex >= logLines.length - 1) continue;
                strLog = strLog + "\n";
            }
            logger.finer(bundle.formatString("ServerValidatorUtil.CodeLog.fmt.txt", (java.lang.Object)strLog));
            CarriageControlSeqHolder listCarriageControlHldr = new CarriageControlSeqHolder();
            LineTypeSeqHolder listLineTypeHldr = new LineTypeSeqHolder();
            StringSeqHolder listHldr = new StringSeqHolder();
            sasLanguage.FlushListLines(Integer.MAX_VALUE, listCarriageControlHldr, listLineTypeHldr, listHldr);
            String[] listLines = listHldr.value;
            String strLine = "";
            for (int lineIndex = 0; lineIndex < listLines.length; ++lineIndex) {
                strLine = strLine + listLines[lineIndex];
                if (lineIndex >= listLines.length - 1) continue;
                strLine = strLine + "\n";
            }
            logger.finest(bundle.formatString("ServerValidatorUtil.CodeLog.fmt.txt", (java.lang.Object)strLine));
        }
        catch (BadSessionID exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (GenericError err) {
            throw ServerValidatorUtil.logServerValidatorException(err, "Extended", validationLevel, logger);
        }
        catch (SystemException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        finally {
            if (iSTPContext != null) {
                try {
                    iSTPContext.Close();
                }
                catch (GenericError err) {
                    throw ServerValidatorUtil.logServerValidatorException(err, "Extended", validationLevel, logger);
                }
                catch (SystemException exc) {
                    throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
                }
            }
        }
    }

    public static void validateOLAPServerGetSchemas(ConnectionInterface cx, Logger logger, int validationLevel) throws ServerValidatorException {
        try {
            String strServerType = "OLAP";
            String strLevel = String.valueOf(validationLevel);
            String strValidationMethod = bundle.getString("ServerValidatorUtil.OLAP.GettingSchemas.txt");
            logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
            Object obj = cx.getObject();
            IMDXServer iMDX = IMDXServerHelper.narrow((Object)obj);
            Metadata iOLAPMetadata = new Metadata(iMDX);
            SchemaInterface[] schemaArray = iOLAPMetadata.getSchemas();
            String strSchemaNames = "";
            for (int schemaIndex = 0; schemaIndex < schemaArray.length; ++schemaIndex) {
                SchemaInterface schema = schemaArray[schemaIndex];
                strSchemaNames = strSchemaNames + schema.getName();
                if (schemaIndex >= schemaArray.length - 1) continue;
                strSchemaNames = strSchemaNames + ", ";
            }
            logger.info(bundle.getString("ServerValidatorUtil.OLAP.GettingSchemasSuccess.txt"));
            logger.fine(bundle.formatString("ServerValidatorUtil.OLAP.SchemaNames.fmt.txt", (java.lang.Object)strSchemaNames));
        }
        catch (OLAPException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (SystemException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
    }

    public static void validateTableServerAccessSampleDB(UserContextInterface user, String machineName, int port, Logger logger, int validationLevel) throws ServerValidatorException {
        String strUserName = "";
        PasswordAuthentication pwAuth = null;
        String queryString = "select * from data_services where data_service_name='BASE'";
        String nextException = "";
        try {
            String strServerType = "Federation";
            String strLevel = String.valueOf(validationLevel);
            String strValidationMethod = bundle.getString("ServerValidatorUtil.Table.AccessingDB.txt");
            logger.info(bundle.formatString("ServerValidatorUtil.StartExtendedValidation.fmt.txt", (java.lang.Object)strServerType, (java.lang.Object)strLevel, (java.lang.Object)strValidationMethod));
            UserIdentityInterface ui = user.getAuthServer().generatePassword(null);
            strUserName = (String)ui.getPrincipal();
            pwAuth = new PasswordAuthentication(strUserName, ((String)ui.getCredential()).toCharArray());
        }
        catch (RemoteException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", validationLevel, logger);
        }
        catch (ServiceException e) {
            throw ServerValidatorUtil.logServerValidatorException(e, "Extended", validationLevel, logger);
        }
        try {
            Class.forName("com.sas.tkts.TKTSDriver");
            Properties properties = new Properties();
            properties.put("userName", strUserName);
            properties.put("password", pwAuth != null ? String.valueOf(pwAuth.getPassword()) : "");
            properties.put("constring", "(driver=SYSCAT)");
            Connection conn = DriverManager.getConnection("jdbc:sastkts://" + machineName + ":" + port, properties);
            Statement statement = conn.createStatement();
            ResultSet result = statement.executeQuery(queryString);
            if (!result.next()) {
                throw ServerValidatorUtil.logServerValidatorException(bundle.getString("ServerValidatorUtil.Table.DataError.txt"), "Extended", validationLevel, logger);
            }
            logger.info(bundle.getString("ServerValidatorUtil.Table.AccessingDBSuccess.txt"));
            statement.close();
            conn.close();
        }
        catch (ClassNotFoundException e) {
            throw ServerValidatorUtil.logServerValidatorException(e, "Extended", validationLevel, logger);
        }
        catch (SQLException sqle) {
            nextException = sqle.getNextException().getMessage();
            if (nextException != null) {
                logger.info(nextException);
            }
            throw ServerValidatorUtil.logServerValidatorException(sqle, "Extended", validationLevel, logger);
        }
        finally {
            pwAuth = null;
        }
    }

    private static void getRepositories(Node node, List<String> list) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerValidatorUtil.getRepositories(children.item(childIndex), list);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Repository")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String strId = childNodeMap.getNamedItem("Id").getNodeValue();
                    if (strId.equalsIgnoreCase("A0000001.A0000001")) break;
                    String strName = childNodeMap.getNamedItem("Name").getNodeValue();
                    list.add(strName);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    ServerValidatorUtil.getRepositories(children.item(childIndex), list);
                }
                break;
            }
        }
    }

    private static void ping(String host, int port) throws UnknownHostException, IOException {
        String proxyList = System.getenv("SAS_IOM_PROXYLIST");
        if (proxyList != null) {
            return;
        }
        InetAddress address = InetAddress.getByName(host);
        try {
            Socket socket = new Socket(address, port);
            if (socket.isConnected()) {
                socket.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static ServerValidatorException logServerValidatorException(String message, String validationType, int validationLevel, Logger logger) {
        ServerValidatorException svExc = new ServerValidatorException(message, validationType, validationLevel);
        ServerUtil.logChainedExceptionMessages((ChainedExceptionInterface)svExc, logger);
        return svExc;
    }

    public static ServerValidatorException logServerValidatorException(Throwable throwable, String validationType, int validationLevel, Logger logger) {
        ServerValidatorException svExc = new ServerValidatorException(throwable, validationType, validationLevel);
        ServerUtil.logChainedExceptionMessages((ChainedExceptionInterface)svExc, logger);
        return svExc;
    }
}

