/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.sessions.impl;

import com.sas.iom.SASIOMCommon.IServerSessions;
import com.sas.iom.SASIOMCommon.IServerSessionsHelper;
import com.sas.iom.SASIOMCommon.ISessionAdministration;
import com.sas.iom.SASIOMCommon.ISessionAdministrationHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.sessions.impl.ServerSessionImpl;
import com.sas.services.connection.ConnectionInterface;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class IOMServerSessionImpl
extends ServerSessionImpl {
    public IOMServerSessionImpl(ServerMonitorInterface server, String sessionID, String owner) {
        super(server, sessionID, owner);
    }

    @Override
    public void end() throws ServerException {
        ServerInterface server = (ServerInterface)((java.lang.Object)this.getServer());
        if (server.getServerConnection() == null) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        ConnectionInterface cx = (ConnectionInterface)server.getServerConnection();
        Object obj = cx.getObject();
        try {
            IServerSessions session = IServerSessionsHelper.narrow((Object)obj);
            Object ssnObj = session.UseSession(ServerUtil.convertStringToUUID(this.getID()));
            ISessionAdministration admin = ISessionAdministrationHelper.narrow((Object)ssnObj);
            admin.EndSession();
        }
        catch (GenericError error) {
            throw ServerUtil.logServerException(error, server.getLogger());
        }
        catch (SystemException exc) {
            throw ServerUtil.logServerException(exc, server.getLogger());
        }
    }
}

