/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.options.impl;

import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.options.IOMServerOptionInterface;
import com.sas.management.servers.options.ServerOptionEvent;
import com.sas.management.servers.options.ServerOptionModelInterface;
import com.sas.management.servers.options.impl.ServerOptionImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ObjectImpl;

public class IOMServerOptionImpl
extends ServerOptionImpl
implements IOMServerOptionInterface {
    private String m_strCategory = null;
    private IServerInformation m_info = null;

    public IOMServerOptionImpl(ServerMonitorInterface server, String name, int type, String value) {
        super(server, name, type, value);
    }

    @Override
    public void update() throws ServerException {
        ServerInterface server = (ServerInterface)((Object)this.getServer());
        if (server.getServerConnection() == null) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            if (this.getCategory() == null) {
                throw new ServerException("Option '" + this.getName() + "' does not exist!");
            }
            IFilteredList list = this.getInfo().UseCategory(this.getCategory(), this.getName());
            ORB orb = ((ObjectImpl)this.getInfo())._orb();
            Object obj = this.getValue();
            if (this.getType() == 16) {
                obj = Boolean.valueOf(this.getValue());
            }
            if (this.getType() == 4) {
                obj = Integer.valueOf(this.getValue());
            }
            Any any = ServerUtil.convertObjectToAny(obj, orb);
            list.SetValue(this.getName(), any);
            ServerOptionEvent event = new ServerOptionEvent(this, this.getName(), this.getType(), this.getValue());
            ServerOptionModelInterface model = ServerFactory.getServerOptionModel(this.getServer());
            model.fireServerOptionEvent(event);
        }
        catch (GenericError error) {
            throw ServerUtil.logServerException(error, server.getLogger());
        }
        catch (SystemException exc) {
            throw ServerUtil.logServerException(exc, server.getLogger());
        }
    }

    @Override
    public String getCategory() {
        return this.m_strCategory;
    }

    @Override
    public void setCategory(String category) {
        this.m_strCategory = category;
    }

    public IServerInformation getInfo() {
        return this.m_info;
    }

    public void setInfo(IServerInformation info) {
        this.m_info = info;
    }
}

