/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.monitor;

import com.sas.iom.ConnectSpawner.IConnectSpawnerAdministration;
import com.sas.iom.ConnectSpawner.IConnectSpawnerAdministrationHelper;
import com.sas.iom.ConnectSpawnerEvents.IConnectSpawnerEventsHelper;
import com.sas.iom.ConnectSpawnerEvents._IConnectSpawnerEventsImplBase;
import com.sas.iom.ObjectSpawner.ISpawnedServer;
import com.sas.iom.ObjectSpawner.ISpawnerAdministration;
import com.sas.iom.ObjectSpawner.ISpawnerAdministrationHelper;
import com.sas.iom.ObjectSpawner.ISpawnerInformation;
import com.sas.iom.ObjectSpawner.ISpawnerInformationHelper;
import com.sas.iom.ObjectSpawnerEvents.ISpawnerEventsHelper;
import com.sas.iom.ObjectSpawnerEvents._ISpawnerEventsImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.management.impl.ModelImpl;
import com.sas.management.servers.ServerConnectionEvent;
import com.sas.management.servers.ServerConnectionListener;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.monitor.SpawnerEvent;
import com.sas.management.servers.monitor.SpawnerListener;
import com.sas.management.servers.monitor.SpawnerModelInterface;
import com.sas.management.servers.monitor.SpawnerMonitorInterface;
import com.sas.services.connection.ConnectionInterface;
import java.util.Vector;
import java.util.logging.Handler;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class SpawnerModel
extends ModelImpl
implements SpawnerModelInterface,
ServerConnectionListener {
    protected SpawnerMonitorInterface m_spawner = null;
    private ServerConnectionModelInterface m_mdlConnState = null;
    protected Handler m_handler = null;
    ConnectionInterface m_cx = null;
    private ConnectionPoint m_connectionPoint = null;
    private int m_spawnerEventsHandle = -1;
    private boolean m_bListenerInitialized = false;

    public SpawnerModel(SpawnerMonitorInterface spawner) {
        this.m_spawner = spawner;
        this.m_mdlConnState = ServerFactory.getServerConnectionModel((ServerInterface)((java.lang.Object)spawner));
        this.m_mdlConnState.addServerConnectionListener(this);
        if (((ServerInterface)((java.lang.Object)spawner)).getObjectState() == 1) {
            this.initializeSpawnerEventsListener();
        }
    }

    @Override
    public synchronized void addSpawnerListener(SpawnerListener listener) {
        this.getListenerList().add(listener);
    }

    @Override
    public synchronized void removeSpawnerListener(SpawnerListener listener) {
        this.getListenerList().remove(listener);
    }

    @Override
    public synchronized void fireSpawnerEvent(SpawnerEvent event) {
        Vector listenerList = new Vector();
        listenerList.addAll(this.getListenerList());
        block5: for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            SpawnerListener listener = (SpawnerListener)listenerList.get(listenerIndex);
            switch (event.getType()) {
                case 0: {
                    listener.serverStarted(event);
                    continue block5;
                }
                case 1: {
                    listener.serverEnded(event);
                    continue block5;
                }
                case 2: {
                    listener.serverFailed(event);
                    continue block5;
                }
                default: {
                    continue block5;
                }
            }
        }
    }

    @Override
    public void stateChanged(ServerConnectionEvent event) {
        if (event.getState() == 1) {
            this.initializeSpawnerEventsListener();
        }
        if (event.getState() == 0) {
            this.disposeSpawnerEventsListener();
        }
    }

    private synchronized void initializeSpawnerEventsListener() {
        if (this.m_bListenerInitialized) {
            return;
        }
        if (((ServerInterface)((java.lang.Object)this.m_spawner)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isConnectSpawner((ServerInterface)((java.lang.Object)this.m_spawner))) {
            if (((ServerInterface)((java.lang.Object)this.m_spawner)).getServerConnection() == null) {
                return;
            }
            this.m_cx = (ConnectionInterface)((ServerInterface)((java.lang.Object)this.m_spawner)).getServerConnection();
            Object obj = this.m_cx.getObject();
            ConnectSpawnerEventsListener cnspawnerEventsListener = new ConnectSpawnerEventsListener();
            try {
                IConnectSpawnerAdministration cnspawner_admin = IConnectSpawnerAdministrationHelper.narrow((Object)obj);
                String cpidString = IConnectSpawnerEventsHelper.id();
                CP_ID cpid = this.getCPID(cpidString);
                ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)cnspawner_admin);
                ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                cpContainer.FindConnectionPoint(cpid, cpHolder);
                this.m_connectionPoint = cpHolder.value;
                IntHolder handleHolder = new IntHolder();
                this.m_connectionPoint.Advise((Object)cnspawnerEventsListener, handleHolder);
                this.m_spawnerEventsHandle = handleHolder.value;
            }
            catch (SystemException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        } else if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_spawner))) {
            this.m_cx = (ConnectionInterface)((ServerInterface)((java.lang.Object)this.m_spawner)).getServerConnection();
            Object obj = this.m_cx.getObject();
            try {
                ISpawnerAdministration admin = ISpawnerAdministrationHelper.narrow((Object)obj);
                SpawnerEventsListener spawnerEventsListener = new SpawnerEventsListener();
                String cpidString = ISpawnerEventsHelper.id();
                CP_ID cpid = this.getCPID(cpidString);
                ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)admin);
                ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                cpContainer.FindConnectionPoint(cpid, cpHolder);
                this.m_connectionPoint = cpHolder.value;
                IntHolder handleHolder = new IntHolder();
                this.m_connectionPoint.Advise((Object)spawnerEventsListener, handleHolder);
                this.m_spawnerEventsHandle = handleHolder.value;
            }
            catch (SystemException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        }
        this.m_bListenerInitialized = true;
    }

    protected CP_ID getCPID(String cpidString) {
        int i;
        CP_ID cpid = null;
        int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
        short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
        short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
        byte[] d4 = new byte[8];
        for (i = 0; i < 2; ++i) {
            d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
        }
        for (i = 0; i < 6; ++i) {
            d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
        }
        cpid = new CP_ID(d1, d2, d3, d4);
        return cpid;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeSpawnerEventsListener();
        if (this.m_mdlConnState != null) {
            this.m_mdlConnState.removeServerConnectionListener(this);
            this.m_mdlConnState = null;
        }
    }

    private synchronized void disposeSpawnerEventsListener() {
        this.m_bListenerInitialized = false;
        if (((ServerInterface)((java.lang.Object)this.m_spawner)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_spawner)) && this.m_connectionPoint != null) {
            this.m_connectionPoint.Unadvise(this.m_spawnerEventsHandle);
        }
    }

    class ConnectSpawnerEventsListener
    extends _IConnectSpawnerEventsImplBase {
        ConnectSpawnerEventsListener() {
        }

        public void ServerStart(UUID serverID) {
            SpawnerModel.this.m_spawner.incrementServerCount();
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 0, ServerUtil.convertUUIDToString(serverID), this.getServerName(serverID));
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        public void ServerEnd(UUID serverID) {
            SpawnerModel.this.m_spawner.decrementServerCount();
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 1, ServerUtil.convertUUIDToString(serverID), this.getServerName(serverID));
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        public void ServerFailed(String logicalServer, String serverComponent) {
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 2, null, serverComponent);
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        private String getServerName(UUID serverID) {
            return null;
        }

        public void ServerFailed(String serverComponent) {
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 2, null, serverComponent);
            SpawnerModel.this.fireSpawnerEvent(event);
        }
    }

    class SpawnerEventsListener
    extends _ISpawnerEventsImplBase {
        SpawnerEventsListener() {
        }

        public void ServerStart(UUID serverID) {
            SpawnerModel.this.m_spawner.incrementServerCount();
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 0, ServerUtil.convertUUIDToString(serverID), this.getServerName(serverID));
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        public void ServerEnd(UUID serverID) {
            SpawnerModel.this.m_spawner.decrementServerCount();
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 1, ServerUtil.convertUUIDToString(serverID), this.getServerName(serverID));
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        public void ServerFailed(String logicalServer, String serverComponent) {
            SpawnerEvent event = new SpawnerEvent((java.lang.Object)this, 2, null, serverComponent);
            SpawnerModel.this.fireSpawnerEvent(event);
        }

        private String getServerName(UUID serverID) {
            String strServerName = null;
            if (SpawnerModel.this.m_cx != null) {
                Object obj = SpawnerModel.this.m_cx.getObject();
                try {
                    ISpawnerInformation info = ISpawnerInformationHelper.narrow((Object)obj);
                    ISpawnedServer spawnedServer = info.GetSpawnedServer(serverID);
                    strServerName = spawnedServer.ServerComponentName();
                }
                catch (GenericError error) {
                    SpawnerModel.this.getLogger().severe(error.getLocalizedMessage());
                }
                catch (SystemException exc) {
                    SpawnerModel.this.getLogger().severe(exc.getLocalizedMessage());
                }
            }
            return strServerName;
        }
    }
}

