/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.log;

import com.sas.iom.SASIOMCommon.IIOMServerAppenderView;
import com.sas.iom.SASIOMCommon.IIOMServerAppenderViewPackage.MapEOF;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.DateTimeSeqHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.log.ServerLogFilter;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.options.IOMServerOptionInterface;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.net.util.DateConverter;
import com.sas.workspace.WAdminResource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class ServerLogUtil {
    private static final String SINGLE_SPACE = " ";
    private static Logger m_logger = Logger.getLogger("com.sas.management.servers.log.ServerLogUtil");
    protected static WAdminResource m_bundle = new WAdminResource(ServerLogUtil.class);

    public static ServerLogInterface getServerLog(ServerMonitorInterface server, ServerLogFilter filter, IServerLog serverLog, String hostID, Logger logger) throws ServerException {
        AnySeqHolder entries;
        ServerLogUtil.setLogger(logger);
        ServerLogInterface log = ServerFactory.getServerLog().get(ServerUtil.getServerMapKey(((ServerInterface)((Object)server)).getID(), hostID));
        if (log == null) {
            log = ServerFactory.newServerLog(server);
        }
        ServerLogInterface retServerLog = log;
        StringBuffer sbfLog = new StringBuffer(0);
        int numToRead = 1000;
        Vector<AnySeqHolder> lstEntries = new Vector<AnySeqHolder>();
        try {
            IIOMServerAppenderView logView = serverLog.GetIOMServerAppenderView(ServerLogUtil.getIOMLogFilterString(filter));
            try {
                IntHolder numRead;
                do {
                    entries = new AnySeqHolder();
                    numRead = new IntHolder();
                    logView.ReadEntries(numToRead, entries, numRead);
                    if (numRead.value == 0) continue;
                    lstEntries.add(entries);
                } while (numRead.value >= numToRead);
            }
            catch (MapEOF exception) {}
        }
        catch (GenericError error) {
            throw ServerLogUtil.logServerLogException(error);
        }
        catch (SystemException exc) {
            throw ServerLogUtil.logServerLogException(exc);
        }
        for (int entryIndex = 0; entryIndex < lstEntries.size(); ++entryIndex) {
            entries = (AnySeqHolder)lstEntries.get(entryIndex);
            Any[] entriesArray = entries.value;
            Object[] entryLists = new Object[4];
            if (entriesArray == null) continue;
            try {
                for (int i = 0; i < entriesArray.length; ++i) {
                    Any anyValue = entriesArray[i];
                    TypeCode typecode = anyValue.type();
                    TCKind kind = typecode.kind();
                    int kindType = kind.value();
                    if (kindType != 21) continue;
                    if (typecode.name().equals(StringSeqHelper.type().name())) {
                        entryLists[i] = StringSeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (!typecode.name().equals(DateTimeSeqHelper.type().name())) continue;
                    entryLists[i] = DateTimeSeqHelper.extract((Any)anyValue);
                }
                String[] messageArray = (String[])entryLists[2];
                long[] datetimeArray = (long[])entryLists[3];
                for (int index = 0; index < messageArray.length; ++index) {
                    String strMessage = messageArray[index];
                    long datetime = datetimeArray[index];
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    DateConverter.corbaToJava((long)datetime, (Calendar)calendar);
                    sbfLog.append(strMessage + System.getProperty("line.separator"));
                }
                continue;
            }
            catch (BadKind error) {
                throw ServerLogUtil.logServerLogException(error);
            }
        }
        retServerLog.setLog(sbfLog);
        return retServerLog;
    }

    public static String getLoggerLevel(IOMServerOptionInterface option) throws IllegalArgumentException, ServerException {
        IOMServerOptionInterface optParent;
        if (!option.getCategory().equals("Loggers")) {
            throw new IllegalArgumentException("Argument 'option' is not a logger option");
        }
        String strLevel = option.getValue();
        if (strLevel.equals("NULL") && (optParent = ServerLogUtil.getParentLoggerOption(option.getServer(), option.getName())) != null) {
            return ServerLogUtil.getLoggerLevel(optParent);
        }
        return strLevel;
    }

    public static IOMServerOptionInterface getParentLoggerOption(ServerMonitorInterface server, String optionName) throws ServerException {
        IOMServerOptionInterface optParent = null;
        String strName = optionName;
        String strParentName = "";
        if (strName.indexOf(46) != -1) {
            strParentName = strName.substring(0, strName.lastIndexOf(46));
        }
        if (strParentName.equals(strName)) {
            return null;
        }
        ServerOptionInterface[] aryOptions = server.getServerOptions();
        for (int optionIndex = 0; optionIndex < aryOptions.length; ++optionIndex) {
            ServerOptionInterface optServer = aryOptions[optionIndex];
            if (!(optServer instanceof IOMServerOptionInterface) || !((IOMServerOptionInterface)optServer).getCategory().equals("Loggers") || !strParentName.equals(optServer.getName().trim())) continue;
            optParent = (IOMServerOptionInterface)optServer;
            break;
        }
        if (optParent == null && strParentName != "") {
            return ServerLogUtil.getParentLoggerOption(server, strParentName);
        }
        return optParent;
    }

    public static boolean isRootLoggerOption(IOMServerOptionInterface option) throws ServerException {
        return ServerLogUtil.getParentLoggerOption(option.getServer(), option.getName()) == null;
    }

    private static ServerException logServerLogException(Throwable throwable) {
        return ServerUtil.logServerException(throwable, ServerLogUtil.getLogger());
    }

    public static String getDisplayLogLevelValue(int level) {
        String strLevel = "";
        switch (level) {
            case 0x7FFFFFFF: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelOff.Name.txt");
                break;
            }
            case 1000: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelError.Name.txt");
                break;
            }
            case 900: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelWarning.Name.txt");
                break;
            }
            case 800: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelInformation.Name.txt");
                break;
            }
            case 700: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelDebug.Name.txt");
                break;
            }
            case 300: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelTrace.Name.txt");
                break;
            }
            case -2147483648: {
                strLevel = m_bundle.getString("ServerLogUtil.LevelAll.Name.txt");
                break;
            }
        }
        return strLevel;
    }

    public static String getIOMLogLevelValue(int intLevel) {
        String strLevel = null;
        switch (intLevel) {
            case -2147483648: {
                break;
            }
            case 300: {
                strLevel = "TRACE";
                break;
            }
            case 700: {
                strLevel = "DEBUG";
                break;
            }
            case 800: {
                strLevel = "INFO";
                break;
            }
            case 900: {
                strLevel = "WARN";
                break;
            }
            case 1000: {
                strLevel = "ERROR";
                break;
            }
            case 0x7FFFFFFF: {
                strLevel = "FATAL";
                break;
            }
        }
        return strLevel;
    }

    public static int getLogLevel(int level) {
        int intLogLevel = Integer.MIN_VALUE;
        if (level > ServerLogFilter.ERROR_LEVEL && level <= Integer.MAX_VALUE) {
            intLogLevel = Integer.MAX_VALUE;
        }
        if (level > ServerLogFilter.WARN_LEVEL && level <= ServerLogFilter.ERROR_LEVEL) {
            intLogLevel = ServerLogFilter.ERROR_LEVEL;
        }
        if (level > ServerLogFilter.INFO_LEVEL && level <= ServerLogFilter.WARN_LEVEL) {
            intLogLevel = ServerLogFilter.WARN_LEVEL;
        }
        if (level > ServerLogFilter.DEBUG_LEVEL && level <= ServerLogFilter.INFO_LEVEL) {
            intLogLevel = ServerLogFilter.INFO_LEVEL;
        }
        if (level > ServerLogFilter.TRACE_LEVEL && level <= ServerLogFilter.DEBUG_LEVEL) {
            intLogLevel = ServerLogFilter.DEBUG_LEVEL;
        }
        if (level > Integer.MIN_VALUE && level <= ServerLogFilter.TRACE_LEVEL) {
            intLogLevel = ServerLogFilter.TRACE_LEVEL;
        }
        return intLogLevel;
    }

    public static String getIOMLogFilterString(ServerLogFilter filter) {
        String strFilter = "";
        if (filter.getThresholdLevel() != Integer.MIN_VALUE) {
            strFilter = "threshold=" + ServerLogUtil.getIOMLogLevelValue(filter.getThresholdLevel()) + SINGLE_SPACE;
        }
        if (filter.getLevel() != Integer.MAX_VALUE) {
            strFilter = strFilter + "level=" + ServerLogUtil.getIOMLogLevelValue(filter.getLevel()) + SINGLE_SPACE;
        }
        if (filter.getStartTime() != null) {
            strFilter = strFilter + "start=" + ServerLogUtil.formatIOMLogTime(filter.getStartTime()) + SINGLE_SPACE;
        }
        if (filter.getEndTime() != null) {
            strFilter = strFilter + "end=" + ServerLogUtil.formatIOMLogTime(filter.getEndTime()) + SINGLE_SPACE;
        }
        return strFilter.trim();
    }

    private static String formatIOMLogTime(Calendar time) {
        String strIOMLogTimeFormat = "ddMMMyyyy:HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(strIOMLogTimeFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(time.getTime());
    }

    public static void addHandler(Logger logger, Handler handler) {
        boolean bContainsHandler = false;
        Handler[] aryHandler = logger.getHandlers();
        for (int index = 0; index < aryHandler.length; ++index) {
            Handler h = aryHandler[index];
            if (h != handler) continue;
            bContainsHandler = true;
            break;
        }
        if (!bContainsHandler) {
            logger.addHandler(handler);
        }
    }

    public static void removeHandlers(Logger logger) {
        Handler[] aryHandler = logger.getHandlers();
        for (int index = 0; index < aryHandler.length; ++index) {
            Handler handler = aryHandler[index];
            logger.removeHandler(handler);
        }
    }

    private static Logger getLogger() {
        return m_logger;
    }

    private static void setLogger(Logger logger) {
        m_logger = logger;
    }
}

