/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.log;

import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMCommon.IServerLogHelper;
import com.sas.iom.SASIOMCommonEvents.ILogEventsHelper;
import com.sas.iom.SASIOMCommonEvents._ILogEventsImplBase;
import com.sas.iom.SASIOMDefs.CP_ID;
import com.sas.iom.SASIOMDefs.ConnectionPoint;
import com.sas.iom.SASIOMDefs.ConnectionPointContainer;
import com.sas.iom.SASIOMDefs.ConnectionPointContainerHelper;
import com.sas.iom.SASIOMDefs.ConnectionPointHolder;
import com.sas.management.impl.ModelImpl;
import com.sas.management.servers.ServerConnectionEvent;
import com.sas.management.servers.ServerConnectionListener;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.log.ServerLogEvent;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.log.ServerLogListener;
import com.sas.management.servers.log.ServerLogModelInterface;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.services.connection.ConnectionInterface;
import java.util.Calendar;
import java.util.Vector;
import java.util.logging.Handler;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ServerLogModel
extends ModelImpl
implements ServerLogModelInterface,
ServerConnectionListener {
    protected ServerMonitorInterface m_server = null;
    private ServerConnectionModelInterface m_mdlConnState = null;
    protected Handler m_handler = null;
    private ConnectionInterface m_cx = null;
    private ConnectionPoint m_connectionPoint = null;
    private int m_logEventsHandle = -1;
    private boolean m_bListenerInitialized = false;

    public ServerLogModel(ServerMonitorInterface server) {
        this.m_server = server;
        this.m_mdlConnState = ServerFactory.getServerConnectionModel((ServerInterface)((java.lang.Object)server));
        this.m_mdlConnState.addServerConnectionListener(this);
        if (((ServerInterface)((java.lang.Object)server)).getObjectState() == 1) {
            this.initializeLogEventsListener();
        }
    }

    @Override
    public synchronized void addServerLogListener(ServerLogListener listener) {
        this.getListenerList().add(listener);
    }

    @Override
    public synchronized void removeServerLogListener(ServerLogListener listener) {
        this.getListenerList().remove(listener);
    }

    @Override
    public synchronized void fireServerLogEvent(ServerLogEvent event) {
        Vector listenerList = new Vector();
        listenerList.addAll(this.getListenerList());
        for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerLogListener listener = (ServerLogListener)listenerList.get(listenerIndex);
            listener.entryLogged(event);
        }
    }

    @Override
    public void stateChanged(ServerConnectionEvent event) {
        if (event.getState() == 1) {
            this.initializeLogEventsListener();
        }
        if (event.getState() == 0) {
            this.disposeLogEventsListener();
        }
    }

    private synchronized void initializeLogEventsListener() {
        if (this.m_bListenerInitialized) {
            return;
        }
        if (((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_server))) {
            this.m_cx = (ConnectionInterface)((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection();
            Object obj = this.m_cx.getObject();
            try {
                int i;
                IServerLog log = IServerLogHelper.narrow((Object)obj);
                if (log == null) {
                    return;
                }
                LogEventsListener logEventsListener = new LogEventsListener();
                String cpidString = ILogEventsHelper.id();
                int d1 = (int)Long.parseLong(cpidString.substring(4, 12), 16);
                short d2 = (short)Integer.parseInt(cpidString.substring(13, 17), 16);
                short d3 = (short)Integer.parseInt(cpidString.substring(18, 22), 16);
                byte[] d4 = new byte[8];
                for (i = 0; i < 2; ++i) {
                    d4[i] = (byte)Short.parseShort(cpidString.substring(23 + i * 2, 25 + i * 2), 16);
                }
                for (i = 0; i < 6; ++i) {
                    d4[i + 2] = (byte)Short.parseShort(cpidString.substring(28 + i * 2, 30 + i * 2), 16);
                }
                CP_ID cpid = new CP_ID(d1, d2, d3, d4);
                ConnectionPointContainer cpContainer = ConnectionPointContainerHelper.narrow((Object)log);
                ConnectionPointHolder cpHolder = new ConnectionPointHolder();
                cpContainer.FindConnectionPoint(cpid, cpHolder);
                this.m_connectionPoint = cpHolder.value;
                IntHolder handleHolder = new IntHolder();
                this.m_connectionPoint.Advise((Object)logEventsListener, handleHolder);
                this.m_logEventsHandle = handleHolder.value;
            }
            catch (SystemException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        }
        this.m_bListenerInitialized = true;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.disposeLogEventsListener();
        if (this.m_mdlConnState != null) {
            this.m_mdlConnState.removeServerConnectionListener(this);
            this.m_mdlConnState = null;
        }
    }

    private synchronized void disposeLogEventsListener() {
        this.m_bListenerInitialized = false;
        if (((ServerInterface)((java.lang.Object)this.m_server)).getServerConnection() == null) {
            return;
        }
        if (ServerUtil.isIOMServer((ServerInterface)((java.lang.Object)this.m_server)) && this.m_connectionPoint != null) {
            this.m_connectionPoint.Unadvise(this.m_logEventsHandle);
        }
    }

    class LogEventsListener
    extends _ILogEventsImplBase {
        LogEventsListener() {
        }

        public void EventLogged(String name, String level, String[] message) {
            Calendar cdrTime = Calendar.getInstance();
            String strMessage = "";
            for (int messageIndex = 0; messageIndex < message.length; ++messageIndex) {
                strMessage = strMessage + message[messageIndex];
            }
            String strLogEntry = strMessage + System.getProperty("line.separator");
            ServerLogInterface log = ServerFactory.getServerLog().get(((ServerInterface)((java.lang.Object)ServerLogModel.this.m_server)).getID());
            if (log == null) {
                log = ServerFactory.newServerLog(ServerLogModel.this.m_server);
            }
            log.appendLog(strLogEntry);
            ServerLogEvent event = new ServerLogEvent((java.lang.Object)this, name, level, strMessage, cdrTime);
            ServerLogModel.this.fireServerLogEvent(event);
        }
    }
}

