/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.PathInterface;
import com.sas.management.ValidatorException;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.ContentServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.services.webdav.DAVException;
import com.sas.services.webdav.DAVResource;
import com.sas.services.webdav.WebDAVStatus;
import com.sas.workspace.WAdminResource;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.Properties;

public class WebDAVServerImpl
extends ContentServerImpl {
    private String m_strProtocol = "http";
    private String m_strAuthType = "user/password";
    private String m_strAuthDomain = "DefaultAuth";
    private String m_strHost = "localhost";
    private int m_port = 80;
    private String m_strContentLocation = "/dav/sas";
    private SpawnerInterface m_spawner = null;
    private Object m_objConn = null;
    protected static WAdminResource bundle = new WAdminResource(WebDAVServerImpl.class);

    public WebDAVServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        ConnectionInterface[] connectionArray = this.getConnections();
        for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            ConnectionInterface conn = connectionArray[connIndex];
            this.m_strProtocol = conn.getApplicationProtocol();
            this.m_strAuthType = conn.getAuthenticationType();
            this.m_strAuthDomain = conn.getAuthenticationDomain();
            this.m_port = conn.getPort();
        }
        this.m_strHost = this.getHost();
        PathInterface[] pathArray = this.getPaths();
        for (int pathIndex = 0; pathIndex < pathArray.length; ++pathIndex) {
            PathInterface path = pathArray[pathIndex];
            if (path.supportsDAV()) continue;
            this.removePath(path);
        }
        if (pathArray.length > 0) {
            this.m_strContentLocation = pathArray[0].getPath();
        }
    }

    @Override
    public Object getServerConnection() {
        return this.m_objConn;
    }

    @Override
    public void setServerConnection(Object connection) {
        this.m_objConn = connection;
    }

    @Override
    public void validate() throws ValidatorException {
        if (this.getConnections().length == 0) {
            throw this.logServerValidatorException(bundle.getString("WebDAVServerImpl.NoConnection.txt"), "Simple", 1);
        }
        super.validate();
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing("WebDAV", this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
        this.initialize();
        String strServerType = "WebDAV";
        String strLevel = String.valueOf(1);
        String strValidationMethod = bundle.getString("ServerImpl.MakingConnection.txt");
        this.getLogger().info(bundle.formatString("ServerImpl.StartExtendedValidation.fmt.txt", (Object)strServerType, (Object)strLevel, (Object)strValidationMethod));
        if (this.getUserContext() == null) {
            throw this.logServerValidatorException(bundle.getString("ServerImpl.NoCredentials.txt"), "Extended", 1);
        }
        DAVResource resource = null;
        UserContextInterface user = this.getUserContext();
        UserIdentityInterface userIdentity = null;
        String strUserID = null;
        PasswordAuthentication pwAuth = null;
        String strURL = null;
        try {
            if (this.getServerParms() == null) {
                this.setServerParms(new Properties());
            }
            String strKey = "contentlocation";
            if (!this.getServerParms().containsKey(strKey)) {
                this.getServerParms().setProperty(strKey, this.m_strContentLocation);
            }
            int index = 1;
            while (this.getServerParms().containsKey(strKey)) {
                boolean bIsWebDAVEnabled;
                int statusCode;
                boolean bSuccess;
                String strContentLocation = (String)this.getServerParms().get(strKey);
                strKey = "contentlocation" + String.valueOf(++index);
                strURL = this.m_strProtocol + "://" + this.m_strHost + ":" + String.valueOf(this.m_port) + strContentLocation + "/";
                this.getLogger().info(bundle.formatString("WebDAVServerImpl.Path.fmt.txt", (Object)strURL));
                if (this.m_strAuthType.equalsIgnoreCase("user/password")) {
                    userIdentity = user.getIdentityByDomain(this.m_strAuthDomain, true);
                } else if (this.m_strAuthType.equalsIgnoreCase("metadata")) {
                    userIdentity = user.getAuthServer().generatePassword(null);
                }
                if (userIdentity != null) {
                    strUserID = (String)userIdentity.getPrincipal();
                    pwAuth = new PasswordAuthentication(strUserID, ((String)userIdentity.getCredential()).toCharArray());
                }
                boolean bl = bSuccess = (statusCode = (resource = new DAVResource(strURL, strUserID, String.valueOf(pwAuth.getPassword()))).getStatusCode()) == 200;
                if (!bSuccess) {
                    if (statusCode == 401) {
                        user.removeIdentity(userIdentity);
                    } else if (statusCode == 404) {
                        throw this.logServerValidatorException(bundle.formatString("WebDAVServerImpl.Http404StatusCodeText.fmt.txt", (Object)String.valueOf(statusCode), (Object)WebDAVStatus.getStatusText((int)statusCode), (Object)strURL, (Object)strUserID), "Extended", 2);
                    }
                    throw this.logServerValidatorException(bundle.formatString("WebDAVServerImpl.HttpStatusCodeText.fmt.txt", (Object)String.valueOf(statusCode), (Object)WebDAVStatus.getStatusText((int)statusCode)), "Extended", 2);
                }
                this.getLogger().info(bundle.getString("ServerImpl.ConnectionSuccess.txt"));
                strLevel = String.valueOf(2);
                strValidationMethod = bundle.getString("WebDAVServerImpl.WebDAVEnabled.txt");
                this.getLogger().info(bundle.formatString("ServerImpl.StartExtendedValidation.fmt.txt", (Object)strServerType, (Object)strLevel, (Object)strValidationMethod));
                resource.doOptions();
                String[] capArray = resource.getDavCapabilities();
                boolean bl2 = bIsWebDAVEnabled = capArray != null && capArray.length > 0;
                if (!bIsWebDAVEnabled) {
                    throw this.logServerValidatorException(bundle.getString("WebDAVServerImpl.NotWebDAVEnabled.txt"), "Extended", 2);
                }
                this.getLogger().info(bundle.getString("WebDAVServerImpl.IsWebDAVEnabled.txt"));
                strLevel = String.valueOf(3);
                strValidationMethod = bundle.getString("WebDAVServerImpl.PathExistence.txt");
                this.getLogger().info(bundle.formatString("ServerImpl.StartExtendedValidation.fmt.txt", (Object)strServerType, (Object)strLevel, (Object)strValidationMethod));
                resource.setPath(resource.getPath());
                boolean bPathExists = resource.exists();
                if (bPathExists) {
                    this.getLogger().info(bundle.getString("WebDAVServerImpl.PathExists.txt"));
                    continue;
                }
                throw this.logServerValidatorException(bundle.getString("WebDAVServerImpl.PathDoesNotExist.txt"), "Extended", 3);
            }
        }
        catch (DAVException exc) {
            if (exc.getStatusCode() == 401) {
                try {
                    user.removeIdentity(userIdentity);
                }
                catch (RemoteException remoteException) {}
            } else if (exc.getStatusCode() == 404) {
                throw this.logServerValidatorException(bundle.formatString("WebDAVServerImpl.Http404StatusCodeText.fmt.txt", (Object)String.valueOf(exc.getStatusCode()), (Object)WebDAVStatus.getStatusText((int)exc.getStatusCode()), strURL, strUserID), "Extended", 2);
            }
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 2, this.getLogger());
        }
        catch (ServiceException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 2, this.getLogger());
        }
        catch (RemoteException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 2, this.getLogger());
        }
        finally {
            pwAuth = null;
            try {
                if (resource != null) {
                    resource.close();
                }
            }
            catch (RemoteException exc) {
                throw this.logServerValidatorException(exc, "Extended", 2);
            }
        }
    }

    @Override
    public SpawnerInterface getSpawner() {
        return this.m_spawner;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
        this.m_spawner = spawner;
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strContentLocation;
            String strPort;
            String strHost;
            String strAuthDomain;
            String strAuthType;
            String strProtocol = (String)this.getServerParms().get("protocol");
            if (strProtocol != null) {
                this.m_strProtocol = strProtocol;
            }
            if ((strAuthType = (String)this.getServerParms().get("authtype")) != null) {
                this.m_strAuthType = strAuthType;
            }
            if ((strAuthDomain = (String)this.getServerParms().get("authdomain")) != null) {
                this.m_strAuthDomain = strAuthDomain;
            }
            if ((strHost = (String)this.getServerParms().get("host")) != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
            if ((strContentLocation = (String)this.getServerParms().get("contentlocation")) != null) {
                this.m_strContentLocation = strContentLocation;
            }
        }
    }
}

