/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.IOMServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.Properties;

public class TableServerImpl
extends IOMServerImpl {
    private String m_strHost = "localhost";
    private int m_port = 21032;

    public TableServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        this.initialize();
        this.setServerParms(serverParms);
    }

    private void initialize() {
        this.m_strHost = this.getHost();
        ConnectionInterface[] connectionArray = this.getConnections();
        for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            ConnectionInterface conn = connectionArray[connIndex];
            if (!conn.getApplicationProtocol().equalsIgnoreCase("Bridge")) continue;
            this.m_port = conn.getPort();
            break;
        }
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing("Federation", this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ConnectionFactoryAdminInterface admin;
        this.initialize();
        PlatformConnectionFactoryConfiguration cxfConfig = null;
        com.sas.services.connection.ConnectionInterface cx = null;
        try {
            LogicalServerInterface logicalServer = this.getInfoLogicalServer();
            cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer, ServerUtil.getServerURI(this), this.m_strHost, this.m_port, false);
            cx = ServerValidatorUtil.validateIOMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, "Federation", this.getUserContext(), this.getLogger(), 1);
            admin = null;
        }
        catch (ServiceException exc) {
            try {
                throw this.logServerValidatorException(exc, "Extended", 1);
                catch (RemoteException exc2) {
                    throw this.logServerValidatorException(exc2, "Extended", 1);
                }
            }
            catch (Throwable throwable) {
                ConnectionFactoryAdminInterface admin2 = null;
                try {
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(cxfConfig);
                    admin2 = cxf.getAdminInterface();
                    throw throwable;
                }
                catch (ConnectionFactoryException exc3) {
                    throw this.logServerValidatorException(exc3, "Extended", 1);
                }
                finally {
                    if (cx != null) {
                        cx.close();
                    }
                    if (admin2 != null) {
                        admin2.shutdown();
                    }
                }
            }
        }
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            admin = cxf.getAdminInterface();
            return;
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (cx != null) {
                cx.close();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strPort;
            String strHost = (String)this.getServerParms().get("host");
            if (strHost != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
        }
    }
}

