/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.ObjectSpawner.ISpawnedServer;
import com.sas.iom.ObjectSpawner.ISpawnerInformation;
import com.sas.iom.ObjectSpawner.ISpawnerInformationHelper;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.BooleanSeqHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.management.servers.InstanceServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnedServerInterface;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.WorkspaceServerInterface;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.administrator.ServerStateEvent;
import com.sas.management.servers.administrator.ServerStateModelInterface;
import com.sas.management.servers.impl.IOMServerImpl;
import com.sas.management.servers.impl.InstanceServerImpl;
import com.sas.management.servers.impl.ObjectSpawnerImpl;
import com.sas.management.servers.monitor.SpawnerEvent;
import com.sas.management.servers.monitor.SpawnerListener;
import com.sas.management.servers.monitor.SpawnerModelInterface;
import com.sas.management.servers.monitor.SpawnerMonitorInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public abstract class SpawnedServerImpl
extends IOMServerImpl
implements SpawnedServerInterface,
SpawnerListener {
    private ConnectionInterface m_cx = null;
    private SpawnerInterface m_spawner = null;
    private SpawnerInterface m_origSpawner = null;
    private ISpawnedServer m_spawnedServer = null;
    private SpawnerModelInterface m_mdlSpawner = null;
    private InstanceServerInterface[] m_instanceServerArray = new InstanceServerInterface[0];
    private static WAdminResource bundle = new WAdminResource(SpawnedServerImpl.class);

    public SpawnedServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
    }

    public SpawnedServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, hostID, serverParms, user);
    }

    @Override
    public void connect() throws ServerException {
        this.m_origSpawner = this.getSpawner();
        if (this.m_origSpawner == null) {
            throw this.logServerException(bundle.getString("SpawnedServerImpl.ServerNotAssociatedToSpawner.txt"));
        }
        this.m_spawner = this.copySpawner(this.m_origSpawner);
        if (this.m_mdlSpawner == null) {
            this.m_mdlSpawner = ServerFactory.getSpawnerModel((SpawnerMonitorInterface)((java.lang.Object)this.m_spawner));
            this.m_mdlSpawner.addSpawnerListener(this);
        }
        this.setSpawner(this.m_spawner);
        PrivilegedAction<java.lang.Object> action = new PrivilegedAction<java.lang.Object>(){

            @Override
            public java.lang.Object run() {
                SpawnedServerImpl.this.getSpawner().getLogger().setParent(SpawnedServerImpl.this.getLogger());
                SpawnedServerImpl.this.getSpawner().getLogger().setUseParentHandlers(true);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (SecurityException exc) {
            this.logServerException(exc);
        }
        this.m_spawner.connect();
        if (!((ServerAdministratorInterface)((java.lang.Object)this.m_spawner)).isAdministrator()) {
            this.disconnect();
            throw this.logServerException(bundle.getString("SpawnedServerImpl.NoAdminPrivileges.txt"));
        }
        ConnectionInterface spCx = (ConnectionInterface)this.m_spawner.getServerConnection();
        this.setSpawnerConnection(spCx);
        this.setServerConnection(spCx);
        Object obj = spCx.getObject();
        try {
            ISpawnerInformation spawnerInfo = ISpawnerInformationHelper.narrow((Object)obj);
            String strServerFilter = new String();
            StringSeqHolder strSHLogicalServers = new StringSeqHolder();
            StringSeqHolder strSHServerComponents = new StringSeqHolder();
            UUIDSeqHolder uuidSHServerClasses = new UUIDSeqHolder();
            StringSeqHolder strSHProcessOwners = new StringSeqHolder();
            UUIDSeqHolder uuidSHServerIDs = new UUIDSeqHolder();
            try {
                spawnerInfo.ListLaunchedServers(strServerFilter, strSHLogicalServers, strSHServerComponents, uuidSHServerClasses, strSHProcessOwners, uuidSHServerIDs);
            }
            catch (GenericError error) {
                throw this.logServerException(error);
            }
            String[] scArray = strSHServerComponents.value;
            int scIndex = 0;
            this.m_instanceServerArray = new InstanceServerInterface[0];
            for (scIndex = 0; scIndex < scArray.length; ++scIndex) {
                String strSC = scArray[scIndex];
                UUID scUUID = uuidSHServerIDs.value[scIndex];
                if (!strSC.equalsIgnoreCase(this.getName())) continue;
                this.addInstanceServer(scUUID, spawnerInfo);
            }
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    @Override
    public void disconnect() throws ServerException {
        if (this.m_spawner != null) {
            this.m_spawner.disconnect();
            this.setServerConnection(this.m_spawner.getServerConnection());
            this.m_spawner.dispose();
        }
        InstanceServerInterface[] instServerArray = this.getInstanceServers();
        for (int serverIndex = 0; serverIndex < instServerArray.length; ++serverIndex) {
            InstanceServerInterface server = instServerArray[serverIndex];
            ((InstanceServerImpl)server).disconnect();
        }
        this.cleanupUponLostConnection();
        if (this.m_origSpawner != null && !this.m_origSpawner.isDisposed()) {
            this.setSpawner(this.m_origSpawner);
        }
    }

    @Override
    protected void cleanupUponLostConnection() {
        this.removeSpawnerListener();
        super.cleanupUponLostConnection();
    }

    @Override
    public boolean isConnected() {
        if (this.m_spawner != null) {
            return ((ObjectSpawnerImpl)this.m_spawner).isConnected();
        }
        return super.isConnected();
    }

    @Override
    public void setServerConnection(java.lang.Object connection) {
        if (this.m_spawner != null) {
            ((ObjectSpawnerImpl)this.m_spawner).setServerConnection(connection);
        }
        super.setServerConnection(connection);
    }

    @Override
    public String getState() throws ServerException {
        if (this.getSpawner() != null) {
            return ((ObjectSpawnerImpl)this.getSpawner()).getState();
        }
        return super.getState();
    }

    @Override
    public void serverStarted(SpawnerEvent event) {
        String strName = event.getName();
        String strID = event.getID();
        UUID uuid = ServerUtil.convertStringToUUID(strID);
        ISpawnerInformation spawnerInfo = ISpawnerInformationHelper.narrow((Object)this.getSpawnerConnection().getObject());
        try {
            if (this.getName().equalsIgnoreCase(strName)) {
                this.addInstanceServer(uuid, spawnerInfo);
            }
        }
        catch (ServerException exc) {
            this.logServerException((Throwable)((java.lang.Object)exc));
        }
    }

    @Override
    public void serverEnded(SpawnerEvent event) {
        String strID = event.getID();
        InstanceServerInterface[] instServerArray = this.getInstanceServers();
        for (int serverIndex = 0; serverIndex < instServerArray.length; ++serverIndex) {
            InstanceServerInterface server = instServerArray[serverIndex];
            if (!ServerUtil.convertUUIDToString(server.getUUID()).equalsIgnoreCase(strID)) continue;
            try {
                ((InstanceServerImpl)server).disconnect();
            }
            catch (ServerException exc) {
                this.logServerException((Throwable)((java.lang.Object)exc));
            }
            break;
        }
    }

    @Override
    public void serverFailed(SpawnerEvent event) {
        this.getLogger().warning("Server " + event.getName() + " failed to start!");
    }

    protected ConnectionInterface getSpawnerConnection() {
        return this.m_cx;
    }

    protected void setSpawnerConnection(ConnectionInterface connection) {
        this.m_cx = connection;
    }

    protected ISpawnedServer getSpawnedServer() {
        return this.m_spawnedServer;
    }

    protected void setSpawnedServer(ISpawnedServer server) {
        this.m_spawnedServer = server;
    }

    @Override
    public InstanceServerInterface[] getInstanceServers() {
        return this.m_instanceServerArray;
    }

    @Override
    public synchronized void addInstanceServer(InstanceServerInterface server) {
        InstanceServerInterface[] serverArray = new InstanceServerInterface[this.m_instanceServerArray.length + 1];
        for (int serverIndex = 0; serverIndex < this.m_instanceServerArray.length; ++serverIndex) {
            InstanceServerInterface s;
            serverArray[serverIndex] = s = this.m_instanceServerArray[serverIndex];
        }
        serverArray[serverArray.length - 1] = server;
        this.m_instanceServerArray = serverArray;
    }

    @Override
    public synchronized void removeInstanceServer(InstanceServerInterface server) {
        InstanceServerInterface[] serverArray = new InstanceServerInterface[this.m_instanceServerArray.length - 1];
        int index = -1;
        for (int serverIndex = 0; serverIndex < this.m_instanceServerArray.length; ++serverIndex) {
            InstanceServerInterface s = this.m_instanceServerArray[serverIndex];
            if (s == server) continue;
            serverArray[++index] = s;
        }
        this.m_instanceServerArray = serverArray;
    }

    private void addInstanceServer(UUID uuid, ISpawnerInformation spawnerInfo) throws ServerException {
        try {
            ISpawnedServer spawnedServer = null;
            try {
                spawnedServer = spawnerInfo.GetSpawnedServer(uuid);
                this.setSpawnedServer(spawnedServer);
            }
            catch (GenericError error) {
                throw this.logServerException(error);
            }
            IServerAdministration admin = IServerAdministrationHelper.narrow((Object)spawnedServer);
            IServerInformation info = IServerInformationHelper.narrow((Object)spawnedServer);
            InstanceServerInterface instanceServer = ServerFactory.newInstanceServer(this, uuid, this.getMetaConnection(), this.getID(), this.getHostID(), this.getServerParms(), this.getUserContext());
            if (this instanceof WorkspaceServerInterface) {
                ((InstanceServerImpl)instanceServer).setServerConnection(this.getSpawnerConnection());
                ((InstanceServerImpl)instanceServer).setAdministrator(admin);
                ((InstanceServerImpl)instanceServer).setInfo(info);
            } else {
                ((InstanceServerImpl)instanceServer).setPort(this.getPort(info));
                ((InstanceServerImpl)instanceServer).setDomain(this.getDomain());
            }
            ((InstanceServerImpl)instanceServer).connect();
            this.addInstanceServer(instanceServer);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
    }

    private int getPort(IServerInformation info) throws ServerException {
        int iPort = -1;
        try {
            IFilteredList list = info.UseCategory("Information", "IOM.ServerPort");
            String strColumns = new String("value");
            AnySeqHolder attrs = new AnySeqHolder();
            list.GetAttributes(strColumns, attrs);
            Any[] attrsArray = attrs.value;
            java.lang.Object[] lists = new java.lang.Object[1];
            try {
                for (int i = 0; i < attrsArray.length; ++i) {
                    Any anyValue = attrsArray[i];
                    TypeCode typecode = anyValue.type();
                    TCKind kind = typecode.kind();
                    int kindType = kind.value();
                    if (kindType != 21) continue;
                    if (typecode.name().equals(StringSeqHelper.type().name())) {
                        lists[i] = StringSeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (typecode.name().equals(AnySeqHelper.type().name())) {
                        lists[i] = AnySeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                    lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                }
                Any[] valuesArray = (Any[])lists[0];
                for (int valueIndex = 0; valueIndex < valuesArray.length; ++valueIndex) {
                    Any any = valuesArray[valueIndex];
                    java.lang.Object anyObj = ServerUtil.convertAnyToObject(any);
                    if (!(anyObj instanceof Integer)) continue;
                    Integer processID = (Integer)anyObj;
                    iPort = processID;
                }
            }
            catch (BadKind error) {
                throw this.logServerException(error);
            }
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return iPort;
    }

    private SpawnerInterface copySpawner(SpawnerInterface spawner) {
        ObjectSpawnerImpl impl = new ObjectSpawnerImpl(this.getMetaConnection(), spawner.getID(), ((ObjectSpawnerImpl)spawner).getHostID(), ((ObjectSpawnerImpl)spawner).getServerParms(), ((ObjectSpawnerImpl)spawner).getUserContext()){

            @Override
            public void stateChanged(ServerStateEvent event) {
                ServerStateModelInterface mdlState = ServerFactory.getServerStateModel(SpawnedServerImpl.this);
                mdlState.fireServerStateChanged(event);
                if (event.getState().equalsIgnoreCase("Stopped")) {
                    try {
                        SpawnedServerImpl.this.disconnect();
                    }
                    catch (ServerException exc) {
                        this.logServerException((Throwable)((java.lang.Object)exc));
                    }
                }
            }
        };
        return impl;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeSpawnerListener();
    }

    private void removeSpawnerListener() {
        if (this.m_mdlSpawner != null) {
            this.m_mdlSpawner.removeSpawnerListener(this);
            this.m_mdlSpawner = null;
        }
    }
}

