/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.CredentialsInterface;
import com.sas.management.MetadataFactory;
import com.sas.management.ValidatorException;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerConnectionEvent;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.administrator.ServerStateEvent;
import com.sas.management.servers.administrator.ServerStateListener;
import com.sas.management.servers.administrator.ServerStateModelInterface;
import com.sas.management.servers.clients.ServerClientInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.connections.impl.COMConnectionImpl;
import com.sas.management.servers.connections.impl.SASConnectionImpl;
import com.sas.management.servers.connections.impl.TCPConnectionImpl;
import com.sas.management.servers.log.ServerLogFilter;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.management.servers.sessions.ServerSessionInterface;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorInterface;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.ServiceException;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.user.UserContextInterface;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public abstract class ServerImpl
extends MetadataImpl
implements ServerInterface,
ServerValidatorInterface,
ServerAdministratorInterface,
ServerMonitorInterface,
CredentialsInterface,
ServerStateListener {
    private String m_strType = null;
    private String m_strVersion = "9.2";
    private String m_strHost = "localhost";
    private String m_strHostID = null;
    private ConnectionInterface[] m_connectionArray = new ConnectionInterface[0];
    private ServerSessionInterface[] m_sessionArray = new ServerSessionInterface[0];
    private LogicalServerInterface m_svrLogical = null;
    private boolean m_bConnected = false;
    private Properties m_serverParms;
    private UserContextInterface m_usrContext = null;
    private PasswordAuthentication m_credentials;
    private ServerStateModelInterface m_mdlState = null;

    public ServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID);
        this.initialize(metaConn, serverParms, user);
    }

    public ServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID);
        this.m_strHostID = hostID;
        this.initialize(metaConn, serverParms, user);
    }

    private void initialize(MetaServerConnection metaConn, Properties serverParms, UserContextInterface user) {
        this.setServerParms(serverParms);
        this.setUserContext(user);
        if (metaConn != null && this.getID() != null) {
            this.initializeMetadata();
        }
        this.m_mdlState = ServerFactory.getServerStateModel(this);
        this.m_mdlState.addServerStateListener(this);
    }

    private void initializeMetadata() {
        try {
            ServerComponent server = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerComponent><AssociatedMachine/><SourceConnections/><SoftwareTrees/><UsedByComponents/></ServerComponent><Tree><Members/></Tree></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerComponent", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerComponent)objectList.get(0);
                }
            }
            this.setType(server.getClassIdentifier());
            this.setVersion(server.getSoftwareVersion());
            if (this.m_strHostID != null) {
                Machine[] machineArray = ServerUtil.getHosts(server);
                for (int machIndex = 0; machIndex < machineArray.length; ++machIndex) {
                    Machine machine = machineArray[machIndex];
                    if (!machine.getFQID().equalsIgnoreCase(this.m_strHostID)) continue;
                    this.setHost(machine.getName());
                    break;
                }
            } else {
                String strHost = null;
                Machine machine = server.getAssociatedMachine();
                if (machine != null) {
                    strHost = machine.getName();
                }
                if (strHost == null) {
                    AssociationList connectionsList = server.getSourceConnections();
                    Vector<String> hostList = new Vector<String>(1);
                    for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                        Connection conn = (Connection)connectionsList.get(connIndex);
                        TCPIPConnection tcpConn = null;
                        COMConnection comConn = null;
                        SASClientConnection sasConn = null;
                        if (conn instanceof TCPIPConnection && !hostList.contains((tcpConn = (TCPIPConnection)conn).getHostName())) {
                            hostList.add(tcpConn.getHostName());
                        }
                        if (conn instanceof COMConnection && !hostList.contains((comConn = (COMConnection)conn).getHostName())) {
                            hostList.add(comConn.getHostName());
                        }
                        if (!(conn instanceof SASClientConnection) || hostList.contains((sasConn = (SASClientConnection)conn).getRemoteAddress())) continue;
                        hostList.add(sasConn.getRemoteAddress());
                    }
                    if (hostList.size() > 0) {
                        strHost = (String)hostList.get(0);
                    }
                }
                if (strHost != null) {
                    this.setHost(strHost);
                }
            }
            AssociationList connectionsList = server.getSourceConnections();
            for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                Connection conn = (Connection)connectionsList.get(connIndex);
                if (conn instanceof TCPIPConnection) {
                    TCPConnectionImpl connection = new TCPConnectionImpl(this.getMetaConnection(), this, conn.getFQID());
                    this.addConnection(connection);
                }
                if (conn instanceof COMConnection) {
                    COMConnectionImpl connection = new COMConnectionImpl(this.getMetaConnection(), this, conn.getFQID());
                    this.addConnection(connection);
                }
                if (!(conn instanceof SASClientConnection)) continue;
                SASConnectionImpl connection = new SASConnectionImpl(this.getMetaConnection(), this, conn.getFQID());
                this.addConnection(connection);
            }
            AssociationList lstUsedByComponents = server.getUsedByComponents();
            for (int compIndex = 0; compIndex < lstUsedByComponents.size(); ++compIndex) {
                DeployedComponent component = (DeployedComponent)lstUsedByComponents.get(compIndex);
                if (!(component instanceof LogicalServer) || !component.getClassIdentifier().equalsIgnoreCase(server.getClassIdentifier())) continue;
                LogicalServerInterface logicalServer = (LogicalServerInterface)ServerFactory.getServers().get(component.getFQID());
                if (logicalServer == null) {
                    logicalServer = ServerFactory.newLogicalServer(this.getMetaConnection(), component.getFQID(), component.getClassIdentifier(), this.getServerParms(), this.getUserContext());
                }
                this.setLogicalServer(logicalServer);
            }
            this.setObjectState(1);
            if (this.getLogicalServer() != null) {
                ServerInterface[] serverArray = this.getLogicalServer().getServers();
                for (int serverIndex = 0; serverIndex < serverArray.length; ++serverIndex) {
                    ServerInterface s = serverArray[serverIndex];
                    if (s.getID() == null || !s.getID().equalsIgnoreCase(this.getID())) continue;
                    try {
                        if (s.getObjectState() != 0) continue;
                        this.getLogicalServer().deleteServer(s);
                        this.getLogicalServer().addServer(this);
                        continue;
                    }
                    catch (ServerException serverException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (ServerException exc) {
            this.logServerException((Throwable)((Object)exc));
        }
        catch (MdException exc) {
            this.logServerException(exc);
        }
        catch (RemoteException exc) {
            this.logServerException(exc);
        }
    }

    @Override
    public String getType() {
        return this.m_strType;
    }

    @Override
    public String getHost() {
        return this.m_strHost;
    }

    @Override
    public String getVersion() {
        return this.m_strVersion;
    }

    @Override
    public ConnectionInterface[] getConnections() {
        return this.m_connectionArray;
    }

    @Override
    public LogicalServerInterface getLogicalServer() {
        return this.m_svrLogical;
    }

    @Override
    public void setType(String type) {
        this.m_strType = type;
    }

    @Override
    public void setHost(String host) {
        this.m_strHost = host;
    }

    @Override
    public void setVersion(String version) {
        this.m_strVersion = version;
    }

    @Override
    public void addConnection(ConnectionInterface connection) throws ServerException {
        switch (connection.getType()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new ServerException("Argument 'connection' should be of one of the following: ConnectionInterface.TCP, ConnectionInterface.COM, ConnectionInterface.SAS");
            }
        }
        ConnectionInterface[] connectionArray = new ConnectionInterface[this.m_connectionArray.length + 1];
        for (int connIndex = 0; connIndex < this.m_connectionArray.length; ++connIndex) {
            ConnectionInterface conn;
            connectionArray[connIndex] = conn = this.m_connectionArray[connIndex];
        }
        connectionArray[connectionArray.length - 1] = connection;
        this.m_connectionArray = connectionArray;
    }

    @Override
    public void deleteConnection(ConnectionInterface connection) throws ServerException {
        switch (connection.getType()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new ServerException("Argument 'connection' should be of one of the following: ConnectionInterface.TCP, ConnectionInterface.COM, ConnectionInterface.SAS");
            }
        }
        boolean bContainsConnection = false;
        for (int connIndex = 0; connIndex < this.m_connectionArray.length; ++connIndex) {
            ConnectionInterface conn = this.m_connectionArray[connIndex];
            if (conn != connection) continue;
            bContainsConnection = true;
            break;
        }
        if (!bContainsConnection) {
            throw new ServerException("Connection is not on list - cannot remove!");
        }
        ConnectionInterface[] connectionArray = new ConnectionInterface[this.m_connectionArray.length - 1];
        int index = -1;
        for (int connIndex = 0; connIndex < this.m_connectionArray.length; ++connIndex) {
            ConnectionInterface conn = this.m_connectionArray[connIndex];
            if (conn == connection) continue;
            connectionArray[++index] = conn;
        }
        this.m_connectionArray = connectionArray;
    }

    @Override
    public void setLogicalServer(LogicalServerInterface server) {
        this.m_svrLogical = server;
    }

    @Override
    public boolean isAdministrator() throws ServerException {
        throw this.logServerException("Server cannot determine administrative privileges!");
    }

    @Override
    public void start() throws ServerException {
        throw this.logServerException("Server does not support 'start'!");
    }

    @Override
    public void stop() throws ServerException {
        throw this.logServerException("Server does not support 'stop'!");
    }

    @Override
    public void pause() throws ServerException {
        throw this.logServerException("Server does not support 'pause'!");
    }

    @Override
    public void resume() throws ServerException {
        throw this.logServerException("Server does not support 'resume'!");
    }

    @Override
    public void quiesce() throws ServerException {
        throw this.logServerException("Server does not support 'quiesce'!");
    }

    @Override
    public void refresh() throws ServerException {
        throw this.logServerException("Server does not support 'refresh'!");
    }

    @Override
    public String getState() throws ServerException {
        throw this.logServerException("Cannot determine server state!");
    }

    @Override
    public void clearCredentials() throws ServerException {
        throw this.logServerException("Server does not support clearing credentials!");
    }

    @Override
    public void resetCounters() throws ServerException {
        throw this.logServerException("Server does not support resetting counters!");
    }

    @Override
    public void poll(int interval, int timeout) throws ServerException {
        throw this.logServerException("Server does not support polling!");
    }

    @Override
    public ServerClientInterface[] getServerClients() throws ServerException {
        throw this.logServerException("Cannot retrieve server clients!");
    }

    @Override
    public void setServerClients(ServerClientInterface[] clients) {
    }

    @Override
    public ServerSessionInterface[] getServerSessions() throws ServerException {
        throw this.logServerException("Server does not support sessions!");
    }

    @Override
    public void addServerSession(ServerSessionInterface session) {
        ServerSessionInterface[] sessionArray = new ServerSessionInterface[this.m_sessionArray.length + 1];
        for (int sessionIndex = 0; sessionIndex < this.m_sessionArray.length; ++sessionIndex) {
            ServerSessionInterface s;
            sessionArray[sessionIndex] = s = this.m_sessionArray[sessionIndex];
        }
        sessionArray[sessionArray.length - 1] = session;
        this.m_sessionArray = sessionArray;
    }

    @Override
    public void removeServerSession(ServerSessionInterface session) {
        if (this.m_sessionArray.length == 0) {
            return;
        }
        ServerSessionInterface[] sessionArray = new ServerSessionInterface[this.m_sessionArray.length - 1];
        int index = -1;
        for (int sessionIndex = 0; sessionIndex < this.m_sessionArray.length; ++sessionIndex) {
            ServerSessionInterface s = this.m_sessionArray[sessionIndex];
            if (s == session) continue;
            sessionArray[++index] = s;
        }
        this.m_sessionArray = sessionArray;
    }

    @Override
    public ServerLogInterface getServerLog(ServerLogFilter filter) throws ServerException {
        throw this.logServerException("Cannot retrieve server log!");
    }

    @Override
    public void setServerLog(ServerLogInterface log) {
    }

    @Override
    public ServerOptionInterface[] getServerOptions() throws ServerException {
        throw this.logServerException("Cannot retrieve server options!");
    }

    @Override
    public void setServerOptions(ServerOptionInterface[] options) {
    }

    @Override
    public abstract void validateSimple() throws ServerValidatorException;

    @Override
    public abstract void validateExtended() throws ServerValidatorException;

    @Override
    public void validate() throws ValidatorException {
        this.validateSimple();
        this.validateExtended();
    }

    @Override
    public void connect() throws ServerException {
        throw new ServerException("Cannot connect to server!");
    }

    @Override
    public void disconnect() throws ServerException {
        throw new ServerException("Cannot disconnect from server!");
    }

    public boolean isConnected() {
        return this.m_bConnected;
    }

    public void setIsConnected(boolean flag) {
        this.m_bConnected = flag;
    }

    protected void cleanupUponLostConnection() {
    }

    protected void fireServerConnectedChanged() {
        ServerConnectionEvent event = new ServerConnectionEvent(this, this.isConnected());
        ServerConnectionModelInterface model = ServerFactory.getServerConnectionModel(this);
        model.fireServerConnectionChanged(event);
    }

    protected void fireServerDisconnectedChanged() {
        ServerConnectionEvent event = new ServerConnectionEvent(this, false);
        ServerConnectionModelInterface model = ServerFactory.getServerConnectionModel(this);
        model.fireServerConnectionChanged(event);
    }

    protected void fireServerStateChanged() throws ServerException {
        ServerStateEvent event = new ServerStateEvent(this, this.getState());
        ServerStateModelInterface model = ServerFactory.getServerStateModel(this);
        model.fireServerStateChanged(event);
    }

    protected void fireServerStateChanged(String state) {
        ServerStateEvent event = new ServerStateEvent(this, state);
        ServerStateModelInterface model = ServerFactory.getServerStateModel(this);
        model.fireServerStateChanged(event);
    }

    protected void fireUnknownServerStateChanged() {
        ServerStateEvent event = new ServerStateEvent(this, "Unknown");
        ServerStateModelInterface model = ServerFactory.getServerStateModel(this);
        model.fireServerStateChanged(event);
    }

    public Properties getServerParms() {
        return this.m_serverParms;
    }

    public void setServerParms(Properties serverParms) {
        this.m_serverParms = serverParms;
    }

    @Override
    public UserContextInterface getUserContext() {
        return this.m_usrContext;
    }

    @Override
    public void setUserContext(UserContextInterface user) {
        this.m_usrContext = user;
    }

    public PasswordAuthentication getCredentials() {
        return this.m_credentials;
    }

    public void setCredentials(PasswordAuthentication credentials) {
        this.m_credentials = credentials;
    }

    public String getHostID() {
        return this.m_strHostID;
    }

    protected com.sas.services.information.metadata.LogicalServerInterface getInfoLogicalServer() throws ServiceException, RemoteException {
        com.sas.services.information.metadata.LogicalServerInterface logicalServer = null;
        com.sas.services.information.ServerInterface authServer = this.getUserContext().getAuthServer();
        ServerFilter filter = new ServerFilter();
        filter.setType("ServerComponent");
        filter.setName(this.getName());
        filter.setOMRRepository(this.getMetaConnection().getReposId());
        List serverList = authServer.search((FilterInterface)filter);
        block0: for (int serverIndex = 0; serverIndex < serverList.size(); ++serverIndex) {
            com.sas.services.information.metadata.ServerInterface server = (com.sas.services.information.metadata.ServerInterface)serverList.get(serverIndex);
            List servedObjectList = server.getServed();
            for (int ssIndex = 0; ssIndex < servedObjectList.size(); ++ssIndex) {
                Object servedObj = servedObjectList.get(ssIndex);
                if (!(servedObj instanceof com.sas.services.information.metadata.LogicalServerInterface)) continue;
                logicalServer = (com.sas.services.information.metadata.LogicalServerInterface)servedObj;
                continue block0;
            }
        }
        return logicalServer;
    }

    protected ServerException logServerException(String message) {
        return ServerUtil.logServerException(message, this.getLogger());
    }

    protected ServerException logServerException(Throwable throwable) {
        return ServerUtil.logServerException(throwable, this.getLogger());
    }

    protected ServerValidatorException logServerValidatorException(String message, String validationType, int validationLevel) {
        return ServerValidatorUtil.logServerValidatorException(message, validationType, validationLevel, this.getLogger());
    }

    protected ServerValidatorException logServerValidatorException(Throwable throwable, String validationType, int validationLevel) {
        return ServerValidatorUtil.logServerValidatorException(throwable, validationType, validationLevel, this.getLogger());
    }

    @Override
    public void stateChanged(ServerStateEvent event) {
        if (event.getState().equalsIgnoreCase("Stopped")) {
            this.cleanupUponLostConnection();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.isConnected()) {
            try {
                this.disconnect();
            }
            catch (ServerException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        }
        this.removeServerStateListener();
    }

    private void removeServerStateListener() {
        if (this.m_mdlState != null) {
            this.m_mdlState.removeServerStateListener(this);
            this.m_mdlState = null;
        }
    }
}

