/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.MetadataFactory;
import com.sas.management.PropertyInterface;
import com.sas.management.ValidatorException;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;

public class PostgresServerImpl
extends ServerImpl {
    private String m_strHost = "localhost";
    private int m_port = 5432;
    private String m_adminScript = "";
    private Properties m_deployAgentConnectionProps;
    private String m_deployAgenPort;
    protected static WAdminResource bundle = new WAdminResource(PostgresServerImpl.class);

    public PostgresServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        this.initialize();
        this.setServerParms(serverParms);
        this.m_adminScript = this.getScriptLocation();
        this.m_deployAgentConnectionProps = this.getDeployAgentConnectionProperties();
        this.m_deployAgenPort = this.m_deployAgentConnectionProps.getProperty("solstice.agent.jmx.port");
    }

    private void initialize() {
        ConnectionInterface[] connectionArray = this.getConnections();
        block0: for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            ConnectionInterface conn = connectionArray[connIndex];
            if (!conn.getApplicationProtocol().equalsIgnoreCase("Postgres")) continue;
            this.m_port = conn.getPort();
            PropertyInterface[] props = conn.getProperties();
            for (int i = 0; i < props.length; ++i) {
                PropertyInterface prop = props[i];
                if (prop == null || !prop.getPropertyName().equalsIgnoreCase("SERVER")) continue;
                this.m_strHost = prop.getDefaultValue();
                break block0;
            }
            break;
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strPort;
            String strHost = (String)this.getServerParms().get("host");
            if (strHost != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
        }
    }

    @Override
    public void stop() throws ServerException {
    }

    @Override
    public void start() throws ServerException {
    }

    @Override
    public void validate() throws ValidatorException {
        this.validateSimple();
        this.validateExtended();
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        try {
            ServerValidatorUtil.validateServerPing("Web Infrastructure Platform Data", this.getLogger(), this.m_strHost, this.m_port, 1);
        }
        catch (ServerValidatorException exc) {
            this.getLogger().info(bundle.getString("PostgresServerImpl.PingFailedDetailed.txt"));
            throw new ServerValidatorException(bundle.getString("PostgresServerImpl.PingFailed.txt"));
        }
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
    }

    private String getScriptLocation() {
        HashMap publicProperties = new HashMap();
        HashMap privateProperties = new HashMap();
        String scriptLocation = "";
        try {
            ServerComponent sc = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            ConfigurablePropertiesUtil.getObjectProperties((SoftwareComponent)sc, publicProperties, privateProperties);
            scriptLocation = (String)publicProperties.get("webinfdsvrc.smc.script");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return scriptLocation;
    }

    private Properties getDeployAgentConnectionProperties() {
        Properties securityProperties = new Properties();
        String securityFileLocation = System.getProperty("sas.deployment.agent.client.config");
        if (securityFileLocation != null && securityFileLocation.length() > 0) {
            try {
                FileInputStream fis = new FileInputStream(securityFileLocation);
                securityProperties.load(fis);
                fis.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException e) {
                securityProperties.clear();
            }
        }
        return securityProperties;
    }

    @Override
    public SpawnerInterface getSpawner() {
        return null;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
    }

    @Override
    public Object getServerConnection() {
        return null;
    }

    @Override
    public void setServerConnection(Object connection) {
    }
}

