/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.management.MetadataFactory;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.impl.IOMServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.meta.SASOMI.IServer;
import com.sas.meta.SASOMI.IServerHelper;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;

public class MetadataServerImpl
extends IOMServerImpl {
    private String m_strAuthDomain = "DefaultAuth";
    private String m_strHost = "localhost";
    private int m_port = 8561;
    protected static WAdminResource bundle = new WAdminResource(MetadataServerImpl.class);

    public MetadataServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        int connIndex;
        com.sas.management.servers.connections.ConnectionInterface[] connectionArray = this.getConnections();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_strAuthDomain = connectionArray[connIndex].getAuthenticationDomain();
            if (this.m_strAuthDomain != null) break;
        }
        this.m_strHost = this.getHost();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_port = connectionArray[connIndex].getPort();
            if (this.m_port > 0) break;
        }
    }

    @Override
    public String getState() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        String strState = "Unknown";
        if (!this.isAdministrator()) {
            return strState;
        }
        if (this.getServerConnection() instanceof ConnectionInterface) {
            Object obj = ((ConnectionInterface)this.getServerConnection()).getObject();
            IServer metaServer = IServerHelper.narrow((Object)obj);
            StringHolder outStatus = new StringHolder();
            try {
                metaServer.Status("<state/>", outStatus, "");
                String strStatusValue = outStatus.value;
                Document docLogCfg = MetadataFactory.getMdFactory().getOMIUtil().parseXML(strStatusValue);
                XPath xpath = XPathFactory.newInstance().newXPath();
                String strExpression = "*/text()";
                String strStatus = (String)xpath.evaluate(strExpression, docLogCfg, XPathConstants.STRING);
                int iStatus = Integer.parseInt(strStatus);
                if (iStatus == -1) {
                    strState = "Unknown";
                } else if (iStatus == 0) {
                    strState = "Running";
                } else if (iStatus == 1) {
                    strState = "Paused";
                } else if (iStatus == 2) {
                    strState = "Running";
                }
            }
            catch (GenericError err) {
                throw this.logServerException(err);
            }
            catch (MdException exc) {
                throw this.logServerException(exc);
            }
            catch (RemoteException exc) {
                throw this.logServerException(exc);
            }
            catch (XPathExpressionException exc) {
                throw this.logServerException(exc);
            }
        }
        return strState;
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing("Metadata", this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ConnectionFactoryAdminInterface admin;
        this.initialize();
        PlatformConnectionFactoryConfiguration cxfConfig = null;
        ConnectionInterface cx = null;
        try {
            LogicalServerInterface logicalServer = this.getInfoLogicalServer();
            cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer, ServerUtil.getServerURI(this), this.m_strHost, this.m_port, false);
            cx = ServerValidatorUtil.validateIOMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, "Metadata", this.getUserContext(), this.getLogger(), 1);
            ServerValidatorUtil.validateMetadataServerGetRepositories(cx, this.getLogger(), 2);
            admin = null;
        }
        catch (ServiceException exc) {
            try {
                throw this.logServerValidatorException(exc, "Extended", 1);
                catch (RemoteException exc2) {
                    throw this.logServerValidatorException(exc2, "Extended", 1);
                }
            }
            catch (Throwable throwable) {
                ConnectionFactoryAdminInterface admin2 = null;
                try {
                    PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(cxfConfig);
                    admin2 = cxf.getAdminInterface();
                    throw throwable;
                }
                catch (ConnectionFactoryException exc3) {
                    throw this.logServerValidatorException(exc3, "Extended", 1);
                }
                finally {
                    if (cx != null) {
                        cx.close();
                    }
                    if (admin2 != null) {
                        admin2.shutdown();
                    }
                }
            }
        }
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            admin = cxf.getAdminInterface();
            return;
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (cx != null) {
                cx.close();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strPort;
            String strHost;
            String strAuthDomain = (String)this.getServerParms().get("authdomain");
            if (strAuthDomain != null) {
                this.m_strAuthDomain = strAuthDomain;
            }
            if ((strHost = (String)this.getServerParms().get("host")) != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
        }
    }
}

