/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotPaused;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotRunning;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotStoppable;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMCommon.IServerLogHelper;
import com.sas.iom.SASIOMCommon.IServerSessions;
import com.sas.iom.SASIOMCommon.IServerSessionsHelper;
import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.BooleanSeqHelper;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.DoubleSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.management.MetadataFactory;
import com.sas.management.ValidatorException;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.clients.ServerClientInterface;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.servers.log.ServerLogFilter;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.log.ServerLogUtil;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.management.servers.options.impl.IOMServerOptionImpl;
import com.sas.management.servers.sessions.ServerSessionInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.net.util.DateConverter;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public abstract class IOMServerImpl
extends ServerImpl {
    private SpawnerInterface m_spawner = null;
    private IServerAdministration m_admin = null;
    private IServerInformation m_info = null;
    private String m_strServerState = "Unknown";
    private ServerClientInterface[] m_clientArray = new ServerClientInterface[0];
    private ServerSessionInterface[] m_sessionArray = new ServerSessionInterface[0];
    private IServerSessions m_sessions = null;
    private ServerLogInterface m_logServer = null;
    private IServerLog m_log = null;
    private ServerOptionInterface[] m_optionArray = new ServerOptionInterface[0];
    protected Logger m_logger = Logger.getLogger("com.sas.management.servers.impl.IOMServerImpl");
    private String m_strDomain = null;
    private ConnectionFactoryConfiguration m_cxfConfig = null;
    private ConnectionInterface m_cx = null;
    private static WAdminResource m_bundle = new WAdminResource(IOMServerImpl.class);

    public IOMServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        this.initialize(metaConn);
    }

    public IOMServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, hostID, serverParms, user);
        this.initialize(metaConn);
    }

    private void initialize(MetaServerConnection metaConn) {
        if (metaConn != null && this.getID() != null) {
            this.initializeMetadata();
        }
    }

    protected void initializeMetadata() {
        try {
            ServerComponent server = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerComponent><UsingComponents/></ServerComponent></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerComponent", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerComponent)objectList.get(0);
                }
            }
            AssociationList usingComponentsList = server.getUsingComponents();
            for (int compIndex = 0; compIndex < usingComponentsList.size(); ++compIndex) {
                DeployedComponent component = (DeployedComponent)usingComponentsList.get(compIndex);
                if (!(component instanceof ServerComponent) || !ServerUtil.serverContainsHost((ServerComponent)component, this.getHostID())) continue;
                SpawnerInterface s = (SpawnerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(component.getFQID(), this.getHostID()));
                if (s == null) {
                    s = (SpawnerInterface)ServerFactory.newServer(this.getMetaConnection(), component.getFQID(), this.getHostID(), "IOM Spawner", null, this.getUserContext());
                }
                this.setSpawner(s);
            }
            this.setObjectState(1);
            if (this.getSpawner() != null) {
                ServerInterface[] serverArray = this.getSpawner().getServers();
                for (int serverIndex = 0; serverIndex < serverArray.length; ++serverIndex) {
                    ServerInterface s = serverArray[serverIndex];
                    if (s.getID() == null || !s.getID().equalsIgnoreCase(this.getID())) continue;
                    try {
                        if (s.getObjectState() != 0) continue;
                        this.getSpawner().removeServer(s);
                        this.getSpawner().addServer(this);
                        continue;
                    }
                    catch (ServerException serverException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (MdException exc) {
            this.logServerException(exc);
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((java.lang.Object)"", (Throwable)re);
        }
    }

    @Override
    public void validate() throws ValidatorException {
        boolean bContainsBridge = false;
        com.sas.management.servers.connections.ConnectionInterface[] aryConnection = this.getConnections();
        for (int connIndex = 0; connIndex < aryConnection.length; ++connIndex) {
            com.sas.management.servers.connections.ConnectionInterface conn = aryConnection[connIndex];
            if (!conn.getApplicationProtocol().equalsIgnoreCase("Bridge")) continue;
            bContainsBridge = true;
            break;
        }
        if (!bContainsBridge) {
            throw this.logServerValidatorException(m_bundle.getString("IOMServerImpl.NoBridgeConnection.txt"), "Simple", 1);
        }
        super.validate();
    }

    @Override
    public void connect() throws ServerException {
        if (this.isConnected()) {
            return;
        }
        UserContextInterface user = this.getUserContext();
        boolean bContainsBridge = false;
        com.sas.management.servers.connections.ConnectionInterface[] aryConnection = this.getConnections();
        for (int connIndex = 0; connIndex < aryConnection.length; ++connIndex) {
            com.sas.management.servers.connections.ConnectionInterface conn = aryConnection[connIndex];
            if (!conn.getApplicationProtocol().equalsIgnoreCase("Bridge")) continue;
            bContainsBridge = true;
            break;
        }
        if (!bContainsBridge) {
            throw this.logServerException(m_bundle.getString("IOMServerImpl.NoBridgeConnection.txt"));
        }
        try {
            this.m_cxfConfig = new PlatformConnectionFactoryConfiguration(this.getInfoLogicalServer(), ServerUtil.getServerURI(this), this.getHost(), ServerUtil.getBridgePort(this), true);
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
            ConnectionInterface cx = cxf.getConnection(user);
            this.setServerConnection(cx);
            Object obj = this.m_cx.getObject();
            IServerAdministration admin = IServerAdministrationHelper.narrow((Object)obj);
            this.setAdministrator(admin);
            IServerInformation info = IServerInformationHelper.narrow((Object)obj);
            this.setInfo(info);
            IServerSessions session = IServerSessionsHelper.narrow((Object)obj);
            this.setSession(session);
            IServerLog log = IServerLogHelper.narrow((Object)obj);
            this.setLog(log);
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        catch (ServiceException exc) {
            throw this.logServerException(exc);
        }
        catch (RemoteException exc) {
            throw this.logServerException(exc);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    @Override
    public void disconnect() throws ServerException {
        if (!this.isConnected()) {
            return;
        }
        ConnectionFactoryAdminInterface admin = null;
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
            admin = cxf.getAdminInterface();
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        finally {
            if (this.m_cx != null) {
                this.m_cx.close();
                this.m_cx = null;
                this.cleanupUponLostConnection();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.getServerConnection() != null;
    }

    @Override
    public boolean isAdministrator() throws ServerException {
        boolean bIsAdmin = false;
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getInfo() == null) {
            return bIsAdmin;
        }
        try {
            bIsAdmin = this.getInfo().IsAdministrator();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return bIsAdmin;
    }

    @Override
    public void start() throws ServerException {
        throw this.logServerException("Server does not support 'start'!");
    }

    @Override
    public void stop() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().StopServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotStoppable exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void pause() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().PauseServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotRunning exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void resume() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().ContinueServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotPaused exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void quiesce() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().DeferredStopServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotStoppable exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void refresh() throws ServerException {
        throw new ServerException("Server does not support 'refresh'!");
    }

    @Override
    public void clearCredentials() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().CacheFlush();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void resetCounters() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        try {
            this.getAdministrator().ResetPerformanceCounters();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void poll(int interval, int timeout) throws ServerException {
        ServerUtil.pollIOMServer(this, interval, timeout);
    }

    @Override
    protected void cleanupUponLostConnection() {
        this.setServerConnection(null);
        this.fireServerConnectedChanged();
        this.fireUnknownServerStateChanged();
    }

    @Override
    public String getState() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (!this.isAdministrator()) {
            return this.m_strServerState;
        }
        if (this.getInfo() == null) {
            return this.m_strServerState;
        }
        try {
            IFilteredList list = this.getInfo().UseCategory("Information", "IOM.ServerState");
            String strColumns = new String("value");
            AnySeqHolder attrs = new AnySeqHolder();
            list.GetAttributes(strColumns, attrs);
            Any[] attrsArray = attrs.value;
            java.lang.Object[] lists = new java.lang.Object[1];
            try {
                for (int i = 0; i < attrsArray.length; ++i) {
                    Any anyValue = attrsArray[i];
                    TypeCode typecode = anyValue.type();
                    TCKind kind = typecode.kind();
                    int kindType = kind.value();
                    if (kindType != 21) continue;
                    if (typecode.name().equals(StringSeqHelper.type().name())) {
                        lists[i] = StringSeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (typecode.name().equals(AnySeqHelper.type().name())) {
                        lists[i] = AnySeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                    lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                }
                Any[] valuesArray = (Any[])lists[0];
                for (int valueIndex = 0; valueIndex < valuesArray.length; ++valueIndex) {
                    Any any = valuesArray[valueIndex];
                    java.lang.Object anyObj = ServerUtil.convertAnyToObject(any);
                    if (!(anyObj instanceof String)) continue;
                    this.m_strServerState = (String)anyObj;
                }
            }
            catch (BadKind error) {
                throw this.logServerException(error);
            }
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_strServerState;
    }

    @Override
    public ServerClientInterface[] getServerClients() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getAdministrator() == null || this.getInfo() == null) {
            return this.m_clientArray;
        }
        try {
            StringSeqHolder clients = new StringSeqHolder();
            StringSeqHolder clientHosts = new StringSeqHolder();
            DateTimeSeqHolder enterTimes = new DateTimeSeqHolder();
            this.getAdministrator().ListClients(clients, clientHosts, enterTimes);
            String[] clientsArray = clients.value;
            String[] clientHostsArray = clientHosts.value;
            long[] enterTimesArray = enterTimes.value;
            this.m_clientArray = new ServerClientInterface[clientsArray.length];
            for (int index = 0; index < clientsArray.length; ++index) {
                String strUser = clientsArray[index];
                String strHost = clientHostsArray[index];
                Calendar cdr = Calendar.getInstance();
                cdr.setTimeZone(TimeZone.getTimeZone("GMT"));
                DateConverter.corbaToJava((long)enterTimesArray[index], (Calendar)cdr);
                ServerClientInterface client = ServerFactory.newServerClient(this, strUser);
                client.setHost(strHost);
                client.setEntryTime(cdr);
                this.m_clientArray[index] = client;
            }
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_clientArray;
    }

    @Override
    public void setServerClients(ServerClientInterface[] clients) {
        this.m_clientArray = clients;
    }

    @Override
    public ServerSessionInterface[] getServerSessions() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getSession() != null) {
            String userFilter = "";
            UUIDSeqHolder sessionIDs = new UUIDSeqHolder();
            StringSeqHolder owners = new StringSeqHolder();
            DoubleSeqHolder inactiveTimes = new DoubleSeqHolder();
            try {
                this.getSession().SessionList(userFilter, sessionIDs, owners, inactiveTimes);
                UUID[] sessionIDsArray = sessionIDs.value;
                String[] ownersArray = owners.value;
                double[] inactiveTimesArray = inactiveTimes.value;
                this.m_sessionArray = new ServerSessionInterface[sessionIDsArray.length];
                for (int index = 0; index < sessionIDsArray.length; ++index) {
                    String strSessionID = ServerUtil.convertUUIDToString(sessionIDsArray[index]);
                    String strOwner = ownersArray[index];
                    double dblInactiveTime = inactiveTimesArray[index];
                    ServerSessionInterface session = ServerFactory.getServerSessions().get(strSessionID);
                    if (session == null) {
                        session = ServerFactory.newServerSession(this, strSessionID, strOwner);
                    }
                    session.setIdleTime(dblInactiveTime);
                    if (dblInactiveTime == 0.0) {
                        session.setState(0);
                    } else {
                        session.setState(1);
                    }
                    this.m_sessionArray[index] = session;
                }
            }
            catch (GenericError error) {
                throw this.logServerException(error);
            }
            catch (SystemException exc) {
                throw this.logServerException(exc);
            }
        } else {
            throw this.logServerException("Server does not support sessions!");
        }
        return this.m_sessionArray;
    }

    @Override
    public void addServerSession(ServerSessionInterface session) {
        ServerSessionInterface[] sessionArray = new ServerSessionInterface[this.m_sessionArray.length + 1];
        for (int sessionIndex = 0; sessionIndex < this.m_sessionArray.length; ++sessionIndex) {
            ServerSessionInterface s;
            sessionArray[sessionIndex] = s = this.m_sessionArray[sessionIndex];
        }
        sessionArray[sessionArray.length - 1] = session;
        this.m_sessionArray = sessionArray;
    }

    @Override
    public void removeServerSession(ServerSessionInterface session) {
        if (this.m_sessionArray.length == 0) {
            return;
        }
        ServerSessionInterface[] sessionArray = new ServerSessionInterface[this.m_sessionArray.length - 1];
        int index = -1;
        for (int sessionIndex = 0; sessionIndex < this.m_sessionArray.length; ++sessionIndex) {
            ServerSessionInterface s = this.m_sessionArray[sessionIndex];
            if (s == session) continue;
            sessionArray[++index] = s;
        }
        this.m_sessionArray = sessionArray;
    }

    @Override
    public ServerLogInterface getServerLog(ServerLogFilter filter) throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getLog() == null) {
            return this.m_logServer;
        }
        return ServerLogUtil.getServerLog(this, filter, this.getLog(), this.getHostID(), this.getLogger());
    }

    @Override
    public void setServerLog(ServerLogInterface log) {
        this.m_logServer = log;
    }

    @Override
    public ServerOptionInterface[] getServerOptions() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getInfo() == null) {
            return this.m_optionArray;
        }
        try {
            Vector<ServerOptionInterface> optionList = new Vector<ServerOptionInterface>();
            String[] categoriesArray = this.getInfo().ListCategories();
            for (int catIndex = 0; catIndex < categoriesArray.length; ++catIndex) {
                String strCategory = categoriesArray[catIndex];
                IFilteredList list = this.getInfo().UseCategory(strCategory, "");
                String strColumns = new String("name description writeable value");
                AnySeqHolder attrs = new AnySeqHolder();
                list.GetAttributes(strColumns, attrs);
                Any[] attrsArray = attrs.value;
                java.lang.Object[] lists = new java.lang.Object[attrsArray.length];
                try {
                    for (int i = 0; i < attrsArray.length; ++i) {
                        Any anyValue = attrsArray[i];
                        TypeCode typecode = anyValue.type();
                        TCKind kind = typecode.kind();
                        int kindType = kind.value();
                        if (kindType != 21) continue;
                        if (typecode.name().equals(StringSeqHelper.type().name())) {
                            lists[i] = StringSeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (typecode.name().equals(AnySeqHelper.type().name())) {
                            lists[i] = AnySeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                        lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                    }
                    String[] namesArray = (String[])lists[0];
                    String[] descsArray = (String[])lists[1];
                    boolean[] writeableArray = (boolean[])lists[2];
                    Any[] valuesArray = (Any[])lists[3];
                    for (int valueIndex = 0; valueIndex < valuesArray.length; ++valueIndex) {
                        String strName = namesArray[valueIndex];
                        String strDesc = descsArray[valueIndex];
                        boolean bWriteable = writeableArray[valueIndex];
                        String strValue = "";
                        Any any = valuesArray[valueIndex];
                        java.lang.Object anyObj = ServerUtil.convertAnyToObject(any);
                        int iType = 12;
                        if (anyObj instanceof Integer) {
                            iType = 4;
                        }
                        if (anyObj instanceof Boolean) {
                            iType = 16;
                        }
                        if (anyObj instanceof Date) {
                            iType = 91;
                            anyObj = new Long(((Date)anyObj).getTime());
                        }
                        strValue = anyObj.toString();
                        ServerOptionInterface option = ServerFactory.newServerOption(this, strName, iType, strValue);
                        option.setDesc(strDesc);
                        option.setIsWriteable(bWriteable);
                        optionList.add(option);
                        if (!(option instanceof IOMServerOptionImpl)) continue;
                        ((IOMServerOptionImpl)option).setCategory(strCategory);
                        ((IOMServerOptionImpl)option).setInfo(this.getInfo());
                    }
                    continue;
                }
                catch (BadKind error) {
                    throw this.logServerException(error);
                }
            }
            this.m_optionArray = optionList.toArray(new ServerOptionInterface[0]);
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_optionArray;
    }

    @Override
    public void setServerOptions(ServerOptionInterface[] options) {
        this.m_optionArray = options;
    }

    @Override
    public SpawnerInterface getSpawner() {
        return this.m_spawner;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
        this.m_spawner = spawner;
    }

    @Override
    public java.lang.Object getServerConnection() {
        return this.m_cx;
    }

    @Override
    public void setServerConnection(java.lang.Object connection) {
        if (connection != null && !(connection instanceof ConnectionInterface)) {
            throw new IllegalArgumentException("Argument 'connection' should be of type ConnectionInterface!");
        }
        this.m_cx = (ConnectionInterface)connection;
    }

    protected IServerAdministration getAdministrator() {
        return this.m_admin;
    }

    protected void setAdministrator(IServerAdministration admin) {
        this.m_admin = admin;
    }

    protected IServerInformation getInfo() {
        return this.m_info;
    }

    protected void setInfo(IServerInformation info) {
        this.m_info = info;
    }

    protected IServerSessions getSession() {
        return this.m_sessions;
    }

    protected void setSession(IServerSessions session) {
        this.m_sessions = session;
    }

    protected IServerLog getLog() {
        return this.m_log;
    }

    protected void setLog(IServerLog log) {
        this.m_log = log;
    }

    protected String getDomain() {
        return this.m_strDomain;
    }

    protected void setDomain(String domain) {
        this.m_strDomain = domain;
    }
}

