/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.management.MetadataFactory;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class GridServerImpl
extends ServerImpl {
    private String m_strAuthDomain = "";
    private String m_strHost = "";
    private int m_port = 0;
    private ServerComponent m_workspace = null;
    private String m_serverContextName = "";
    private String m_gridSignonPrefix = "%put rc=%sysfunc(grdsvc_enable(_all_,server=\"";
    private String m_gridSubmit = "signon t1; rsubmit;proc options;run;endrsubmit;";
    private String m_gridSignoff = "signoff _all_;";
    private String m_debugOption = "options set=SAS_GRID_DEBUG '0xFFFFFFFF';";
    protected static WAdminResource bundle = new WAdminResource(GridServerImpl.class);
    private ConnectionFactoryConfiguration m_cxfConfig = null;
    private ConnectionInterface m_cx = null;
    private ConnectionFactoryInterface m_cxf = null;
    private ConnectionFactoryAdminInterface m_admin = null;
    UserContextInterface m_user = null;
    UserIdentityInterface m_userIdentity = null;
    UserContextInterface m_userContext;

    public GridServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        this.initialize();
        this.setServerParms(serverParms);
    }

    private void initialize() {
        int connIndex;
        com.sas.management.servers.connections.ConnectionInterface[] connectionArray = this.getConnections();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_strAuthDomain = connectionArray[connIndex].getAuthenticationDomain();
            if (this.m_strAuthDomain != null) break;
        }
        this.m_strHost = this.getHost();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_port = connectionArray[connIndex].getPort();
            if (this.m_port > 0) break;
        }
        if (Workspace.isDebug()) {
            this.getLogger().fine("Host of this server=" + this.m_strHost);
            this.getLogger().fine("Port of this server=" + this.m_port);
        }
    }

    protected LogicalServerInterface getWorkSpaceLogicalServer() throws ServiceException, RemoteException {
        LogicalServerInterface logicalServer = null;
        ServerInterface authServer = this.getUserContext().getAuthServer();
        ServerFilter filter = new ServerFilter();
        filter.setType("ServerComponent");
        filter.setName(this.m_workspace.getName());
        filter.setOMRRepository(this.getMetaConnection().getReposId());
        List serverList = authServer.search((FilterInterface)filter);
        block0: for (int serverIndex = 0; serverIndex < serverList.size(); ++serverIndex) {
            com.sas.services.information.metadata.ServerInterface server = (com.sas.services.information.metadata.ServerInterface)serverList.get(serverIndex);
            List servedObjectList = server.getServed();
            for (int ssIndex = 0; ssIndex < servedObjectList.size(); ++ssIndex) {
                java.lang.Object servedObj = servedObjectList.get(ssIndex);
                if (!(servedObj instanceof LogicalServerInterface)) continue;
                logicalServer = (LogicalServerInterface)servedObj;
                continue block0;
            }
        }
        return logicalServer;
    }

    public void getWorkSpaceServer() throws MdException, RemoteException {
        String fqid = this.getMetaConnection().getReposId();
        if (fqid != null) {
            String strTemplate = "<TEMPLATES><ServerComponent><UsedByComponents/></ServerComponent></TEMPLATES>";
            String strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + this.getName() + "'][UsedByComponents/LogicalServer[@ClassIdentifier='" + "D7E796B4-654C-4ab3-B690-657EE79309FB" + "']]\" />";
            String strOptions = strTemplate + strXMLSelect;
            int flags = 8604;
            List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), fqid, "ServerComponent", flags, strOptions, true);
            if (objectList.size() == 1) {
                ServerComponent connectServer = (ServerComponent)objectList.get(0);
                LogicalServer lc = (LogicalServer)connectServer.getUsedByComponents().get(0);
                ServerContext sc = (ServerContext)lc.getUsedByComponents().get(0);
                this.m_serverContextName = sc.getName();
                AssociationList usingComponents = sc.getUsingComponents();
                for (LogicalServer logicalServer : usingComponents) {
                    String classID = logicalServer.getClassIdentifier();
                    if (!classID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) continue;
                    this.m_workspace = (ServerComponent)logicalServer.getUsingComponents().get(0);
                    break;
                }
            }
        }
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
        block19: {
            boolean getError = false;
            try {
                this.getWorkSpaceServer();
                if (this.m_workspace != null) {
                    LogicalServerInterface logicalServer = this.getWorkSpaceLogicalServer();
                    this.m_cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer);
                    this.m_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                    this.m_cx = ((PlatformConnectionFactoryInterface)this.m_cxf).getConnection(this.getUserContext());
                    break block19;
                }
                ServerValidatorException exc = new ServerValidatorException(bundle.getString("GridServerImpl.NoWorkSpace.txt"), "Extended", 1);
                this.getLogger().severe(exc.getLocalizedMessage());
                getError = true;
                throw exc;
            }
            catch (RemoteException exc) {
                getError = true;
                throw this.logServerValidatorException(exc, "Extended", 1);
            }
            catch (MdException exc) {
                getError = true;
                throw this.logServerValidatorException(exc, "Extended", 1);
            }
            catch (ServiceException exc) {
                getError = true;
                throw this.logServerValidatorException(exc, "Extended", 1);
            }
            catch (ConnectionFactoryException e) {
                getError = true;
                throw this.logServerValidatorException(e, "Extended", 1);
            }
            finally {
                try {
                    if (this.m_cxf != null) {
                        this.m_admin = this.m_cxf.getAdminInterface();
                    }
                }
                catch (ConnectionFactoryException e) {
                    getError = true;
                    throw this.logServerValidatorException(e, "Extended", 1);
                }
                if (getError) {
                    this.closeFactory();
                }
            }
        }
        try {
            String server = this.m_serverContextName + "\"));";
            String signonCode1 = "";
            String signonCode = this.m_gridSignonPrefix.concat(server);
            if (Workspace.isDebug()) {
                String debug = signonCode.concat(this.m_debugOption);
                signonCode1 = debug.concat(this.m_gridSubmit);
            } else {
                signonCode1 = signonCode.concat(this.m_gridSubmit);
            }
            String gridCode = signonCode1.concat(this.m_gridSignoff);
            this.validateGridServerCodeSubmit(gridCode, 2);
        }
        catch (GenericError e) {
            this.closeFactory();
            throw this.logServerValidatorException(e, "Extended", 1);
        }
        this.closeFactory();
    }

    private void closeFactory() {
        if (this.m_cx != null) {
            this.m_cx.close();
        }
        if (this.m_admin != null) {
            this.m_admin.shutdown();
        }
    }

    public void validateGridServerCodeSubmit(String code, int validationLevel) throws ServerValidatorException, GenericError {
        IWorkspace iWorkspace = null;
        try {
            Object obj = this.m_cx.getObject();
            iWorkspace = IWorkspaceHelper.narrow((Object)obj);
            ILanguageService m_sasLanguage = iWorkspace.LanguageService();
            this.getLogger().fine(bundle.formatString("ConnectServerImpl.CodeToSubmit.fmt.txt", (java.lang.Object)code));
            m_sasLanguage.Submit(code);
            CarriageControlSeqHolder m_logCCHolder = new CarriageControlSeqHolder();
            LineTypeSeqHolder m_logTypeHolder = new LineTypeSeqHolder();
            StringSeqHolder m_logLinesHolder = new StringSeqHolder();
            m_sasLanguage.FlushLogLines(Integer.MAX_VALUE, m_logCCHolder, m_logTypeHolder, m_logLinesHolder);
            LineType[] linetypes = m_logTypeHolder.value;
            String[] lines = m_logLinesHolder.value;
            StringBuffer errormsg = new StringBuffer();
            String previous = null;
            for (int i = 0; i < linetypes.length; ++i) {
                switch (linetypes[i].value()) {
                    case 6: {
                        if (previous == null || lines[i].compareTo(previous) == 0) break;
                        if (errormsg.length() != 0) {
                            errormsg.append("\n");
                        }
                        errormsg.append(lines[i]);
                        break;
                    }
                    case 0: 
                    case 9: {
                        if (!lines[i].toString().startsWith("rc") || lines[i].toString().endsWith("0")) break;
                        errormsg.append(lines[i]);
                    }
                }
                previous = lines[i];
                this.getLogger().fine(lines[i].toString());
            }
            if (errormsg.length() > 0) {
                this.getLogger().severe(errormsg.toString());
                throw this.logServerValidatorException(bundle.getString("GridServerImpl.signonserver.failed.txt"), "Extended", 1);
            }
            this.getLogger().fine(bundle.getString("GridServerImpl.signonserver.ok.txt"));
        }
        catch (SystemException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (iWorkspace != null) {
                iWorkspace.Close();
            }
            this.closeFactory();
        }
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
    }

    @Override
    public SpawnerInterface getSpawner() {
        return null;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
    }

    @Override
    public java.lang.Object getServerConnection() {
        return null;
    }

    @Override
    public void setServerConnection(java.lang.Object connection) {
    }
}

