/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.MetadataFactory;
import com.sas.management.PathInterface;
import com.sas.management.impl.PathImpl;
import com.sas.management.servers.ContentServerInterface;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public abstract class ContentServerImpl
extends ServerImpl
implements ContentServerInterface {
    private PathInterface[] m_pathArray = new PathInterface[0];

    public ContentServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            ServerComponent server = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerComponent><DataPackages/></ServerComponent></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerComponent", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerComponent)objectList.get(0);
                }
            }
            AssociationList dataPackagesList = server.getDataPackages();
            for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                if (!(ddp instanceof Directory)) continue;
                Directory dir = (Directory)ddp;
                PathImpl path = new PathImpl(this.getMetaConnection(), dir.getFQID(), dir.getDirectoryName());
                this.addPath(path);
            }
            this.setObjectState(1);
        }
        catch (MdException exc) {
            this.logServerException(exc);
        }
        catch (RemoteException exc) {
            this.logServerException(exc);
        }
    }

    @Override
    public PathInterface[] getPaths() {
        return this.m_pathArray;
    }

    @Override
    public void addPath(PathInterface path) {
        PathInterface[] pathArray = new PathInterface[this.m_pathArray.length + 1];
        for (int pathIndex = 0; pathIndex < this.m_pathArray.length; ++pathIndex) {
            PathInterface p;
            pathArray[pathIndex] = p = this.m_pathArray[pathIndex];
        }
        pathArray[pathArray.length - 1] = path;
        this.m_pathArray = pathArray;
    }

    @Override
    public void removePath(PathInterface path) {
        PathInterface[] pathArray = new PathInterface[this.m_pathArray.length - 1];
        int index = -1;
        for (int pathIndex = 0; pathIndex < this.m_pathArray.length; ++pathIndex) {
            PathInterface p = this.m_pathArray[pathIndex];
            if (p == path) continue;
            pathArray[++index] = p;
        }
        this.m_pathArray = pathArray;
    }
}

