/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.ConnectSpawner.IConnectSpawnerAdministration;
import com.sas.iom.ConnectSpawner.IConnectSpawnerAdministrationHelper;
import com.sas.iom.ConnectSpawner.IConnectSpawnerInformation;
import com.sas.iom.ConnectSpawner.IConnectSpawnerInformationHelper;
import com.sas.iom.SASIOMCommon.IFilteredList;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotPaused;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotRunning;
import com.sas.iom.SASIOMCommon.IServerAdministrationPackage.iomServerNotStoppable;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMCommon.IServerLogHelper;
import com.sas.iom.SASIOMDefs.AnySeqHelper;
import com.sas.iom.SASIOMDefs.AnySeqHolder;
import com.sas.iom.SASIOMDefs.BooleanSeqHelper;
import com.sas.iom.SASIOMDefs.DateTimeSeqHolder;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHelper;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.management.MetadataFactory;
import com.sas.management.servers.ConnectSpawnedServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.clients.ServerClientInterface;
import com.sas.management.servers.impl.ConnectSpawnedServerImpl;
import com.sas.management.servers.log.ServerLogFilter;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.log.ServerLogUtil;
import com.sas.management.servers.monitor.SpawnerMonitorInterface;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.management.servers.options.impl.IOMServerOptionImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.net.util.DateConverter;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.Credential;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.SecurityPackageCredential;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class ConnectSpawnerImpl
extends ConnectSpawnedServerImpl
implements SpawnerInterface,
SpawnerMonitorInterface {
    private ServerInterface[] m_serverArray = new ServerInterface[0];
    private SpawnerInterface m_spawner = null;
    private IConnectSpawnerAdministration m_admin = null;
    private IConnectSpawnerInformation m_info = null;
    private IServerAdministration m_serverAdmin = null;
    private IServerInformation m_serverInfo = null;
    private String m_strServerState = "Unknown";
    private ServerClientInterface[] m_clientArray = new ServerClientInterface[0];
    private ServerLogInterface m_logServer = null;
    private IServerLog m_serverLog = null;
    private ServerOptionInterface[] m_optionArray = new ServerOptionInterface[0];
    protected Logger m_spawnerLogger = Logger.getLogger("com.sas.management.servers.impl.ConnectSpawnerImpl");
    private ConnectionFactoryConfiguration m_cxfConfig = null;
    private int m_intServerCount = 0;
    private String m_strDomain = null;
    private UserContextInterface m_user = null;
    private PlatformConnectionFactoryInterface m_cxf = null;
    private ConnectionInterface m_cx = null;
    private static WAdminResource m_bundle = new WAdminResource(ConnectSpawnerImpl.class);
    private String m_strHost = "localhost";

    public ConnectSpawnerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
        this.initialize(metaConn);
    }

    public ConnectSpawnerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, hostID, serverParms, user);
        this.initialize(metaConn);
    }

    private void initialize(MetaServerConnection metaConn) {
        if (metaConn != null && this.getID() != null) {
            this.initializeMetadata();
        }
    }

    protected void initializeMetadata() {
        try {
            Machine machine;
            ServerComponent server = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerComponent><UsedByComponents/><SoftwareTrees/></ServerComponent><Tree><Members/></Tree></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerComponent", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerComponent)objectList.get(0);
                }
            }
            if ((machine = server.getAssociatedMachine()) != null) {
                this.m_strHost = machine.getName();
            }
            AssociationList usedbyComponentsList = server.getUsedByComponents();
            for (int compIndex = 0; compIndex < usedbyComponentsList.size(); ++compIndex) {
                ServerComponent component = (ServerComponent)usedbyComponentsList.get(compIndex);
                if (!ServerUtil.serverContainsHost(component, this.getHostID())) continue;
                ServerInterface s = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(component.getFQID(), this.getHostID()));
                if (s == null && component.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                    s = ServerFactory.newServer(this.getMetaConnection(), component.getFQID(), this.getHostID(), component.getClassIdentifier(), null, this.getUserContext());
                }
                if (s == null) continue;
                this.addServer(s);
            }
            this.setObjectState(1);
            for (int serverIndex = 0; serverIndex < this.getServers().length; ++serverIndex) {
                ServerInterface s = this.getServers()[serverIndex];
                if (s.getSpawner() == null || s.getSpawner().getObjectState() != 0) continue;
                s.setSpawner(this);
            }
        }
        catch (ServerException exc) {
            this.logServerException((Throwable)((java.lang.Object)exc));
        }
        catch (MdException exc) {
            this.logServerException(exc);
        }
        catch (RemoteException exc) {
            this.logServerException(exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws ServerException {
        if (this.isConnected()) {
            return;
        }
        boolean bContainsOperator = false;
        this.m_intServerCount = 0;
        String strHost = this.getHost();
        if (Workspace.isDebug()) {
            System.out.println("The host of the spawner is " + strHost);
        }
        int port = -1;
        String strAuthType = null;
        for (int connIndex = 0; connIndex < this.getConnections().length; ++connIndex) {
            com.sas.management.servers.connections.ConnectionInterface conn = this.getConnections()[connIndex];
            if (!conn.getApplicationProtocol().equalsIgnoreCase("Operator")) continue;
            bContainsOperator = true;
            port = conn.getPort();
            this.m_strDomain = conn.getAuthenticationDomain();
            strAuthType = conn.getAuthenticationType();
            break;
        }
        if (!bContainsOperator) {
            throw this.logServerException(m_bundle.getString("ObjectSpawnerImpl.NoOperatorConnection.txt"));
        }
        BridgeServer bridgeServer = new BridgeServer("00000000-0000-0000-0000-000000000000", strHost, port);
        bridgeServer.setDomain(this.m_strDomain);
        this.m_user = this.getUserContext();
        UserIdentityInterface userIdentity = null;
        try {
            if (strAuthType != null && strAuthType.equalsIgnoreCase("IWA")) {
                bridgeServer.setSecurityPackage("Negotiate");
                this.m_cxfConfig = new ManualConnectionFactoryConfiguration((Server)bridgeServer);
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                SecurityPackageCredential cred = SecurityPackageCredential.getInstance();
                this.m_cx = cxf.getConnection((Credential)cred);
            } else {
                this.m_cxfConfig = new ManualConnectionFactoryConfiguration((Server)bridgeServer);
                this.m_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                userIdentity = this.m_user.getAuthServer().generatePassword(null);
                if (userIdentity != null) {
                    String strUser = (String)userIdentity.getPrincipal();
                    this.m_cx = this.m_cxf.getConnection(strUser, (String)userIdentity.getCredential(), this.m_strDomain);
                }
            }
            this.setConnection(this.m_cx);
        }
        catch (ConnectionFactoryException connectionFactoryException) {
        }
        catch (ServiceException serviceException) {
        }
        catch (RemoteException remoteException) {
        }
        catch (SystemException systemException) {
        }
        finally {
            if (this.m_cx == null) {
                this.m_cx = this.connectFromDomain();
                this.setConnection(this.m_cx);
            }
        }
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    private ConnectionInterface connectFromDomain() throws ServerException {
        List lstIdentities = new ArrayList();
        ConnectionInterface cx = null;
        try {
            lstIdentities = this.m_user.getIdentitiesByDomain(this.m_strDomain, true, null);
            for (int idIndex = 0; idIndex < lstIdentities.size(); ++idIndex) {
                UserIdentityInterface m_userIdentity = (UserIdentityInterface)lstIdentities.get(idIndex);
                if (m_userIdentity == null) {
                    throw this.logServerException(m_bundle.getString("ServerImpl.NoCredentials.txt"));
                }
                String strUser = (String)m_userIdentity.getPrincipal();
                this.m_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                cx = this.m_cxf.getConnection(strUser, (String)m_userIdentity.getCredential(), this.m_strDomain);
            }
        }
        catch (RemoteException exc) {
            throw this.logServerException(exc);
        }
        catch (ServiceException exc) {
            throw this.logServerException(exc);
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        return cx;
    }

    private void setConnection(ConnectionInterface cx) {
        this.setServerConnection(cx);
        Object obj = cx.getObject();
        this.m_admin = IConnectSpawnerAdministrationHelper.narrow((Object)obj);
        this.m_info = IConnectSpawnerInformationHelper.narrow((Object)obj);
        this.m_serverAdmin = IServerAdministrationHelper.narrow((Object)obj);
        this.m_serverInfo = IServerInformationHelper.narrow((Object)obj);
        this.m_serverLog = IServerLogHelper.narrow((Object)obj);
    }

    @Override
    public void disconnect() throws ServerException {
        if (!this.isConnected()) {
            return;
        }
        ConnectionFactoryAdminInterface admin = null;
        try {
            this.m_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
            admin = this.m_cxf.getAdminInterface();
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        finally {
            if (this.m_cx != null) {
                this.m_cx.close();
                this.m_cx = null;
                this.cleanupUponLostConnection();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.getServerConnection() != null;
    }

    @Override
    public boolean isAdministrator() throws ServerException {
        boolean bIsAdmin = false;
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.m_serverInfo == null) {
            return bIsAdmin;
        }
        try {
            bIsAdmin = this.m_serverInfo.IsAdministrator();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return bIsAdmin;
    }

    @Override
    public void start() throws ServerException {
        throw new ServerException("Spawner does not support 'start'!");
    }

    @Override
    public void stop() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            this.m_serverAdmin.StopServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotStoppable exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void pause() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            this.m_serverAdmin.PauseServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotRunning exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void resume() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            this.m_serverAdmin.ContinueServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotPaused exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void quiesce() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            this.m_serverAdmin.DeferredStopServer();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        catch (iomServerNotStoppable exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void refresh() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            this.m_admin.Refresh();
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
    }

    @Override
    public void poll(int interval, int timeout) throws ServerException {
        ServerUtil.pollIOMServer(this, interval, timeout);
    }

    @Override
    protected void cleanupUponLostConnection() {
        this.setServerConnection(null);
        this.fireServerConnectedChanged();
        this.fireUnknownServerStateChanged();
    }

    @Override
    public String getState() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        if (!this.isAdministrator()) {
            return this.m_strServerState;
        }
        if (this.m_serverInfo == null) {
            return this.m_strServerState;
        }
        try {
            IFilteredList list = this.m_serverInfo.UseCategory("Information", "IOM.ServerState");
            String strColumns = new String("value");
            AnySeqHolder attrs = new AnySeqHolder();
            list.GetAttributes(strColumns, attrs);
            Any[] attrsArray = attrs.value;
            java.lang.Object[] lists = new java.lang.Object[1];
            try {
                for (int i = 0; i < attrsArray.length; ++i) {
                    Any anyValue = attrsArray[i];
                    TypeCode typecode = anyValue.type();
                    TCKind kind = typecode.kind();
                    int kindType = kind.value();
                    if (kindType != 21) continue;
                    if (typecode.name().equals(StringSeqHelper.type().name())) {
                        lists[i] = StringSeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (typecode.name().equals(AnySeqHelper.type().name())) {
                        lists[i] = AnySeqHelper.extract((Any)anyValue);
                        continue;
                    }
                    if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                    lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                }
                Any[] valuesArray = (Any[])lists[0];
                for (int valueIndex = 0; valueIndex < valuesArray.length; ++valueIndex) {
                    Any any = valuesArray[valueIndex];
                    java.lang.Object anyObj = ServerUtil.convertAnyToObject(any);
                    if (!(anyObj instanceof String)) continue;
                    this.m_strServerState = (String)anyObj;
                }
            }
            catch (BadKind error) {
                throw this.logServerException(error);
            }
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_strServerState;
    }

    @Override
    public ServerClientInterface[] getServerClients() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.m_serverAdmin == null || this.m_serverInfo == null) {
            return this.m_clientArray;
        }
        try {
            StringSeqHolder clients = new StringSeqHolder();
            StringSeqHolder clientHosts = new StringSeqHolder();
            DateTimeSeqHolder enterTimes = new DateTimeSeqHolder();
            this.m_serverAdmin.ListClients(clients, clientHosts, enterTimes);
            String[] clientsArray = clients.value;
            String[] clientHostsArray = clientHosts.value;
            long[] enterTimesArray = enterTimes.value;
            this.m_clientArray = new ServerClientInterface[clientsArray.length];
            for (int index = 0; index < clientsArray.length; ++index) {
                String strUser = clientsArray[index];
                String strHost = clientHostsArray[index];
                Calendar cdr = Calendar.getInstance();
                cdr.setTimeZone(TimeZone.getTimeZone("GMT"));
                DateConverter.corbaToJava((long)enterTimesArray[index], (Calendar)cdr);
                ServerClientInterface client = ServerFactory.newServerClient(this, strUser);
                client.setHost(strHost);
                client.setEntryTime(cdr);
                this.m_clientArray[index] = client;
            }
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_clientArray;
    }

    @Override
    public void setServerClients(ServerClientInterface[] clients) {
        this.m_clientArray = clients;
    }

    @Override
    public ServerLogInterface getServerLog(ServerLogFilter filter) throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        if (this.m_serverLog == null) {
            return this.m_logServer;
        }
        return ServerLogUtil.getServerLog(this, filter, this.m_serverLog, this.getHostID(), this.getLogger());
    }

    @Override
    public void setServerLog(ServerLogInterface log) {
        this.m_logServer = log;
    }

    @Override
    public ServerOptionInterface[] getServerOptions() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        try {
            Vector<ServerOptionInterface> optionList = new Vector<ServerOptionInterface>();
            String[] categoriesArray = this.m_serverInfo.ListCategories();
            for (int catIndex = 0; catIndex < categoriesArray.length; ++catIndex) {
                String strCategory = categoriesArray[catIndex];
                IFilteredList list = this.m_serverInfo.UseCategory(strCategory, "");
                String strColumns = new String("name description writeable value");
                AnySeqHolder attrs = new AnySeqHolder();
                list.GetAttributes(strColumns, attrs);
                Any[] attrsArray = attrs.value;
                java.lang.Object[] lists = new java.lang.Object[attrsArray.length];
                try {
                    for (int i = 0; i < attrsArray.length; ++i) {
                        Any anyValue = attrsArray[i];
                        TypeCode typecode = anyValue.type();
                        TCKind kind = typecode.kind();
                        int kindType = kind.value();
                        if (kindType != 21) continue;
                        if (typecode.name().equals(StringSeqHelper.type().name())) {
                            lists[i] = StringSeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (typecode.name().equals(AnySeqHelper.type().name())) {
                            lists[i] = AnySeqHelper.extract((Any)anyValue);
                            continue;
                        }
                        if (!typecode.name().equals(BooleanSeqHelper.type().name())) continue;
                        lists[i] = BooleanSeqHelper.extract((Any)anyValue);
                    }
                    String[] namesArray = (String[])lists[0];
                    String[] descsArray = (String[])lists[1];
                    boolean[] writeableArray = (boolean[])lists[2];
                    Any[] valuesArray = (Any[])lists[3];
                    for (int valueIndex = 0; valueIndex < valuesArray.length; ++valueIndex) {
                        String strName = namesArray[valueIndex];
                        String strDesc = descsArray[valueIndex];
                        boolean bWriteable = writeableArray[valueIndex];
                        String strValue = "";
                        Any any = valuesArray[valueIndex];
                        java.lang.Object anyObj = ServerUtil.convertAnyToObject(any);
                        int iType = 12;
                        if (anyObj instanceof Integer) {
                            iType = 4;
                        }
                        if (anyObj instanceof Boolean) {
                            iType = 16;
                        }
                        if (anyObj instanceof Date) {
                            iType = 91;
                            anyObj = new Long(((Date)anyObj).getTime());
                        }
                        strValue = anyObj.toString();
                        ServerOptionInterface option = ServerFactory.newServerOption(this, strName, iType, strValue);
                        option.setDesc(strDesc);
                        option.setIsWriteable(bWriteable);
                        optionList.add(option);
                        if (!(option instanceof IOMServerOptionImpl)) continue;
                        ((IOMServerOptionImpl)option).setCategory(strCategory);
                        ((IOMServerOptionImpl)option).setInfo(this.m_serverInfo);
                    }
                    continue;
                }
                catch (BadKind error) {
                    throw this.logServerException(error);
                }
            }
            this.m_optionArray = optionList.toArray(new ServerOptionInterface[0]);
        }
        catch (GenericError error) {
            throw this.logServerException(error);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_optionArray;
    }

    @Override
    public void setServerOptions(ServerOptionInterface[] options) {
        this.m_optionArray = options;
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        throw this.logServerValidatorException("Spawner does not support 'validation'!", "Simple", 1);
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
        throw this.logServerValidatorException("Spawner does not support 'validation'!", "Extended", 1);
    }

    @Override
    public ServerInterface[] getServers() {
        return this.m_serverArray;
    }

    @Override
    public void addServer(ServerInterface server) throws ServerException {
        if (server.getObjectState() == 1) {
            String strServerHost;
            if (!server.getType().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                throw new ServerException("Spawner only spawns connect server!");
            }
            String strSpawnerHost = this.getHost();
            if (!strSpawnerHost.equalsIgnoreCase(strServerHost = server.getHost())) {
                throw new ServerException("Spawner only spawns servers on the same host!");
            }
        }
        ServerInterface[] serverArray = new ServerInterface[this.m_serverArray.length + 1];
        for (int serverIndex = 0; serverIndex < this.m_serverArray.length; ++serverIndex) {
            ServerInterface s;
            serverArray[serverIndex] = s = this.m_serverArray[serverIndex];
        }
        serverArray[serverArray.length - 1] = server;
        this.m_serverArray = serverArray;
    }

    @Override
    public void removeServer(ServerInterface server) throws ServerException {
        boolean bContainsServer = false;
        for (int serverIndex = 0; serverIndex < this.m_serverArray.length; ++serverIndex) {
            ServerInterface s = this.m_serverArray[serverIndex];
            if (s != server) continue;
            bContainsServer = true;
            break;
        }
        if (!bContainsServer) {
            throw new ServerException("Server is not on list - cannot remove!");
        }
        ServerInterface[] serverArray = new ServerInterface[this.m_serverArray.length - 1];
        int index = -1;
        for (int serverIndex = 0; serverIndex < this.m_serverArray.length; ++serverIndex) {
            ServerInterface s = this.m_serverArray[serverIndex];
            if (s == server) continue;
            serverArray[++index] = s;
        }
        this.m_serverArray = serverArray;
    }

    @Override
    public int getServerCount() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to spawner!");
        }
        ConnectSpawnedServerInterface[] serverArray = this.getSpawnedServers();
        if (serverArray != null) {
            this.m_intServerCount = serverArray.length;
        }
        return this.m_intServerCount;
    }

    @Override
    public SpawnerInterface getSpawner() {
        return this;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
        this.m_spawner = spawner;
    }

    @Override
    public java.lang.Object getServerConnection() {
        return this.m_cx;
    }

    @Override
    public void setServerConnection(java.lang.Object connection) {
        if (connection != null && !(connection instanceof ConnectionInterface)) {
            throw new IllegalArgumentException("Argument 'connection' should be of type ConnectionInterface!");
        }
        this.m_cx = (ConnectionInterface)connection;
    }

    protected IConnectSpawnerInformation getInfo() {
        return this.m_info;
    }

    protected IConnectSpawnerAdministration getAdmin() {
        return this.m_admin;
    }

    @Override
    public void incrementServerCount() {
        ++this.m_intServerCount;
    }

    @Override
    public void decrementServerCount() {
        --this.m_intServerCount;
    }

    @Override
    public String getHost() {
        return this.m_strHost;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public String getServerName() {
        return this.getName();
    }

    @Override
    public void setUser(String user) {
    }

    @Override
    public void setServerName(String server) {
    }
}

