/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.MetadataFactory;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.servers.ApplicationServerInterface;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.user.UserContextInterface;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;

public class ApplicationServerImpl
extends MetadataImpl
implements ApplicationServerInterface {
    private LogicalServerInterface[] m_aryServers = new LogicalServerInterface[0];
    private Properties m_serverParms;
    private UserContextInterface m_usrContext = null;

    public ApplicationServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID);
        this.setMetaConnection(metaConn);
        this.setServerParms(serverParms);
        this.setUserContext(user);
        if (metaConn != null && this.getID() != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            ServerContext server = (ServerContext)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerContext><UsingComponents/></ServerContext></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerContext", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerContext)objectList.get(0);
                }
            }
            AssociationList usingComponentsList = server.getUsingComponents();
            for (int compIndex = 0; compIndex < usingComponentsList.size(); ++compIndex) {
                LogicalServer component = (LogicalServer)usingComponentsList.get(compIndex);
                LogicalServerInterface s = (LogicalServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(component.getFQID(), null));
                if (s == null) {
                    s = ServerFactory.newLogicalServer(this.getMetaConnection(), component.getFQID(), component.getClassIdentifier(), null, this.getUserContext());
                }
                if (s == null) continue;
                this.addLogicalServer(s);
            }
            this.setObjectState(1);
            for (int serverIndex = 0; serverIndex < this.getLogicalServers().length; ++serverIndex) {
                LogicalServerInterface s = this.getLogicalServers()[serverIndex];
                if (s.getApplicationServer() == null || s.getApplicationServer().getObjectState() != 0) continue;
                s.setApplicationServer(this);
            }
        }
        catch (ServerException exc) {
            ServerUtil.logServerException((Throwable)((Object)exc), this.getLogger());
        }
        catch (MdException exc) {
            ServerUtil.logServerException(exc, this.getLogger());
        }
        catch (RemoteException exc) {
            ServerUtil.logServerException(exc, this.getLogger());
        }
    }

    @Override
    public LogicalServerInterface[] getLogicalServers() {
        return this.m_aryServers;
    }

    @Override
    public void addLogicalServer(LogicalServerInterface server) throws ServerException {
        LogicalServerInterface[] aryServers = new LogicalServerInterface[this.m_aryServers.length + 1];
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            LogicalServerInterface svr;
            aryServers[serverIndex] = svr = this.m_aryServers[serverIndex];
        }
        aryServers[aryServers.length - 1] = server;
        this.m_aryServers = aryServers;
    }

    @Override
    public void deleteLogicalServer(LogicalServerInterface server) throws ServerException {
        boolean bContainsServer = false;
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            LogicalServerInterface svr = this.m_aryServers[serverIndex];
            if (svr != server) continue;
            bContainsServer = true;
            break;
        }
        if (!bContainsServer) {
            throw new ServerException("Logical Server is not on list - cannot remove!");
        }
        LogicalServerInterface[] aryServers = new LogicalServerInterface[this.m_aryServers.length - 1];
        int index = -1;
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            LogicalServerInterface svr = this.m_aryServers[serverIndex];
            if (svr == server) continue;
            aryServers[++index] = svr;
        }
        this.m_aryServers = aryServers;
    }

    public Properties getServerParms() {
        return this.m_serverParms;
    }

    public void setServerParms(Properties serverParms) {
        this.m_serverParms = serverParms;
    }

    public UserContextInterface getUserContext() {
        return this.m_usrContext;
    }

    public void setUserContext(UserContextInterface user) {
        this.m_usrContext = user;
    }
}

