/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.SpawnedServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.util.Properties;

public class ABMServerImpl
extends SpawnedServerImpl {
    private String m_strAuthDomain = "DefaultAuth";
    private String m_strHost = "localhost";
    private int m_port = 6785;
    private String m_strResource = "0";
    protected static WAdminResource bundle = new WAdminResource(ABMServerImpl.class);

    public ABMServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    public ABMServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, hostID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        int connIndex;
        ConnectionInterface[] connectionArray = this.getConnections();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_strAuthDomain = connectionArray[connIndex].getAuthenticationDomain();
            if (this.m_strAuthDomain != null) break;
        }
        this.m_strHost = this.getHost();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_port = connectionArray[connIndex].getPort();
            if (this.m_port > 0) break;
        }
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing("ABM", this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ConnectionFactoryAdminInterface admin;
        this.initialize();
        ManualConnectionFactoryConfiguration cxfConfig = null;
        com.sas.services.connection.ConnectionInterface cx = null;
        try {
            BridgeServer bridgeServer = new BridgeServer(this.getType(), this.m_strHost, this.m_port);
            bridgeServer.setDomain(this.m_strAuthDomain);
            bridgeServer.setOption("resource", this.m_strResource);
            cxfConfig = new ManualConnectionFactoryConfiguration((Server)bridgeServer);
            cx = ServerValidatorUtil.validateABMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, "ABM", this.m_strAuthDomain, this.getUserContext(), this.getLogger(), 1);
            admin = null;
        }
        catch (Throwable throwable) {
            ConnectionFactoryAdminInterface admin2 = null;
            try {
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory(cxfConfig);
                admin2 = cxf.getAdminInterface();
            }
            catch (ConnectionFactoryException exc) {
                throw this.logServerValidatorException(exc, "Extended", 1);
            }
            finally {
                if (cx != null) {
                    cx.close();
                }
                if (admin2 != null) {
                    admin2.shutdown();
                }
            }
            throw throwable;
        }
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
            admin = cxf.getAdminInterface();
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
        finally {
            if (cx != null) {
                cx.close();
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strResource;
            String strPort;
            String strHost;
            String strAuthDomain = (String)this.getServerParms().get("authdomain");
            if (strAuthDomain != null) {
                this.m_strAuthDomain = strAuthDomain;
            }
            if ((strHost = (String)this.getServerParms().get("host")) != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
            if ((strResource = (String)this.getServerParms().get("resource")) != null) {
                this.m_strResource = strResource;
            }
        }
    }
}

