/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.administrator;

import com.sas.management.impl.ModelImpl;
import com.sas.management.servers.ServerConnectionEvent;
import com.sas.management.servers.ServerConnectionListener;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.administrator.ServerStateEvent;
import com.sas.management.servers.administrator.ServerStateListener;
import com.sas.management.servers.administrator.ServerStateModelInterface;
import com.sas.management.servers.log.ServerLogEvent;
import com.sas.management.servers.log.ServerLogListener;
import com.sas.management.servers.log.ServerLogModelInterface;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import java.nio.channels.ClosedByInterruptException;
import java.util.Vector;

public class ServerStateModel
extends ModelImpl
implements ServerStateModelInterface,
ServerConnectionListener,
ServerLogListener {
    ServerAdministratorInterface m_server = null;
    private ServerConnectionModelInterface m_mdlConnState = null;
    private ServerLogModelInterface m_mdlLog = null;
    Thread m_thrPoll = null;

    public ServerStateModel(ServerAdministratorInterface server) {
        this.m_server = server;
        this.m_mdlConnState = ServerFactory.getServerConnectionModel((ServerInterface)((Object)server));
        this.m_mdlConnState.addServerConnectionListener(this);
    }

    public String getState() throws ServerException {
        return this.m_server.getState();
    }

    @Override
    public synchronized void addServerStateListener(ServerStateListener listener) {
        this.getListenerList().add(listener);
    }

    @Override
    public synchronized void removeServerStateListener(ServerStateListener listener) {
        this.getListenerList().remove(listener);
    }

    @Override
    public synchronized void fireServerStateChanged(ServerStateEvent event) {
        Vector listenerList = new Vector();
        listenerList.addAll(this.getListenerList());
        for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerStateListener listener = (ServerStateListener)listenerList.get(listenerIndex);
            listener.stateChanged(event);
        }
    }

    @Override
    public void stateChanged(ServerConnectionEvent event) {
        if (event.getState() == 1 && this.m_mdlLog == null && this.m_server instanceof ServerMonitorInterface) {
            try {
                if (!this.m_server.isAdministrator()) {
                    return;
                }
                this.m_mdlLog = ServerFactory.getServerLogModel((ServerMonitorInterface)((Object)this.m_server));
                this.m_mdlLog.addServerLogListener(this);
            }
            catch (ServerException exc) {
                this.getLogger().severe(exc.getLocalizedMessage());
            }
        }
        if (event.getState() == 0) {
            this.removeServerLogListener();
        }
    }

    @Override
    public synchronized void entryLogged(ServerLogEvent event) {
        String strName = event.getName();
        String strMessage = event.getMessage();
        if (strName.startsWith("Perf.ARM.IOM")) {
            String strState;
            if (strName.endsWith(".ServerAdministration.StopServer") || strName.endsWith(".Server.Stop")) {
                this.stopPolling();
                if (strMessage.indexOf("START") != -1) {
                    try {
                        strState = this.fireCurrentServerState();
                        if (!strState.equalsIgnoreCase("Stopped")) {
                            this.poll();
                        }
                    }
                    catch (ServerException exc) {
                        this.fireStoppedServerState();
                    }
                }
                if (strMessage.indexOf("STOP") != -1) {
                    try {
                        this.fireCurrentServerState();
                    }
                    catch (ServerException exc) {
                        ServerUtil.logServerException(exc.getLocalizedMessage(), ((ServerInterface)((Object)this.m_server)).getLogger());
                    }
                }
            }
            if (strName.endsWith(".ServerAdministration.DeferredStopServer")) {
                this.stopPolling();
                if (strMessage.indexOf("START") != -1) {
                    try {
                        strState = this.fireCurrentServerState();
                        if (!strState.equalsIgnoreCase("Stopped")) {
                            this.poll();
                        }
                    }
                    catch (ServerException exc) {
                        this.fireStoppedServerState();
                    }
                }
                if (strMessage.indexOf("STOP") != -1) {
                    try {
                        this.fireCurrentServerState();
                    }
                    catch (ServerException exc) {
                        ServerUtil.logServerException(exc.getLocalizedMessage(), ((ServerInterface)((Object)this.m_server)).getLogger());
                    }
                }
            }
            if ((strName.endsWith(".ServerAdministration.PauseServer") || strName.endsWith(".Server.Pause")) && (strMessage.indexOf("START") != -1 || strMessage.indexOf("STOP") != -1)) {
                try {
                    this.fireCurrentServerState();
                }
                catch (ServerException exc) {
                    ServerUtil.logServerException(exc.getLocalizedMessage(), ((ServerInterface)((Object)this.m_server)).getLogger());
                }
            }
            if ((strName.endsWith(".ServerAdministration.ContinueServer") || strName.endsWith(".Server.Resume")) && (strMessage.indexOf("START") != -1 || strMessage.indexOf("STOP") != -1)) {
                try {
                    this.fireCurrentServerState();
                }
                catch (ServerException exc) {
                    ServerUtil.logServerException(exc.getLocalizedMessage(), ((ServerInterface)((Object)this.m_server)).getLogger());
                }
            }
        }
    }

    private String fireCurrentServerState() throws ServerException {
        String strState = this.m_server.getState();
        ServerStateEvent stateEvent = new ServerStateEvent(this, strState);
        this.fireServerStateChanged(stateEvent);
        return strState;
    }

    void fireStoppedServerState() {
        ServerStateEvent stateEvt = new ServerStateEvent(this, "Stopped");
        this.fireServerStateChanged(stateEvt);
    }

    private void poll() {
        this.m_thrPoll = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerStateModel.this.m_server.poll(10000, 60000);
                }
                catch (ServerException exc) {
                    for (Throwable cause = exc.getTargetException(); cause != null; cause = cause.getCause()) {
                        if (!(cause instanceof ClosedByInterruptException)) continue;
                        return;
                    }
                    ServerStateModel.this.fireStoppedServerState();
                }
            }
        });
        this.m_thrPoll.setName("ServerPollingThread");
        this.m_thrPoll.start();
    }

    private void stopPolling() {
        if (this.m_thrPoll != null) {
            this.m_thrPoll.interrupt();
            this.m_thrPoll = null;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeServerLogListener();
        if (this.m_mdlConnState != null) {
            this.m_mdlConnState.removeServerConnectionListener(this);
            this.m_mdlConnState = null;
        }
    }

    private void removeServerLogListener() {
        if (this.m_mdlLog != null) {
            this.m_mdlLog.removeServerLogListener(this);
            this.m_mdlLog = null;
        }
    }
}

