/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers;

import com.sas.iom.SASIOMDefs.UUID;
import com.sas.iom.orb.UUIDConverter;
import com.sas.management.MetadataInterface;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.log.ServerLogUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.meta.SASOMI.ISecurity_1_1;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedDataPackage;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Identity;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Login;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.connection.omr.RemoteUtil;
import com.sas.services.connection.platform.mgmt.ServerMBeanUtil;
import com.sas.services.user.CallbackCancelledException;
import com.sas.util.ChainedExceptionInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StringHolder;

public class ServerUtil {
    private static Logger m_logger;
    protected static WAdminResource bundle;

    public static Properties getLogicalServerProperties(MetaServerConnection metaConn, Properties logicalServerProperties) throws MdException, RemoteException {
        Properties properties = logicalServerProperties;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        String strName = logicalServerProperties.getProperty("servername");
        String strID = logicalServerProperties.getProperty("serverid");
        if (strName == null && strID == null) {
            return properties;
        }
        String strReposID = metaConn.getReposId();
        if (strID != null) {
            strReposID = ServerUtil.getReposID(strID);
        }
        if (strReposID == null) {
            throw new MdException(bundle.getString("ServerFactory.NoReposID.txt"));
        }
        String strType = "LogicalServer";
        int flags = 396;
        String strTemplate = "<TEMPLATES><LogicalServer><Properties/><UsingComponents/></LogicalServer><ServerComponent><SourceConnections/></ServerComponent><TCPIPConnection><Domain/></TCPIPConnection></TEMPLATES>";
        String strXMLSelect = "";
        if (strName != null) {
            strXMLSelect = "<XMLSELECT search=\"LogicalServer[@Name='" + strName + "']\" />";
        }
        if (strID != null) {
            strXMLSelect = "<XMLSELECT search=\"LogicalServer[@Id='" + strID + "']\" />";
        }
        String strOptions = strTemplate + strXMLSelect;
        List logicalServersList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        block0: for (int lsIndex = 0; lsIndex < logicalServersList.size(); ++lsIndex) {
            LogicalServer logicalServer = (LogicalServer)logicalServersList.get(lsIndex);
            properties = ServerUtil.getServerComponentProperties((ServerComponent)logicalServer, properties);
            AssociationList usingComponentsList = logicalServer.getUsingComponents();
            block1: for (int serverIndex = 0; serverIndex < usingComponentsList.size(); ++serverIndex) {
                ServerComponent serverComponent = (ServerComponent)usingComponentsList.get(serverIndex);
                if (properties.containsKey("authdomain")) continue block0;
                AssociationList connectionsList = serverComponent.getSourceConnections();
                for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                    Connection connection = (Connection)connectionsList.get(connIndex);
                    if (!(connection instanceof TCPIPConnection)) continue;
                    AuthenticationDomain domain = connection.getDomain();
                    if (domain == null) continue block1;
                    properties.put("authdomain", domain.getName());
                    continue block1;
                }
            }
        }
        store.dispose();
        return properties;
    }

    public static Properties getServerProperties(MetaServerConnection metaConn, String strServerName) throws MdException, RemoteException {
        Properties properties = new Properties();
        properties.put("servername", strServerName);
        return ServerUtil.getServerProperties(metaConn, properties);
    }

    public static Properties getServerProperties(MetaServerConnection metaConn, Properties serverProperties) throws MdException, RemoteException {
        Properties properties = serverProperties;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        String strName = serverProperties.getProperty("servername");
        String strID = serverProperties.getProperty("serverid");
        if (strName == null && strID == null) {
            return properties;
        }
        String strReposID = metaConn.getReposId();
        if (strID != null) {
            strReposID = ServerUtil.getReposID(strID);
        }
        if (strReposID == null) {
            throw new MdException(bundle.getString("ServerFactory.NoReposID.txt"));
        }
        String strType = "ServerComponent";
        int flags = 396;
        String strTemplate = "<TEMPLATES><ServerComponent><SourceConnections/><DataPackages/><Properties/></ServerComponent><TCPIPConnection><Domain/><Properties/></TCPIPConnection><SASClientConnection><Domain/><Properties/></SASClientConnection></TEMPLATES>";
        String strXMLSelect = "";
        if (strName != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + strName + "']\" />";
        }
        if (strID != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Id='" + strID + "']\" />";
        }
        String strOptions = strTemplate + strXMLSelect;
        List serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        for (int serverIndex = 0; serverIndex < serversList.size(); ++serverIndex) {
            ServerComponent serverComponent = (ServerComponent)serversList.get(serverIndex);
            properties = ServerUtil.getServerComponentProperties(serverComponent, properties);
            AssociationList connectionsList = serverComponent.getSourceConnections();
            for (int connIndex = 0; connIndex < connectionsList.size(); ++connIndex) {
                Connection connection = (Connection)connectionsList.get(connIndex);
                properties = ServerUtil.getConnectionProperties(serverComponent, connection, properties);
            }
            AssociationList dataPackagesList = serverComponent.getDataPackages();
            for (int dpIndex = 0; dpIndex < dataPackagesList.size(); ++dpIndex) {
                DeployedDataPackage ddp = (DeployedDataPackage)dataPackagesList.get(dpIndex);
                properties = ServerUtil.getDataPackageProperties(serverComponent, ddp, properties);
            }
        }
        store.dispose();
        return properties;
    }

    private static Properties getServerComponentProperties(ServerComponent serverComponent, Properties serverProperties) throws MdException, RemoteException {
        return ServerUtil.getServerComponentProperties(serverComponent, serverProperties, true);
    }

    private static Properties getServerComponentProperties(ServerComponent serverComponent, Properties serverProperties, boolean bReplaceNameAndID) throws MdException, RemoteException {
        Properties properties = serverProperties;
        if (bReplaceNameAndID) {
            properties.put("servername", serverComponent.getName());
            properties.put("serverid", serverComponent.getFQID());
        }
        AssociationList serverPropertiesList = serverComponent.getProperties();
        for (int propIndex = 0; propIndex < serverPropertiesList.size(); ++propIndex) {
            Property serverProp = (Property)serverPropertiesList.get(propIndex);
            properties.put(serverProp.getPropertyName(), serverProp.getDefaultValue());
        }
        return properties;
    }

    private static Properties getConnectionProperties(ServerComponent serverComponent, Connection connection, Properties serverProperties) throws MdException, RemoteException {
        Properties properties = serverProperties;
        if (connection instanceof TCPIPConnection) {
            TCPIPConnection tcpConn = (TCPIPConnection)connection;
            if (tcpConn.getDomain() != null) {
                properties.put("authdomain", tcpConn.getDomain().getName());
            }
            properties.put("protocol", tcpConn.getApplicationProtocol());
            properties.put("host", tcpConn.getHostName());
            if ((serverComponent.getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") || serverComponent.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || serverComponent.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || serverComponent.getClassIdentifier().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") || serverComponent.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || serverComponent.getClassIdentifier().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) && !tcpConn.getApplicationProtocol().equalsIgnoreCase("Bridge")) {
                if (tcpConn.getApplicationProtocol().equalsIgnoreCase("MultiBridge")) {
                    int index = 0;
                    String strKey = "multibridge";
                    while (properties.containsKey(strKey)) {
                        strKey = "multibridge" + String.valueOf(++index);
                    }
                    properties.put(strKey, String.valueOf(tcpConn.getPort()));
                }
            } else {
                properties.put("port", String.valueOf(tcpConn.getPort()));
            }
        }
        if (connection instanceof SASClientConnection) {
            SASClientConnection sasConn = (SASClientConnection)connection;
            if (sasConn.getDomain() != null) {
                properties.put("authdomain", sasConn.getDomain().getName());
            }
            properties.put("host", sasConn.getRemoteAddress());
            properties.put("port", String.valueOf(sasConn.getPort()));
        }
        if (connection instanceof COMConnection) {
            COMConnection comConn = (COMConnection)connection;
            properties.put("host", comConn.getHostName());
        }
        AssociationList connPropertiesList = connection.getProperties();
        for (int propIndex = 0; propIndex < connPropertiesList.size(); ++propIndex) {
            Property connProp = (Property)connPropertiesList.get(propIndex);
            properties.put(connProp.getPropertyName(), connProp.getDefaultValue());
        }
        return properties;
    }

    private static Properties getDataPackageProperties(ServerComponent serverComponent, DeployedDataPackage ddp, Properties serverProperties) {
        try {
            Properties properties = serverProperties;
            if (ddp instanceof Directory) {
                Directory directory = (Directory)ddp;
                if (serverComponent.getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) {
                    int index = 1;
                    String strKey = "contentlocation";
                    while (properties.containsKey(strKey)) {
                        strKey = "contentlocation" + String.valueOf(++index);
                    }
                    properties.put(strKey, directory.getDirectoryName());
                }
            }
            return properties;
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            return null;
        }
    }

    public static PasswordAuthentication getCredentials(String strUserID, String strPassword) {
        PasswordAuthentication credentials = new PasswordAuthentication(strUserID, strPassword.toCharArray());
        return credentials;
    }

    public static String getReposID(String strObjectID) {
        return "A0000001." + strObjectID.substring(0, 8);
    }

    public static boolean supportsMultipleHosts(String serverType) {
        return serverType.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || serverType.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || serverType.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || serverType.equalsIgnoreCase("IOM Spawner") || serverType.equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39");
    }

    public static boolean supportsDAV(ServerComponent sc) throws MdException, RemoteException {
        AssociationList lstDataPackages = sc.getDataPackages();
        for (int dpIndex = 0; dpIndex < lstDataPackages.size(); ++dpIndex) {
            DeployedDataPackage ddp = (DeployedDataPackage)lstDataPackages.get(dpIndex);
            if (!(ddp instanceof Directory)) continue;
            Directory dir = (Directory)ddp;
            AssociationList propertyList = dir.getProperties();
            for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                Property prop = (Property)propertyList.get(propIndex);
                if (!prop.getPropertyName().equalsIgnoreCase("SupportsWebDAV") || !prop.getDefaultValue().equalsIgnoreCase("1")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDMVServer(ServerComponent sc) throws MdException, RemoteException {
        return ServerUtil.supportsHTTPApplicationType(sc, "DatafluxDMS") || ServerUtil.supportsHTTPApplicationType(sc, "POServer");
    }

    public static boolean supportsHTTPApplicationType(ServerComponent sc, String applicationType) throws MdException, RemoteException {
        if (sc == null) {
            return false;
        }
        AssociationList lstProperties = sc.getProperties();
        for (int pIndex = 0; pIndex < lstProperties.size(); ++pIndex) {
            Property prop = (Property)lstProperties.get(pIndex);
            if (!"SubType".equals(prop.getPropertyName())) continue;
            return prop.getDefaultValue().equals(applicationType);
        }
        return false;
    }

    public static Machine[] getHosts(ServerComponent sc) throws MdException, RemoteException {
        Vector<Machine> hostList = new Vector<Machine>(1);
        AssociationList treeList = sc.getSoftwareTrees();
        for (int treeIndex = 0; treeIndex < treeList.size(); ++treeIndex) {
            Tree tree = (Tree)treeList.get(treeIndex);
            if (!tree.getTreeType().equalsIgnoreCase("MachineGroup")) continue;
            AssociationList machineList = tree.getMembers();
            for (int machineIndex = 0; machineIndex < machineList.size(); ++machineIndex) {
                Machine machine = (Machine)machineList.get(machineIndex);
                if (machine == null) continue;
                hostList.add(machine);
            }
        }
        Machine[] hostArray = new Machine[]{};
        return hostList.toArray(hostArray);
    }

    public static boolean serverContainsHost(ServerComponent sc, String hostID) throws MdException, RemoteException {
        boolean bContainsHost = false;
        Machine[] machArray = ServerUtil.getHosts(sc);
        for (int machIndex = 0; machIndex < machArray.length; ++machIndex) {
            Machine machine = machArray[machIndex];
            if (!machine.getFQID().equalsIgnoreCase(hostID)) continue;
            bContainsHost = true;
            break;
        }
        return bContainsHost;
    }

    public static String getServerURI(ServerInterface server) {
        return ServerUtil.getURI(server);
    }

    public static String getServerURI(LogicalServerInterface server) {
        return ServerUtil.getURI(server);
    }

    private static String getURI(MetadataInterface server) throws IllegalArgumentException {
        if (!(server instanceof ServerInterface) && !(server instanceof LogicalServerInterface)) {
            throw new IllegalArgumentException("Argument 'server' is not a server or logical server!");
        }
        String strURIType = null;
        if (server instanceof ServerInterface) {
            strURIType = "ServerComponent";
        } else if (server instanceof LogicalServerInterface) {
            strURIType = "LogicalServer";
        }
        String strURIFQID = server.getID();
        return RemoteUtil.composeURI((String)strURIType, (String)strURIFQID);
    }

    public static int getBridgePort(ServerInterface server) {
        int port = -1;
        ConnectionInterface[] connectionArray = server.getConnections();
        for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            ConnectionInterface conn = connectionArray[connIndex];
            if (!conn.getApplicationProtocol().equals("Bridge")) continue;
            port = conn.getPort();
            break;
        }
        return port;
    }

    public static String formatCalendar(Calendar calendar) {
        String strCalendar = "";
        if (calendar != null) {
            strCalendar = ServerUtil.getDateFormat().format(calendar.getTime());
        }
        return strCalendar;
    }

    public static Date parseDate(String dateFormat) throws ParseException {
        return ServerUtil.getDateFormat().parse(dateFormat);
    }

    private static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance();
    }

    public static boolean isIOMServer(ServerInterface server) {
        boolean bIOMServer = false;
        if (server.getType().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") || server.getType().equalsIgnoreCase("MQPollingServer") || server.getType().equalsIgnoreCase("IOM Spawner") || server.getType().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6") || server.getType().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd") || server.getType().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || server.getType().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") || server.getType().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || server.getType().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc") || server.getType().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) {
            // empty if block
        }
        bIOMServer = true;
        return bIOMServer;
    }

    public static boolean isSpawner(ServerComponent serverComponent) throws RemoteException {
        return serverComponent.getClassIdentifier().equalsIgnoreCase("IOM Spawner") || serverComponent.getClassIdentifier().equalsIgnoreCase("Connect Spawner");
    }

    public static boolean containsPaths(ServerComponent serverComponent) throws RemoteException {
        return serverComponent.getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06");
    }

    public static boolean canBeManaged(ServerComponent sc) {
        boolean bManaged = false;
        try {
            if ((sc.getMajor() == 9 && sc.getMinor() >= 2 || sc.getMajor() > 9) && (sc.getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") || sc.getClassIdentifier().equalsIgnoreCase("IOM Spawner") || sc.getClassIdentifier().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6") || sc.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || sc.getClassIdentifier().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") || sc.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || sc.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc") || sc.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || sc.getClassIdentifier().equalsIgnoreCase("Connect Spawner") || sc.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06") || sc.getClassIdentifier().equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE"))) {
                bManaged = true;
            }
            if ((sc.getMajor() == 2 && sc.getMinor() >= 1 || sc.getMajor() > 2) && sc.getClassIdentifier().equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                bManaged = true;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bManaged;
    }

    public static boolean canBeValidated(ServerComponent sc) {
        boolean bValidated = false;
        try {
            if (sc.getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06") || sc.getClassIdentifier().equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836") || sc.getClassIdentifier().equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6") || sc.getClassIdentifier().equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd") || sc.getClassIdentifier().equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb") || sc.getClassIdentifier().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39") || sc.getClassIdentifier().equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06") || sc.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c") || sc.getClassIdentifier().equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c") || sc.getClassIdentifier().equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB") || sc.getClassIdentifier().equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE") || sc.getClassIdentifier().equalsIgnoreCase("SASInfrastructureData")) {
                bValidated = true;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
        return bValidated;
    }

    public static String getServerMapKey(String serverID, String hostID) {
        String strMapKey = serverID;
        if (serverID != null && hostID != null) {
            strMapKey = strMapKey + "/" + hostID;
        }
        return strMapKey;
    }

    public static void pollIOMServer(ServerAdministratorInterface server, int interval, int timeout) throws ServerException, IllegalArgumentException {
        if (!ServerUtil.isIOMServer((ServerInterface)((Object)server))) {
            throw new IllegalArgumentException("Argument 'server' is not an IOM server!");
        }
        if (interval > timeout) {
            throw new IllegalArgumentException("Argument 'interval' cannot exceed argument 'timeout'");
        }
        int TIMEOUT = timeout;
        int INTERVAL = interval;
        for (int iTotalTime = 0; iTotalTime < TIMEOUT; iTotalTime += INTERVAL) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (((ServerInterface)((Object)server)).getServerConnection() == null) {
                throw new ServerException("Lost connection!");
            }
            server.getState();
            try {
                Thread.sleep(INTERVAL);
                continue;
            }
            catch (InterruptedException exc) {
                return;
            }
        }
    }

    public static boolean compareHosts(String host1, String host2) {
        if (host1 == null || host2 == null) {
            return false;
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        try {
            InetAddress a1 = InetAddress.getByName(host1);
            InetAddress a2 = InetAddress.getByName(host2);
            boolean result = a1.equals(a2);
            return result;
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static String convertUUIDToString(UUID uuid) {
        return UUIDConverter.uuidToString((UUID)uuid);
    }

    public static UUID convertStringToUUID(String str) {
        return UUIDConverter.stringToUUID((String)str);
    }

    public static Object convertAnyToObject(Any any) {
        Object obj = null;
        try {
            obj = ServerMBeanUtil.anyObjectToObject((Any)any);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    public static Any convertObjectToAny(Object object, ORB orb) {
        Any any = ServerMBeanUtil.objectToAny((Object)object, (ORB)orb);
        return any;
    }

    public static ServerException logServerException(String message, Logger logger) {
        ServerException exc = new ServerException(message);
        ServerUtil.logChainedExceptionMessages((ChainedExceptionInterface)exc, logger);
        return exc;
    }

    public static ServerException logServerException(Throwable throwable, Logger logger) {
        ServerException exc = new ServerException(throwable);
        ServerUtil.logChainedExceptionMessages((ChainedExceptionInterface)exc, logger);
        return exc;
    }

    public static void logChainedExceptionMessages(ChainedExceptionInterface exception, Logger logger) {
        String strMessage;
        ArrayList<String> lstMessages = new ArrayList<String>(1);
        Throwable cause = exception.getTargetException();
        if (cause == null && (strMessage = ((Throwable)exception).getLocalizedMessage()) != null) {
            lstMessages.add(strMessage);
        }
        while (cause != null) {
            strMessage = cause.getLocalizedMessage();
            if (strMessage != null && !lstMessages.contains(strMessage)) {
                lstMessages.add(cause.getLocalizedMessage());
            }
            cause = cause.getCause();
        }
        Collections.reverse(lstMessages);
        for (int msgIndex = 0; msgIndex < lstMessages.size(); ++msgIndex) {
            String strMessage2 = (String)lstMessages.get(msgIndex);
            logger.severe(strMessage2);
        }
    }

    public static boolean isCallbackCancelledException(ChainedExceptionInterface exception) {
        if (exception instanceof CallbackCancelledException) {
            return true;
        }
        Throwable cause = exception.getTargetException();
        ChainedExceptionInterface chainedException = null;
        if (cause instanceof ChainedExceptionInterface && ((ChainedExceptionInterface)cause).getTargetException() instanceof ChainedExceptionInterface) {
            chainedException = (ChainedExceptionInterface)((ChainedExceptionInterface)cause).getTargetException();
        }
        while (cause != null) {
            if (cause instanceof CallbackCancelledException) {
                return true;
            }
            cause = cause.getCause();
        }
        if (chainedException != null) {
            return ServerUtil.isCallbackCancelledException(chainedException);
        }
        return false;
    }

    public static void printLog(String string) {
        ServerUtil.printLog(System.out, string, true);
    }

    public static void printLog(PrintStream stream, String string) {
        ServerUtil.printLog(stream, string, true);
    }

    public static void printLog(String string, boolean bDateTimeStamp) {
        ServerUtil.printLog(System.out, string, bDateTimeStamp);
    }

    public static void printLog(PrintStream stream, String string, boolean bDateTimeStamp) {
        if (bDateTimeStamp) {
            stream.println(new Date(System.currentTimeMillis()) + ": " + string);
        } else {
            stream.println(string);
        }
    }

    private static Logger getLogger() {
        if (m_logger == null) {
            m_logger = Logger.getLogger("com.sas.management.servers.ServerUtil");
            m_logger.setLevel(Level.ALL);
        }
        return m_logger;
    }

    public static PasswordAuthentication getLogin(MetaServerConnection metaConn, String strAuthDomain, String strReposID, Handler handler) throws MdException, RemoteException {
        PasswordAuthentication credentials = null;
        if (handler != null) {
            ServerLogUtil.addHandler(ServerUtil.getLogger(), handler);
        }
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        String strType = "AuthenticationDomain";
        int flags = 8588;
        String strTemplate = "<TEMPLATES><AuthenticationDomain><Logins/></AuthenticationDomain></TEMPLATES>";
        String strXMLSelect = "<XMLSELECT search=\"AuthenticationDomain[@Name='" + strAuthDomain + "']\" />";
        String strOptions = strTemplate + strXMLSelect;
        int domainIndex = 0;
        List authDomainsList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        if (domainIndex < authDomainsList.size()) {
            AuthenticationDomain domain = (AuthenticationDomain)authDomainsList.get(domainIndex);
            ArrayList<Login> loginsList = new ArrayList<Login>();
            AssociationList loginsFromDomainList = domain.getLogins();
            if (loginsFromDomainList.size() <= 1) {
                loginsList.addAll((Collection<Login>)loginsFromDomainList);
            }
            if (loginsList.size() == 0) {
                ISecurity_1_1 iSec = null;
                if (metaConn.getConnection() != null) {
                    try {
                        iSec = Workspace.getMdFactory().getConnection().MakeISecurityConnection(metaConn.getConnection());
                    }
                    catch (RemoteException exc) {
                        throw new MdException(exc.getLocalizedMessage());
                    }
                }
                StringHolder returnStrHolder = new StringHolder();
                try {
                    iSec.GetIdentity("", returnStrHolder);
                }
                catch (Exception exc) {
                    throw new MdException(exc.getLocalizedMessage());
                }
                Identity iIdentity = null;
                String retValue = returnStrHolder.value;
                if (retValue != null && !retValue.startsWith("UNKNOWN:") && retValue.startsWith("OMSOBJ:")) {
                    String strIDXMLSelect;
                    String objid = returnStrHolder.value.substring(returnStrHolder.value.lastIndexOf(47) + 1);
                    strType = "Identity";
                    strOptions = strIDXMLSelect = "<XMLSELECT search=\"*[@Id='" + objid + "']\" />";
                    List identityList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags |= 0x10, strOptions, true);
                    if (identityList.size() > 0) {
                        iIdentity = (Identity)identityList.get(0);
                    }
                }
                if (iIdentity != null) {
                    AssociationList lLoginsFromID = iIdentity.getLogins();
                    for (int lDomIndex = 0; lDomIndex < loginsFromDomainList.size(); ++lDomIndex) {
                        Login iLD = (Login)loginsFromDomainList.get(lDomIndex);
                        for (int lIDIndex = 0; lIDIndex < lLoginsFromID.size(); ++lIDIndex) {
                            Login iLP = (Login)lLoginsFromID.get(lIDIndex);
                            if (!iLD.getId().equals(iLP.getId())) continue;
                            loginsList.add(iLP);
                        }
                    }
                } else {
                    loginsList.addAll((Collection<Login>)loginsFromDomainList);
                }
            }
            if (loginsList.size() == 1) {
                Login iLogin = (Login)loginsList.get(0);
                if (iLogin.getPassword().equals("********")) {
                    String strMessage = bundle.getString("ServerUtil.NoCredentialsUnrestricted.txt");
                    ServerUtil.getLogger().severe(strMessage);
                    throw new MdException(strMessage);
                }
                credentials = ServerUtil.getCredentials(iLogin.getUserID(), iLogin.getPassword());
                ServerUtil.getLogger().info(bundle.formatString("ServerUtil.AcquiredCredentials.fmt.txt", (Object)iLogin.getUserID()));
            }
        }
        store.dispose();
        if (credentials == null) {
            ServerUtil.getLogger().info(bundle.getString("ServerUtil.CredentialsNotAcquired.txt"));
        }
        return credentials;
    }

    public static boolean isConnectSpawner(ServerInterface server) {
        boolean bIOMServer = false;
        if (server != null && server.getType().equalsIgnoreCase("Connect Spawner")) {
            bIOMServer = true;
        }
        return bIOMServer;
    }

    static {
        bundle = new WAdminResource(ServerUtil.class);
    }
}

