/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers;

import com.sas.iom.SASIOMDefs.UUID;
import com.sas.management.MetadataFactory;
import com.sas.management.MetadataInterface;
import com.sas.management.ModelInterface;
import com.sas.management.PathInterface;
import com.sas.management.PropertyInterface;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.impl.PathImpl;
import com.sas.management.servers.ApplicationServerInterface;
import com.sas.management.servers.ConnectSpawnedServerInterface;
import com.sas.management.servers.ContentServerInterface;
import com.sas.management.servers.InstanceServerInterface;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerConnectionModel;
import com.sas.management.servers.ServerConnectionModelInterface;
import com.sas.management.servers.ServerConnectorInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactoryEvent;
import com.sas.management.servers.ServerFactoryListener;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnedServerInterface;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.WorkspaceServerInterface;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.administrator.ServerStateModel;
import com.sas.management.servers.administrator.ServerStateModelInterface;
import com.sas.management.servers.clients.ServerClientInterface;
import com.sas.management.servers.clients.impl.ServerClientImpl;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.connections.impl.COMConnectionImpl;
import com.sas.management.servers.connections.impl.ConnectionImpl;
import com.sas.management.servers.connections.impl.SASConnectionImpl;
import com.sas.management.servers.connections.impl.TCPConnectionImpl;
import com.sas.management.servers.impl.ABMLogicalServerImpl;
import com.sas.management.servers.impl.ABMServerImpl;
import com.sas.management.servers.impl.ApplicationServerImpl;
import com.sas.management.servers.impl.CntSpawnedServerImpl;
import com.sas.management.servers.impl.ConnectServerImpl;
import com.sas.management.servers.impl.ConnectSpawnerImpl;
import com.sas.management.servers.impl.DMVHTTPServerImpl;
import com.sas.management.servers.impl.GridServerImpl;
import com.sas.management.servers.impl.IOMLogicalServerImpl;
import com.sas.management.servers.impl.InstanceServerImpl;
import com.sas.management.servers.impl.LogicalServerImpl;
import com.sas.management.servers.impl.MetadataLogicalServerImpl;
import com.sas.management.servers.impl.MetadataServerImpl;
import com.sas.management.servers.impl.OLAPLogicalServerImpl;
import com.sas.management.servers.impl.OLAPServerImpl;
import com.sas.management.servers.impl.OSSchedulerServerImpl;
import com.sas.management.servers.impl.ObjectSpawnerImpl;
import com.sas.management.servers.impl.PooledWorkspaceLogicalServerImpl;
import com.sas.management.servers.impl.PooledWorkspaceServerImpl;
import com.sas.management.servers.impl.PostgresServerImpl;
import com.sas.management.servers.impl.ProcessOrchestrationLogicalServerImpl;
import com.sas.management.servers.impl.ProcessOrchestrationServerImpl;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.servers.impl.StoredProcessLogicalServerImpl;
import com.sas.management.servers.impl.StoredProcessServerImpl;
import com.sas.management.servers.impl.TableServerImpl;
import com.sas.management.servers.impl.WebDAVServerImpl;
import com.sas.management.servers.impl.WorkspaceInstanceServerImpl;
import com.sas.management.servers.impl.WorkspaceLogicalServerImpl;
import com.sas.management.servers.impl.WorkspaceServerImpl;
import com.sas.management.servers.log.ServerLogInterface;
import com.sas.management.servers.log.ServerLogModel;
import com.sas.management.servers.log.ServerLogModelInterface;
import com.sas.management.servers.log.ServerLogUtil;
import com.sas.management.servers.log.impl.ServerLogImpl;
import com.sas.management.servers.monitor.ServerMonitorInterface;
import com.sas.management.servers.monitor.SpawnerModel;
import com.sas.management.servers.monitor.SpawnerModelInterface;
import com.sas.management.servers.monitor.SpawnerMonitorInterface;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.management.servers.options.ServerOptionModel;
import com.sas.management.servers.options.ServerOptionModelInterface;
import com.sas.management.servers.options.impl.IOMServerOptionImpl;
import com.sas.management.servers.options.impl.ServerOptionImpl;
import com.sas.management.servers.sessions.ServerSessionInterface;
import com.sas.management.servers.sessions.ServerSessionModel;
import com.sas.management.servers.sessions.ServerSessionModelInterface;
import com.sas.management.servers.sessions.impl.IOMServerSessionImpl;
import com.sas.management.servers.sessions.impl.ServerSessionImpl;
import com.sas.management.servers.validator.ServerValidatorInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdFactoryListener;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Handler;
import java.util.logging.Logger;

public class ServerFactory
implements MdFactoryListener {
    private static ServerFactory m_factory = new ServerFactory();
    private List<Object> m_serverClassList = new Vector<Object>(1);
    private static Map<String, MetadataInterface> m_serverMap = new HashMap<String, MetadataInterface>(1);
    private static Map<String, ServerSessionInterface> m_sessionMap = new HashMap<String, ServerSessionInterface>(1);
    private static Map<String, ServerLogInterface> m_logMap = new HashMap<String, ServerLogInterface>(1);
    private static Map<ServerConnectorInterface, ServerConnectionModelInterface> m_serverConnectionModelMap = new HashMap<ServerConnectorInterface, ServerConnectionModelInterface>(1);
    private static Map<ServerAdministratorInterface, ServerStateModelInterface> m_serverStateModelMap = new HashMap<ServerAdministratorInterface, ServerStateModelInterface>(1);
    private static Map<ServerMonitorInterface, ServerSessionModelInterface> m_serverSessionModelMap = new HashMap<ServerMonitorInterface, ServerSessionModelInterface>(1);
    private static Map<SpawnerMonitorInterface, SpawnerModelInterface> m_spawnerModelMap = new HashMap<SpawnerMonitorInterface, SpawnerModelInterface>(1);
    private static Map<ServerMonitorInterface, ServerLogModelInterface> m_serverLogModelMap = new HashMap<ServerMonitorInterface, ServerLogModelInterface>(1);
    private static Map<ServerMonitorInterface, ServerOptionModelInterface> m_serverOptionModelMap = new HashMap<ServerMonitorInterface, ServerOptionModelInterface>(1);
    private static MdObjectStore m_store = MetadataFactory.getStore();
    private static MdObjectStore m_otherStore = null;
    private static List<ServerFactoryListener> m_lstListeners = new Vector<ServerFactoryListener>(1);
    private static Map<ServerFactoryListener, String[]> m_mapListenerIDs = new HashMap<ServerFactoryListener, String[]>(1);
    private static boolean m_bFactoryInitialized = false;
    protected static WAdminResource bundle = new WAdminResource(ServerFactory.class);

    public static void initialize() {
        try {
            if (!m_bFactoryInitialized) {
                String[] aryTypes = new String[]{"ServerComponent", "LogicalServer", "TCPIPConnection", "SASClientConnection", "COMConnection", "Machine", "Directory", "Property"};
                MetadataFactory.getMdFactory().addMdFactoryListener((MdFactoryListener)m_factory, aryTypes);
                m_bFactoryInitialized = true;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public static ServerInterface newServer(MetaServerConnection metaConn, String ID, String type, Properties serverParms, UserContextInterface user) {
        return ServerFactory.newServer(metaConn, ID, null, type, serverParms, user);
    }

    public static ServerInterface newServer(MetaServerConnection metaConn, String ID, String hostID, String type, Properties serverParms, UserContextInterface user) {
        ServerImpl server;
        block39: {
            ServerComponent s3;
            server = null;
            if (metaConn != null) {
                m_serverMap.put(ServerUtil.getServerMapKey(ID, hostID), ServerFactory.newServer(null, ID, hostID, type, serverParms, user));
                try {
                    s3 = (ServerComponent)MetadataFactory.getStore().getObject(ID);
                    if (s3 == null) {
                        String strTemplate = "<TEMPLATES><ServerComponent><AssociatedMachine/><DataPackages/><Properties/><SoftwareTrees/><SourceConnections/><UsingPrototype/><UsingComponents/></ServerComponent><TCPIPConnection><Domain/><Properties/></TCPIPConnection><SASClientConnection><Domain/><Properties/></SASClientConnection><COMConnection><Domain/><Properties/></COMConnection><Tree><Members/></Tree><Directory><Properties/></Directory><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
                        String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + ID + "']\" />";
                        String strOptions = strTemplate + strXMLSelect;
                        int flags = 8604;
                        MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), metaConn.getReposId(), "ServerComponent", flags, strOptions, true);
                    }
                }
                catch (MdException s2) {
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            }
            if (type.equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) {
                try {
                    s3 = (ServerComponent)MetadataFactory.getStore().getObject(ID);
                    if (!ServerUtil.isDMVServer(s3)) {
                        server = new WebDAVServerImpl(metaConn, ID, serverParms, user);
                        break block39;
                    }
                    server = new DMVHTTPServerImpl(metaConn, ID, serverParms, user);
                }
                catch (MdException s3) {
                }
                catch (RemoteException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                }
            } else if (type.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
                server = new MetadataServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("IOM Spawner")) {
                server = new ObjectSpawnerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
                server = new OLAPServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("b379c9c1-89e0-4e72-ba43-6a416899b5dd")) {
                server = new OSSchedulerServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
                server = new PooledWorkspaceServerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) {
                server = new ProcessOrchestrationServerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
                server = new ConnectServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                server = new StoredProcessServerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("e803e04b-aaf0-4c74-86a6-f7008aa702dc")) {
                server = new TableServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) {
                server = new WorkspaceServerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("D7E796B4-654C-4ab3-B690-657EE79309FB")) {
                server = new GridServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("Connect Spawner")) {
                server = new ConnectSpawnerImpl(metaConn, ID, hostID, serverParms, user);
            } else if (type.equalsIgnoreCase("SASInfrastructureData")) {
                server = new PostgresServerImpl(metaConn, ID, serverParms, user);
            } else if (type.equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39")) {
                server = new ABMServerImpl(metaConn, ID, hostID, serverParms, user);
            }
        }
        if (server != null) {
            m_serverMap.put(ServerUtil.getServerMapKey(ID, hostID), server);
        }
        return server;
    }

    public static MetadataInterface removeServer(String key) {
        return ServerFactory.getServers().remove(key);
    }

    public static ServerValidatorInterface newServerValidator(ServerInterface server) {
        ServerValidatorInterface serverValidator = null;
        if (server instanceof ServerValidatorInterface) {
            serverValidator = (ServerValidatorInterface)((Object)server);
        }
        return serverValidator;
    }

    public static ServerValidatorInterface newLogicalServerValidator(LogicalServerInterface server) {
        ServerValidatorInterface serverValidator = null;
        if (server instanceof ServerValidatorInterface) {
            serverValidator = (ServerValidatorInterface)((Object)server);
        }
        return serverValidator;
    }

    public static ConnectionInterface newConnection(MetaServerConnection metaConn, ServerInterface server, String ID, int type) {
        ConnectionImpl connection = null;
        switch (type) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument 'type' should be one of the following: ConnectionInterface.TCP, ConnectionInterface.COM, ConnectionInterface.SAS");
            }
        }
        switch (type) {
            case 0: {
                connection = new TCPConnectionImpl(metaConn, server, ID);
                break;
            }
            case 1: {
                connection = new COMConnectionImpl(metaConn, server, ID);
                break;
            }
            case 2: {
                connection = new SASConnectionImpl(metaConn, server, ID);
            }
        }
        return connection;
    }

    public static ApplicationServerInterface newApplicationServer(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        ApplicationServerImpl server = null;
        if (metaConn != null) {
            m_serverMap.put(ID, ServerFactory.newApplicationServer(null, ID, serverParms, user));
            try {
                ServerContext scxt = (ServerContext)MetadataFactory.getStore().getObject(ID);
                if (scxt == null) {
                    String strTemplate = "<TEMPLATES><ServerContext/></TEMPLATES>";
                    String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + ID + "']\" />";
                    String strOptions = strTemplate + strXMLSelect;
                    int flags = 8604;
                    MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), metaConn.getReposId(), "ServerComponent", flags, strOptions, true);
                }
            }
            catch (MdException scxt) {
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        if ((server = new ApplicationServerImpl(metaConn, ID, serverParms, user)) != null) {
            m_serverMap.put(ID, server);
        }
        return server;
    }

    public static LogicalServerInterface newLogicalServer(MetaServerConnection metaConn, String ID, String type, Properties serverParms, UserContextInterface user) {
        IOMLogicalServerImpl server = null;
        if (metaConn != null) {
            m_serverMap.put(ID, ServerFactory.newLogicalServer(null, ID, type, serverParms, user));
            try {
                LogicalServer ls = (LogicalServer)MetadataFactory.getStore().getObject(ID);
                if (ls == null) {
                    String strTemplate = "<TEMPLATES><LogicalServer><UsingComponents/></LogicalServer><ServerComponent><SoftwareTrees/></ServerComponent><Tree><Members/></Tree></TEMPLATES>";
                    String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + ID + "']\" />";
                    String strOptions = strTemplate + strXMLSelect;
                    int flags = 8604;
                    MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), metaConn.getReposId(), "ServerComponent", flags, strOptions, true);
                }
            }
            catch (MdException ls) {
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        if (type.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
            server = new MetadataLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) {
            server = new WorkspaceLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("620963ee-32bf-4128-bf5f-4b0df8ff90eb")) {
            server = new PooledWorkspaceLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39")) {
            server = new ABMLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("94D98CD0-56C5-40A3-A140-49D21D17BDCE")) {
            server = new ProcessOrchestrationLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
            server = new StoredProcessLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (type.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
            server = new OLAPLogicalServerImpl(metaConn, ID, serverParms, user);
        }
        if (server != null) {
            m_serverMap.put(ID, server);
        }
        return server;
    }

    public static InstanceServerInterface newInstanceServer(SpawnedServerInterface server, UUID uuid, MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        InstanceServerImpl instanceServer = null;
        instanceServer = server instanceof WorkspaceServerInterface ? new WorkspaceInstanceServerImpl(server, uuid, metaConn, ID, hostID, serverParms, user) : new InstanceServerImpl(server, uuid, metaConn, ID, hostID, serverParms, user);
        return instanceServer;
    }

    public static ServerClientInterface newServerClient(ServerMonitorInterface server, String user) {
        ServerClientImpl client = new ServerClientImpl(server, user);
        return client;
    }

    public static ConnectSpawnedServerInterface newConnectSpawnedServer(ServerMonitorInterface server, String user) {
        CntSpawnedServerImpl cntspawnServer = new CntSpawnedServerImpl(server, user);
        return cntspawnServer;
    }

    public static ServerSessionInterface newServerSession(ServerMonitorInterface server, String sessionID, String owner) {
        ServerSessionImpl session = null;
        session = ServerUtil.isIOMServer((ServerInterface)((Object)server)) ? new IOMServerSessionImpl(server, sessionID, owner) : new ServerSessionImpl(server, sessionID, owner);
        m_sessionMap.put(session.getID(), session);
        return session;
    }

    public static ServerOptionInterface newServerOption(ServerMonitorInterface server, String name, int type, String value) {
        ServerOptionImpl option = null;
        option = ServerUtil.isIOMServer((ServerInterface)((Object)server)) ? new IOMServerOptionImpl(server, name, type, value) : new ServerOptionImpl(server, name, type, value);
        return option;
    }

    public static ServerLogInterface newServerLog(ServerMonitorInterface server) {
        ServerLogImpl log = new ServerLogImpl(server);
        m_logMap.put(((ServerInterface)((Object)server)).getID(), log);
        return log;
    }

    public static Map<String, MetadataInterface> getServers() {
        return m_serverMap;
    }

    public static ServerConnectionModelInterface getServerConnectionModel(ServerConnectorInterface server) {
        ServerConnectionModelInterface model = m_serverConnectionModelMap.get(server);
        if (model == null) {
            model = new ServerConnectionModel(server);
            m_serverConnectionModelMap.put(server, model);
        }
        return model;
    }

    public static ServerStateModelInterface getServerStateModel(ServerAdministratorInterface server) {
        ServerStateModelInterface model = m_serverStateModelMap.get(server);
        if (model == null) {
            model = new ServerStateModel(server);
            m_serverStateModelMap.put(server, model);
        }
        return model;
    }

    public static ServerSessionModelInterface getServerSessionModel(ServerMonitorInterface server) {
        ServerSessionModelInterface model = m_serverSessionModelMap.get(server);
        if (model == null) {
            model = new ServerSessionModel(server);
            m_serverSessionModelMap.put(server, model);
        }
        return model;
    }

    public static SpawnerModelInterface getSpawnerModel(SpawnerMonitorInterface server) {
        SpawnerModelInterface model = m_spawnerModelMap.get(server);
        if (model == null) {
            model = new SpawnerModel(server);
            m_spawnerModelMap.put(server, model);
        }
        return model;
    }

    public static ServerLogModelInterface getServerLogModel(ServerMonitorInterface server) {
        ServerLogModelInterface model = m_serverLogModelMap.get(server);
        if (model == null) {
            model = new ServerLogModel(server);
            m_serverLogModelMap.put(server, model);
        }
        return model;
    }

    public static ServerOptionModelInterface getServerOptionModel(ServerMonitorInterface server) {
        ServerOptionModelInterface model = m_serverOptionModelMap.get(server);
        if (model == null) {
            model = new ServerOptionModel();
            m_serverOptionModelMap.put(server, model);
        }
        return model;
    }

    public static Map<String, ServerSessionInterface> getServerSessions() {
        return m_sessionMap;
    }

    public static Map<String, ServerLogInterface> getServerLog() {
        return m_logMap;
    }

    public static MdObjectStore getStore() {
        if (m_otherStore != null) {
            return m_otherStore;
        }
        return m_store;
    }

    public static void setStore(MdObjectStore store) {
        m_otherStore = store;
        MetadataFactory.setStore(store);
    }

    public static synchronized void addServerFactoryListener(ServerFactoryListener listener) {
        ServerFactory.addServerFactoryListener(listener, null);
    }

    public static synchronized void addServerFactoryListener(ServerFactoryListener listener, String[] IDs) {
        m_lstListeners.add(listener);
        if (IDs != null) {
            m_mapListenerIDs.put(listener, IDs);
        }
    }

    public static synchronized void removeServerFactoryListener(ServerFactoryListener listener) {
        m_lstListeners.remove(listener);
        m_mapListenerIDs.remove(listener);
    }

    public static synchronized void fireServerAdded(ServerFactoryEvent event) {
        Vector<ServerFactoryListener> listenerList = new Vector<ServerFactoryListener>();
        listenerList.addAll(m_lstListeners);
        for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerFactoryListener listener = (ServerFactoryListener)listenerList.get(listenerIndex);
            listener.serverAdded(event);
        }
    }

    public static synchronized void fireServerModified(ServerFactoryEvent event) {
        Vector<ServerFactoryListener> listenerList = new Vector<ServerFactoryListener>();
        listenerList.addAll(m_lstListeners);
        block0: for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerFactoryListener listener = (ServerFactoryListener)listenerList.get(listenerIndex);
            if (m_mapListenerIDs.containsKey(listener)) {
                String[] aryIDs = m_mapListenerIDs.get(listener);
                for (int idIndex = 0; idIndex < aryIDs.length; ++idIndex) {
                    String strID = aryIDs[idIndex];
                    if (!strID.equalsIgnoreCase(event.getServerID())) continue;
                    listener.serverModified(event);
                    continue block0;
                }
                continue;
            }
            listener.serverModified(event);
        }
    }

    public static synchronized void fireServerDeleted(ServerFactoryEvent event) {
        Vector<ServerFactoryListener> listenerList = new Vector<ServerFactoryListener>();
        listenerList.addAll(m_lstListeners);
        block0: for (int listenerIndex = 0; listenerIndex < listenerList.size(); ++listenerIndex) {
            ServerFactoryListener listener = (ServerFactoryListener)listenerList.get(listenerIndex);
            if (m_mapListenerIDs.containsKey(listener)) {
                String[] aryIDs = m_mapListenerIDs.get(listener);
                for (int idIndex = 0; idIndex < aryIDs.length; ++idIndex) {
                    String strID = aryIDs[idIndex];
                    if (!strID.equalsIgnoreCase(event.getServerID())) continue;
                    listener.serverDeleted(event);
                    continue block0;
                }
                continue;
            }
            listener.serverDeleted(event);
        }
    }

    public synchronized void MdObjectsCreated(MdFactoryEvent evt) throws RemoteException {
        Map mapObject = evt.getObjectMap();
        if (mapObject == null) {
            return;
        }
        Object[] aryID = mapObject.keySet().toArray();
        for (int index = 0; index < aryID.length; ++index) {
            String strID = (String)aryID[index];
            String strType = (String)mapObject.get(strID);
            String strTemplate = null;
            if (strType.equalsIgnoreCase("ServerComponent")) {
                strTemplate = "<TEMPLATES><ServerComponent><AssociatedMachine/><DataPackages/><Properties/><SoftwareTrees/><SourceConnections/><UsingPrototype/><UsingComponents/></ServerComponent><TCPIPConnection><Domain/><Properties/></TCPIPConnection><SASClientConnection><Domain/><Properties/></SASClientConnection><COMConnection><Domain/><Properties/></COMConnection><Tree><Members/></Tree><Directory><Properties/></Directory><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("LogicalServer")) {
                strTemplate = "<TEMPLATES><LogicalServer><UsingComponents/></LogicalServer><ServerComponent><SoftwareTrees/></ServerComponent><Tree><Members/></Tree></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("TCPIPConnection")) {
                strTemplate = "<TEMPLATES><TCPIPConnection><Domain/><Properties/></TCPIPConnection><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("SASClientConnection")) {
                strTemplate = "<TEMPLATES><SASClientConnection><Domain/><Properties/></SASClientConnection><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("COMConnection")) {
                strTemplate = "<TEMPLATES><COMConnection><Domain/><Properties/></COMConnection><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("Machine")) {
                strTemplate = "<TEMPLATES><Machine/></TEMPLATES>";
            } else if (strType.equalsIgnoreCase("Directory")) {
                strTemplate = "<TEMPLATES><Directory><Properties/></Directory><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            } else {
                if (!strType.equalsIgnoreCase("Property")) continue;
                strTemplate = "<TEMPLATES><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
            }
            if (ServerFactory.getStore().getObject(strID) == null) {
                try {
                    String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + strID + "']\" />";
                    String strOptions = strTemplate + strXMLSelect;
                    int flags = 8604;
                    MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)ServerFactory.getStore(), ServerUtil.getReposID(strID), strType, flags, strOptions);
                }
                catch (MdException exc) {
                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    return;
                }
            }
            try {
                ServerFactoryEvent event;
                ServerFactoryEvent event2;
                String strHostID;
                Machine machine;
                String strServerComponentID;
                Root root = (Root)ServerFactory.getStore().getObject(strID);
                if (root instanceof ServerContext) continue;
                if (root instanceof LogicalServer) {
                    LogicalServer ls = (LogicalServer)root;
                    String strLogicalServerID = ls.getFQID();
                    AssociationList lstUsingComponentsList = ls.getUsingComponents();
                    for (int compIndex = 0; compIndex < lstUsingComponentsList.size(); ++compIndex) {
                        ServerComponent serverComponent = (ServerComponent)lstUsingComponentsList.get(compIndex);
                        strServerComponentID = serverComponent.getFQID();
                        Machine[] aryMachines = ServerUtil.getHosts(serverComponent);
                        String[] aryHostIDs = new String[aryMachines.length];
                        if (aryMachines.length == 0) {
                            aryHostIDs = new String[]{null};
                        }
                        for (int machIndex = 0; machIndex < aryMachines.length; ++machIndex) {
                            String strHostID2;
                            machine = aryMachines[machIndex];
                            aryHostIDs[machIndex] = strHostID2 = machine.getFQID();
                        }
                        for (int idIndex = 0; idIndex < aryHostIDs.length; ++idIndex) {
                            ServerInterface server;
                            strHostID = aryHostIDs[idIndex];
                            if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strServerComponentID, strHostID)) || (server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID, strHostID))) == null) continue;
                            LogicalServerInterface logicalServer = (LogicalServerInterface)ServerFactory.getServers().get(strLogicalServerID);
                            if (logicalServer == null && (logicalServer = ServerFactory.newLogicalServer(((ServerImpl)server).getMetaConnection(), strLogicalServerID, ls.getClassIdentifier(), null, ((ServerImpl)server).getUserContext())) != null) {
                                event2 = new ServerFactoryEvent((Object)this, logicalServer.getID(), null, logicalServer);
                                ServerFactory.fireServerAdded(event2);
                            }
                            if (logicalServer == null) continue;
                            server.setLogicalServer(logicalServer);
                        }
                    }
                    continue;
                }
                if (root instanceof ServerComponent) {
                    ServerComponent serverComponent = (ServerComponent)root;
                    String strServerComponentID2 = serverComponent.getFQID();
                    Machine[] aryMachines = ServerUtil.getHosts(serverComponent);
                    String[] aryHostIDs = new String[aryMachines.length];
                    if (aryMachines.length == 0) {
                        aryHostIDs = new String[]{null};
                    }
                    for (int machIndex = 0; machIndex < aryMachines.length; ++machIndex) {
                        String strHostID3;
                        Machine machine2 = aryMachines[machIndex];
                        aryHostIDs[machIndex] = strHostID3 = machine2.getFQID();
                    }
                    for (int idIndex = 0; idIndex < aryHostIDs.length; ++idIndex) {
                        SpawnerInterface spawner;
                        int compIndex;
                        ServerComponent usedbyComponent;
                        String strHostID4 = aryHostIDs[idIndex];
                        AssociationList lstUsedByComponents = serverComponent.getUsedByComponents();
                        if (lstUsedByComponents.size() > 0 && (usedbyComponent = (ServerComponent)lstUsedByComponents.get(0)) instanceof LogicalServer) {
                            LogicalServerInterface logicalServer;
                            LogicalServer logicalServerComponent = (LogicalServer)lstUsedByComponents.get(0);
                            String strLogicalServerID = logicalServerComponent.getFQID();
                            if (ServerFactory.getServers().containsKey(strLogicalServerID) && (logicalServer = (LogicalServerInterface)ServerFactory.getServers().get(strLogicalServerID)) != null) {
                                ServerInterface server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID2, strHostID4));
                                if (server == null && (server = ServerFactory.newServer(((LogicalServerImpl)logicalServer).getMetaConnection(), strServerComponentID2, strHostID4, serverComponent.getClassIdentifier(), null, ((LogicalServerImpl)logicalServer).getUserContext())) != null) {
                                    event2 = new ServerFactoryEvent((Object)this, server.getID(), null, server);
                                    ServerFactory.fireServerAdded(event2);
                                }
                                if (server != null) {
                                    try {
                                        logicalServer.addServer(server);
                                        event2 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                                        ServerFactory.fireServerModified(event2);
                                    }
                                    catch (ServerException exc) {
                                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                                    }
                                }
                            }
                        }
                        AssociationList lstUsingComponents = serverComponent.getUsingComponents();
                        for (compIndex = 0; compIndex < lstUsingComponents.size(); ++compIndex) {
                            ServerFactoryEvent event3;
                            DeployedComponent usingDeployedComponent = (DeployedComponent)lstUsingComponents.get(compIndex);
                            if (!(usingDeployedComponent instanceof ServerComponent)) continue;
                            ServerComponent usingComponent = (ServerComponent)usingDeployedComponent;
                            String strUsingComponentID = usingComponent.getFQID();
                            if (!ServerUtil.isSpawner(usingComponent) || (!ServerUtil.serverContainsHost(usingComponent, strHostID4) || !ServerUtil.serverContainsHost(serverComponent, strHostID4)) && !usingComponent.getAssociatedMachine().getName().equalsIgnoreCase(serverComponent.getAssociatedMachine().getName())) continue;
                            if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strUsingComponentID, strHostID4)) || (spawner = (SpawnerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strUsingComponentID, strHostID4))) == null) break;
                            ServerInterface server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID2, strHostID4));
                            if (server == null && (server = ServerFactory.newServer(((ServerImpl)((Object)spawner)).getMetaConnection(), strServerComponentID2, strHostID4, serverComponent.getClassIdentifier(), null, ((ServerImpl)((Object)spawner)).getUserContext())) != null) {
                                event3 = new ServerFactoryEvent((Object)this, server.getID(), null, server);
                                ServerFactory.fireServerAdded(event3);
                            }
                            if (server == null) break;
                            try {
                                spawner.addServer(server);
                                event3 = new ServerFactoryEvent((Object)this, spawner.getID(), spawner, spawner);
                                ServerFactory.fireServerModified(event3);
                            }
                            catch (ServerException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                            break;
                        }
                        if (!ServerUtil.isSpawner(serverComponent)) continue;
                        for (compIndex = 0; compIndex < lstUsedByComponents.size(); ++compIndex) {
                            ServerFactoryEvent event4;
                            ServerInterface spawnedServer;
                            ServerComponent spawnedServerComponent = (ServerComponent)lstUsedByComponents.get(compIndex);
                            String strSpawnedServerComponentID = spawnedServerComponent.getFQID();
                            if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strSpawnedServerComponentID, strHostID4)) || (spawnedServer = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strSpawnedServerComponentID, strHostID4))) == null) continue;
                            spawner = (SpawnerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID2, strHostID4));
                            if (spawner == null && (spawner = (SpawnerInterface)ServerFactory.newServer(((ServerImpl)spawnedServer).getMetaConnection(), strServerComponentID2, strHostID4, serverComponent.getClassIdentifier(), null, ((ServerImpl)spawnedServer).getUserContext())) != null) {
                                event4 = new ServerFactoryEvent((Object)this, spawner.getID(), null, spawner);
                                ServerFactory.fireServerAdded(event4);
                            }
                            if (spawner == null) continue;
                            spawnedServer.setSpawner(spawner);
                            event4 = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                            ServerFactory.fireServerModified(event4);
                        }
                    }
                    continue;
                }
                if (root instanceof Machine) {
                    Machine machine3 = (Machine)root;
                    String strHostID5 = machine3.getFQID();
                    AssociationList lstTrees = machine3.getTrees();
                    for (int treeIndex = 0; treeIndex < lstTrees.size(); ++treeIndex) {
                        Tree tree = (Tree)lstTrees.get(treeIndex);
                        if (!tree.getTreeType().equalsIgnoreCase("MachineGroup")) continue;
                        AssociationList lstSoftwareComponents = tree.getSoftwareComponents();
                        for (int compIndex = 0; compIndex < lstSoftwareComponents.size(); ++compIndex) {
                            SpawnerInterface spawner;
                            ServerComponent usedbyComponent;
                            ServerComponent serverComponent = (ServerComponent)lstSoftwareComponents.get(compIndex);
                            String strServerComponentID3 = serverComponent.getFQID();
                            AssociationList lstUsedByComponents = serverComponent.getUsedByComponents();
                            if (lstUsedByComponents.size() > 0 && (usedbyComponent = (ServerComponent)lstUsedByComponents.get(0)) instanceof LogicalServer) {
                                LogicalServerInterface logicalServer;
                                LogicalServer logicalServerComponent = (LogicalServer)lstUsedByComponents.get(0);
                                String strLogicalServerID = logicalServerComponent.getFQID();
                                if (ServerFactory.getServers().containsKey(strLogicalServerID) && (logicalServer = (LogicalServerInterface)ServerFactory.getServers().get(strLogicalServerID)) != null) {
                                    ServerFactoryEvent event5;
                                    ServerInterface server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID3, strHostID5));
                                    if (server == null && (server = ServerFactory.newServer(((LogicalServerImpl)logicalServer).getMetaConnection(), strServerComponentID3, strHostID5, serverComponent.getClassIdentifier(), null, ((LogicalServerImpl)logicalServer).getUserContext())) != null) {
                                        event5 = new ServerFactoryEvent((Object)this, server.getID(), null, server);
                                        ServerFactory.fireServerAdded(event5);
                                    }
                                    if (server != null) {
                                        try {
                                            logicalServer.addServer(server);
                                            event5 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                                            ServerFactory.fireServerModified(event5);
                                        }
                                        catch (ServerException exc) {
                                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                                        }
                                    }
                                }
                            }
                            AssociationList lstUsingComponents = serverComponent.getUsingComponents();
                            for (int ucIndex = 0; ucIndex < lstUsingComponents.size(); ++ucIndex) {
                                ServerFactoryEvent event6;
                                DeployedComponent usingDeployedComponent = (DeployedComponent)lstUsingComponents.get(ucIndex);
                                if (!(usingDeployedComponent instanceof ServerComponent)) continue;
                                ServerComponent usingComponent = (ServerComponent)usingDeployedComponent;
                                String strUsingComponentID = usingComponent.getFQID();
                                if (!ServerUtil.isSpawner(usingComponent) || (!ServerUtil.serverContainsHost(usingComponent, strHostID5) || !ServerUtil.serverContainsHost(serverComponent, strHostID5)) && !usingComponent.getAssociatedMachine().getName().equalsIgnoreCase(serverComponent.getAssociatedMachine().getName())) continue;
                                if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strUsingComponentID, strHostID5)) || (spawner = (SpawnerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strUsingComponentID, strHostID5))) == null) break;
                                ServerInterface server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID3, strHostID5));
                                if (server == null && (server = ServerFactory.newServer(((ServerImpl)((Object)spawner)).getMetaConnection(), strServerComponentID3, strHostID5, serverComponent.getClassIdentifier(), null, ((ServerImpl)((Object)spawner)).getUserContext())) != null) {
                                    event6 = new ServerFactoryEvent((Object)this, server.getID(), null, server);
                                    ServerFactory.fireServerAdded(event6);
                                }
                                if (server == null) break;
                                try {
                                    spawner.addServer(server);
                                    event6 = new ServerFactoryEvent((Object)this, spawner.getID(), spawner, spawner);
                                    ServerFactory.fireServerModified(event6);
                                }
                                catch (ServerException exc) {
                                    Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                                }
                                break;
                            }
                            if (!ServerUtil.isSpawner(serverComponent)) continue;
                            for (int ubcIndex = 0; ubcIndex < lstUsedByComponents.size(); ++ubcIndex) {
                                ServerInterface spawnedServer;
                                ServerComponent spawnedServerComponent = (ServerComponent)lstUsedByComponents.get(ubcIndex);
                                String strSpawnedServerComponentID = spawnedServerComponent.getFQID();
                                if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strSpawnedServerComponentID, strHostID5)) || (spawnedServer = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strSpawnedServerComponentID, strHostID5))) == null) continue;
                                spawner = (SpawnerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID3, strHostID5));
                                if (spawner == null && (spawner = (SpawnerInterface)ServerFactory.newServer(((ServerImpl)spawnedServer).getMetaConnection(), strServerComponentID3, strHostID5, serverComponent.getClassIdentifier(), null, ((ServerImpl)spawnedServer).getUserContext())) != null) {
                                    event = new ServerFactoryEvent((Object)this, spawner.getID(), null, spawner);
                                    ServerFactory.fireServerAdded(event);
                                }
                                if (spawner == null) continue;
                                spawnedServer.setSpawner(spawner);
                                event = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                                ServerFactory.fireServerModified(event);
                            }
                        }
                    }
                    continue;
                }
                if (root instanceof Connection) {
                    Connection conn = (Connection)root;
                    String strConnectionID = conn.getFQID();
                    DeployedComponent deployedComponent = conn.getSource();
                    if (!(deployedComponent instanceof ServerComponent)) continue;
                    ServerComponent serverComponent = (ServerComponent)deployedComponent;
                    String strServerComponentID4 = serverComponent.getFQID();
                    Machine[] aryMachines = ServerUtil.getHosts(serverComponent);
                    String[] aryHostIDs = new String[aryMachines.length];
                    if (aryMachines.length == 0) {
                        aryHostIDs = new String[]{null};
                    }
                    for (int machIndex = 0; machIndex < aryMachines.length; ++machIndex) {
                        Machine machine4 = aryMachines[machIndex];
                        aryHostIDs[machIndex] = strHostID = machine4.getFQID();
                    }
                    for (int idIndex = 0; idIndex < aryHostIDs.length; ++idIndex) {
                        ServerInterface server;
                        String strHostID6 = aryHostIDs[idIndex];
                        if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strServerComponentID4, strHostID6)) || (server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID4, strHostID6))) == null) continue;
                        int connType = -1;
                        if (conn instanceof TCPIPConnection) {
                            connType = 0;
                        }
                        if (conn instanceof SASClientConnection) {
                            connType = 2;
                        }
                        if (conn instanceof COMConnection) {
                            connType = 1;
                        }
                        ConnectionInterface connection = ServerFactory.newConnection(((ServerImpl)server).getMetaConnection(), server, strConnectionID, connType);
                        try {
                            server.addConnection(connection);
                            event2 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                            ServerFactory.fireServerModified(event2);
                            continue;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    continue;
                }
                if (root instanceof Directory) {
                    Directory directory = (Directory)root;
                    String strPathID = directory.getFQID();
                    String strPath = directory.getDirectoryName();
                    AssociationList lstDeployedComponents = directory.getDeployedComponents();
                    for (int compIndex = 0; compIndex < lstDeployedComponents.size(); ++compIndex) {
                        ContentServerInterface server;
                        DeployedComponent component = (DeployedComponent)lstDeployedComponents.get(compIndex);
                        if (!(component instanceof ServerComponent)) continue;
                        ServerComponent serverComponent = (ServerComponent)component;
                        String strServerComponentID5 = serverComponent.getFQID();
                        if (!ServerUtil.containsPaths(serverComponent) || !ServerFactory.getServers().containsKey(strServerComponentID5) || (server = (ContentServerInterface)ServerFactory.getServers().get(strServerComponentID5)) == null) continue;
                        PathInterface path = MetadataFactory.newPath(((ServerImpl)((Object)server)).getMetaConnection(), strPathID, strPath);
                        server.addPath(path);
                        ServerFactoryEvent event7 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event7);
                    }
                    continue;
                }
                if (!(root instanceof Property)) continue;
                Property prop = (Property)root;
                String strPropertyID = prop.getFQID();
                String strPropertyName = prop.getPropertyName();
                Root assocObject = prop.getAssociatedObject();
                if (assocObject instanceof ServerContext) continue;
                if (assocObject instanceof LogicalServer) {
                    LogicalServerInterface logicalServer;
                    LogicalServer ls = (LogicalServer)assocObject;
                    String strLogicalServerID = ls.getFQID();
                    if (!ServerFactory.getServers().containsKey(strLogicalServerID) || (logicalServer = (LogicalServerInterface)ServerFactory.getServers().get(strLogicalServerID)) == null) continue;
                    PropertyInterface property = MetadataFactory.newProperty(((LogicalServerImpl)logicalServer).getMetaConnection(), strPropertyID, strPropertyName);
                    logicalServer.addProperty(property);
                    ServerFactoryEvent event8 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                    ServerFactory.fireServerModified(event8);
                    continue;
                }
                if (assocObject instanceof ServerComponent) {
                    ServerComponent serverComponent = (ServerComponent)assocObject;
                    strServerComponentID = serverComponent.getFQID();
                    Machine[] aryMachines = ServerUtil.getHosts(serverComponent);
                    String[] aryHostIDs = new String[aryMachines.length];
                    if (aryMachines.length == 0) {
                        aryHostIDs = new String[]{null};
                    }
                    for (int machIndex = 0; machIndex < aryMachines.length; ++machIndex) {
                        String strHostID7;
                        machine = aryMachines[machIndex];
                        aryHostIDs[machIndex] = strHostID7 = machine.getFQID();
                    }
                    for (int idIndex = 0; idIndex < aryHostIDs.length; ++idIndex) {
                        ServerInterface server;
                        strHostID = aryHostIDs[idIndex];
                        if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strServerComponentID, strHostID)) || (server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID, strHostID))) == null) continue;
                        PropertyInterface property = MetadataFactory.newProperty(((ServerImpl)server).getMetaConnection(), strPropertyID, strPropertyName);
                        server.addProperty(property);
                        event2 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event2);
                    }
                    continue;
                }
                if (assocObject instanceof Connection) {
                    Connection conn = (Connection)assocObject;
                    String strConnectionID = conn.getFQID();
                    DeployedComponent deployedComponent = conn.getSource();
                    if (!(deployedComponent instanceof ServerComponent)) continue;
                    ServerComponent serverComponent = (ServerComponent)deployedComponent;
                    String strServerComponentID6 = serverComponent.getFQID();
                    Machine[] aryMachines = ServerUtil.getHosts(serverComponent);
                    String[] aryHostIDs = new String[aryMachines.length];
                    if (aryMachines.length == 0) {
                        aryHostIDs = new String[]{null};
                    }
                    for (int machIndex = 0; machIndex < aryMachines.length; ++machIndex) {
                        String strHostID8;
                        Machine machine5 = aryMachines[machIndex];
                        aryHostIDs[machIndex] = strHostID8 = machine5.getFQID();
                    }
                    block32: for (int idIndex = 0; idIndex < aryHostIDs.length; ++idIndex) {
                        ServerInterface server;
                        String strHostID9 = aryHostIDs[idIndex];
                        if (!ServerFactory.getServers().containsKey(ServerUtil.getServerMapKey(strServerComponentID6, strHostID9)) || (server = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(strServerComponentID6, strHostID9))) == null) continue;
                        ConnectionInterface[] aryConnections = server.getConnections();
                        for (int connIndex = 0; connIndex < aryConnections.length; ++connIndex) {
                            ConnectionInterface connection = aryConnections[connIndex];
                            if (!connection.getID().equalsIgnoreCase(strConnectionID)) continue;
                            PropertyInterface property = MetadataFactory.newProperty(((ConnectionImpl)connection).getMetaConnection(), strPropertyID, strPropertyName);
                            connection.addProperty(property);
                            ServerFactoryEvent event9 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                            ServerFactory.fireServerModified(event9);
                            continue block32;
                        }
                    }
                    continue;
                }
                if (!(assocObject instanceof Directory)) continue;
                Directory directory = (Directory)assocObject;
                String strPathID = directory.getFQID();
                AssociationList lstDeployedComponents = directory.getDeployedComponents();
                block34: for (int compIndex = 0; compIndex < lstDeployedComponents.size(); ++compIndex) {
                    ContentServerInterface server;
                    DeployedComponent component = (DeployedComponent)lstDeployedComponents.get(compIndex);
                    if (!(component instanceof ServerComponent)) continue;
                    ServerComponent serverComponent = (ServerComponent)component;
                    String strServerComponentID7 = serverComponent.getFQID();
                    if (!ServerUtil.containsPaths(serverComponent) || !ServerFactory.getServers().containsKey(strServerComponentID7) || (server = (ContentServerInterface)ServerFactory.getServers().get(strServerComponentID7)) == null) continue;
                    PathInterface[] aryPaths = server.getPaths();
                    for (int pathIndex = 0; pathIndex < aryPaths.length; ++pathIndex) {
                        PathInterface path = aryPaths[pathIndex];
                        if (!path.getID().equalsIgnoreCase(strPathID)) continue;
                        PropertyInterface property = MetadataFactory.newProperty(((PathImpl)path).getMetaConnection(), strPropertyID, strPropertyName);
                        path.addProperty(property);
                        event = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event);
                        continue block34;
                    }
                }
                continue;
            }
            catch (MdException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
    }

    public synchronized void MdObjectsDeleted(MdFactoryEvent evt) throws RemoteException {
        Map mapObject = evt.getObjectMap();
        if (mapObject == null) {
            return;
        }
        Object[] aryID = mapObject.keySet().toArray();
        block14: for (int index = 0; index < aryID.length; ++index) {
            String strID = (String)aryID[index];
            String strType = (String)mapObject.get(strID);
            if (strID.indexOf(36) != -1) continue;
            block15: for (String strServerID : ServerFactory.getMapCopy(ServerFactory.getServers()).keySet()) {
                ServerFactoryEvent event;
                PropertyInterface property;
                ConnectionInterface[] aryConnections;
                String strHostID;
                ServerFactoryEvent event2;
                SpawnerInterface spawner;
                ServerFactoryEvent event3;
                ServerInterface server;
                ServerInterface server2;
                MetadataInterface object = ServerFactory.getServers().get(strServerID);
                if (object == null) continue;
                if ((strType == null || strType.equalsIgnoreCase("LogicalServer")) && strServerID.equalsIgnoreCase(strID)) {
                    if (!(object instanceof LogicalServerInterface)) continue block14;
                    LogicalServerInterface logicalServer = (LogicalServerInterface)object;
                    ServerInterface[] aryServers = logicalServer.getServers();
                    for (int serverIndex = 0; serverIndex < aryServers.length; ++serverIndex) {
                        server2 = aryServers[serverIndex];
                        SpawnerInterface spawner2 = server2.getSpawner();
                        if (spawner2 != null) {
                            try {
                                spawner2.removeServer(server2);
                                ServerFactoryEvent event4 = new ServerFactoryEvent((Object)this, spawner2.getID(), spawner2, spawner2);
                                ServerFactory.fireServerModified(event4);
                            }
                            catch (ServerException exc) {
                                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                            }
                        }
                        String strHostID2 = ((ServerImpl)server2).getHostID();
                        ServerFactory.removeServer(ServerUtil.getServerMapKey(server2.getID(), strHostID2));
                        server2.dispose();
                        ServerFactoryEvent event5 = new ServerFactoryEvent((Object)this, server2.getID(), server2, null);
                        ServerFactory.fireServerDeleted(event5);
                    }
                    ServerFactory.removeServer(logicalServer.getID());
                    logicalServer.dispose();
                    ServerFactoryEvent event6 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, null);
                    ServerFactory.fireServerDeleted(event6);
                    continue block14;
                }
                if ((strType == null || strType.equalsIgnoreCase("ServerComponent")) && strServerID.startsWith(strID) && object instanceof ServerInterface) {
                    SpawnerInterface serverSpawner;
                    server = (ServerInterface)object;
                    LogicalServerInterface logicalServer = server.getLogicalServer();
                    if (logicalServer != null) {
                        try {
                            logicalServer.deleteServer(server);
                            ServerFactoryEvent event7 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                            ServerFactory.fireServerModified(event7);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if ((serverSpawner = server.getSpawner()) != null) {
                        try {
                            serverSpawner.removeServer(server);
                            event3 = new ServerFactoryEvent((Object)this, serverSpawner.getID(), serverSpawner, serverSpawner);
                            ServerFactory.fireServerModified(event3);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        spawner = (SpawnerInterface)server;
                        ServerInterface[] aryServers = spawner.getServers();
                        for (int serverIndex = 0; serverIndex < aryServers.length; ++serverIndex) {
                            ServerInterface spawnedServer = aryServers[serverIndex];
                            spawnedServer.setSpawner(null);
                            event2 = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                            ServerFactory.fireServerModified(event2);
                        }
                    }
                    strHostID = ((ServerImpl)server).getHostID();
                    ServerFactory.removeServer(ServerUtil.getServerMapKey(server.getID(), strHostID));
                    server.dispose();
                    ServerFactoryEvent event8 = new ServerFactoryEvent((Object)this, server.getID(), server, null);
                    ServerFactory.fireServerDeleted(event8);
                }
                if ((strType == null || strType.equalsIgnoreCase("Machine")) && strServerID.contains(strID) && object instanceof ServerInterface) {
                    SpawnerInterface serverSpawner;
                    server = (ServerInterface)object;
                    LogicalServerInterface logicalServer = server.getLogicalServer();
                    if (logicalServer != null) {
                        try {
                            logicalServer.deleteServer(server);
                            ServerFactoryEvent event9 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                            ServerFactory.fireServerModified(event9);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if ((serverSpawner = server.getSpawner()) != null) {
                        try {
                            serverSpawner.removeServer(server);
                            event3 = new ServerFactoryEvent((Object)this, serverSpawner.getID(), serverSpawner, serverSpawner);
                            ServerFactory.fireServerModified(event3);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        spawner = (SpawnerInterface)server;
                        ServerInterface[] aryServers = spawner.getServers();
                        for (int serverIndex = 0; serverIndex < aryServers.length; ++serverIndex) {
                            ServerInterface spawnedServer = aryServers[serverIndex];
                            spawnedServer.setSpawner(null);
                            event2 = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                            ServerFactory.fireServerModified(event2);
                        }
                    }
                    strHostID = ((ServerImpl)server).getHostID();
                    ServerFactory.removeServer(ServerUtil.getServerMapKey(server.getID(), strHostID));
                    server.dispose();
                    ServerFactoryEvent event10 = new ServerFactoryEvent((Object)this, server.getID(), server, null);
                    ServerFactory.fireServerDeleted(event10);
                }
                if ((strType == null || strType.equalsIgnoreCase("TCPIPConnection") || strType.equalsIgnoreCase("SASClientConnection") || strType.equalsIgnoreCase("COMConnection")) && object instanceof ServerInterface) {
                    server = (ServerInterface)object;
                    boolean bConnected = server.getServerConnection() != null;
                    boolean bDisposed = false;
                    aryConnections = server.getConnections();
                    for (int connIndex = 0; connIndex < aryConnections.length; ++connIndex) {
                        ConnectionInterface connection = aryConnections[connIndex];
                        if (!connection.getID().equalsIgnoreCase(strID)) continue;
                        try {
                            server.deleteConnection(connection);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                        connection.dispose();
                        bDisposed = true;
                        ServerFactoryEvent event11 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event11);
                        break;
                    }
                    if (bConnected && bDisposed) {
                        try {
                            server.disconnect();
                            if (MetadataFactory.getStore().getObject(server.getID()) != null) {
                                server.connect();
                            }
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                }
                if ((strType == null || strType.equalsIgnoreCase("Directory")) && object instanceof ContentServerInterface) {
                    server = (ContentServerInterface)object;
                    PathInterface[] aryPaths = server.getPaths();
                    for (int pathIndex = 0; pathIndex < aryPaths.length; ++pathIndex) {
                        PathInterface path = aryPaths[pathIndex];
                        if (!path.getID().equalsIgnoreCase(strID)) continue;
                        server.removePath(path);
                        path.dispose();
                        ServerFactoryEvent event12 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event12);
                        break;
                    }
                }
                if (strType != null && !strType.equalsIgnoreCase("Property")) continue;
                PropertyInterface[] aryProperties = object.getProperties();
                for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                    PropertyInterface property2 = aryProperties[propIndex];
                    if (!property2.getID().equalsIgnoreCase(strID)) continue;
                    object.deleteProperty(property2);
                    property2.dispose();
                    if (object instanceof ServerInterface) {
                        server2 = (ServerInterface)object;
                        ServerFactoryEvent event13 = new ServerFactoryEvent((Object)this, server2.getID(), server2, server2);
                        ServerFactory.fireServerModified(event13);
                        break;
                    }
                    if (!(object instanceof LogicalServerInterface)) break;
                    LogicalServerInterface logicalServer = (LogicalServerInterface)object;
                    ServerFactoryEvent event14 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                    ServerFactory.fireServerModified(event14);
                    break;
                }
                if (object instanceof ServerInterface) {
                    ServerInterface server3 = (ServerInterface)object;
                    boolean bFound = false;
                    aryConnections = server3.getConnections();
                    for (int connIndex = 0; connIndex < aryConnections.length; ++connIndex) {
                        ConnectionInterface connection = aryConnections[connIndex];
                        aryProperties = connection.getProperties();
                        for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                            property = aryProperties[propIndex];
                            if (!property.getID().equalsIgnoreCase(strID)) continue;
                            connection.deleteProperty(property);
                            property.dispose();
                            event = new ServerFactoryEvent((Object)this, server3.getID(), server3, server3);
                            ServerFactory.fireServerModified(event);
                            bFound = true;
                            break;
                        }
                        if (bFound) break;
                    }
                }
                if (!(object instanceof ContentServerInterface)) continue;
                ContentServerInterface server4 = (ContentServerInterface)object;
                boolean bFound = false;
                PathInterface[] aryPaths = server4.getPaths();
                for (int pathIndex = 0; pathIndex < aryPaths.length; ++pathIndex) {
                    PathInterface path = aryPaths[pathIndex];
                    aryProperties = path.getProperties();
                    for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                        property = aryProperties[propIndex];
                        if (!property.getID().equalsIgnoreCase(strID)) continue;
                        path.deleteProperty(property);
                        property.dispose();
                        event = new ServerFactoryEvent((Object)this, server4.getID(), server4, server4);
                        ServerFactory.fireServerModified(event);
                        bFound = true;
                        break;
                    }
                    if (bFound) continue block15;
                }
            }
        }
    }

    public synchronized void MdObjectsModified(MdFactoryEvent evt) throws RemoteException {
        Map mapObject = evt.getObjectMap();
        if (mapObject == null) {
            return;
        }
        Object[] aryID = mapObject.keySet().toArray();
        block26: for (int index = 0; index < aryID.length; ++index) {
            String strID = (String)aryID[index];
            String strType = (String)mapObject.get(strID);
            block27: for (String strServerID : ServerFactory.getMapCopy(ServerFactory.getServers()).keySet()) {
                ServerFactoryEvent event;
                ServerInterface spawnedServer;
                ServerInterface[] arySpawnedServers;
                ServerInterface spawnedServer2;
                int serverIndex;
                ServerInterface server;
                MetadataInterface object = ServerFactory.getServers().get(strServerID);
                if (object == null || strType.equalsIgnoreCase("ServerContext")) continue;
                if (strType.equalsIgnoreCase("LogicalServer")) {
                    ServerFactoryEvent event2;
                    ServerInterface server2;
                    int serverIndex2;
                    LogicalServerInterface logicalServer;
                    if (!strServerID.equalsIgnoreCase(strID) || !(object instanceof LogicalServerInterface)) continue;
                    LogicalServerInterface oldServer = logicalServer = (LogicalServerInterface)object;
                    ServerInterface[] aryServers = logicalServer.getServers();
                    for (serverIndex2 = 0; serverIndex2 < aryServers.length; ++serverIndex2) {
                        server2 = aryServers[serverIndex2];
                        server2.setLogicalServer(null);
                        event2 = new ServerFactoryEvent((Object)this, server2.getID(), server2, server2);
                        ServerFactory.fireServerModified(event2);
                    }
                    ServerFactory.removeServer(logicalServer.getID());
                    logicalServer.dispose();
                    logicalServer = ServerFactory.newLogicalServer(((LogicalServerImpl)logicalServer).getMetaConnection(), logicalServer.getID(), logicalServer.getType(), null, ((LogicalServerImpl)logicalServer).getUserContext());
                    if (logicalServer == null) continue block26;
                    aryServers = logicalServer.getServers();
                    for (serverIndex2 = 0; serverIndex2 < aryServers.length; ++serverIndex2) {
                        server2 = aryServers[serverIndex2];
                        server2.setLogicalServer(logicalServer);
                        event2 = new ServerFactoryEvent((Object)this, server2.getID(), server2, server2);
                        ServerFactory.fireServerModified(event2);
                    }
                    ServerFactoryEvent event3 = new ServerFactoryEvent((Object)this, logicalServer.getID(), oldServer, logicalServer);
                    ServerFactory.fireServerModified(event3);
                    continue block26;
                }
                if (strType.equalsIgnoreCase("ServerComponent")) {
                    if (!strServerID.startsWith(strID) || !(object instanceof ServerInterface)) continue;
                    ServerInterface oldServer = server = (ServerInterface)object;
                    LogicalServerInterface logicalServer = server.getLogicalServer();
                    boolean bServerDeletedFromLogicalServer = false;
                    if (logicalServer != null) {
                        try {
                            logicalServer.deleteServer(server);
                            bServerDeletedFromLogicalServer = true;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().info((Object)exc.getLocalizedMessage());
                        }
                    }
                    SpawnerInterface serverSpawner = server.getSpawner();
                    boolean bServerRemovedFromSpawner = false;
                    if (serverSpawner != null) {
                        try {
                            serverSpawner.removeServer(server);
                            bServerRemovedFromSpawner = true;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().info((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        SpawnerInterface spawner = (SpawnerInterface)server;
                        ServerInterface[] arySpawnedServers2 = spawner.getServers();
                        for (serverIndex = 0; serverIndex < arySpawnedServers2.length; ++serverIndex) {
                            spawnedServer2 = arySpawnedServers2[serverIndex];
                            spawnedServer2.setSpawner(null);
                            ServerFactoryEvent event4 = new ServerFactoryEvent((Object)this, spawnedServer2.getID(), spawnedServer2, spawnedServer2);
                            ServerFactory.fireServerModified(event4);
                        }
                    }
                    String strHostID = ((ServerImpl)server).getHostID();
                    ServerFactory.removeServer(ServerUtil.getServerMapKey(server.getID(), strHostID));
                    boolean bConnected = server.getServerConnection() != null;
                    server.dispose();
                    if ((server = ServerFactory.newServer(((ServerImpl)server).getMetaConnection(), server.getID(), strHostID, server.getType(), null, ((ServerImpl)server).getUserContext())) == null) continue;
                    if (bConnected) {
                        try {
                            server.connect();
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (logicalServer != null) {
                        try {
                            if (bServerDeletedFromLogicalServer) {
                                logicalServer.addServer(server);
                                ServerFactoryEvent event5 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                                ServerFactory.fireServerModified(event5);
                            }
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (serverSpawner != null) {
                        try {
                            if (bServerRemovedFromSpawner) {
                                serverSpawner.addServer(server);
                                ServerFactoryEvent event6 = new ServerFactoryEvent((Object)this, serverSpawner.getID(), serverSpawner, serverSpawner);
                                ServerFactory.fireServerModified(event6);
                            }
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        SpawnerInterface spawner = (SpawnerInterface)server;
                        arySpawnedServers = spawner.getServers();
                        for (int serverIndex3 = 0; serverIndex3 < arySpawnedServers.length; ++serverIndex3) {
                            spawnedServer = arySpawnedServers[serverIndex3];
                            spawnedServer.setSpawner(spawner);
                            event = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                            ServerFactory.fireServerModified(event);
                        }
                    }
                    ServerFactoryEvent event7 = new ServerFactoryEvent((Object)this, server.getID(), oldServer, server);
                    ServerFactory.fireServerModified(event7);
                    continue;
                }
                if (strType.equalsIgnoreCase("Machine")) {
                    if (!strServerID.contains(strID) || !(object instanceof ServerInterface)) continue;
                    ServerInterface oldServer = server = (ServerInterface)object;
                    LogicalServerInterface logicalServer = server.getLogicalServer();
                    boolean bServerDeletedFromLogicalServer = false;
                    if (logicalServer != null) {
                        try {
                            logicalServer.deleteServer(server);
                            bServerDeletedFromLogicalServer = true;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().info((Object)exc.getLocalizedMessage());
                        }
                    }
                    SpawnerInterface serverSpawner = server.getSpawner();
                    boolean bServerRemovedFromSpawner = false;
                    if (serverSpawner != null) {
                        try {
                            serverSpawner.removeServer(server);
                            bServerRemovedFromSpawner = true;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().info((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        SpawnerInterface spawner = (SpawnerInterface)server;
                        ServerInterface[] arySpawnedServers3 = spawner.getServers();
                        for (serverIndex = 0; serverIndex < arySpawnedServers3.length; ++serverIndex) {
                            spawnedServer2 = arySpawnedServers3[serverIndex];
                            spawnedServer2.setSpawner(null);
                            ServerFactoryEvent event8 = new ServerFactoryEvent((Object)this, spawnedServer2.getID(), spawnedServer2, spawnedServer2);
                            ServerFactory.fireServerModified(event8);
                        }
                    }
                    String strHostID = ((ServerImpl)server).getHostID();
                    ServerFactory.removeServer(ServerUtil.getServerMapKey(server.getID(), strHostID));
                    boolean bConnected = server.getServerConnection() != null;
                    server.dispose();
                    if ((server = ServerFactory.newServer(((ServerImpl)server).getMetaConnection(), server.getID(), strHostID, server.getType(), null, ((ServerImpl)server).getUserContext())) == null) continue;
                    if (bConnected) {
                        try {
                            server.connect();
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (logicalServer != null) {
                        try {
                            if (bServerDeletedFromLogicalServer) {
                                logicalServer.addServer(server);
                                ServerFactoryEvent event9 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                                ServerFactory.fireServerModified(event9);
                            }
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (serverSpawner != null) {
                        try {
                            if (bServerRemovedFromSpawner) {
                                serverSpawner.addServer(server);
                                ServerFactoryEvent event10 = new ServerFactoryEvent((Object)this, serverSpawner.getID(), serverSpawner, serverSpawner);
                                ServerFactory.fireServerModified(event10);
                            }
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                    }
                    if (server instanceof SpawnerInterface) {
                        SpawnerInterface spawner = (SpawnerInterface)server;
                        arySpawnedServers = spawner.getServers();
                        for (int serverIndex4 = 0; serverIndex4 < arySpawnedServers.length; ++serverIndex4) {
                            spawnedServer = arySpawnedServers[serverIndex4];
                            spawnedServer.setSpawner(spawner);
                            event = new ServerFactoryEvent((Object)this, spawnedServer.getID(), spawnedServer, spawnedServer);
                            ServerFactory.fireServerModified(event);
                        }
                    }
                    ServerFactoryEvent event11 = new ServerFactoryEvent((Object)this, server.getID(), oldServer, server);
                    ServerFactory.fireServerModified(event11);
                    continue;
                }
                if (strType.equalsIgnoreCase("TCPIPConnection") || strType.equalsIgnoreCase("SASClientConnection") || strType.equalsIgnoreCase("COMConnection")) {
                    if (!(object instanceof ServerInterface)) continue;
                    server = (ServerInterface)object;
                    boolean bConnected = server.getServerConnection() != null;
                    boolean bDisposed = false;
                    ConnectionInterface[] aryConnections = server.getConnections();
                    for (int connIndex = 0; connIndex < aryConnections.length; ++connIndex) {
                        ConnectionInterface connection = aryConnections[connIndex];
                        boolean bConnectionDeletedFromServer = false;
                        if (!connection.getID().equalsIgnoreCase(strID)) continue;
                        try {
                            server.deleteConnection(connection);
                            bConnectionDeletedFromServer = true;
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                        connection.dispose();
                        bDisposed = true;
                        connection = ServerFactory.newConnection(((ServerImpl)server).getMetaConnection(), server, connection.getID(), connection.getType());
                        if (!bConnectionDeletedFromServer) break;
                        try {
                            server.addConnection(connection);
                        }
                        catch (ServerException exc) {
                            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                        }
                        ServerFactoryEvent event12 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event12);
                        break;
                    }
                    if (!bConnected || !bDisposed) continue;
                    try {
                        server.disconnect();
                        if (MetadataFactory.getStore().getObject(server.getID()) == null) continue;
                        server.connect();
                    }
                    catch (ServerException exc) {
                        Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
                    }
                    continue;
                }
                if (strType.equalsIgnoreCase("Directory")) {
                    if (!(object instanceof ContentServerInterface)) continue;
                    server = (ContentServerInterface)object;
                    PathInterface[] aryPaths = server.getPaths();
                    for (int pathIndex = 0; pathIndex < aryPaths.length; ++pathIndex) {
                        PathInterface path = aryPaths[pathIndex];
                        if (!path.getID().equalsIgnoreCase(strID)) continue;
                        server.removePath(path);
                        path.dispose();
                        path = MetadataFactory.newPath(((ServerImpl)server).getMetaConnection(), path.getID(), path.getPath());
                        server.addPath(path);
                        ServerFactoryEvent event13 = new ServerFactoryEvent((Object)this, server.getID(), server, server);
                        ServerFactory.fireServerModified(event13);
                        continue block27;
                    }
                    continue;
                }
                if (!strType.equalsIgnoreCase("Property")) continue;
                PropertyInterface[] aryProperties = object.getProperties();
                for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                    PropertyInterface property = aryProperties[propIndex];
                    if (!property.getID().equalsIgnoreCase(strID)) continue;
                    object.deleteProperty(property);
                    property.dispose();
                    property = MetadataFactory.newProperty(((MetadataImpl)object).getMetaConnection(), property.getID(), property.getPropertyName());
                    object.addProperty(property);
                    if (object instanceof ServerInterface) {
                        ServerInterface server3 = (ServerInterface)object;
                        ServerFactoryEvent event14 = new ServerFactoryEvent((Object)this, server3.getID(), server3, server3);
                        ServerFactory.fireServerModified(event14);
                        break;
                    }
                    if (!(object instanceof LogicalServerInterface)) break;
                    LogicalServerInterface logicalServer = (LogicalServerInterface)object;
                    ServerFactoryEvent event15 = new ServerFactoryEvent((Object)this, logicalServer.getID(), logicalServer, logicalServer);
                    ServerFactory.fireServerModified(event15);
                    break;
                }
                if (object instanceof ServerInterface) {
                    ServerInterface server4 = (ServerInterface)object;
                    boolean bFound = false;
                    ConnectionInterface[] aryConnections = server4.getConnections();
                    for (int connIndex = 0; connIndex < aryConnections.length; ++connIndex) {
                        ConnectionInterface connection = aryConnections[connIndex];
                        aryProperties = connection.getProperties();
                        for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                            PropertyInterface property = aryProperties[propIndex];
                            if (!property.getID().equalsIgnoreCase(strID)) continue;
                            connection.deleteProperty(property);
                            property.dispose();
                            property = MetadataFactory.newProperty(((ServerImpl)server4).getMetaConnection(), property.getID(), property.getPropertyName());
                            connection.addProperty(property);
                            ServerFactoryEvent event16 = new ServerFactoryEvent((Object)this, server4.getID(), server4, server4);
                            ServerFactory.fireServerModified(event16);
                            bFound = true;
                            break;
                        }
                        if (bFound) break;
                    }
                }
                if (!(object instanceof ContentServerInterface)) continue;
                ContentServerInterface server5 = (ContentServerInterface)object;
                boolean bFound = false;
                PathInterface[] aryPaths = server5.getPaths();
                for (int pathIndex = 0; pathIndex < aryPaths.length; ++pathIndex) {
                    PathInterface path = aryPaths[pathIndex];
                    aryProperties = path.getProperties();
                    for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
                        PropertyInterface property = aryProperties[propIndex];
                        if (!property.getID().equalsIgnoreCase(strID)) continue;
                        path.deleteProperty(property);
                        property.dispose();
                        property = MetadataFactory.newProperty(((ServerImpl)((Object)server5)).getMetaConnection(), property.getID(), property.getPropertyName());
                        path.addProperty(property);
                        ServerFactoryEvent event17 = new ServerFactoryEvent((Object)this, server5.getID(), server5, server5);
                        ServerFactory.fireServerModified(event17);
                        bFound = true;
                        break;
                    }
                    if (bFound) continue block27;
                }
            }
        }
    }

    private static Map<String, MetadataInterface> getMapCopy(Map<String, MetadataInterface> map) {
        HashMap<String, MetadataInterface> mapCopy = new HashMap<String, MetadataInterface>();
        mapCopy.putAll(map);
        return mapCopy;
    }

    public static void dispose() {
        ModelInterface model;
        int index;
        m_lstListeners.clear();
        m_mapListenerIDs.clear();
        ServerFactory.removeMetadataFactoryListener();
        Map<String, MetadataInterface> serverMap = ServerFactory.getServers();
        Object[] serverArray = serverMap.keySet().toArray();
        for (int index2 = 0; index2 < serverArray.length; ++index2) {
            MetadataInterface server = serverMap.get(serverArray[index2]);
            if (server == null) continue;
            server.dispose();
            server = null;
        }
        Object[] modelArray = new Object[]{};
        modelArray = m_serverConnectionModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_serverConnectionModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        modelArray = m_serverStateModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_serverStateModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        modelArray = m_serverSessionModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_serverSessionModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        modelArray = m_spawnerModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_spawnerModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        modelArray = m_serverLogModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_serverLogModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        modelArray = m_serverOptionModelMap.keySet().toArray();
        for (index = 0; index < modelArray.length; ++index) {
            model = m_serverOptionModelMap.get(modelArray[index]);
            model.dispose();
            model = null;
        }
        m_serverMap.clear();
        m_sessionMap.clear();
        m_logMap.clear();
        m_serverConnectionModelMap.clear();
        m_serverStateModelMap.clear();
        m_serverSessionModelMap.clear();
        m_spawnerModelMap.clear();
        m_serverLogModelMap.clear();
        m_serverOptionModelMap.clear();
        MetadataFactory.dispose();
        try {
            if (m_store != null) {
                m_store.dispose();
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    private static void removeMetadataFactoryListener() {
        try {
            if (m_bFactoryInitialized) {
                MdObjectStore oStore = ServerFactory.getStore();
                if (oStore != null && !oStore.isDisposed()) {
                    MetadataFactory.getMdFactory().removeMdFactoryListener((MdFactoryListener)m_factory);
                }
                m_bFactoryInitialized = false;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    public static ServerInterface newServer(MetaServerConnection metaConn, String ID, String type, Properties serverParms, UserContextInterface user, Handler handler) {
        ServerInterface server = ServerFactory.newServer(metaConn, ID, type, serverParms, user);
        ServerLogUtil.addHandler(server.getLogger(), handler);
        return server;
    }

    public static ServerInterface newServer(MetaServerConnection metaConn, String ID, String hostID, String type, Properties serverParms, UserContextInterface user, Handler handler) {
        ServerInterface server = ServerFactory.newServer(metaConn, ID, hostID, type, serverParms, user);
        ServerLogUtil.addHandler(server.getLogger(), handler);
        return server;
    }

    public ConnectionInterface newConnection(MetaServerConnection metaConn, ServerInterface server, String ID, int type, Handler handler) {
        ConnectionInterface connection = ServerFactory.newConnection(metaConn, server, ID, type);
        ServerLogUtil.addHandler(connection.getLogger(), handler);
        return connection;
    }

    public static LogicalServerInterface newLogicalServer(MetaServerConnection metaConn, String ID, String type, Properties serverParms, UserContextInterface user, Handler handler) {
        LogicalServerInterface logicalServer = ServerFactory.newLogicalServer(metaConn, ID, type, serverParms, user);
        ServerLogUtil.addHandler(logicalServer.getLogger(), handler);
        return logicalServer;
    }

    public static InstanceServerInterface newInstanceServer(SpawnedServerInterface server, UUID uuid, MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user, Handler handler) {
        InstanceServerInterface instanceServer = ServerFactory.newInstanceServer(server, uuid, metaConn, ID, hostID, serverParms, user);
        ServerLogUtil.addHandler(Logger.getLogger(instanceServer.getClass().getName()), handler);
        return instanceServer;
    }

    public static ServerSessionInterface newServerSession(ServerMonitorInterface server, String sessionID, String owner, Handler handler) {
        ServerSessionInterface session = ServerFactory.newServerSession(server, sessionID, owner);
        ServerLogUtil.addHandler(session.getLogger(), handler);
        return session;
    }

    public static ServerSessionModelInterface getServerSessionModel(ServerMonitorInterface server, Handler handler) {
        ServerSessionModelInterface model = ServerFactory.getServerSessionModel(server);
        ServerLogUtil.addHandler(model.getLogger(), handler);
        return model;
    }

    public static SpawnerModelInterface getSpawnerModel(SpawnerMonitorInterface server, Handler handler) {
        SpawnerModelInterface model = ServerFactory.getSpawnerModel(server);
        ServerLogUtil.addHandler(model.getLogger(), handler);
        return model;
    }

    public static ServerLogModelInterface getServerLogModel(ServerMonitorInterface server, Handler handler) {
        ServerLogModelInterface model = ServerFactory.getServerLogModel(server);
        ServerLogUtil.addHandler(model.getLogger(), handler);
        return model;
    }

    public ServerValidatorInterface newServerValidator(MetaServerConnection metaConn, Properties serverProperties, PasswordAuthentication credentials, Handler handler) throws ServerException {
        String strServerType;
        ServerImpl server = null;
        String strID = (String)serverProperties.get("serverid");
        if (metaConn != null) {
            String strReposID = metaConn.getReposId();
            if (strID != null) {
                strReposID = ServerUtil.getReposID(strID);
            }
            if (strReposID == null) {
                throw new ServerException(bundle.formatString("ServerFactory.CannotCreateServer.fmt.txt", (Object)bundle.getString("ServerFactory.NoReposID.txt")));
            }
            try {
                String strAuthDomain;
                serverProperties = ServerUtil.getServerProperties(metaConn, serverProperties);
                if (credentials == null && (strAuthDomain = serverProperties.getProperty("authdomain")) != null) {
                    credentials = ServerUtil.getLogin(metaConn, strAuthDomain, strReposID, handler);
                }
            }
            catch (MdException exc) {
                throw new ServerException(exc);
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        if ((strServerType = serverProperties.getProperty("classidentifier")) == null) {
            throw new ServerException(bundle.formatString("ServerFactory.CannotCreateServer.fmt.txt", (Object)bundle.getString("ServerFactory.NoServerType.txt")));
        }
        if (strServerType.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
            server = new MetadataServerImpl(metaConn, strID, serverProperties, null);
        }
        if (strServerType.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) {
            server = new WorkspaceServerImpl(metaConn, strID, serverProperties, null);
        }
        if (strServerType.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
            server = new StoredProcessServerImpl(metaConn, strID, serverProperties, null);
        }
        if (strServerType.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
            server = new OLAPServerImpl(metaConn, strID, serverProperties, null);
        }
        if (strServerType.equalsIgnoreCase("028e4060-d545-11d5-880d-aa0004006d06")) {
            server = new ConnectServerImpl(metaConn, strID, serverProperties, null);
        }
        if (strServerType.equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) {
            server = new WebDAVServerImpl(metaConn, strID, serverProperties, null);
        }
        this.m_serverClassList.add(server);
        return server;
    }

    public ServerValidatorInterface newLogicalServerValidator(MetaServerConnection metaConn, Properties logicalServerProperties, UserContextInterface user, Handler handler) throws ServerException {
        String strLogicalServerType;
        IOMLogicalServerImpl server = null;
        String strID = null;
        if (metaConn != null) {
            String strReposID = metaConn.getReposId();
            strID = (String)logicalServerProperties.get("serverid");
            if (strID != null) {
                strReposID = ServerUtil.getReposID(strID);
            }
            if (strReposID == null) {
                throw new ServerException(bundle.formatString("ServerFactory.CannotCreateServer.fmt.txt", (Object)bundle.getString("ServerFactory.NoReposID.txt")));
            }
            try {
                logicalServerProperties = ServerUtil.getLogicalServerProperties(metaConn, logicalServerProperties);
                if (user == null) {
                    throw new ServerException(bundle.getString("ServerFactory.NoUserContext.txt"));
                }
            }
            catch (MdException exc) {
                throw new ServerException(exc);
            }
            catch (RemoteException exc) {
                Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            }
        }
        if ((strLogicalServerType = logicalServerProperties.getProperty("classidentifier")) == null) {
            throw new ServerException(bundle.formatString("ServerFactory.CannotCreateServer.fmt.txt", (Object)bundle.getString("ServerFactory.NoServerType.txt")));
        }
        if (strLogicalServerType.equalsIgnoreCase("0217e202-b560-11db-ad91-001083ff6836")) {
            server = new MetadataLogicalServerImpl(metaConn, strID, logicalServerProperties, user);
        }
        if (strLogicalServerType.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) {
            server = new WorkspaceLogicalServerImpl(metaConn, strID, logicalServerProperties, user);
        }
        if (strLogicalServerType.equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
            server = new StoredProcessLogicalServerImpl(metaConn, strID, logicalServerProperties, user);
        }
        if (strLogicalServerType.equalsIgnoreCase("f3f46472-1e31-11d5-87c2-00c04f38f9f6")) {
            server = new OLAPLogicalServerImpl(metaConn, strID, logicalServerProperties, user);
        }
        this.m_serverClassList.add(server);
        return server;
    }
}

