/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.impl;

import com.sas.management.MetadataException;
import com.sas.management.MetadataFactory;
import com.sas.management.MetadataInterface;
import com.sas.management.PropertyInterface;
import com.sas.management.impl.PropertyImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MetadataImpl
implements MetadataInterface {
    private String m_strID = null;
    private String m_strName = "Metadata";
    private String m_strDesc = "";
    private PropertyInterface[] m_propertiesArray = new PropertyInterface[0];
    private int m_iObjectState = 0;
    private boolean m_bDisposed = false;
    private MetaServerConnection m_metaConn;
    private Logger m_logger;

    public MetadataImpl(MetaServerConnection metaConn, String ID) {
        this.setMetaConnection(metaConn);
        this.setID(ID);
        this.setLogger(Logger.getLogger(this.getClass().getName()));
        this.getLogger().setLevel(Level.ALL);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            Root root = (Root)MetadataFactory.getStore().getObject(this.getID());
            if (root == null) {
                String strTemplate = "<TEMPLATES><Root><Properties/></Root></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "Root", flags, strOptions, true);
                if (objectList.size() > 0) {
                    root = (Root)objectList.get(0);
                }
            }
            this.setID(root.getFQID());
            this.setName(root.getName());
            this.setDesc(root.getDesc());
            if (root instanceof Property) {
                return;
            }
            AssociationList propertiesList = root.getProperties();
            PropertyInterface[] propertiesArray = new PropertyInterface[propertiesList.size()];
            for (int propIndex = 0; propIndex < propertiesList.size(); ++propIndex) {
                Property prop = (Property)propertiesList.get(propIndex);
                PropertyImpl property = new PropertyImpl(this.getMetaConnection(), prop.getFQID(), prop.getPropertyName());
                propertiesArray[propIndex] = property;
            }
            this.setProperties(propertiesArray);
        }
        catch (MdException exc) {
            MetadataException mdExc = new MetadataException(exc);
            this.getLogger().severe(mdExc.getLocalizedMessage());
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
    }

    @Override
    public String getID() {
        return this.m_strID;
    }

    @Override
    public String getName() {
        return this.m_strName;
    }

    @Override
    public String getDesc() {
        return this.m_strDesc;
    }

    @Override
    public PropertyInterface[] getProperties() {
        return this.m_propertiesArray;
    }

    @Override
    public int getObjectState() {
        return this.m_iObjectState;
    }

    @Override
    public void setID(String ID) {
        this.m_strID = ID;
    }

    @Override
    public void setName(String name) {
        this.m_strName = name;
    }

    @Override
    public void setDesc(String desc) {
        this.m_strDesc = desc;
    }

    @Override
    public void addProperty(PropertyInterface property) {
        PropertyInterface[] propertiesArray = new PropertyInterface[this.m_propertiesArray.length + 1];
        for (int propIndex = 0; propIndex < this.m_propertiesArray.length; ++propIndex) {
            PropertyInterface p;
            propertiesArray[propIndex] = p = this.m_propertiesArray[propIndex];
        }
        propertiesArray[propertiesArray.length - 1] = property;
        this.m_propertiesArray = propertiesArray;
    }

    @Override
    public void deleteProperty(PropertyInterface property) {
        PropertyInterface[] propertiesArray = new PropertyInterface[this.m_propertiesArray.length - 1];
        int index = -1;
        for (int propIndex = 0; propIndex < this.m_propertiesArray.length; ++propIndex) {
            PropertyInterface p = this.m_propertiesArray[propIndex];
            if (p == property) continue;
            propertiesArray[++index] = p;
        }
        this.m_propertiesArray = propertiesArray;
    }

    @Override
    public void setProperties(PropertyInterface[] properties) {
        this.m_propertiesArray = properties;
    }

    @Override
    public void setObjectState(int state) {
        switch (state) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Argument 'state' should be one of the following: MetadataInterface.STATE_PARTIAL, MetadataInterface.STATE_COMPLETE");
            }
        }
        this.m_iObjectState = state;
    }

    public boolean isUsingMetaConnection() {
        return this.m_metaConn != null;
    }

    public MetaServerConnection getMetaConnection() {
        return this.m_metaConn;
    }

    public void setMetaConnection(MetaServerConnection metaConn) {
        this.m_metaConn = metaConn;
    }

    @Override
    public Logger getLogger() {
        return this.m_logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isDisposed() {
        return this.m_bDisposed;
    }

    @Override
    public void dispose() {
        this.m_bDisposed = true;
    }
}

