/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management;

import com.sas.management.OptionInterface;
import com.sas.management.PathInterface;
import com.sas.management.PropertyInterface;
import com.sas.management.impl.OptionImpl;
import com.sas.management.impl.PathImpl;
import com.sas.management.impl.PropertyImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;

public class MetadataFactory {
    private static MdObjectStore m_store = null;
    private static MdObjectStore m_otherStore = null;
    private static MdFactory m_mdFactory = null;
    private static MdFactory m_otherMdFactory = null;

    private MetadataFactory() {
    }

    private static MdObjectStore createStore() {
        try {
            return MetadataFactory.getMdFactory().createObjectStore();
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
            return null;
        }
    }

    public static PropertyInterface newProperty(MetaServerConnection metaConn, String ID, String propertyName) {
        PropertyImpl property = new PropertyImpl(metaConn, ID, propertyName);
        return property;
    }

    public static PathInterface newPath(MetaServerConnection metaConn, String ID, String path) {
        PathImpl p = new PathImpl(metaConn, ID, path);
        return p;
    }

    public static OptionInterface newOption(String name, int type, String value) {
        OptionImpl option = new OptionImpl(name, type, value);
        return option;
    }

    public static MdObjectStore getStore() {
        if (m_otherStore != null) {
            return m_otherStore;
        }
        if (m_store == null) {
            m_store = MetadataFactory.createStore();
            return m_store;
        }
        return m_store;
    }

    public static void setStore(MdObjectStore store) {
        m_otherStore = store;
    }

    public static MdFactory getMdFactory() {
        if (m_otherMdFactory != null) {
            return m_otherMdFactory;
        }
        if (m_mdFactory == null) {
            m_mdFactory = Workspace.getMdFactory();
            return m_mdFactory;
        }
        return m_mdFactory;
    }

    public static void setMdFactory(MdFactory factory) {
        m_otherMdFactory = factory;
    }

    public static void dispose() {
        try {
            if (m_store != null) {
                m_store.dispose();
                m_store = null;
            }
            if (m_mdFactory != null) {
                m_mdFactory = null;
            }
        }
        catch (RemoteException exc) {
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }
}

