/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.saslog.client.types;

import com.sas.codepolicy.SASScope;
import com.sas.svcs.saslog.client.types.LogLineItemList;
import com.sas.util.Strings;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="SASLogSummary", propOrder={"sasErrors", "sasWarnings", "applicationErrors", "applicationMessages", "numLogLines", "numListingLines", "taskID"})
@SASScope
public class SASLogSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="SASErrors", required=true)
    private LogLineItemList sasErrors;
    @XmlElement(name="SASWarnings", required=true)
    private LogLineItemList sasWarnings;
    @XmlElement(name="ApplicationErrors", required=true)
    private LogLineItemList applicationErrors;
    @XmlElement(name="ApplicationMessages", required=true)
    private LogLineItemList applicationMessages;
    @XmlElement(name="NumLogLines")
    private int numLogLines;
    @XmlElement(name="NumListingLines")
    private int numListingLines;
    @XmlElement(name="TaskID", required=true)
    private String taskID;

    public LogLineItemList getSASErrors() {
        return this.sasErrors;
    }

    public void setSASErrors(LogLineItemList value) {
        this.sasErrors = value;
    }

    public LogLineItemList getSASWarnings() {
        return this.sasWarnings;
    }

    public void setSASWarnings(LogLineItemList value) {
        this.sasWarnings = value;
    }

    public LogLineItemList getApplicationErrors() {
        return this.applicationErrors;
    }

    public void setApplicationErrors(LogLineItemList value) {
        this.applicationErrors = value;
    }

    public LogLineItemList getApplicationMessages() {
        return this.applicationMessages;
    }

    public void setApplicationMessages(LogLineItemList value) {
        this.applicationMessages = value;
    }

    public int getNumLogLines() {
        return this.numLogLines;
    }

    public void setNumLogLines(int value) {
        this.numLogLines = value;
    }

    public int getNumListingLines() {
        return this.numListingLines;
    }

    public void setNumListingLines(int value) {
        this.numListingLines = value;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public void setTaskID(String value) {
        this.taskID = value;
    }

    public boolean equals(Object object) {
        boolean isEqual = false;
        if (object != null) {
            if (object == this) {
                isEqual = true;
            } else if (object instanceof SASLogSummary) {
                SASLogSummary other = (SASLogSummary)object;
                boolean bl = isEqual = Strings.equal((String)this.taskID, (String)other.getTaskID(), (boolean)false, (boolean)false) && this.numListingLines == other.numListingLines && this.numLogLines == other.numLogLines;
                if (isEqual) {
                    isEqual = this.isEqualSASErrors(other.sasErrors);
                }
                if (isEqual) {
                    isEqual = this.isEqualSASWarnings(other.sasWarnings);
                }
                if (isEqual) {
                    isEqual = this.isEqualApplicationErrors(other.applicationErrors);
                }
                if (isEqual) {
                    isEqual = this.isEqualApplicationMessages(other.applicationMessages);
                }
            }
        }
        return isEqual;
    }

    public int hashCode() {
        int prime = 17;
        int primeTaskID = 3;
        int primeApplicationErrors = 5;
        int primeApplicationMsgs = 7;
        int primeSASErrors = 11;
        int primeSASWarnings = 13;
        int hashCode = 17;
        hashCode = 17 * hashCode + Integer.valueOf(this.numListingLines).hashCode();
        hashCode = 17 * hashCode + Integer.valueOf(this.numLogLines).hashCode();
        hashCode = 17 * hashCode + (null == this.taskID ? 3 : this.taskID.hashCode());
        hashCode = 17 * hashCode + (null == this.applicationErrors ? 5 : this.applicationErrors.hashCode());
        hashCode = 17 * hashCode + (null == this.applicationMessages ? 7 : this.applicationMessages.hashCode());
        hashCode = 17 * hashCode + (null == this.sasErrors ? 11 : this.sasErrors.hashCode());
        hashCode = 17 * hashCode + (null == this.sasWarnings ? 13 : this.sasWarnings.hashCode());
        return hashCode;
    }

    private boolean isEqualApplicationErrors(LogLineItemList otherMessages) {
        return this.applicationErrors == null ? otherMessages == null : this.applicationErrors.equals(otherMessages);
    }

    private boolean isEqualApplicationMessages(LogLineItemList otherApplicationMessages) {
        return this.applicationMessages == null ? otherApplicationMessages == null : this.applicationMessages.equals(otherApplicationMessages);
    }

    private boolean isEqualSASErrors(LogLineItemList otherMessages) {
        return this.sasErrors == null ? otherMessages == null : this.sasErrors.equals(otherMessages);
    }

    private boolean isEqualSASWarnings(LogLineItemList otherMessages) {
        return this.sasWarnings == null ? otherMessages == null : this.sasWarnings.equals(otherMessages);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(super.toString());
        stringBuilder.append("[taskID=");
        stringBuilder.append(this.taskID);
        stringBuilder.append("][numLogLines=");
        stringBuilder.append(this.numLogLines);
        stringBuilder.append("][numListingLines=");
        stringBuilder.append(this.numListingLines);
        stringBuilder.append("][numSASErrors=");
        LogLineItemList logLineItemList = this.getSASErrors();
        int numErrors = null == logLineItemList ? 0 : logLineItemList.getItems().size();
        stringBuilder.append(numErrors);
        stringBuilder.append("][numSASWarnings=");
        logLineItemList = this.getSASWarnings();
        int numWarnings = null == logLineItemList ? 0 : logLineItemList.getItems().size();
        stringBuilder.append(numWarnings);
        stringBuilder.append("][numAppErrors=");
        logLineItemList = this.getApplicationErrors();
        int numAppErrors = null == logLineItemList ? 0 : logLineItemList.getItems().size();
        stringBuilder.append(numAppErrors);
        stringBuilder.append("][numAppMessages=");
        logLineItemList = this.getApplicationMessages();
        int numAppMessages = null == logLineItemList ? 0 : logLineItemList.getItems().size();
        stringBuilder.append(numAppMessages);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

