/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.server;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.ServerState;
import com.sas.svcs.metadata.mgmt.impl.RequestContext;
import com.sas.svcs.metadata.mgmt.impl.server.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Date;
import org.omg.CORBA.StringHolder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ServerStatusProcessor {
    private RequestContext context;
    private MetadataRepositoryService repositoryService;

    ServerStatusProcessor(RequestContext context, MetadataRepositoryService repositoryService) {
        this.context = context;
        this.repositoryService = repositoryService;
    }

    String getServerStateMessage() {
        try {
            return this.context.getFactory().getConnection().getPauseComment();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
    }

    ServerState getServerState() {
        Document doc;
        String serverState = " ";
        String pauseComment = " ";
        String modelVersion = " ";
        String platformVersion = " ";
        String alertEmail = " ";
        String startTime = " ";
        String serverPath = " ";
        String clusterState = " ";
        String definedNodes = " ";
        String currentNodes = " ";
        String hasQuorum = " ";
        String clusterGuid = " ";
        String serverStatusRequest = "<PauseComment/><ServerState/><ModelVersion/><PlatformVersion/><OMA ALERTEMAIL='' SERVER_STARTED='' CURRENT_TIME='' SERVERSTARTPATH=''/><ClusterState/><Cluster Defined_Nodes=\"\" Current_Nodes=\"\" Has_Quorum=\"\" ClusterGUID =\"\"/>";
        String statusResponseStr = "";
        String serverStatusOptions = "<Cluster/>";
        ServerState state = new ServerState();
        ServerState.Access access = ServerState.Access.OFFLINE;
        state.setAccess(access);
        try {
            statusResponseStr = this.getServerStateString("<PauseComment/><ServerState/><ModelVersion/><PlatformVersion/><OMA ALERTEMAIL='' SERVER_STARTED='' CURRENT_TIME='' SERVERSTARTPATH=''/><ClusterState/><Cluster Defined_Nodes=\"\" Current_Nodes=\"\" Has_Quorum=\"\" ClusterGUID =\"\"/>", "<Cluster/>");
            doc = this.context.getFactory().getOMIUtil().parseXML("<metadata>" + statusResponseStr + "</metadata>");
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        NodeList nodeList = doc.getElementsByTagName("PauseComment");
        Node node = nodeList.item(0);
        NodeList childList = node.getChildNodes();
        Node childNode = childList.item(0);
        if (childNode != null) {
            pauseComment = childNode.getNodeValue();
        }
        if ((childNode = (childList = (node = (nodeList = doc.getElementsByTagName("ServerState")).item(0)).getChildNodes()).item(0)) != null) {
            serverState = childNode.getNodeValue();
            access = serverState.equalsIgnoreCase("ONLINE") ? ServerState.Access.ONLINE : (serverState.equalsIgnoreCase("READONLY") ? ServerState.Access.READONLY : (serverState.equalsIgnoreCase("ADMIN") ? ServerState.Access.ADMIN : (serverState.equalsIgnoreCase("ADMIN(READONLY)") ? ServerState.Access.ADMIN_RO : (serverState.equalsIgnoreCase("OFFLINE") ? ServerState.Access.OFFLINE : (serverState.equalsIgnoreCase("RECOVERY") ? ServerState.Access.RECOVERY : (serverState.equalsIgnoreCase("NOQUOROM") ? ServerState.Access.NOQUOROM : (serverState.equalsIgnoreCase("STARTING") ? ServerState.Access.STARTING : ServerState.Access.OFFLINE)))))));
        }
        if ((childNode = (childList = (node = (nodeList = doc.getElementsByTagName("ModelVersion")).item(0)).getChildNodes()).item(0)) != null) {
            modelVersion = childNode.getNodeValue();
        }
        if ((childNode = (childList = (node = (nodeList = doc.getElementsByTagName("PlatformVersion")).item(0)).getChildNodes()).item(0)) != null) {
            platformVersion = childNode.getNodeValue();
        }
        nodeList = doc.getElementsByTagName("OMA");
        node = nodeList.item(0);
        Element OMAelement = (Element)node;
        alertEmail = OMAelement.getAttribute("ALERTEMAIL");
        startTime = OMAelement.getAttribute("SERVER_STARTED");
        serverPath = OMAelement.getAttribute("SERVERSTARTPATH");
        Date startDate = null;
        try {
            startDate = this.context.getFactory().getUtil().getDateForDoubleSASDateTimeString(startTime);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        String currentTime = OMAelement.getAttribute("CURRENT_TIME");
        Date currentDate = null;
        try {
            currentDate = this.context.getFactory().getUtil().getDateForDoubleSASDateTimeString(currentTime);
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        state.setAccess(access);
        state.setPauseComment(pauseComment);
        state.setModelVersion(modelVersion);
        state.setPlatformVersion(platformVersion);
        state.setAlertEmail(alertEmail);
        state.setServerPath(serverPath);
        if (startDate != null) {
            state.setStartedDate(startDate);
        }
        if (currentDate != null) {
            state.setCurrentDate(currentDate);
        }
        nodeList = doc.getElementsByTagName("ClusterState");
        node = nodeList.item(0);
        clusterState = node.getTextContent();
        nodeList = doc.getElementsByTagName("Cluster");
        node = nodeList.item(0);
        NamedNodeMap attrList = node.getAttributes();
        childNode = attrList.getNamedItem("Defined_Nodes");
        if (childNode != null) {
            definedNodes = childNode.getNodeValue();
        }
        if ((childNode = attrList.getNamedItem("Current_Nodes")) != null) {
            currentNodes = childNode.getNodeValue();
        }
        if ((childNode = attrList.getNamedItem("Has_Quorum")) != null) {
            hasQuorum = childNode.getNodeValue();
        }
        if ((childNode = attrList.getNamedItem("ClusterGUID")) != null) {
            clusterGuid = childNode.getNodeValue();
        }
        state.setClusterState(clusterState);
        state.setDefinedNodes(definedNodes);
        state.setCurrentNodes(currentNodes);
        state.setHasQuorum(hasQuorum);
        state.setClusterGUID(clusterGuid);
        return state;
    }

    ServerState setServerState(ServerState desiredState) {
        ServerState currentState = this.getServerState();
        int rc = 0;
        ServerState.Access desiredAccess = desiredState.getAccess();
        ServerState.Access newAccess = null;
        String newPauseComment = null;
        String newAlertEmail = null;
        if (currentState.getAccess().equals((Object)ServerState.Access.RECOVERY)) {
            throw new IllegalStateException(RB.getStringResource("ServerStatusProcessor.setState.error.inRecovery.txt"));
        }
        if (desiredAccess != null && desiredAccess.equals((Object)ServerState.Access.RECOVERY)) {
            throw new IllegalArgumentException(RB.getStringResource("ServerStatusProcessor.setState.error.recoverByRecovery.txt"));
        }
        if (desiredAccess != null && currentState.getAccess() != desiredAccess) {
            newAccess = desiredState.getAccess();
        }
        if (desiredState.getPauseComment() != null && !currentState.getPauseComment().equals(desiredState.getPauseComment())) {
            newPauseComment = desiredState.getPauseComment();
        }
        if (desiredState.getAlertEmail() != null && !currentState.getAlertEmail().equals(desiredState.getAlertEmail())) {
            newAlertEmail = desiredState.getAlertEmail();
        }
        if (newAccess == null && newPauseComment == null && newAlertEmail == null) {
            return currentState;
        }
        if (newAccess == null) {
            newAccess = currentState.getAccess();
        }
        String stateName = "";
        if (newAccess == ServerState.Access.ADMIN) {
            stateName = "ADMIN";
        } else if (newAccess == ServerState.Access.ONLINE) {
            stateName = "ONLINE";
        } else if (newAccess == ServerState.Access.READONLY) {
            stateName = "READONLY";
        } else if (newAccess == ServerState.Access.OFFLINE) {
            stateName = "OFFLINE";
        } else if (newAccess == ServerState.Access.ADMIN_RO) {
            stateName = "ADMIN(READONLY)";
        } else if (newAccess == ServerState.Access.RECOVERY) {
            stateName = "RECOVERY";
        } else if (newAccess == ServerState.Access.NOQUOROM) {
            stateName = "NOQUOROM";
        } else if (newAccess == ServerState.Access.STARTING) {
            stateName = "STARTING";
        }
        String pauseCommentXML = "";
        if (newPauseComment != null && newPauseComment.length() > 0) {
            pauseCommentXML = "<PAUSECOMMENT>" + newPauseComment + "</PAUSECOMMENT>";
        }
        String alertEmailXML = "";
        if (newAlertEmail != null && newAlertEmail.length() > 0) {
            alertEmailXML = "<OMA ALERTEMAIL=\"" + newAlertEmail + "\"/>";
        }
        try {
            switch (newAccess) {
                case ONLINE: {
                    rc = this.context.getIServer().Resume("<SERVER/> <CLUSTER/>");
                    if (rc == 0) break;
                    throw new RuntimeException(new Message(RB.getResources(), "ServerStatusProcessor.setState.error.nonZeroReturnCode.fmt", (Object)"Resume", (Object)new Integer(rc).toString()).toString());
                }
                case ADMIN: 
                case ADMIN_RO: 
                case READONLY: 
                case OFFLINE: {
                    rc = this.context.getIServer().Pause("<SERVER State=\"" + stateName + "\"/> <CLUSTER/>" + pauseCommentXML);
                    if (rc == 0) break;
                    throw new RuntimeException(new Message(RB.getResources(), "ServerStatusProcessor.setState.error.nonZeroReturnCode.fmt", (Object)"Pause", (Object)new Integer(rc).toString()).toString());
                }
            }
            if (!alertEmailXML.equalsIgnoreCase("")) {
                this.context.getIServer().Refresh("<CLUSTER/> " + alertEmailXML);
            }
        }
        catch (GenericError e) {
            throw new RuntimeException(e);
        }
        this.repositoryService.clearRepositoryCache();
        ServerState newState = this.getServerState();
        if (desiredAccess != null && desiredAccess != newState.getAccess()) {
            throw new RuntimeException(new Message(RB.getResources(), "ServerStatusProcessor.setState.error.stateNotAchieved.fmt", (Object)stateName).toString());
        }
        return newState;
    }

    String getServerStateString(String input, String options) {
        StringHolder response = new StringHolder();
        try {
            this.context.getIServer().Status(input, response, options);
        }
        catch (GenericError e) {
            throw new RuntimeException(e);
        }
        String outputStr = response.value;
        return outputStr;
    }
}

