/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AuthenticationDomain;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.logging.log4j.Logger;

public class VerifyAuthenticationDomains
extends AbstractToolImpl {
    static final String NAME = RB.getStringResource("VerifyAuthenticationDomains.tool.name.txt");
    static final String DESCRIPTION = RB.getStringResource("VerifyAuthenticationDomains.tool.desc.txt");
    static final String ID = "AuthDomains";
    private static AnalysisTool _factoryInstance;
    private Set<String> _authDomainNamesSet = new HashSet<String>();

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new VerifyAuthenticationDomains();
        }
        return _factoryInstance;
    }

    private VerifyAuthenticationDomains() {
    }

    private VerifyAuthenticationDomains(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        VerifyAuthenticationDomains newObject = new VerifyAuthenticationDomains(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        this._authDomainNamesSet.clear();
        List authDomains = null;
        try {
            this.createObjectStore();
            int flags = 2304;
            authDomains = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "AuthenticationDomain", flags, "", false);
            if (authDomains.size() == 0) {
                this._log.info(RB.getStringResource("VerifyAuthenticationDomains.Analyze.NotFound.txt"));
                this._result.setStatus(Operation.Status.SUCCESS);
                return;
            }
            if (this._repository.getRepositoryType() != null && this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                int numOfDuplicates = 0;
                for (AuthenticationDomain domain : authDomains) {
                    if (!this._authDomainNamesSet.contains(domain.getName())) {
                        this._authDomainNamesSet.add(domain.getName());
                        continue;
                    }
                    ++numOfDuplicates;
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Analyze.DuplicatedDomainFound.fmt", (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                }
                if (numOfDuplicates > 1) {
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Analyze.DuplicatedDomainsFound.fmt", (Object)new Integer(numOfDuplicates), (Object)this._repository.getDefaultRepositoryName()));
                    this._result.setWarningDetected(true);
                    this._result.setRepairNeeded(true);
                } else {
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Analyze.NoDuplicatedDomainFound.fmt", (Object)this._repository.getDefaultRepositoryName()));
                }
            } else {
                for (AuthenticationDomain domain : authDomains) {
                    this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Analyze.DomainFoundInNonFoundation.fmt", (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                }
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Analyze.DomainsFoundInNonFoundation.fmt", (Object)new Integer(authDomains.size()), (Object)this._repository.getDefaultRepositoryName()));
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void repairImpl() {
        this._authDomainNamesSet.clear();
        try {
            int flags = 2304;
            List authDomainsInFoundation = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._OMIUtil.getFoundationReposID(), "AuthenticationDomain", flags, "", false);
            if (this._repository.getRepositoryType() != null && this._repository.getRepositoryType().equalsIgnoreCase("Foundation")) {
                int numOfDuplicates = 0;
                for (int i = 0; i < authDomainsInFoundation.size(); ++i) {
                    AuthenticationDomain domain = (AuthenticationDomain)authDomainsInFoundation.get(i);
                    if (domain != null && !this._authDomainNamesSet.contains(domain.getName())) {
                        this._authDomainNamesSet.add(domain.getName());
                        continue;
                    }
                    String oldName = domain.getName();
                    String newName = domain.getName() + "_Foundation";
                    int j = 0;
                    while (this._authDomainNamesSet.contains(newName)) {
                        newName = newName + j++;
                    }
                    domain.setName(newName);
                    domain.setPublicType("AuthenticationDomain");
                    domain.setUsageVersion(1000000.0);
                    try {
                        domain.updateMetadataAll();
                    }
                    catch (MdException e1) {
                        domain.setName(domain.getName() + "_" + System.currentTimeMillis());
                        domain.updateMetadataAll();
                    }
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.Rename_Foundation.fmt", (Object)oldName, (Object)domain.getName(), (Object)this._repository.getDefaultRepositoryName()));
                    this._authDomainNamesSet.add(domain.getName());
                }
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.Results_Foundation.fmt", (Object)new Integer(numOfDuplicates), (Object)this._repository.getDefaultRepositoryName()));
            } else {
                for (AuthenticationDomain domain : authDomainsInFoundation) {
                    this._authDomainNamesSet.add(domain.getName());
                }
                List authDomainsList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "AuthenticationDomain", flags, "", false);
                int numberOfMoved = 0;
                int numberOfMovedAndRenamed = 0;
                for (AuthenticationDomain domain : authDomainsList) {
                    AuthenticationDomain newDomain;
                    String oldDomainName = domain.getName();
                    if (domain != null && !this._authDomainNamesSet.contains(domain.getName())) {
                        block19: {
                            newDomain = this.createDomain(domain, this._OMIUtil.getFoundationReposID());
                            this._OMIUtil.deleteMetadataObject("AuthenticationDomain", domain.getId());
                            try {
                                newDomain.updateMetadataAll();
                                ++numberOfMoved;
                                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.MoveTo_Foundation.fmt", (Object)oldDomainName));
                            }
                            catch (MdException e1) {
                                if (!this.renameAndSave(newDomain)) break block19;
                                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.RenamedAndMovedTo_Foundation.fmt", (Object)oldDomainName, (Object)newDomain.getName()));
                                ++numberOfMovedAndRenamed;
                            }
                        }
                        this._authDomainNamesSet.add(newDomain.getName());
                        continue;
                    }
                    newDomain = this.createDomain(domain, this._OMIUtil.getFoundationReposID());
                    this._OMIUtil.deleteMetadataObject("AuthenticationDomain", domain.getId());
                    if (this.renameAndSave(newDomain)) {
                        // empty if block
                    }
                    ++numberOfMovedAndRenamed;
                    this._authDomainNamesSet.add(newDomain.getName());
                    this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.RenamedAndMovedTo_Foundation.fmt", (Object)oldDomainName, (Object)newDomain.getName()));
                }
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"VerifyAuthenticationDomains.Repair.Results_NonFoundation.fmt", (Object)new Integer(numberOfMoved + numberOfMovedAndRenamed), (Object)this._repository.getDefaultRepositoryName(), (Object)new Integer(numberOfMovedAndRenamed)));
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    private AuthenticationDomain createDomain(AuthenticationDomain domain, String reposID) throws RemoteException, MdException {
        AuthenticationDomain newDomain = (AuthenticationDomain)this._factory.createComplexMetadataObject(this._store, null, domain.getName(), "AuthenticationDomain", reposID.substring(9));
        newDomain.setDesc(domain.getDesc());
        newDomain.setPublicType("AuthenticationDomain");
        newDomain.setUsageVersion(1000000.0);
        newDomain.getLogins().addAll((Collection)domain.getLogins());
        newDomain.getConnections().addAll((Collection)domain.getConnections());
        return newDomain;
    }

    private boolean renameAndSave(AuthenticationDomain domain) {
        try {
            domain.setName(domain.getName() + "_" + this._repository.getDefaultRepositoryName());
            domain.updateMetadataAll();
            return true;
        }
        catch (MdException e) {
            try {
                domain.setName(domain.getName() + "_" + System.currentTimeMillis());
                domain.updateMetadataAll();
                return true;
            }
            catch (RemoteException e2) {
                e2.printStackTrace();
            }
            catch (MdException e1) {
                e1.printStackTrace();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return false;
    }
}

