/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractPropertyObjectComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.List;

class OrphanedPropertySetComponent
extends AbstractPropertyObjectComponent {
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertySet Name=\"\"><Implementors/><OwningObject/></PropertySet></TEMPLATES>";

    public OrphanedPropertySetComponent(AnalysisTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedPropertySetComponent.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertySet";
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        List owningObjectList = objectMap.getAssociation("OwningObject");
        if (owningObjectList != null && owningObjectList.size() > 0) {
            return false;
        }
        List implementorsList = objectMap.getAssociation("Implementors");
        return implementorsList == null || implementorsList.size() <= 0;
    }
}

