/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PropertyGroup;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractToolImpl;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.logging.log4j.Logger;

public class OrphanedPropertyGroups
extends AbstractToolImpl {
    private static final String NAME = RB.getStringResource("OrphanedPropertyGroups.tool.name");
    private static final String DESCRIPTION = RB.getStringResource("OrphanedPropertyGroups.tool.desc");
    private static final String ID = "OrphPropGrp";
    private static AnalysisTool _factoryInstance;
    private List<String> _orphansList = null;
    private int _propGrpCount = 0;

    public static AnalysisTool getFactory() {
        if (_factoryInstance == null) {
            _factoryInstance = new OrphanedPropertyGroups();
        }
        return _factoryInstance;
    }

    private OrphanedPropertyGroups() {
    }

    private OrphanedPropertyGroups(OMIRepositoryInterface repository, Logger log) {
        super(repository, log);
    }

    @Override
    public AnalysisTool newInstance(OMIRepositoryInterface repository, Logger log) {
        OrphanedPropertyGroups newObject = new OrphanedPropertyGroups(repository, log);
        return newObject;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public void analyzeImpl() {
        this._propGrpCount = 0;
        this._orphansList = null;
        try {
            this.createObjectStore();
            String strTemplate = "<TEMPLATES><PropertyGroup Name=\"\"><AssociatedObject/><ParentGroup/><GroupedProperties/><SubpropertyGroups/><Properties/></PropertyGroup></TEMPLATES>";
            int flags = 2308;
            List propGrpsList = this._OMIUtil.getMetadataObjectsSubset((MdStore)this._store, this._repository.getDefaultRepositoryId(), "PropertyGroup", flags, strTemplate, false);
            if (propGrpsList == null || propGrpsList.size() == 0) {
                this._log.info(RB.getStringResource("OrphanedPropertyGroups.Analyze.NotFound.txt"));
                this._result.setStatus(Operation.Status.SUCCESS);
                return;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug("Found " + propGrpsList.size() + " total PropertyGroup objects.  Searching for orphans.");
            }
            for (PropertyGroup pGrp : propGrpsList) {
                AssociationList groupsAssocList = pGrp.getParentGroups(false);
                AssociationList assocObjectsList = pGrp.getAssociatedObjects(false);
                if (groupsAssocList != null && groupsAssocList.size() != 0 || assocObjectsList != null && assocObjectsList.size() != 0) continue;
                ++this._propGrpCount;
                if (this._orphansList == null) {
                    this._orphansList = new ArrayList<String>();
                }
                this._orphansList.add(pGrp.getFQID());
                if (this._propGrpCount > 100 || !this._log.isDebugEnabled()) continue;
                this._log.debug("Found orphaned PropertyGroup: " + pGrp.getName() + " (" + pGrp.getId() + ")");
            }
            if (this._orphansList == null) {
                this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyGroups.Analyze.NoOrphans.txt", (Object)this._repository.getDefaultRepositoryName()));
            } else {
                Integer total = new Integer(this._propGrpCount);
                this._log.warn(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyGroups.Analyze.OrphansFound.txt", (Object)total, (Object)this._repository.getDefaultRepositoryName()));
                this._result.setWarningDetected(true);
                this._result.setRepairNeeded(true);
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }

    @Override
    public void repairImpl() {
        int deletedCount = 0;
        try {
            String strDeleteTemplate = "<Template TemplateName=\"PropertyCleanup\"><Property><OwningType><PropertyType match=\"*[@Name='GenericString'][Groups/Group[@Name='Entity Property Types']]\" TemplateExpand=\"no\"/><PropertyType TemplateExpand=\"yes\"/></OwningType><ExternalIdentities/><PrimaryPropertyGroup/><SpecTargetTransformations/><Properties/><StoredConfiguration/></Property><PropertySet><SetProperties/><Properties/></PropertySet><PropertyGroup><Properties/><GroupedProperties/><SubPropertyGroups/><PropertySets/></PropertyGroup><PropertyType><StoredConfiguration/></PropertyType></Template>";
            for (String orphanID : this._orphansList) {
                List deletedList = this._OMIUtil.deleteMetadataObject("PropertyGroup", orphanID, strDeleteTemplate);
                if (deletedList == null || deletedList.size() <= 0) continue;
                ++deletedCount;
                deletedList = null;
            }
            Integer deleted = new Integer(deletedCount);
            Integer total = new Integer(this._orphansList.size());
            this._log.info(Message.format((ResourceBundle)RB.getResources(), (String)"OrphanedPropertyGroups.Repair.Results.txt", (Object)deleted, (Object)total));
            if (this._orphansList != null) {
                this._orphansList.clear();
                this._orphansList = null;
            }
            this._result.setStatus(Operation.Status.SUCCESS);
        }
        catch (MdException e) {
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.release();
        }
    }
}

