/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.svcs.metadata.mgmt.impl.analysis.AbstractPropertyObjectComponent;
import com.sas.svcs.metadata.mgmt.impl.analysis.AnalysisTool;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import java.rmi.RemoteException;
import java.util.List;

class OrphanedPropertyGroupComponent
extends AbstractPropertyObjectComponent {
    private static final String ANALYZE_TEMPLATE = "<TEMPLATES><PropertyGroup Name=\"\"><Customizers/><Editors/><Validators/><Implementors/><AssociatedObject/><ParentGroup/><GroupedProperties/><SubpropertyGroups/><Properties/></PropertyGroup></TEMPLATES>";

    public OrphanedPropertyGroupComponent(AnalysisTool parentAnalyzeTool) {
        super(parentAnalyzeTool);
    }

    @Override
    public String getComponentLabel() {
        return RB.getStringResource("OrphanedPropertyGroupComponent.tool.label.txt");
    }

    @Override
    public String getAnalyzeTemplate() {
        return ANALYZE_TEMPLATE;
    }

    @Override
    public String getMetadataType() {
        return "PropertyGroup";
    }

    @Override
    public boolean isOrphan(FastMetadata objectMap) throws MdException, RemoteException {
        if (objectMap == null) {
            return false;
        }
        if (this.containsCommonAssociations(objectMap)) {
            return false;
        }
        List groupsAssocList = objectMap.getAssociation("ParentGroup");
        if (groupsAssocList != null && groupsAssocList.size() > 0) {
            return false;
        }
        List assocObjectsList = objectMap.getAssociation("AssociatedObject");
        return assocObjectsList == null || assocObjectsList.size() <= 0;
    }
}

