/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.impl.analysis;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.FastMetadata;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.information.OMIRepositoryInterface;
import com.sas.services.information.OMIServer;
import com.sas.services.information.metadata.FolderInterface;
import com.sas.services.information.metadata.RootFolderInterface;
import com.sas.svcs.metadata.mgmt.impl.analysis.RB;
import com.sas.text.Message;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;

class FolderStructureUtil {
    protected static final String BIP_SERVICE_CLASSID = "E5F27790-2149-11D6-8828-AA0004006D06";
    protected static final String BIP_SERVICE_NAME = "BIP Service";
    protected static final String BIP_FOLDER_TYPE = "BIP Folder";
    private static final String SYSTEM_FOLDER = "System";

    FolderStructureUtil() {
    }

    static List<SoftwareComponent> getRootFolders(String reposID, MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        int flags = 392;
        String options = "<XMLSELECT SEARCH=\"*[@Name='BIP Service' and @ClassIdentifier='E5F27790-2149-11D6-8828-AA0004006D06']\" />";
        List objectList = factory.getOMIUtil().getMetadataObjectsSubset((MdStore)store, reposID, "SoftwareComponent", flags, options, false);
        return objectList;
    }

    static SoftwareComponent getRootFolder(String reposID, MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        List<SoftwareComponent> rootFolders = FolderStructureUtil.getRootFolders(reposID, factory, store);
        if (rootFolders != null && rootFolders.size() > 0) {
            return rootFolders.get(0);
        }
        return null;
    }

    static SoftwareComponent getServerRootFolder(MdFactory factory, MdObjectStore store) throws MdException, RemoteException {
        String foundationReposID = factory.getOMIUtil().getFoundationReposID();
        List<SoftwareComponent> rootFolders = FolderStructureUtil.getRootFolders(foundationReposID, factory, store);
        if (rootFolders != null && rootFolders.size() > 0) {
            return rootFolders.get(0);
        }
        return null;
    }

    public static void repairInvalidRootFolderType(SoftwareComponent rootFolder) throws MdException, RemoteException {
        String publicType;
        if (rootFolder != null && ((publicType = rootFolder.getPublicType()) == null || publicType.length() == 0)) {
            rootFolder.setPublicType("RootFolder");
            rootFolder.updateMetadataAll();
        }
    }

    public static void repairMultipleTopLevelFolders(OMIRepositoryInterface repos, SoftwareComponent rootFolder) throws RemoteException, MdException {
        String reposName = repos.getDefaultRepositoryName();
        AssociationList topLevelFolders = rootFolder.getSoftwareTrees();
        if (topLevelFolders.size() > 0) {
            Tree mainFolder = null;
            for (Tree folder : topLevelFolders) {
                if (mainFolder == null) {
                    mainFolder = folder;
                }
                if (!reposName.equalsIgnoreCase(folder.getName())) continue;
                mainFolder = folder;
                break;
            }
            for (Tree folder : topLevelFolders) {
                if (folder == mainFolder) continue;
                folder.getSoftwareComponents().clear();
            }
            MdObjectStore store = (MdObjectStore)rootFolder.getObjectStore();
            store.updatedMetadataAll();
        }
    }

    public static FastMetadata getTopLevelFolders(MdFactory factory, String rootFolderID) throws MdException, RemoteException {
        String template = "<Templates><SoftwareComponent><SoftwareTrees search=\"@PublicType='Folder'\"/></SoftwareComponent><Tree Name=\"\" TreeType=\"\" PublicType=\"\" /></Templates>";
        int flags = 260;
        FastMetadata treeMap = factory.getOMIUtil().getFastMetadata("SoftwareComponent", rootFolderID, template, flags);
        return treeMap;
    }

    public static FastMetadata getFolderContents(MdFactory factory, String folderID) throws MdException, RemoteException {
        StringBuffer templateBuffer = new StringBuffer();
        templateBuffer.append("<Templates><Tree Name=\"\" TreeType=\"\" PublicType=\"\" ><SubTrees search=\"@PublicType='Folder'\"/><Members/></Tree>");
        templateBuffer.append("<Root Name=\"\" PublicType=\"\" />");
        templateBuffer.append("</Templates>");
        int flags = 404;
        FastMetadata treeMap = factory.getOMIUtil().getFastMetadata("Tree", folderID, templateBuffer.toString(), flags);
        return treeMap;
    }

    public static FastMetadata getFolderDetails(MdFactory factory, String folderID) throws MdException, RemoteException {
        String template = "<Templates><Tree><ParentTree/><SoftwareComponents/></Tree></Templates>";
        int flags = 396;
        FastMetadata treeMap = factory.getOMIUtil().getFastMetadata("Tree", folderID, template, flags);
        return treeMap;
    }

    public static List<FastMetadata> getAllFolders(MdFactory factory, String reposID) throws MdException, RemoteException {
        int flags = 392;
        String options = "<XMLSELECT SEARCH=\"*[@PublicType='Folder']\" />";
        List objectList = factory.getOMIUtil().getFastMetadataObjects("Tree", reposID, options, flags);
        return objectList;
    }

    public static FolderInterface makeRepairObjectFolder(OMIRepositoryInterface repos) throws ServiceException, RemoteException {
        FolderInterface systemFolder;
        String REPAIR_FOLDER = "Repaired Objects";
        RootFolderInterface parentFolder = null;
        FolderInterface repairFolder = null;
        String reposType = repos.getRepositoryType();
        if ("FOUNDATION".equalsIgnoreCase(reposType)) {
            parentFolder = ((OMIServer)repos.getServer()).getRootFolder();
        } else if ("CUSTOM".equalsIgnoreCase(reposType)) {
            List folders = repos.getRootFolders();
            if (folders.size() <= 0) {
                throw new ServiceException(Message.format((ResourceBundle)RB.getResources(), (String)"FolderStructureUtil.NoRootFolder.fmt.txt", (Object)repos.getDefaultRepositoryName()));
            }
            parentFolder = (FolderInterface)folders.get(0);
        } else {
            return null;
        }
        if (parentFolder != null && (repairFolder = (systemFolder = FolderStructureUtil.getSystemFolder((FolderInterface)parentFolder)).makeSubfolder("Repaired Objects")).getState() == 1) {
            repairFolder.update();
        }
        return repairFolder;
    }

    private static FolderInterface getSystemFolder(FolderInterface parent) throws ServiceException, RemoteException {
        FolderInterface systemFolder = parent.getSubfolder(SYSTEM_FOLDER);
        if (systemFolder == null) {
            systemFolder = parent.makeSubfolder(SYSTEM_FOLDER);
            Tree systemTree = (Tree)systemFolder.getRepositoryEntity();
            systemTree.setTreeType(SYSTEM_FOLDER);
        }
        return systemFolder;
    }
}

