/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.metadata.mgmt.client;

import com.sas.codepolicy.SASScope;
import java.util.Date;

public abstract class Operation {
    private String name;
    private String comment;
    private Status status = Status.NOT_STARTED;
    private Date started;
    private Date completed;
    private String log;
    private boolean warningDetected;

    public String getName() {
        return this.name;
    }

    @SASScope
    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    @SASScope
    public void setComment(String comment) {
        this.comment = comment;
    }

    public Status getStatus() {
        return this.status;
    }

    @SASScope
    public void setStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("An operation status must be specified.");
        }
        this.status = status;
        switch (status) {
            case ACTIVE: {
                this.setStartedDate(new Date());
                break;
            }
            case SUCCESS: 
            case ERROR: 
            case CANCELLED: 
            case FATAL: {
                this.setCompletedDate(new Date());
                break;
            }
            case NOT_STARTED: 
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("The operation status is unknown!");
            }
        }
    }

    public Date getStartedDate() {
        return this.started;
    }

    @SASScope
    public void setStartedDate(Date started) {
        this.started = started;
    }

    public Date getCompletedDate() {
        return this.completed;
    }

    @SASScope
    public void setCompletedDate(Date completed) {
        this.completed = completed;
    }

    public String getLog() {
        return this.log;
    }

    @SASScope
    public void setLog(String log) {
        this.log = log;
    }

    public boolean isWarningDetected() {
        return this.warningDetected;
    }

    @SASScope
    public void setWarningDetected(boolean warningDetected) {
        this.warningDetected = warningDetected;
    }

    public static enum Status {
        NOT_STARTED,
        ACTIVE,
        SUCCESS,
        ERROR,
        FATAL,
        CANCELLED,
        UNKNOWN;

    }
}

